(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7633,        248]
NotebookOptionsPosition[      5734,        192]
NotebookOutlinePosition[      7009,        224]
CellTagsIndexPosition[      6966,        221]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Inversions" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/Inversions"], 
          "ToInversionVector" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/ToInversionVector"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Inversions\"\>", 
       2->"\<\"ToInversionVector\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Permutations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/Permutations"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Permutations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NumberOfPermutationsByInversions", "ObjectName",
 CellID->6298],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NumberOfPermutationsByInversions", "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the number of permutations of length ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " with exactly ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     " inversions. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NumberOfPermutationsByInversions", "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a table of the number of length-",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " permutations with ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     " inversions, for all ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->24424]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->306],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Inversions",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/Inversions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToInversionVector",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ToInversionVector"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8058]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->80437746],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->365346257]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Permutations",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/Permutations"]], "MoreAbout",
 CellID->424119967]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NumberOfPermutationsByInversions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 51, 55.4649334}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "NumberOfPermutationsByInversions[n, k] gives the number of permutations \
of length n with exactly k inversions. NumberOfPermutationsByInversions[n] \
gives a table of the number of length-n permutations with k inversions, for \
all k.", "synonyms" -> {}, "title" -> "NumberOfPermutationsByInversions", 
    "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/NumberOfPermutationsByInversions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1917, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2540, 77, 69, 1, 70, "ObjectName",
 CellID->6298],
Cell[2612, 80, 1178, 35, 70, "Usage",
 CellID->24424]
}, Open  ]],
Cell[CellGroupData[{
Cell[3827, 120, 309, 9, 70, "SeeAlsoSection",
 CellID->306],
Cell[4139, 131, 500, 17, 70, "SeeAlso",
 CellID->8058]
}, Open  ]],
Cell[CellGroupData[{
Cell[4676, 153, 317, 9, 70, "TutorialsSection",
 CellID->80437746],
Cell[4996, 164, 187, 4, 70, "Tutorials",
 CellID->365346257]
}, Open  ]],
Cell[CellGroupData[{
Cell[5220, 173, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5542, 184, 150, 3, 70, "MoreAbout",
 CellID->424119967]
}, Open  ]],
Cell[5707, 190, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

