(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7961,        256]
NotebookOptionsPosition[      5990,        199]
NotebookOutlinePosition[      7335,        232]
CellTagsIndexPosition[      7292,        229]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"OrbitRepresentatives" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/OrbitRepresentatives"], "Orbits" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/Orbits"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"OrbitRepresentatives\"\>", 
       2->"\<\"Orbits\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Permutation Groups" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/PermutationGroups"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Permutation Groups\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["OrbitInventory", "ObjectName",
 CellID->4293],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"OrbitInventory", "[", 
       RowBox[{
        StyleBox["ci", "TI"], ",", 
        StyleBox["x", "TI"], ",", 
        StyleBox["w", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the value of the cycle index ",
     Cell[BoxData[
      StyleBox["ci", "TI"]], "InlineFormula"],
     " when each formal variable ",
     Cell[BoxData[
      FormBox[
       RowBox[{"x", "[", "i", "]"}], TraditionalForm]], "InlineMath"],
     " is replaced by ",
     Cell[BoxData[
      FormBox["w", TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"OrbitInventory", "[", 
       RowBox[{
        StyleBox["ci", "TI"], ",", 
        StyleBox["x", "TI"], ",", 
        StyleBox["weights", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the inventory of orbits induced on a set of \
functions by the action of a group with cycle index ",
     Cell[BoxData[
      StyleBox["ci", "TI"]], "InlineFormula"],
     ". It is assumed that each element in the range of the functions is \
assigned a weight in list ",
     Cell[BoxData[
      StyleBox["weights", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->20267]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9796],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["OrbitRepresentatives",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/OrbitRepresentatives"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Orbits",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/Orbits"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18763]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->526545765],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->30319067]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Permutation Groups",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/PermutationGroups"]], "MoreAbout",
 CellID->270132012]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"OrbitInventory - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 52, 3.3713858}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "OrbitInventory[ci, x, w] returns the value of the cycle index ci when \
each formal variable x[i] is replaced by w. OrbitInventory[ci, x, weights] \
returns the inventory of orbits induced on a set of functions by the action \
of a group with cycle index ci. It is assumed that each element in the range \
of the functions is assigned a weight in list weights.", "synonyms" -> {}, 
    "title" -> "OrbitInventory", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/OrbitInventory"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1929, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2552, 77, 51, 1, 70, "ObjectName",
 CellID->4293],
Cell[2606, 80, 1429, 42, 70, "Usage",
 CellID->20267]
}, Open  ]],
Cell[CellGroupData[{
Cell[4072, 127, 310, 9, 70, "SeeAlsoSection",
 CellID->9796],
Cell[4385, 138, 499, 17, 70, "SeeAlso",
 CellID->18763]
}, Open  ]],
Cell[CellGroupData[{
Cell[4921, 160, 318, 9, 70, "TutorialsSection",
 CellID->526545765],
Cell[5242, 171, 186, 4, 70, "Tutorials",
 CellID->30319067]
}, Open  ]],
Cell[CellGroupData[{
Cell[5465, 180, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5787, 191, 161, 3, 70, "MoreAbout",
 CellID->270132012]
}, Open  ]],
Cell[5963, 197, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

