(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7553,        247]
NotebookOptionsPosition[      5767,        193]
NotebookOutlinePosition[      6925,        223]
CellTagsIndexPosition[      6882,        220]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AllPairsShortestPath" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/AllPairsShortestPath"], 
          "BreadthFirstTraversal" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/BreadthFirstTraversal"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AllPairsShortestPath\"\>", 
       2->"\<\"BreadthFirstTraversal\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphAlgorithms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graph Algorithms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ParentsToPaths", "ObjectName",
 CellID->17634],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ParentsToPaths", "[", 
       RowBox[{
        StyleBox["l", "TI"], ",", 
        StyleBox["i", "TI"], ",", 
        StyleBox["j", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]takes a list of parents ",
     Cell[BoxData[
      FormBox["l", TraditionalForm]], "InlineMath"],
     " and returns the path from ",
     Cell[BoxData[
      FormBox["i", TraditionalForm]], "InlineMath"],
     " to ",
     Cell[BoxData[
      FormBox["j", TraditionalForm]], "InlineMath"],
     " encoded in the parent list. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ParentsToPaths", "[", 
       RowBox[{
        StyleBox["l", "TI"], ",", 
        StyleBox["i", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the paths from ",
     Cell[BoxData[
      FormBox["i", TraditionalForm]], "InlineMath"],
     " to all vertices."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->16618]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22760],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AllPairsShortestPath",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/AllPairsShortestPath"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BreadthFirstTraversal",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/BreadthFirstTraversal"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17501]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->239810607],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->834371305]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphAlgorithms"]], "MoreAbout",
 CellID->75783442]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ParentsToPaths - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 52, 11.3872160}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "ParentsToPaths[l, i, j] takes a list of parents l and returns the path \
from i to j encoded in the parent list. ParentsToPaths[l, i] returns the \
paths from i to all vertices.", "synonyms" -> {}, "title" -> "ParentsToPaths",
     "type" -> "Symbol", "uri" -> "Combinatorica/ref/ParentsToPaths"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1982, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2605, 78, 52, 1, 70, "ObjectName",
 CellID->17634],
Cell[2660, 81, 1125, 35, 70, "Usage",
 CellID->16618]
}, Open  ]],
Cell[CellGroupData[{
Cell[3822, 121, 311, 9, 70, "SeeAlsoSection",
 CellID->22760],
Cell[4136, 132, 529, 17, 70, "SeeAlso",
 CellID->17501]
}, Open  ]],
Cell[CellGroupData[{
Cell[4702, 154, 318, 9, 70, "TutorialsSection",
 CellID->239810607],
Cell[5023, 165, 187, 4, 70, "Tutorials",
 CellID->834371305]
}, Open  ]],
Cell[CellGroupData[{
Cell[5247, 174, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5569, 185, 156, 3, 70, "MoreAbout",
 CellID->75783442]
}, Open  ]],
Cell[5740, 191, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

