(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9614,        327]
NotebookOptionsPosition[      7481,        261]
NotebookOutlinePosition[      8678,        292]
CellTagsIndexPosition[      8635,        289]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DominationLattice" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/DominationLattice"], "HasseDiagram" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/HasseDiagram"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"DominationLattice\"\>", 
       2->"\<\"HasseDiagram\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphAlgorithms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graph Algorithms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PartitionLattice", "ObjectName",
 CellID->7189],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PartitionLattice", "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns a Hasse diagram of the partially ordered set on \
set partitions of ",
     Cell[BoxData[
      FormBox["1", TraditionalForm]], "InlineMath"],
     " through ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " in which ",
     Cell[BoxData[
      FormBox[
       RowBox[{"p", "<", "q"}], TraditionalForm]], "InlineMath"],
     " if ",
     Cell[BoxData[
      FormBox["q", TraditionalForm]], "InlineMath"],
     " is finer than ",
     Cell[BoxData[
      FormBox["p", TraditionalForm]], "InlineMath"],
     ", that is, each block in ",
     Cell[BoxData[
      FormBox["q", TraditionalForm]], "InlineMath"],
     " is contained in some block in ",
     Cell[BoxData[
      FormBox["p", TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27511]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The function takes two options: ",
 Cell[BoxData["Type"], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["VertexLabel",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/VertexLabel"]], "InlineFormula"],
 ", with default values ",
 Cell[BoxData[
  ButtonBox["Undirected",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/Undirected"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", respectively. "
}], "Notes",
 CellID->22625],

Cell[TextData[{
 "When ",
 Cell[BoxData["Type"], "InlineFormula"],
 " is set to ",
 Cell[BoxData[
  ButtonBox["Directed",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/Directed"]], "InlineFormula"],
 ", the function produces the underlying directed acyclic graph. "
}], "Notes",
 CellID->252874518],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["VertexLabel",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/VertexLabel"]], "InlineFormula"],
 " is set to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", labels are produced for the vertices."
}], "Notes",
 CellID->197636246]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15747],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DominationLattice",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/DominationLattice"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HasseDiagram",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/HasseDiagram"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12579]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->356872703],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->688085646]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphAlgorithms"]], "MoreAbout",
 CellID->52845937]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PartitionLattice - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 52, 11.7622256}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "PartitionLattice[n] returns a Hasse diagram of the partially ordered set \
on set partitions of 1 through n in which p < q if q is finer than p, that \
is, each block in q is contained in some block in p. ", "synonyms" -> {}, 
    "title" -> "PartitionLattice", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/PartitionLattice"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1935, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2558, 77, 53, 1, 70, "ObjectName",
 CellID->7189],
Cell[2614, 80, 1128, 35, 70, "Usage",
 CellID->27511]
}, Open  ]],
Cell[CellGroupData[{
Cell[3779, 120, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4257, 137, 578, 20, 70, "Notes",
 CellID->22625],
Cell[4838, 159, 315, 10, 70, "Notes",
 CellID->252874518],
Cell[5156, 171, 367, 13, 70, "Notes",
 CellID->197636246]
}, Closed]],
Cell[CellGroupData[{
Cell[5560, 189, 311, 9, 70, "SeeAlsoSection",
 CellID->15747],
Cell[5874, 200, 505, 17, 70, "SeeAlso",
 CellID->12579]
}, Open  ]],
Cell[CellGroupData[{
Cell[6416, 222, 318, 9, 70, "TutorialsSection",
 CellID->356872703],
Cell[6737, 233, 187, 4, 70, "Tutorials",
 CellID->688085646]
}, Open  ]],
Cell[CellGroupData[{
Cell[6961, 242, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[7283, 253, 156, 3, 70, "MoreAbout",
 CellID->52845937]
}, Open  ]],
Cell[7454, 259, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

