(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7083,        234]
NotebookOptionsPosition[      5341,        180]
NotebookOutlinePosition[      6459,        210]
CellTagsIndexPosition[      6416,        207]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ChromaticNumber" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/ChromaticNumber"], "MaximumClique" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/MaximumClique"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ChromaticNumber\"\>", 
       2->"\<\"MaximumClique\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Properties" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphProperties"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graph Properties\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PerfectQ", "ObjectName",
 CellID->11955],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PerfectQ", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " is a perfect graph, meaning that for every induced subgraph of ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " the size of a largest clique equals the chromatic number."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20431]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2982],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ChromaticNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ChromaticNumber"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MaximumClique",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/MaximumClique"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8566]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->596007530],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->155334239]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Properties",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphProperties"]], "MoreAbout",
 CellID->3749562]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PerfectQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 52, 19.0749128}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "PerfectQ[g] yields True if g is a perfect graph, meaning that for every \
induced subgraph of g the size of a largest clique equals the chromatic \
number.", "synonyms" -> {}, "title" -> "PerfectQ", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/PerfectQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1932, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2555, 77, 46, 1, 70, "ObjectName",
 CellID->11955],
Cell[2604, 80, 784, 23, 70, "Usage",
 CellID->20431]
}, Open  ]],
Cell[CellGroupData[{
Cell[3425, 108, 310, 9, 70, "SeeAlsoSection",
 CellID->2982],
Cell[3738, 119, 502, 17, 70, "SeeAlso",
 CellID->8566]
}, Open  ]],
Cell[CellGroupData[{
Cell[4277, 141, 318, 9, 70, "TutorialsSection",
 CellID->596007530],
Cell[4598, 152, 187, 4, 70, "Tutorials",
 CellID->155334239]
}, Open  ]],
Cell[CellGroupData[{
Cell[4822, 161, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5144, 172, 155, 3, 70, "MoreAbout",
 CellID->3749562]
}, Open  ]],
Cell[5314, 178, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

