(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6811,        223]
NotebookOptionsPosition[      5046,        169]
NotebookOutlinePosition[      6184,        199]
CellTagsIndexPosition[      6141,        196]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FiniteGraphs" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/FiniteGraphs"], 
          "GeneralizedPetersenGraph" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/GeneralizedPetersenGraph"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FiniteGraphs\"\>", 
       2->"\<\"GeneralizedPetersenGraph\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Built-in Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/BuiltinGraphs"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Built-in Graphs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PetersenGraph", "ObjectName",
 CellID->15381],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["PetersenGraph"], "InlineFormula"],
     "\[LineSeparator]returns the Petersen graph, a graph whose vertices can \
be viewed as the size-2 subsets of a size-5 set with edges connecting \
disjoint subsets."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32193]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28361],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FiniteGraphs",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/FiniteGraphs"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GeneralizedPetersenGraph",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/GeneralizedPetersenGraph"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27407]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->908047518],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->487334291]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Built-in Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/BuiltinGraphs"]], "MoreAbout",
 CellID->471370274]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PetersenGraph - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 52, 27.0594922}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "PetersenGraph returns the Petersen graph, a graph whose vertices can be \
viewed as the size-2 subsets of a size-5 set with edges connecting disjoint \
subsets.", "synonyms" -> {}, "title" -> "PetersenGraph", "type" -> "Symbol", 
    "uri" -> "Combinatorica/ref/PetersenGraph"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1951, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2574, 77, 51, 1, 70, "ObjectName",
 CellID->15381],
Cell[2628, 80, 448, 12, 70, "Usage",
 CellID->32193]
}, Open  ]],
Cell[CellGroupData[{
Cell[3113, 97, 311, 9, 70, "SeeAlsoSection",
 CellID->28361],
Cell[3427, 108, 519, 17, 70, "SeeAlso",
 CellID->27407]
}, Open  ]],
Cell[CellGroupData[{
Cell[3983, 130, 318, 9, 70, "TutorialsSection",
 CellID->908047518],
Cell[4304, 141, 187, 4, 70, "Tutorials",
 CellID->487334291]
}, Open  ]],
Cell[CellGroupData[{
Cell[4528, 150, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[4850, 161, 154, 3, 70, "MoreAbout",
 CellID->471370274]
}, Open  ]],
Cell[5019, 167, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

