(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8316,        283]
NotebookOptionsPosition[      6386,        222]
NotebookOutlinePosition[      7499,        252]
CellTagsIndexPosition[      7456,        249]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RandomRGF" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/RandomRGF"], 
          "SetPartitionToRGF" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/SetPartitionToRGF"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"RandomRGF\"\>", 
       2->"\<\"SetPartitionToRGF\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Partitions and Compositions" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/PartitionsAndCompositions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Partitions and Compositions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RGFToSetPartition", "ObjectName",
 CellID->27175],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"RGFToSetPartition", "[", 
       RowBox[{
        StyleBox["rgf", "TI"], ",", 
        StyleBox["set", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]converts the restricted growth function ",
     Cell[BoxData[
      StyleBox["rgf", "TI"]], "InlineFormula"],
     " into the corresponding set partition of ",
     Cell[BoxData[
      StyleBox["set", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22319]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "If the optional second argument, ",
 Cell[BoxData[
  StyleBox["set", "TI"]], "InlineFormula"],
 ", is not supplied, then ",
 Cell[BoxData[
  StyleBox["rgf", "TI"]], "InlineFormula"],
 " is converted into a set partition of ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["1", "TR"], ",", 
    StyleBox["2", "TR"], ",", 
    StyleBox["\[Ellipsis]", "TI"], ",", 
    RowBox[{
     ButtonBox["Length",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Length"], "[", 
     StyleBox["rgf", "TI"], "]"}]}], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->32687]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24137],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomRGF",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/RandomRGF"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetPartitionToRGF",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/SetPartitionToRGF"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1484]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->88176775],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->373517920]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Partitions and Compositions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/PartitionsAndCompositions"]], "MoreAbout",
 CellID->252251939]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RGFToSetPartition - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 53, 7.0136400}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "RGFToSetPartition[rgf, set] converts the restricted growth function rgf \
into the corresponding set partition of set. ", "synonyms" -> {}, "title" -> 
    "RGFToSetPartition", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/RGFToSetPartition"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1965, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2588, 78, 55, 1, 70, "ObjectName",
 CellID->27175],
Cell[2646, 81, 655, 20, 70, "Usage",
 CellID->22319]
}, Open  ]],
Cell[CellGroupData[{
Cell[3338, 106, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3816, 123, 595, 21, 70, "Notes",
 CellID->32687]
}, Closed]],
Cell[CellGroupData[{
Cell[4448, 149, 311, 9, 70, "SeeAlsoSection",
 CellID->24137],
Cell[4762, 160, 498, 17, 70, "SeeAlso",
 CellID->1484]
}, Open  ]],
Cell[CellGroupData[{
Cell[5297, 182, 317, 9, 70, "TutorialsSection",
 CellID->88176775],
Cell[5617, 193, 187, 4, 70, "Tutorials",
 CellID->373517920]
}, Open  ]],
Cell[CellGroupData[{
Cell[5841, 202, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[6163, 213, 181, 4, 70, "MoreAbout",
 CellID->252251939]
}, Open  ]],
Cell[6359, 220, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

