(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6983,        232]
NotebookOptionsPosition[      5284,        179]
NotebookOutlinePosition[      6358,        208]
CellTagsIndexPosition[      6315,        205]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Compositions" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/Compositions"], 
          "NumberOfCompositions" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/NumberOfCompositions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Compositions\"\>", 
       2->"\<\"NumberOfCompositions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Partitions and Compositions" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/PartitionsAndCompositions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Partitions and Compositions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RandomComposition", "ObjectName",
 CellID->29886],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"RandomComposition", "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]constructs a random composition of integer ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " into ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     " parts."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11078]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13356],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Compositions",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/Compositions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberOfCompositions",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/NumberOfCompositions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29778]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->192452078],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->6603275]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Partitions and Compositions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/PartitionsAndCompositions"]], "MoreAbout",
 CellID->51624558]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RandomComposition - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 52, 34.7315636}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "RandomComposition[n, k] constructs a random composition of integer n \
into k parts.", "synonyms" -> {}, "title" -> "RandomComposition", "type" -> 
    "Symbol", "uri" -> "Combinatorica/ref/RandomComposition"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1983, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2606, 78, 55, 1, 70, "ObjectName",
 CellID->29886],
Cell[2664, 81, 634, 20, 70, "Usage",
 CellID->11078]
}, Open  ]],
Cell[CellGroupData[{
Cell[3335, 106, 311, 9, 70, "SeeAlsoSection",
 CellID->13356],
Cell[3649, 117, 511, 17, 70, "SeeAlso",
 CellID->29778]
}, Open  ]],
Cell[CellGroupData[{
Cell[4197, 139, 318, 9, 70, "TutorialsSection",
 CellID->192452078],
Cell[4518, 150, 185, 4, 70, "Tutorials",
 CellID->6603275]
}, Open  ]],
Cell[CellGroupData[{
Cell[4740, 159, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5062, 170, 180, 4, 70, "MoreAbout",
 CellID->51624558]
}, Open  ]],
Cell[5257, 177, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

