(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7564,        248]
NotebookOptionsPosition[      5749,        193]
NotebookOutlinePosition[      6937,        224]
CellTagsIndexPosition[      6894,        221]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"KSetPartitions" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/KSetPartitions"],
           "RandomSetPartition" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/RandomSetPartition"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"KSetPartitions\"\>", 
       2->"\<\"RandomSetPartition\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Partitions and Compositions" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/PartitionsAndCompositions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Partitions and Compositions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RandomKSetPartition", "ObjectName",
 CellID->822],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"RandomKSetPartition", "[", 
       RowBox[{
        StyleBox["set", "TI"], ",", 
        StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns a random set partition of ",
     Cell[BoxData[
      StyleBox["set", "TI"]], "InlineFormula"],
     " with ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     " blocks. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"RandomKSetPartition", "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns a random set partition of the first ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " natural numbers into ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     " blocks."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->26733]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28266],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["KSetPartitions",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/KSetPartitions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomSetPartition",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/RandomSetPartition"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26348]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->266735626],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->220022043]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Partitions and Compositions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/PartitionsAndCompositions"]], "MoreAbout",
 CellID->298927413]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RandomKSetPartition - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 52, 35.4190812}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "RandomKSetPartition[set, k] returns a random set partition of set with k \
blocks. RandomKSetPartition[n, k] returns a random set partition of the first \
n natural numbers into k blocks.", "synonyms" -> {}, "title" -> 
    "RandomKSetPartition", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/RandomKSetPartition"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1983, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2606, 78, 55, 1, 70, "ObjectName",
 CellID->822],
Cell[2664, 81, 1096, 34, 70, "Usage",
 CellID->26733]
}, Open  ]],
Cell[CellGroupData[{
Cell[3797, 120, 311, 9, 70, "SeeAlsoSection",
 CellID->28266],
Cell[4111, 131, 511, 17, 70, "SeeAlso",
 CellID->26348]
}, Open  ]],
Cell[CellGroupData[{
Cell[4659, 153, 318, 9, 70, "TutorialsSection",
 CellID->266735626],
Cell[4980, 164, 187, 4, 70, "Tutorials",
 CellID->220022043]
}, Open  ]],
Cell[CellGroupData[{
Cell[5204, 173, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5526, 184, 181, 4, 70, "MoreAbout",
 CellID->298927413]
}, Open  ]],
Cell[5722, 191, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

