(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7164,        236]
NotebookOptionsPosition[      5397,        182]
NotebookOutlinePosition[      6541,        212]
CellTagsIndexPosition[      6498,        209]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RandomPartition" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/RandomPartition"], "RandomRGF" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/RandomRGF"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"RandomPartition\"\>", 
       2->"\<\"RandomRGF\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Partitions and Compositions" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/PartitionsAndCompositions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Partitions and Compositions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RandomSetPartition", "ObjectName",
 CellID->9531],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"RandomSetPartition", "[", 
       StyleBox["set", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns a random set partition of ",
     Cell[BoxData[
      StyleBox["set", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"RandomSetPartition", "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns a random set partition of the first ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " natural numbers."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->7895]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9857],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomPartition",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/RandomPartition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomRGF",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/RandomRGF"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15969]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->320290694],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->18867583]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Partitions and Compositions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/PartitionsAndCompositions"]], "MoreAbout",
 CellID->48279643]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RandomSetPartition - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 52, 43.0286510}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "RandomSetPartition[set] returns a random set partition of set. \
RandomSetPartition[n] returns a random set partition of the first n natural \
numbers.", "synonyms" -> {}, "title" -> "RandomSetPartition", "type" -> 
    "Symbol", "uri" -> "Combinatorica/ref/RandomSetPartition"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1949, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2572, 77, 55, 1, 70, "ObjectName",
 CellID->9531],
Cell[2630, 80, 797, 24, 70, "Usage",
 CellID->7895]
}, Open  ]],
Cell[CellGroupData[{
Cell[3464, 109, 310, 9, 70, "SeeAlsoSection",
 CellID->9857],
Cell[3777, 120, 495, 17, 70, "SeeAlso",
 CellID->15969]
}, Open  ]],
Cell[CellGroupData[{
Cell[4309, 142, 318, 9, 70, "TutorialsSection",
 CellID->320290694],
Cell[4630, 153, 186, 4, 70, "Tutorials",
 CellID->18867583]
}, Open  ]],
Cell[CellGroupData[{
Cell[4853, 162, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5175, 173, 180, 4, 70, "MoreAbout",
 CellID->48279643]
}, Open  ]],
Cell[5370, 180, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

