(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7753,        255]
NotebookOptionsPosition[      5916,        200]
NotebookOutlinePosition[      7125,        231]
CellTagsIndexPosition[      7082,        228]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RankSetPartition" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/RankSetPartition"], 
          "UnrankKSetPartition" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/UnrankKSetPartition"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"RankSetPartition\"\>", 
       2->"\<\"UnrankKSetPartition\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Partitions and Compositions" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/PartitionsAndCompositions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Partitions and Compositions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RankKSetPartition", "ObjectName",
 CellID->25426],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"RankKSetPartition", "[", 
       RowBox[{
        StyleBox["sp", "TI"], ",", 
        StyleBox["s", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]ranks ",
     Cell[BoxData[
      StyleBox["sp", "TI"]], "InlineFormula"],
     " in the list of all ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     "-block set partitions of ",
     Cell[BoxData[
      FormBox["s", TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       RowBox[{"RankSetPartition", "["}], 
       StyleBox["sp", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]ranks ",
     Cell[BoxData[
      StyleBox["sp", "TI"]], "InlineFormula"],
     " in the list of all ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     "-block set partitions of the set of elements that appear in any subset \
in ",
     Cell[BoxData[
      StyleBox["sp", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->31650]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31453],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RankSetPartition",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/RankSetPartition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UnrankKSetPartition",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/UnrankKSetPartition"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13071]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->213298516],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->29218308]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Partitions and Compositions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/PartitionsAndCompositions"]], "MoreAbout",
 CellID->431102676]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RankKSetPartition - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 52, 51.0757320}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "RankKSetPartition[sp, s] ranks sp in the list of all k-block set \
partitions of s. RankSetPartition[ sp] ranks sp in the list of all k-block \
set partitions of the set of elements that appear in any subset in sp.", 
    "synonyms" -> {}, "title" -> "RankKSetPartition", "type" -> "Symbol", 
    "uri" -> "Combinatorica/ref/RankKSetPartition"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2004, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2627, 79, 55, 1, 70, "ObjectName",
 CellID->25426],
Cell[2685, 82, 1237, 40, 70, "Usage",
 CellID->31650]
}, Open  ]],
Cell[CellGroupData[{
Cell[3959, 127, 311, 9, 70, "SeeAlsoSection",
 CellID->31453],
Cell[4273, 138, 517, 17, 70, "SeeAlso",
 CellID->13071]
}, Open  ]],
Cell[CellGroupData[{
Cell[4827, 160, 318, 9, 70, "TutorialsSection",
 CellID->213298516],
Cell[5148, 171, 186, 4, 70, "Tutorials",
 CellID->29218308]
}, Open  ]],
Cell[CellGroupData[{
Cell[5371, 180, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5693, 191, 181, 4, 70, "MoreAbout",
 CellID->431102676]
}, Open  ]],
Cell[5889, 198, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

