(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7476,        247]
NotebookOptionsPosition[      5659,        192]
NotebookOutlinePosition[      6851,        223]
CellTagsIndexPosition[      6808,        220]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RankRGF" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/RankRGF"], 
          "UnrankSetPartition" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/UnrankSetPartition"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"RankRGF\"\>", 
       2->"\<\"UnrankSetPartition\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Partitions and Compositions" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/PartitionsAndCompositions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Partitions and Compositions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RankSetPartition", "ObjectName",
 CellID->24882],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"RankSetPartition", "[", 
       RowBox[{
        StyleBox["sp", "TI"], ",", 
        StyleBox["s", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]ranks ",
     Cell[BoxData[
      StyleBox["sp", "TI"]], "InlineFormula"],
     " in the list of all set partitions of set ",
     Cell[BoxData[
      FormBox["s", TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"RankSetPartition", "[", 
       StyleBox["sp", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]ranks ",
     Cell[BoxData[
      StyleBox["sp", "TI"]], "InlineFormula"],
     " in the list of all set partitions of the set of elements that appear \
in any subset in ",
     Cell[BoxData[
      StyleBox["sp", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->1370]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27395],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RankRGF",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/RankRGF"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UnrankSetPartition",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/UnrankSetPartition"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8921]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8375060],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->350836882]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Partitions and Compositions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/PartitionsAndCompositions"]], "MoreAbout",
 CellID->391884819]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RankSetPartition - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 52, 51.7945004}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "RankSetPartition[sp, s] ranks sp in the list of all set partitions of \
set s. RankSetPartition[sp] ranks sp in the list of all set partitions of the \
set of elements that appear in any subset in sp.", "synonyms" -> {}, "title" -> 
    "RankSetPartition", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/RankSetPartition"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1962, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2585, 78, 54, 1, 70, "ObjectName",
 CellID->24882],
Cell[2642, 81, 1045, 33, 70, "Usage",
 CellID->1370]
}, Open  ]],
Cell[CellGroupData[{
Cell[3724, 119, 311, 9, 70, "SeeAlsoSection",
 CellID->27395],
Cell[4038, 130, 496, 17, 70, "SeeAlso",
 CellID->8921]
}, Open  ]],
Cell[CellGroupData[{
Cell[4571, 152, 316, 9, 70, "TutorialsSection",
 CellID->8375060],
Cell[4890, 163, 187, 4, 70, "Tutorials",
 CellID->350836882]
}, Open  ]],
Cell[CellGroupData[{
Cell[5114, 172, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5436, 183, 181, 4, 70, "MoreAbout",
 CellID->391884819]
}, Open  ]],
Cell[5632, 190, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

