(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6894,        228]
NotebookOptionsPosition[      5110,        172]
NotebookOutlinePosition[      6208,        202]
CellTagsIndexPosition[      6165,        199]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NetworkFlow" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/NetworkFlow"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"NetworkFlow\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/ConstructingGraphs"], 
          "Graph Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphAlgorithms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Constructing Graphs\"\>", 
       2->"\<\"Graph Algorithms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ResidualFlowGraph", "ObjectName",
 CellID->29408],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ResidualFlowGraph", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["flow", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the directed residual flow graph for graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " with respect to ",
     Cell[BoxData[
      StyleBox["flow", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1563]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6867],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["NetworkFlow",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/NetworkFlow"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->8110]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->162317140],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->194717519]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Constructing Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/ConstructingGraphs"]], "MoreAbout",
 CellID->117946142],

Cell[TextData[ButtonBox["Graph Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphAlgorithms"]], "MoreAbout",
 CellID->700235397]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ResidualFlowGraph - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 52, 59.7322036}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "ResidualFlowGraph[g, flow] returns the directed residual flow graph for \
graph g with respect to flow.", "synonyms" -> {}, "title" -> 
    "ResidualFlowGraph", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/ResidualFlowGraph"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1950, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2573, 78, 55, 1, 70, "ObjectName",
 CellID->29408],
Cell[2631, 81, 645, 20, 70, "Usage",
 CellID->1563]
}, Open  ]],
Cell[CellGroupData[{
Cell[3313, 106, 310, 9, 70, "SeeAlsoSection",
 CellID->6867],
Cell[3626, 117, 215, 6, 70, "SeeAlso",
 CellID->8110]
}, Open  ]],
Cell[CellGroupData[{
Cell[3878, 128, 318, 9, 70, "TutorialsSection",
 CellID->162317140],
Cell[4199, 139, 187, 4, 70, "Tutorials",
 CellID->194717519]
}, Open  ]],
Cell[CellGroupData[{
Cell[4423, 148, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[4745, 159, 163, 3, 70, "MoreAbout",
 CellID->117946142],
Cell[4911, 164, 157, 3, 70, "MoreAbout",
 CellID->700235397]
}, Open  ]],
Cell[5083, 170, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

