(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12575,        421]
NotebookOptionsPosition[     10255,        351]
NotebookOutlinePosition[     11579,        384]
CellTagsIndexPosition[     11536,        381]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GraphOptions" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/GraphOptions"], 
          "SetGraphOptions" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/SetGraphOptions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"GraphOptions\"\>", 
       2->"\<\"SetGraphOptions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Displaying Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/DisplayingGraphs"], 
          "Graph Construction and Representations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]},\
 #, 2]& , Evaluator -> Automatic], {1->"\<\"Displaying Graphs\"\>", 
       2->"\<\"Graph Construction and Representations\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SetEdgeWeights", "ObjectName",
 CellID->19636],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SetEdgeWeights", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]assigns random real weights in the range ",
     Cell[BoxData[
      FormBox[
       RowBox[{"[", 
        RowBox[{"0", ",", "1"}], "]"}], TraditionalForm]], "InlineMath"],
     " to edges in ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SetEdgeWeights", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["e", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]assigns edge weights to the edges in the edge list ",
     Cell[BoxData[
      FormBox["e", TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SetEdgeWeights", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["w", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]assigns the weights in the weight list ",
     Cell[BoxData[
      FormBox["w", TraditionalForm]], "InlineMath"],
     " to the edges of ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SetEdgeWeights", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["e", "TI"], ",", 
        StyleBox["w", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]assigns the weights in the weight list ",
     Cell[BoxData[
      FormBox["w", TraditionalForm]], "InlineMath"],
     " to the edges in edge list ",
     Cell[BoxData[
      FormBox["e", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->5355]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["SetEdgeWeights"], "InlineFormula"],
 " accepts options ",
 Cell[BoxData[
  ButtonBox["WeightingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/WeightingFunction"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["WeightRange",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/WeightRange"]], "InlineFormula"],
 ". The default value for ",
 Cell[BoxData[
  ButtonBox["WeightingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/WeightingFunction"]], 
  "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal",
   ButtonNote->"ObsLink: Random -> RandomReal (RandomInteger)"]], 
  "InlineFormula"],
 " and the default value for ",
 Cell[BoxData[
  ButtonBox["WeightRange",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/WeightRange"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    RowBox[{"0", ",", "1"}], "]"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->9109],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WeightingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/WeightingFunction"]], 
  "InlineFormula"],
 " can take values ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal",
   ButtonNote->"ObsLink: Random -> RandomReal (RandomInteger)"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RandomInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/RandomInteger"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Euclidean",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/Euclidean"]], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LNorm",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/LNorm"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " for nonnegative ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ", or any pure function that takes two arguments, each argument having the \
form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    ButtonBox["Integer",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Integer"], ",", 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Number",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Number"], ",", 
      ButtonBox["Number",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Number"]}], "}"}]}], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->162410462],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WeightRange",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/WeightRange"]], "InlineFormula"],
 " can be an integer range or a real range."
}], "Notes",
 CellID->42112773]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18728],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/GraphOptions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetGraphOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/SetGraphOptions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17679]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->44251790],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->285588384]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Displaying Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/DisplayingGraphs"]], "MoreAbout",
 CellID->2373510],

Cell[TextData[ButtonBox["Graph Construction and Representations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]], \
"MoreAbout",
 CellID->42492652]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SetEdgeWeights - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 53, 15.2169750}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "SetEdgeWeights[g] assigns random real weights in the range [0, 1] to \
edges in g. SetEdgeWeights[g, e] assigns edge weights to the edges in the \
edge list e. SetEdgeWeights[g, w] assigns the weights in the weight list w to \
the edges of g. SetEdgeWeights[g, e, w] assigns the weights in the weight \
list w to the edges in edge list e.", "synonyms" -> {}, "title" -> 
    "SetEdgeWeights", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/SetEdgeWeights"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2157, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2780, 82, 52, 1, 70, "ObjectName",
 CellID->19636],
Cell[2835, 85, 1938, 60, 70, "Usage",
 CellID->5355]
}, Open  ]],
Cell[CellGroupData[{
Cell[4810, 150, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5288, 167, 1100, 38, 70, "Notes",
 CellID->9109],
Cell[6391, 207, 1470, 51, 70, "Notes",
 CellID->162410462],
Cell[7864, 260, 231, 7, 70, "Notes",
 CellID->42112773]
}, Closed]],
Cell[CellGroupData[{
Cell[8132, 272, 311, 9, 70, "SeeAlsoSection",
 CellID->18728],
Cell[8446, 283, 501, 17, 70, "SeeAlso",
 CellID->17679]
}, Open  ]],
Cell[CellGroupData[{
Cell[8984, 305, 317, 9, 70, "TutorialsSection",
 CellID->44251790],
Cell[9304, 316, 187, 4, 70, "Tutorials",
 CellID->285588384]
}, Open  ]],
Cell[CellGroupData[{
Cell[9528, 325, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[9850, 336, 157, 3, 70, "MoreAbout",
 CellID->2373510],
Cell[10010, 341, 203, 5, 70, "MoreAbout",
 CellID->42492652]
}, Open  ]],
Cell[10228, 349, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

