(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8048,        273]
NotebookOptionsPosition[      6119,        212]
NotebookOutlinePosition[      7231,        242]
CellTagsIndexPosition[      7188,        239]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RGFToSetPartition" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/RGFToSetPartition"], "RGFs" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/RGFs"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"RGFToSetPartition\"\>", 
       2->"\<\"RGFs\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Partitions and Compositions" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/PartitionsAndCompositions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Partitions and Compositions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SetPartitionToRGF", "ObjectName",
 CellID->19704],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SetPartitionToRGF", "[", 
       RowBox[{
        StyleBox["sp", "TI"], ",", 
        StyleBox["set", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]converts the set partition ",
     Cell[BoxData[
      StyleBox["sp", "TI"]], "InlineFormula"],
     " of ",
     Cell[BoxData[
      StyleBox["set", "TI"]], "InlineFormula"],
     " into the corresponding restricted growth function. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6755]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "If the optional argument ",
 Cell[BoxData[
  StyleBox["set", "TI"]], "InlineFormula"],
 " is not specified, then it is assumed that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " knows the underlying order on the set for which ",
 Cell[BoxData[
  StyleBox["sp", "TI"]], "InlineFormula"],
 " is a set partition."
}], "Notes",
 CellID->8879]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14252],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RGFToSetPartition",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/RGFToSetPartition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RGFs",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/RGFs"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10361]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->466698447],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->595225268]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Partitions and Compositions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/PartitionsAndCompositions"]], "MoreAbout",
 CellID->107774486]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SetPartitionToRGF - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 53, 22.5609130}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "SetPartitionToRGF[sp, set] converts the set partition sp of set into the \
corresponding restricted growth function. ", "synonyms" -> {}, "title" -> 
    "SetPartitionToRGF", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/SetPartitionToRGF"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1939, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2562, 77, 55, 1, 70, "ObjectName",
 CellID->19704],
Cell[2620, 80, 652, 20, 70, "Usage",
 CellID->6755]
}, Open  ]],
Cell[CellGroupData[{
Cell[3309, 105, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3787, 122, 365, 12, 70, "Notes",
 CellID->8879]
}, Closed]],
Cell[CellGroupData[{
Cell[4189, 139, 311, 9, 70, "SeeAlsoSection",
 CellID->14252],
Cell[4503, 150, 489, 17, 70, "SeeAlso",
 CellID->10361]
}, Open  ]],
Cell[CellGroupData[{
Cell[5029, 172, 318, 9, 70, "TutorialsSection",
 CellID->466698447],
Cell[5350, 183, 187, 4, 70, "Tutorials",
 CellID->595225268]
}, Open  ]],
Cell[CellGroupData[{
Cell[5574, 192, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5896, 203, 181, 4, 70, "MoreAbout",
 CellID->107774486]
}, Open  ]],
Cell[6092, 210, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

