(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11554,        385]
NotebookOptionsPosition[      9278,        316]
NotebookOutlinePosition[     10554,        348]
CellTagsIndexPosition[     10511,        345]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GraphOptions" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/GraphOptions"], 
          "SetGraphOptions" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/SetGraphOptions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"GraphOptions\"\>", 
       2->"\<\"SetGraphOptions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Displaying Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/DisplayingGraphs"], 
          "Graph Construction and Representations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]},\
 #, 2]& , Evaluator -> Automatic], {1->"\<\"Displaying Graphs\"\>", 
       2->"\<\"Graph Construction and Representations\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SetVertexWeights", "ObjectName",
 CellID->28108],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SetVertexWeights", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]assigns random real weights in the range ",
     Cell[BoxData[
      FormBox[
       RowBox[{"[", 
        RowBox[{"0", ",", "1"}], "]"}], TraditionalForm]], "InlineMath"],
     " to vertices in ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SetVertexWeights", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["w", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]assigns the weights in the weight list ",
     Cell[BoxData[
      FormBox["w", TraditionalForm]], "InlineMath"],
     " to the vertices of ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SetVertexWeights", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["vs", "TI"], ",", 
        StyleBox["w", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]assigns the weights in the weight list ",
     Cell[BoxData[
      FormBox["w", TraditionalForm]], "InlineMath"],
     " to the vertices in the vertex list ",
     Cell[BoxData[
      StyleBox["vs", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->25496]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["SetVertexWeights"], "InlineFormula"],
 " accepts options ",
 Cell[BoxData[
  ButtonBox["WeightingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/WeightingFunction"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["WeightRange",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/WeightRange"]], "InlineFormula"],
 ". The default value for ",
 Cell[BoxData[
  ButtonBox["WeightingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/WeightingFunction"]], 
  "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal",
   ButtonNote->"ObsLink: Random -> RandomReal (RandomInteger)"]], 
  "InlineFormula"],
 " and the default value for ",
 Cell[BoxData[
  ButtonBox["WeightRange",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/WeightRange"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    RowBox[{"0", ",", "1"}], "]"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->19772],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WeightingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/WeightingFunction"]], 
  "InlineFormula"],
 " can take values ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal",
   ButtonNote->"ObsLink: Random -> RandomReal (RandomInteger)"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RandomInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/RandomInteger"]], "InlineFormula"],
 ", or any pure function that takes two arguments, an integer as the first \
argument and a pair ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["number", "TI"], ",", 
    StyleBox["number", "TI"]}], "}"}]], "InlineFormula"],
 " as the second argument."
}], "Notes",
 CellID->251133476],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WeightRange",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/WeightRange"]], "InlineFormula"],
 " can be an integer range or a real range."
}], "Notes",
 CellID->143276713]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21594],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/GraphOptions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetGraphOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/SetGraphOptions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29033]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->359054540],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->628483941]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Displaying Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/DisplayingGraphs"]], "MoreAbout",
 CellID->390663326],

Cell[TextData[ButtonBox["Graph Construction and Representations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]], \
"MoreAbout",
 CellID->109865945]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SetVertexWeights - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 53, 22.8890464}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "SetVertexWeights[g] assigns random real weights in the range [0, 1] to \
vertices in g. SetVertexWeights[g, w] assigns the weights in the weight list \
w to the vertices of g. SetVertexWeights[g, vs, w] assigns the weights in the \
weight list w to the vertices in the vertex list vs.", "synonyms" -> {}, 
    "title" -> "SetVertexWeights", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/SetVertexWeights"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2157, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2780, 82, 54, 1, 70, "ObjectName",
 CellID->28108],
Cell[2837, 85, 1592, 49, 70, "Usage",
 CellID->25496]
}, Open  ]],
Cell[CellGroupData[{
Cell[4466, 139, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4944, 156, 1103, 38, 70, "Notes",
 CellID->19772],
Cell[6050, 196, 829, 27, 70, "Notes",
 CellID->251133476],
Cell[6882, 225, 232, 7, 70, "Notes",
 CellID->143276713]
}, Closed]],
Cell[CellGroupData[{
Cell[7151, 237, 311, 9, 70, "SeeAlsoSection",
 CellID->21594],
Cell[7465, 248, 501, 17, 70, "SeeAlso",
 CellID->29033]
}, Open  ]],
Cell[CellGroupData[{
Cell[8003, 270, 318, 9, 70, "TutorialsSection",
 CellID->359054540],
Cell[8324, 281, 187, 4, 70, "Tutorials",
 CellID->628483941]
}, Open  ]],
Cell[CellGroupData[{
Cell[8548, 290, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[8870, 301, 159, 3, 70, "MoreAbout",
 CellID->390663326],
Cell[9032, 306, 204, 5, 70, "MoreAbout",
 CellID->109865945]
}, Open  ]],
Cell[9251, 314, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

