(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9354,        315]
NotebookOptionsPosition[      7410,        253]
NotebookOutlinePosition[      8480,        282]
CellTagsIndexPosition[      8437,        279]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AllPairsShortestPath" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/AllPairsShortestPath"], 
          "ShortestPathSpanningTree" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/ShortestPathSpanningTree"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AllPairsShortestPath\"\>", 
       2->"\<\"ShortestPathSpanningTree\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphAlgorithms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graph Algorithms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ShortestPath", "ObjectName",
 CellID->14773],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ShortestPath", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["start", "TI"], ",", 
        StyleBox["end", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]finds a shortest path between vertices ",
     Cell[BoxData[
      StyleBox["start", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["end", "TI"]], "InlineFormula"],
     " in graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17808]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "An option ",
 Cell[BoxData[
  ButtonBox["Algorithm",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/Algorithm"]], "InlineFormula"],
 " that takes on the values ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Dijkstra",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/Dijkstra"]], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  ButtonBox["BellmanFord",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/BellmanFord"]], "InlineFormula"],
 " is provided. This allows a choice between using Dijkstra's algorithm and \
the Bellman\[Dash]Ford algorithm. "
}], "Notes",
 CellID->9084],

Cell[TextData[{
 "The default is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Algorithm",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/Algorithm"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ". In this case, depending on whether edges have negative weights and \
depending on the density of the graph, the algorithm chooses between ",
 Cell[BoxData[
  ButtonBox["BellmanFord",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/BellmanFord"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Dijkstra",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/Dijkstra"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->511975024]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18028],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AllPairsShortestPath",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/AllPairsShortestPath"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShortestPathSpanningTree",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ShortestPathSpanningTree"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4000]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28561874],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->22510400]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphAlgorithms"]], "MoreAbout",
 CellID->229349296]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ShortestPath - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 53, 23.2171798}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "ShortestPath[g, start, end] finds a shortest path between vertices start \
and end in graph g. ", "synonyms" -> {}, "title" -> "ShortestPath", "type" -> 
    "Symbol", "uri" -> "Combinatorica/ref/ShortestPath"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1991, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2614, 78, 50, 1, 70, "ObjectName",
 CellID->14773],
Cell[2667, 81, 743, 24, 70, "Usage",
 CellID->17808]
}, Open  ]],
Cell[CellGroupData[{
Cell[3447, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3925, 127, 748, 24, 70, "Notes",
 CellID->9084],
Cell[4676, 153, 748, 23, 70, "Notes",
 CellID->511975024]
}, Closed]],
Cell[CellGroupData[{
Cell[5461, 181, 311, 9, 70, "SeeAlsoSection",
 CellID->18028],
Cell[5775, 192, 534, 17, 70, "SeeAlso",
 CellID->4000]
}, Open  ]],
Cell[CellGroupData[{
Cell[6346, 214, 317, 9, 70, "TutorialsSection",
 CellID->28561874],
Cell[6666, 225, 186, 4, 70, "Tutorials",
 CellID->22510400]
}, Open  ]],
Cell[CellGroupData[{
Cell[6889, 234, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[7211, 245, 157, 3, 70, "MoreAbout",
 CellID->229349296]
}, Open  ]],
Cell[7383, 251, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

