(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8460,        284]
NotebookOptionsPosition[      6472,        222]
NotebookOutlinePosition[      7643,        253]
CellTagsIndexPosition[      7600,        250]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ShakeGraph" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/ShakeGraph"], 
          "ShowGraph" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/ShowGraph"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"ShakeGraph\"\>", 
       2->"\<\"ShowGraph\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Displaying Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/DisplayingGraphs"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Displaying Graphs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SpringEmbedding", "ObjectName",
 CellID->12672],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SpringEmbedding", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]beautifies the embedding of graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " by modeling the embedding as a system of springs. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SpringEmbedding", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["step", "TI"], ",", 
        StyleBox["increment", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]can be used to refine the algorithm. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->1276]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The value of ",
 Cell[BoxData[
  StyleBox["step", "TI"]], "InlineFormula"],
 " tells the function how many iterations to run the algorithm. The value of \
",
 Cell[BoxData[
  StyleBox["increment", "TI"]], "InlineFormula"],
 " tells the function the distance to move the vertices at each ",
 Cell[BoxData[
  StyleBox["step", "TI"]], "InlineFormula"],
 ". The default values are 10 and 0.15 for ",
 Cell[BoxData[
  StyleBox["step", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["increment", "TI"]], "InlineFormula"],
 ", respectively."
}], "Notes",
 CellID->11131]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22977],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShakeGraph",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ShakeGraph"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShowGraph",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ShowGraph"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26170]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->64712123],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->241718520]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Displaying Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/DisplayingGraphs"]], "MoreAbout",
 CellID->112310887]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SpringEmbedding - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 53, 31.3580132}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "SpringEmbedding[g] beautifies the embedding of graph g by modeling the \
embedding as a system of springs. SpringEmbedding[g, step, increment] can be \
used to refine the algorithm. ", "synonyms" -> {}, "title" -> 
    "SpringEmbedding", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/SpringEmbedding"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1904, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2527, 77, 53, 1, 70, "ObjectName",
 CellID->12672],
Cell[2583, 80, 838, 24, 70, "Usage",
 CellID->1276]
}, Open  ]],
Cell[CellGroupData[{
Cell[3458, 109, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3936, 126, 596, 19, 70, "Notes",
 CellID->11131]
}, Closed]],
Cell[CellGroupData[{
Cell[4569, 150, 311, 9, 70, "SeeAlsoSection",
 CellID->22977],
Cell[4883, 161, 485, 17, 70, "SeeAlso",
 CellID->26170]
}, Open  ]],
Cell[CellGroupData[{
Cell[5405, 183, 317, 9, 70, "TutorialsSection",
 CellID->64712123],
Cell[5725, 194, 187, 4, 70, "Tutorials",
 CellID->241718520]
}, Open  ]],
Cell[CellGroupData[{
Cell[5949, 203, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[6271, 214, 159, 3, 70, "MoreAbout",
 CellID->112310887]
}, Open  ]],
Cell[6445, 220, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

