(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6746,        226]
NotebookOptionsPosition[      5074,        173]
NotebookOutlinePosition[      6119,        202]
CellTagsIndexPosition[      6076,        199]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AlternatingGroup" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/AlternatingGroup"], "OrbitInventory" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/OrbitInventory"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"AlternatingGroup\"\>", 
       2->"\<\"OrbitInventory\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Permutation Groups" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/PermutationGroups"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Permutation Groups\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SymmetricGroup", "ObjectName",
 CellID->10979],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SymmetricGroup", "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the symmetric group on ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " symbols."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->30554]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14577],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AlternatingGroup",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/AlternatingGroup"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OrbitInventory",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/OrbitInventory"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7374]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->409063428],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->369517938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Permutation Groups",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/PermutationGroups"]], "MoreAbout",
 CellID->180956024]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SymmetricGroup - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 53, 39.3113418}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "SymmetricGroup[n] returns the symmetric group on n symbols.", 
    "synonyms" -> {}, "title" -> "SymmetricGroup", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/SymmetricGroup"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1952, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2575, 78, 52, 1, 70, "ObjectName",
 CellID->10979],
Cell[2630, 81, 480, 15, 70, "Usage",
 CellID->30554]
}, Open  ]],
Cell[CellGroupData[{
Cell[3147, 101, 311, 9, 70, "SeeAlsoSection",
 CellID->14577],
Cell[3461, 112, 506, 17, 70, "SeeAlso",
 CellID->7374]
}, Open  ]],
Cell[CellGroupData[{
Cell[4004, 134, 318, 9, 70, "TutorialsSection",
 CellID->409063428],
Cell[4325, 145, 187, 4, 70, "Tutorials",
 CellID->369517938]
}, Open  ]],
Cell[CellGroupData[{
Cell[4549, 154, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[4871, 165, 161, 3, 70, "MoreAbout",
 CellID->180956024]
}, Open  ]],
Cell[5047, 171, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

