(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7020,        231]
NotebookOptionsPosition[      5259,        177]
NotebookOutlinePosition[      6396,        207]
CellTagsIndexPosition[      6353,        204]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FiniteGraphs" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/FiniteGraphs"], 
          "HamiltonianCycle" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/HamiltonianCycle"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"FiniteGraphs\"\>", 
       2->"\<\"HamiltonianCycle\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Built-in Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/BuiltinGraphs"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Built-in Graphs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ThomassenGraph", "ObjectName",
 CellID->31409],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["ThomassenGraph"], "InlineFormula"],
     "\[LineSeparator]returns a hypotraceable graph, a graph ",
     Cell[BoxData[
      FormBox["G", TraditionalForm]], "InlineMath"],
     " that has no Hamiltonian path but whose subgraph ",
     Cell[BoxData[
      FormBox[
       RowBox[{"G", "-", "v"}], TraditionalForm]], "InlineMath"],
     " for every vertex ",
     Cell[BoxData[
      FormBox["v", TraditionalForm]], "InlineMath"],
     " has a Hamiltonian path."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15316]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28982],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FiniteGraphs",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/FiniteGraphs"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HamiltonianCycle",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/HamiltonianCycle"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3410]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->101818631],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->9908318]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Built-in Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/BuiltinGraphs"]], "MoreAbout",
 CellID->48233204]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ThomassenGraph - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 53, 47.6240546}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "ThomassenGraph returns a hypotraceable graph, a graph G that has no \
Hamiltonian path but whose subgraph G - v for every vertex v has a \
Hamiltonian path.", "synonyms" -> {}, "title" -> "ThomassenGraph", "type" -> 
    "Symbol", "uri" -> "Combinatorica/ref/ThomassenGraph"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1927, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2550, 77, 52, 1, 70, "ObjectName",
 CellID->31409],
Cell[2605, 80, 704, 20, 70, "Usage",
 CellID->15316]
}, Open  ]],
Cell[CellGroupData[{
Cell[3346, 105, 311, 9, 70, "SeeAlsoSection",
 CellID->28982],
Cell[3660, 116, 502, 17, 70, "SeeAlso",
 CellID->3410]
}, Open  ]],
Cell[CellGroupData[{
Cell[4199, 138, 318, 9, 70, "TutorialsSection",
 CellID->101818631],
Cell[4520, 149, 185, 4, 70, "Tutorials",
 CellID->9908318]
}, Open  ]],
Cell[CellGroupData[{
Cell[4742, 158, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5064, 169, 153, 3, 70, "MoreAbout",
 CellID->48233204]
}, Open  ]],
Cell[5232, 175, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

