(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9184,        311]
NotebookOptionsPosition[      7100,        247]
NotebookOutlinePosition[      8310,        278]
CellTagsIndexPosition[      8267,        275]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FromAdjacencyMatrix" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/FromAdjacencyMatrix"], 
          "ToAdjacencyLists" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/ToAdjacencyLists"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"FromAdjacencyMatrix\"\>", 
       2->"\<\"ToAdjacencyLists\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Construction and Representations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]},\
 #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Graph Construction and Representations\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ToAdjacencyMatrix", "ObjectName",
 CellID->783],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ToAdjacencyMatrix", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]constructs an adjacency matrix representation for graph \
",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"ToAdjacencyMatrix", "["}], 
         StyleBox["g", "TI"]}], ",", 
        ButtonBox["EdgeWeight",
         BaseStyle->"Link",
         ButtonData->"paclet:Combinatorica/ref/EdgeWeight"]}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]returns edge weights as entries of the adjacency matrix \
with ",
     Cell[BoxData[
      ButtonBox["Infinity",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
     " representing missing edges."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->11543]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "An option ",
 Cell[BoxData["Type"], "InlineFormula"],
 " that takes on values ",
 Cell[BoxData[
  ButtonBox["All",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/All"]], "InlineFormula"],
 " or ",
 Cell[BoxData["Simple"], "InlineFormula"],
 " can be used to affect the matrix constructed. "
}], "Notes",
 CellID->18581],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Type", "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 " is the default, and ",
 Cell[BoxData[
  RowBox[{"Type", "->", "Simple"}]], "InlineFormula"],
 " ignores any self-loops or multiple edges ",
 Cell[BoxData[
  FormBox["g", TraditionalForm]], "InlineMath"],
 " may have. "
}], "Notes",
 CellID->215499208]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29872],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FromAdjacencyMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/FromAdjacencyMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToAdjacencyLists",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ToAdjacencyLists"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3484]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->683479541],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->4004214]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Construction and Representations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]], \
"MoreAbout",
 CellID->108417221]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ToAdjacencyMatrix - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 53, 54.5461068}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "ToAdjacencyMatrix[g] constructs an adjacency matrix representation for \
graph g. ToAdjacencyMatrix[ g, EdgeWeight] returns edge weights as entries of \
the adjacency matrix with Infinity representing missing edges.", 
    "synonyms" -> {}, "title" -> "ToAdjacencyMatrix", "type" -> "Symbol", 
    "uri" -> "Combinatorica/ref/ToAdjacencyMatrix"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2031, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2654, 80, 53, 1, 70, "ObjectName",
 CellID->783],
Cell[2710, 83, 1109, 35, 70, "Usage",
 CellID->11543]
}, Open  ]],
Cell[CellGroupData[{
Cell[3856, 123, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4334, 140, 339, 12, 70, "Notes",
 CellID->18581],
Cell[4676, 154, 409, 14, 70, "Notes",
 CellID->215499208]
}, Closed]],
Cell[CellGroupData[{
Cell[5122, 173, 311, 9, 70, "SeeAlsoSection",
 CellID->29872],
Cell[5436, 184, 516, 17, 70, "SeeAlso",
 CellID->3484]
}, Open  ]],
Cell[CellGroupData[{
Cell[5989, 206, 318, 9, 70, "TutorialsSection",
 CellID->683479541],
Cell[6310, 217, 185, 4, 70, "Tutorials",
 CellID->4004214]
}, Open  ]],
Cell[CellGroupData[{
Cell[6532, 226, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[6854, 237, 204, 5, 70, "MoreAbout",
 CellID->108417221]
}, Open  ]],
Cell[7073, 245, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

