(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9085,        308]
NotebookOptionsPosition[      7080,        244]
NotebookOutlinePosition[      8155,        273]
CellTagsIndexPosition[      8112,        270]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FromOrderedPairs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/FromOrderedPairs"], "FromUnorderedPairs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/FromUnorderedPairs"], "ToUnorderedPairs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/ToUnorderedPairs"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"FromOrderedPairs\"\>", 
       2->"\<\"FromUnorderedPairs\"\>", 
       3->"\<\"ToUnorderedPairs\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Construction and Representations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]},\
 #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Graph Construction and Representations\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ToOrderedPairs", "ObjectName",
 CellID->19966],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ToOrderedPairs", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]constructs a list of ordered pairs representing the \
edges of the graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16637]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox["g", TraditionalForm]], "InlineMath"],
 " is undirected each edge is interpreted as two ordered pairs. "
}], "Notes",
 CellID->445071646],

Cell[TextData[{
 "An option called ",
 Cell[BoxData["Type"], "InlineFormula"],
 " that takes on values ",
 Cell[BoxData["Simple"], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["All",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/All"]], "InlineFormula"],
 " can be used to affect the constructed representation. "
}], "Notes",
 CellID->6990],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Type", "->", "Simple"}]], "InlineFormula"],
 " forces the removal of multiple edges and self-loops. ",
 Cell[BoxData[
  RowBox[{"Type", "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 " keeps all information and is the default option."
}], "Notes",
 CellID->25134288]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7877],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FromOrderedPairs",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/FromOrderedPairs"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FromUnorderedPairs",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/FromUnorderedPairs"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToUnorderedPairs",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ToUnorderedPairs"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30128]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->71200563],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->132860480]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Construction and Representations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]], \
"MoreAbout",
 CellID->5855402]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ToOrderedPairs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 53, 55.2179990}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "ToOrderedPairs[g] constructs a list of ordered pairs representing the \
edges of the graph g. ", "synonyms" -> {}, "title" -> "ToOrderedPairs", 
    "type" -> "Symbol", "uri" -> "Combinatorica/ref/ToOrderedPairs"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2172, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2795, 82, 52, 1, 70, "ObjectName",
 CellID->19966],
Cell[2850, 85, 515, 16, 70, "Usage",
 CellID->16637]
}, Open  ]],
Cell[CellGroupData[{
Cell[3402, 106, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3880, 123, 186, 6, 70, "Notes",
 CellID->445071646],
Cell[4069, 131, 353, 12, 70, "Notes",
 CellID->6990],
Cell[4425, 145, 368, 11, 70, "Notes",
 CellID->25134288]
}, Closed]],
Cell[CellGroupData[{
Cell[4830, 161, 310, 9, 70, "SeeAlsoSection",
 CellID->7877],
Cell[5143, 172, 790, 26, 70, "SeeAlso",
 CellID->30128]
}, Open  ]],
Cell[CellGroupData[{
Cell[5970, 203, 317, 9, 70, "TutorialsSection",
 CellID->71200563],
Cell[6290, 214, 187, 4, 70, "Tutorials",
 CellID->132860480]
}, Open  ]],
Cell[CellGroupData[{
Cell[6514, 223, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[6836, 234, 202, 5, 70, "MoreAbout",
 CellID->5855402]
}, Open  ]],
Cell[7053, 242, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

