(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8907,        297]
NotebookOptionsPosition[      6905,        235]
NotebookOutlinePosition[      8089,        266]
CellTagsIndexPosition[      8046,        263]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FromOrderedPairs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/FromOrderedPairs"], "FromUnorderedPairs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/FromUnorderedPairs"], "ToOrderedPairs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/ToOrderedPairs"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"FromOrderedPairs\"\>", 
       2->"\<\"FromUnorderedPairs\"\>", 
       3->"\<\"ToOrderedPairs\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Construction and Representations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]},\
 #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Graph Construction and Representations\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ToUnorderedPairs", "ObjectName",
 CellID->22707],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ToUnorderedPairs", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]constructs a list of unordered pairs representing the \
edges of graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     ". Each edge, directed or undirected, results in a pair in which the \
smaller vertex appears first. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6993]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "An option called ",
 Cell[BoxData["Type"], "InlineFormula"],
 " that takes on values ",
 Cell[BoxData[
  ButtonBox["All",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/All"]], "InlineFormula"],
 " or ",
 Cell[BoxData["Simple"], "InlineFormula"],
 " can be used, with ",
 Cell[BoxData[
  ButtonBox["All",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/All"]], "InlineFormula"],
 " being the default value. ",
 Cell[BoxData[
  RowBox[{"Type", "->", "Simple"}]], "InlineFormula"],
 " ignores multiple edges and self-loops in ",
 Cell[BoxData[
  FormBox["g", TraditionalForm]], "InlineMath"],
 "."
}], "Notes",
 CellID->24566626]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23199],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FromOrderedPairs",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/FromOrderedPairs"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FromUnorderedPairs",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/FromUnorderedPairs"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToOrderedPairs",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ToOrderedPairs"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23645]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->51757735],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->38961251]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Construction and Representations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]], \
"MoreAbout",
 CellID->91120097]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ToUnorderedPairs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 53, 55.5617578}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "ToUnorderedPairs[g] constructs a list of unordered pairs representing \
the edges of graph g. Each edge, directed or undirected, results in a pair in \
which the smaller vertex appears first. ", "synonyms" -> {}, "title" -> 
    "ToUnorderedPairs", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/ToUnorderedPairs"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2166, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2789, 82, 54, 1, 70, "ObjectName",
 CellID->22707],
Cell[2846, 85, 612, 17, 70, "Usage",
 CellID->6993]
}, Open  ]],
Cell[CellGroupData[{
Cell[3495, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3973, 124, 648, 23, 70, "Notes",
 CellID->24566626]
}, Closed]],
Cell[CellGroupData[{
Cell[4658, 152, 311, 9, 70, "SeeAlsoSection",
 CellID->23199],
Cell[4972, 163, 786, 26, 70, "SeeAlso",
 CellID->23645]
}, Open  ]],
Cell[CellGroupData[{
Cell[5795, 194, 317, 9, 70, "TutorialsSection",
 CellID->51757735],
Cell[6115, 205, 186, 4, 70, "Tutorials",
 CellID->38961251]
}, Open  ]],
Cell[CellGroupData[{
Cell[6338, 214, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[6660, 225, 203, 5, 70, "MoreAbout",
 CellID->91120097]
}, Open  ]],
Cell[6878, 233, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

