(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7173,        238]
NotebookOptionsPosition[      5402,        184]
NotebookOutlinePosition[      6548,        214]
CellTagsIndexPosition[      6505,        211]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AcyclicQ" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/AcyclicQ"], 
          "PartialOrderQ" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/PartialOrderQ"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"AcyclicQ\"\>", 
       2->"\<\"PartialOrderQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphAlgorithms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graph Algorithms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TopologicalSort", "ObjectName",
 CellID->6002],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"TopologicalSort", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a permutation of the vertices of the directed \
acyclic graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " such that an edge ",
     Cell[BoxData[
      FormBox[
       RowBox[{"(", 
        RowBox[{"i", ",", "j"}], ")"}], TraditionalForm]], "InlineMath"],
     " implies that vertex ",
     Cell[BoxData[
      FormBox["i", TraditionalForm]], "InlineMath"],
     " appears before vertex ",
     Cell[BoxData[
      FormBox["j", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3795]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32499],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AcyclicQ",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/AcyclicQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PartialOrderQ",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/PartialOrderQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3955]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->264993417],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->456941593]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphAlgorithms"]], "MoreAbout",
 CellID->616859909]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TopologicalSort - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 53, 55.3898784}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "TopologicalSort[g] gives a permutation of the vertices of the directed \
acyclic graph g such that an edge (i, j) implies that vertex i appears before \
vertex j.", "synonyms" -> {}, "title" -> "TopologicalSort", "type" -> 
    "Symbol", "uri" -> "Combinatorica/ref/TopologicalSort"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1910, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2533, 77, 52, 1, 70, "ObjectName",
 CellID->6002],
Cell[2588, 80, 872, 27, 70, "Usage",
 CellID->3795]
}, Open  ]],
Cell[CellGroupData[{
Cell[3497, 112, 311, 9, 70, "SeeAlsoSection",
 CellID->32499],
Cell[3811, 123, 488, 17, 70, "SeeAlso",
 CellID->3955]
}, Open  ]],
Cell[CellGroupData[{
Cell[4336, 145, 318, 9, 70, "TutorialsSection",
 CellID->264993417],
Cell[4657, 156, 187, 4, 70, "Tutorials",
 CellID->456941593]
}, Open  ]],
Cell[CellGroupData[{
Cell[4881, 165, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5203, 176, 157, 3, 70, "MoreAbout",
 CellID->616859909]
}, Open  ]],
Cell[5375, 182, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

