(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7698,        251]
NotebookOptionsPosition[      5864,        195]
NotebookOutlinePosition[      7009,        225]
CellTagsIndexPosition[      6966,        222]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TransitiveQ" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/TransitiveQ"], 
          "TransitiveReduction" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/TransitiveReduction"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"TransitiveQ\"\>", 
       2->"\<\"TransitiveReduction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/ConstructingGraphs"], 
          "Graph Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphAlgorithms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Constructing Graphs\"\>", 
       2->"\<\"Graph Algorithms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TransitiveClosure", "ObjectName",
 CellID->11716],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"TransitiveClosure", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]finds the transitive closure of graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     ", the supergraph of ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " that contains edge ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], TraditionalForm]], "InlineMath"],
     " if and only if there is a path from ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " to ",
     Cell[BoxData[
      FormBox["y", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3500]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12776],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TransitiveQ",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/TransitiveQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TransitiveReduction",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/TransitiveReduction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15253]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->733384680],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->767201327]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Constructing Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/ConstructingGraphs"]], "MoreAbout",
 CellID->354465402],

Cell[TextData[ButtonBox["Graph Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphAlgorithms"]], "MoreAbout",
 CellID->127586080]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TransitiveClosure - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 53, 55.7180118}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "TransitiveClosure[g] finds the transitive closure of graph g, the \
supergraph of g that contains edge {x, y} if and only if there is a path from \
x to y.", "synonyms" -> {}, "title" -> "TransitiveClosure", "type" -> 
    "Symbol", "uri" -> "Combinatorica/ref/TransitiveClosure"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2113, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2736, 81, 55, 1, 70, "ObjectName",
 CellID->11716],
Cell[2794, 84, 943, 29, 70, "Usage",
 CellID->3500]
}, Open  ]],
Cell[CellGroupData[{
Cell[3774, 118, 311, 9, 70, "SeeAlsoSection",
 CellID->12776],
Cell[4088, 129, 507, 17, 70, "SeeAlso",
 CellID->15253]
}, Open  ]],
Cell[CellGroupData[{
Cell[4632, 151, 318, 9, 70, "TutorialsSection",
 CellID->733384680],
Cell[4953, 162, 187, 4, 70, "Tutorials",
 CellID->767201327]
}, Open  ]],
Cell[CellGroupData[{
Cell[5177, 171, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5499, 182, 163, 3, 70, "MoreAbout",
 CellID->354465402],
Cell[5665, 187, 157, 3, 70, "MoreAbout",
 CellID->127586080]
}, Open  ]],
Cell[5837, 193, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

