(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7338,        244]
NotebookOptionsPosition[      5667,        191]
NotebookOutlinePosition[      6711,        220]
CellTagsIndexPosition[      6668,        217]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PartialOrderQ" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/PartialOrderQ"], 
          "TransitiveClosure" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/TransitiveClosure"], 
          "TransitiveReduction" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/TransitiveReduction"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PartialOrderQ\"\>", 
       2->"\<\"TransitiveClosure\"\>", 
       3->"\<\"TransitiveReduction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Permutation Groups" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/PermutationGroups"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Permutation Groups\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TransitiveQ", "ObjectName",
 CellID->13727],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"TransitiveQ", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " defines a transitive relation."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18304]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11011],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PartialOrderQ",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/PartialOrderQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TransitiveClosure",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/TransitiveClosure"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TransitiveReduction",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/TransitiveReduction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19853]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->34556877],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->224768238]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Permutation Groups",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/PermutationGroups"]], "MoreAbout",
 CellID->155471949]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TransitiveQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 54, 2.3744322}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "TransitiveQ[g] yields True if graph g defines a transitive relation.", 
    "synonyms" -> {}, "title" -> "TransitiveQ", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/TransitiveQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2126, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2749, 82, 49, 1, 70, "ObjectName",
 CellID->13727],
Cell[2801, 85, 621, 20, 70, "Usage",
 CellID->18304]
}, Open  ]],
Cell[CellGroupData[{
Cell[3459, 110, 311, 9, 70, "SeeAlsoSection",
 CellID->11011],
Cell[3773, 121, 788, 26, 70, "SeeAlso",
 CellID->19853]
}, Open  ]],
Cell[CellGroupData[{
Cell[4598, 152, 317, 9, 70, "TutorialsSection",
 CellID->34556877],
Cell[4918, 163, 187, 4, 70, "Tutorials",
 CellID->224768238]
}, Open  ]],
Cell[CellGroupData[{
Cell[5142, 172, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5464, 183, 161, 3, 70, "MoreAbout",
 CellID->155471949]
}, Open  ]],
Cell[5640, 189, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

