(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7181,        236]
NotebookOptionsPosition[      5392,        182]
NotebookOutlinePosition[      6553,        212]
CellTagsIndexPosition[      6510,        209]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BinarySubsets" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/BinarySubsets"], 
          "RankBinarySubset" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/RankBinarySubset"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"BinarySubsets\"\>", 
       2->"\<\"RankBinarySubset\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Subsets and Cycles" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/SubsetsAndCycles"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Subsets and Cycles\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["UnrankBinarySubset", "ObjectName",
 CellID->20656],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"UnrankBinarySubset", "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["l", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " subset of list ",
     Cell[BoxData[
      FormBox["l", TraditionalForm]], "InlineMath"],
     ", listed in increasing order of integers corresponding to the binary \
representations of the subsets."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14837]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18534],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BinarySubsets",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/BinarySubsets"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RankBinarySubset",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/RankBinarySubset"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20201]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->603195534],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->291342968]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Subsets and Cycles",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/SubsetsAndCycles"]], "MoreAbout",
 CellID->104419199]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"UnrankBinarySubset - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 54, 18.6873498}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "UnrankBinarySubset[n, l] gives the n\\[Null]^th subset of list l, listed \
in increasing order of integers corresponding to the binary representations \
of the subsets.", "synonyms" -> {}, "title" -> "UnrankBinarySubset", "type" -> 
    "Symbol", "uri" -> "Combinatorica/ref/UnrankBinarySubset"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1947, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2570, 78, 56, 1, 70, "ObjectName",
 CellID->20656],
Cell[2629, 81, 801, 24, 70, "Usage",
 CellID->14837]
}, Open  ]],
Cell[CellGroupData[{
Cell[3467, 110, 311, 9, 70, "SeeAlsoSection",
 CellID->18534],
Cell[3781, 121, 505, 17, 70, "SeeAlso",
 CellID->20201]
}, Open  ]],
Cell[CellGroupData[{
Cell[4323, 143, 318, 9, 70, "TutorialsSection",
 CellID->603195534],
Cell[4644, 154, 187, 4, 70, "Tutorials",
 CellID->291342968]
}, Open  ]],
Cell[CellGroupData[{
Cell[4868, 163, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5190, 174, 160, 3, 70, "MoreAbout",
 CellID->104419199]
}, Open  ]],
Cell[5365, 180, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

