(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7861,        259]
NotebookOptionsPosition[      6070,        205]
NotebookOutlinePosition[      7234,        235]
CellTagsIndexPosition[      7191,        232]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RankKSetPartition" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/RankKSetPartition"], 
          "UnrankSetPartition" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/UnrankSetPartition"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"RankKSetPartition\"\>", 
       2->"\<\"UnrankSetPartition\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Partitions and Compositions" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/PartitionsAndCompositions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Partitions and Compositions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["UnrankKSetPartition", "ObjectName",
 CellID->21149],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"UnrankSetPartition", "[", 
       RowBox[{
        StyleBox["r", "TI"], ",", 
        StyleBox["s", "TI"], ",", 
        StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]finds a ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     "-block set partition of ",
     Cell[BoxData[
      FormBox["s", TraditionalForm]], "InlineMath"],
     " with rank ",
     Cell[BoxData[
      FormBox["r", TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"UnrankSetPartition", "[", 
       RowBox[{
        StyleBox["r", "TI"], ",", 
        StyleBox["n", "TI"], ",", 
        StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]finds a ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     "-block set partition of ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "\[Ellipsis]", ",", "n"}], "}"}], 
       TraditionalForm]], "InlineMath"],
     " with rank ",
     Cell[BoxData[
      FormBox["r", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->31773]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8303],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RankKSetPartition",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/RankKSetPartition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UnrankSetPartition",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/UnrankSetPartition"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25049]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->264480036],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->36764185]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Partitions and Compositions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/PartitionsAndCompositions"]], "MoreAbout",
 CellID->527765439]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"UnrankKSetPartition - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 54, 18.9842324}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "UnrankSetPartition[r, s, k] finds a k-block set partition of s with rank \
r. UnrankSetPartition[r, n, k] finds a k-block set partition of {1, 2, ..., \
n} with rank r.", "synonyms" -> {}, "title" -> "UnrankKSetPartition", "type" -> 
    "Symbol", "uri" -> "Combinatorica/ref/UnrankKSetPartition"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2004, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2627, 79, 57, 1, 70, "ObjectName",
 CellID->21149],
Cell[2687, 82, 1390, 45, 70, "Usage",
 CellID->31773]
}, Open  ]],
Cell[CellGroupData[{
Cell[4114, 132, 310, 9, 70, "SeeAlsoSection",
 CellID->8303],
Cell[4427, 143, 517, 17, 70, "SeeAlso",
 CellID->25049]
}, Open  ]],
Cell[CellGroupData[{
Cell[4981, 165, 318, 9, 70, "TutorialsSection",
 CellID->264480036],
Cell[5302, 176, 186, 4, 70, "Tutorials",
 CellID->36764185]
}, Open  ]],
Cell[CellGroupData[{
Cell[5525, 185, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5847, 196, 181, 4, 70, "MoreAbout",
 CellID->527765439]
}, Open  ]],
Cell[6043, 203, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

