(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7628,        249]
NotebookOptionsPosition[      5793,        194]
NotebookOutlinePosition[      7001,        225]
CellTagsIndexPosition[      6958,        222]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EdgeConnectivity" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/EdgeConnectivity"], "Harary" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/Harary"], 
          "NetworkFlow" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/NetworkFlow"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"EdgeConnectivity\"\>", 2->"\<\"Harary\"\>", 
       3->"\<\"NetworkFlow\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cycles and Connectivity" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/CyclesAndConnectivity"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Cycles and Connectivity\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["VertexConnectivity", "ObjectName",
 CellID->30348],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"VertexConnectivity", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the minimum number of vertices whose deletion \
from graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " disconnects it. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"VertexConnectivity", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", "Cut"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a set of vertices of minimum size whose removal \
disconnects the graph."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->11740]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23225],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EdgeConnectivity",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/EdgeConnectivity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Harary",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/Harary"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NetworkFlow",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/NetworkFlow"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2439]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->277252352],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->153307228]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Cycles and Connectivity",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/CyclesAndConnectivity"]], "MoreAbout",\

 CellID->158538393]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"VertexConnectivity - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 54, 27.4844500}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "VertexConnectivity[g] gives the minimum number of vertices whose \
deletion from graph g disconnects it. VertexConnectivity[g, Cut] gives a set \
of vertices of minimum size whose removal disconnects the graph.", 
    "synonyms" -> {}, "title" -> "VertexConnectivity", "type" -> "Symbol", 
    "uri" -> "Combinatorica/ref/VertexConnectivity"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2073, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2696, 80, 56, 1, 70, "ObjectName",
 CellID->30348],
Cell[2755, 83, 814, 24, 70, "Usage",
 CellID->11740]
}, Open  ]],
Cell[CellGroupData[{
Cell[3606, 112, 311, 9, 70, "SeeAlsoSection",
 CellID->23225],
Cell[3920, 123, 755, 26, 70, "SeeAlso",
 CellID->2439]
}, Open  ]],
Cell[CellGroupData[{
Cell[4712, 154, 318, 9, 70, "TutorialsSection",
 CellID->277252352],
Cell[5033, 165, 187, 4, 70, "Tutorials",
 CellID->153307228]
}, Open  ]],
Cell[CellGroupData[{
Cell[5257, 174, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5579, 185, 172, 4, 70, "MoreAbout",
 CellID->158538393]
}, Open  ]],
Cell[5766, 192, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

