(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8701,        294]
NotebookOptionsPosition[      6852,        234]
NotebookOutlinePosition[      7883,        263]
CellTagsIndexPosition[      7840,        260]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BipartiteMatchingAndCover" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/BipartiteMatchingAndCover"], 
          "MinimumVertexCover" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/MinimumVertexCover"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"BipartiteMatchingAndCover\"\>", 
       2->"\<\"MinimumVertexCover\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/ConstructingGraphs"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Constructing Graphs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["VertexCover", "ObjectName",
 CellID->6215],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"VertexCover", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns a vertex cover of the graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5622]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "An option ",
 Cell[BoxData[
  ButtonBox["Algorithm",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/Algorithm"]], "InlineFormula"],
 " that can take on values ",
 Cell[BoxData[
  ButtonBox["Greedy",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/Greedy"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Approximate",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/Approximate"]], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  ButtonBox["Optimum",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/Optimum"]], "InlineFormula"],
 " is allowed. The default setting is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Algorithm",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/Algorithm"], "->", 
   ButtonBox["Approximate",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/Approximate"]}]], "InlineFormula"],
 ". Different algorithms are used to compute a vertex cover depending on the \
setting of the option ",
 Cell[BoxData[
  ButtonBox["Algorithm",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/Algorithm"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->23411]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15001],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BipartiteMatchingAndCover",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/BipartiteMatchingAndCover"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MinimumVertexCover",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/MinimumVertexCover"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20135]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->740879464],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->802643142]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Constructing Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/ConstructingGraphs"]], "MoreAbout",
 CellID->525038613]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"VertexCover - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 54, 27.6250786}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "VertexCover[g] returns a vertex cover of the graph g. ", 
    "synonyms" -> {}, "title" -> "VertexCover", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/VertexCover"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2005, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2628, 79, 48, 1, 70, "ObjectName",
 CellID->6215],
Cell[2679, 82, 474, 15, 70, "Usage",
 CellID->5622]
}, Open  ]],
Cell[CellGroupData[{
Cell[3190, 102, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3668, 119, 1191, 38, 70, "Notes",
 CellID->23411]
}, Closed]],
Cell[CellGroupData[{
Cell[4896, 162, 311, 9, 70, "SeeAlsoSection",
 CellID->15001],
Cell[5210, 173, 533, 17, 70, "SeeAlso",
 CellID->20135]
}, Open  ]],
Cell[CellGroupData[{
Cell[5780, 195, 318, 9, 70, "TutorialsSection",
 CellID->740879464],
Cell[6101, 206, 187, 4, 70, "Tutorials",
 CellID->802643142]
}, Open  ]],
Cell[CellGroupData[{
Cell[6325, 215, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[6647, 226, 163, 3, 70, "MoreAbout",
 CellID->525038613]
}, Open  ]],
Cell[6825, 232, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

