(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      5700,        204]
NotebookOptionsPosition[      4042,        152]
NotebookOutlinePosition[      5015,        180]
CellTagsIndexPosition[      4972,        177]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["Calculus`VariationalMethods`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "All of the functionality in ",
 Cell[BoxData["Calculus`VariationalMethods`"], "InlineFormula"],
 " is now available through the newly created ",
 ButtonBox["Variational Methods Package",
  BaseStyle->"Link",
  ButtonData->"paclet:VariationalMethods/guide/VariationalMethodsPackage"],
 ". "
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 "To access functionality from the new ",
 ButtonBox["Variational Methods Package",
  BaseStyle->"Link",
  ButtonData->"paclet:VariationalMethods/guide/VariationalMethodsPackage"],
 ", load ",
 Cell[BoxData["VariationalMethods`"], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->21496468],

Cell[BoxData[
 RowBox[{"<<", "Calculus`VariationalMethods`"}]], "Input", "LegacyInput",
 CellID->1663071679],

Cell[BoxData[
 RowBox[{"<<", "VariationalMethods`"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->1746043248],

Cell[TextData[{
 "This is the first variational derivative of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["F", "TI"], "=", 
    SubsuperscriptBox["\[Integral]", 
     StyleBox[
      RowBox[{"x", "m", "i", "n"}], "TI"], 
     StyleBox[
      RowBox[{"x", "m", "a", "x"}], "TI"]], 
    StyleBox["y", "TI"], 
    RowBox[{"(", 
     StyleBox["x", "TI"], ")"}], 
    SqrtBox[
     RowBox[{"1", "+", 
      SuperscriptBox[
       StyleBox["y", "TI"], "\[Prime]"], 
      SuperscriptBox[
       RowBox[{"(", 
        StyleBox["x", "TI"], ")"}], "2"]}]], "\[DifferentialD]", 
    StyleBox["x", "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ":"
}], "UpgradeDetail",
 CellID->723029451],

Cell[BoxData[
 RowBox[{"VariationalD", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], " ", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "x", "]"}], "^", "2"}]}], "]"}]}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input", "LegacyInput",
 CellID->146173710],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VariationalD", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], " ", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "x", "]"}], "^", "2"}]}], "]"}]}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->380652551],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "+", 
   SuperscriptBox[
    RowBox[{
     SuperscriptBox["y", "\[Prime]",
      MultilineFunction->None], "[", "x", "]"}], "2"], "-", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], " ", 
    RowBox[{
     SuperscriptBox["y", "\[Prime]\[Prime]",
      MultilineFunction->None], "[", "x", "]"}]}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SuperscriptBox[
      RowBox[{
       SuperscriptBox["y", "\[Prime]",
        MultilineFunction->None], "[", "x", "]"}], "2"]}], ")"}], 
   RowBox[{"3", "/", "2"}]]]], "Output",
 CellLabel->"Out[3]=",
 CellID->60519835]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 55, 7.1885914}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/VariationalMethods"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 78, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[890, 35, 350, 9, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[1243, 46, 309, 9, 70, "UpgradeDetail",
 CellID->21496468],
Cell[1555, 57, 108, 2, 70, "Input",
 CellID->1663071679],
Cell[1666, 61, 107, 3, 70, "Input",
 CellID->1746043248],
Cell[1776, 66, 830, 28, 70, "UpgradeDetail",
 CellID->723029451],
Cell[2609, 96, 359, 11, 70, "Input",
 CellID->146173710],
Cell[CellGroupData[{
Cell[2993, 111, 367, 12, 70, "Input",
 CellID->380652551],
Cell[3363, 125, 625, 21, 70, "Output",
 CellID->60519835]
}, Open  ]]
}, Open  ]],
Cell[4015, 150, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

