(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     96825,       2856]
NotebookOptionsPosition[     90363,       2632]
NotebookOutlinePosition[     91328,       2660]
CellTagsIndexPosition[     91285,       2657]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["DiscreteMath`GraphPlot`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 " functionality is now available in the newly added built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel functions ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["LayeredGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFormula"],
 ".\n",
 Cell[BoxData[
  ButtonBox["GraphPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot3D"]], "InlineFormula"],
 " is now available as the newly added built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel function ",
 Cell[BoxData[
  ButtonBox["GraphPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot3D"]], "InlineFormula"],
 ".\n",
 Cell[BoxData[
  ButtonBox["TreePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TreePlot"]], "InlineFormula"],
 " is now available as the newly added built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel function ",
 Cell[BoxData[
  ButtonBox["TreePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TreePlot"]], "InlineFormula"],
 ".\n",
 Cell[BoxData[
  ButtonBox["GraphDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/GraphDistance"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["PseudoDiameter",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/PseudoDiameter"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["MaximalBipartiteMatching",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/MaximalBipartiteMatching"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["MaximalIndependentVertexSet",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/MaximalIndependentVertexSet"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["MaximalIndependentEdgeSet",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/MaximalIndependentEdgeSet"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["MinCut",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/MinCut"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["StrongComponents",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/StrongComponents"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["VertexList",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/VertexList"]], "InlineFormula"],
 " are now available through the newly created ",
 ButtonBox["Graph Utilities Package",
  BaseStyle->"Link",
  ButtonData->"paclet:GraphUtilities/guide/GraphUtilitiesPackage"],
 ". \n",
 Cell[BoxData["EdgeStyleFunction"], "InlineFormula"],
 " option is now available as the newly added built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel option ",
 Cell[BoxData[
  ButtonBox["EdgeRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeRenderingFunction"]], "InlineFormula"],
 "\n",
 Cell[BoxData["TreeSizeFunction"], "InlineFormula"],
 " option is now available as the newly added built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel option ",
 Cell[BoxData[
  ButtonBox["LayerSizeFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayerSizeFunction"]], "InlineFormula"],
 ". \n",
 Cell[BoxData["VertexCoordinates"], "InlineFormula"],
 " option is now available as the newly added built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel option ",
 Cell[BoxData[
  ButtonBox["VertexCoordinateRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexCoordinateRules"]], "InlineFormula"],
 ". \n",
 Cell[BoxData["VertexStyleFunction"], "InlineFormula"],
 " option is now available as the newly added built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel option ",
 Cell[BoxData[
  ButtonBox["VertexRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexRenderingFunction"]], "InlineFormula"],
 ". \n",
 Cell[BoxData["RootPosition"], "InlineFormula"],
 " option is now available as the second argument to built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel function ",
 Cell[BoxData[
  ButtonBox["TreePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TreePlot"]], "InlineFormula"],
 ". "
}], "UpgradeSummary",
 CellID->1010000471],

Cell[CellGroupData[{

Cell["GraphPlot", "UpgradeDetailLabel",
 CellID->305554978],

Cell["Plot a graph specified by a rule list: ", "UpgradeDetail",
 CellID->1457835045],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "DiscreteMath`GraphPlot`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"g", "=", 
  RowBox[{"GraphPlot", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "\[Rule]", "1"}], ",", 
     RowBox[{"3", "\[Rule]", "1"}], ",", 
     RowBox[{"3", "\[Rule]", "2"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"4", "\[Rule]", "2"}], ",", 
     RowBox[{"5", "\[Rule]", "1"}], ",", 
     RowBox[{"5", "\[Rule]", "2"}]}], "}"}], "]"}]}]}], "Input", \
"LegacyInput",
 CellID->680503780],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "=", 
  RowBox[{"GraphPlot", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "\[Rule]", "1"}], ",", 
     RowBox[{"3", "\[Rule]", "1"}], ",", 
     RowBox[{"3", "\[Rule]", "2"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"4", "\[Rule]", "2"}], ",", 
     RowBox[{"5", "\[Rule]", "1"}], ",", 
     RowBox[{"5", "\[Rule]", "2"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->81334614],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.006078734602766, 1.019799542548478}, {
    1.0080578178257147`, 0.44822510047187875`}, {1.709022433897685, 
    1.471694510063808}, {1.715404860550158, 0.}, {0., 0.7312815889854167}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {3, 2}, {3, 1}, {4, 2}, {4, 1}, {5, 2}, {5, 1}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.006078734602766, 1.019799542548478}, {
     1.0080578178257147`, 0.44822510047187875`}, {1.709022433897685, 
     1.471694510063808}, {1.715404860550158, 0.}, {0., 
     0.7312815889854167}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellLabel->"Out[1]=",
 CellID->897025052]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["GraphPlot3D", "UpgradeDetailLabel",
 CellID->235896513],

Cell["Lay out a graph in 3D: ", "UpgradeDetail",
 CellID->28242450],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "DiscreteMath`GraphPlot`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"2", "\[Rule]", "1"}], ",", 
    RowBox[{"3", "\[Rule]", "1"}], ",", 
    RowBox[{"3", "\[Rule]", "2"}], ",", 
    RowBox[{"4", "\[Rule]", "1"}], ",", 
    RowBox[{"4", "\[Rule]", "2"}], ",", 
    RowBox[{"5", "\[Rule]", "1"}], ",", 
    RowBox[{"5", "\[Rule]", "2"}]}], "}"}], "]"}]}], "Input", "LegacyInput",
 CellID->96311716],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"2", "\[Rule]", "1"}], ",", 
    RowBox[{"3", "\[Rule]", "1"}], ",", 
    RowBox[{"3", "\[Rule]", "2"}], ",", 
    RowBox[{"4", "\[Rule]", "1"}], ",", 
    RowBox[{"4", "\[Rule]", "2"}], ",", 
    RowBox[{"5", "\[Rule]", "1"}], ",", 
    RowBox[{"5", "\[Rule]", "2"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->334615587],

Cell[BoxData[
 Graphics3DBox[
  TagBox[GraphicsComplex3DBox[{{0.9524771420518391, 0.7349664917007513, 
    0.7383066979362616}, {0.9524771829291391, 0.7349665229277859, 0.}, {
    1.2729996078719272`, 1.64973866353329, 0.3696580007110389}, {
    1.584432051246063, 0., 0.3696579905700017}, {0., 0.5551609690451003, 
    0.36965797817609386`}}, {
     {RGBColor[0.5, 0., 0.], 
      Line3DBox[{{1, 2}, {3, 2}, {3, 1}, {4, 2}, {4, 1}, {5, 2}, {5, 1}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[Point3DBox[1],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[2],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.9524771420518391, 0.7349664917007513, 
     0.7383066979362616}, {0.9524771829291391, 0.7349665229277859, 0.}, {
     1.2729996078719272`, 1.64973866353329, 0.3696580007110389}, {
     1.584432051246063, 0., 0.3696579905700017}, {0., 0.5551609690451003, 
     0.36965797817609386`}}]& ],
  AspectRatio->Automatic,
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 CellLabel->"Out[4]=",
 CellID->1516381488]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TreePlot", "UpgradeDetailLabel",
 CellID->749583176],

Cell["Draw a binary tree: ", "UpgradeDetail",
 CellID->352272671],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "DiscreteMath`GraphPlot`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"g", "=", 
  RowBox[{"Flatten", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"i", "\[Rule]", " ", 
        RowBox[{"2", "*", "i"}]}], ",", " ", 
       RowBox[{"i", "\[Rule]", 
        RowBox[{
         RowBox[{"2", "*", "i"}], "+", "1"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{
        RowBox[{"2", "^", "4"}], "-", "1"}]}], "}"}]}], "]"}], 
   "]"}]}], "\n", 
 RowBox[{
  RowBox[{"TreePlot", "[", "g", "]"}], ";"}]}], "Input", "LegacyInput",
 CellID->730029133],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"g", "=", 
  RowBox[{"Flatten", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"i", "\[Rule]", " ", 
        RowBox[{"2", "*", "i"}]}], ",", " ", 
       RowBox[{"i", "\[Rule]", 
        RowBox[{
         RowBox[{"2", "*", "i"}], "+", "1"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{
        RowBox[{"2", "^", "4"}], "-", "1"}]}], "}"}]}], "]"}], 
   "]"}]}], "\n", 
 RowBox[{"TreePlot", "[", "g", "]"}]}], "Input",
 CellLabel->"In[79]:=",
 CellID->451904711],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Rule]", "2"}], ",", 
   RowBox[{"1", "\[Rule]", "3"}], ",", 
   RowBox[{"2", "\[Rule]", "4"}], ",", 
   RowBox[{"2", "\[Rule]", "5"}], ",", 
   RowBox[{"3", "\[Rule]", "6"}], ",", 
   RowBox[{"3", "\[Rule]", "7"}], ",", 
   RowBox[{"4", "\[Rule]", "8"}], ",", 
   RowBox[{"4", "\[Rule]", "9"}], ",", 
   RowBox[{"5", "\[Rule]", "10"}], ",", 
   RowBox[{"5", "\[Rule]", "11"}], ",", 
   RowBox[{"6", "\[Rule]", "12"}], ",", 
   RowBox[{"6", "\[Rule]", "13"}], ",", 
   RowBox[{"7", "\[Rule]", "14"}], ",", 
   RowBox[{"7", "\[Rule]", "15"}], ",", 
   RowBox[{"8", "\[Rule]", "16"}], ",", 
   RowBox[{"8", "\[Rule]", "17"}], ",", 
   RowBox[{"9", "\[Rule]", "18"}], ",", 
   RowBox[{"9", "\[Rule]", "19"}], ",", 
   RowBox[{"10", "\[Rule]", "20"}], ",", 
   RowBox[{"10", "\[Rule]", "21"}], ",", 
   RowBox[{"11", "\[Rule]", "22"}], ",", 
   RowBox[{"11", "\[Rule]", "23"}], ",", 
   RowBox[{"12", "\[Rule]", "24"}], ",", 
   RowBox[{"12", "\[Rule]", "25"}], ",", 
   RowBox[{"13", "\[Rule]", "26"}], ",", 
   RowBox[{"13", "\[Rule]", "27"}], ",", 
   RowBox[{"14", "\[Rule]", "28"}], ",", 
   RowBox[{"14", "\[Rule]", "29"}], ",", 
   RowBox[{"15", "\[Rule]", "30"}], ",", 
   RowBox[{"15", "\[Rule]", "31"}]}], "}"}]], "Output",
 CellLabel->"Out[79]=",
 CellID->72431850],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{4.330127018922194, 2.3094010767585034`}, {
    2.0207259421636903`, 1.7320508075688776`}, {6.639528095680697, 
    1.7320508075688776`}, {0.8660254037844387, 1.1547005383792517`}, {
    3.1754264805429417`, 1.1547005383792517`}, {5.484827557301445, 
    1.1547005383792517`}, {7.794228634059948, 1.1547005383792517`}, {
    0.2886751345948129, 0.577350269189626}, {1.4433756729740645`, 
    0.577350269189626}, {2.598076211353316, 0.577350269189626}, {
    3.7527767497325675`, 0.577350269189626}, {4.907477288111819, 
    0.577350269189626}, {6.062177826491071, 0.577350269189626}, {
    7.216878364870323, 0.577350269189626}, {8.371578903249574, 
    0.577350269189626}, {0., 0.}, {0.5773502691896258, 0.}, {
    1.1547005383792517`, 0.}, {1.7320508075688774`, 0.}, {2.3094010767585034`,
     0.}, {2.886751345948129, 0.}, {3.464101615137755, 0.}, {
    4.041451884327381, 0.}, {4.618802153517007, 0.}, {5.196152422706632, 
    0.}, {5.773502691896258, 0.}, {6.3508529610858835`, 0.}, {
    6.92820323027551, 0.}, {7.505553499465135, 0.}, {8.082903768654761, 0.}, {
    8.660254037844387, 0.}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 3}], 
      LineBox[{2, 4}], LineBox[{2, 5}], LineBox[{3, 6}], LineBox[{3, 7}], 
      LineBox[{4, 8}], LineBox[{4, 9}], LineBox[{5, 10}], LineBox[{5, 11}], 
      LineBox[{6, 12}], LineBox[{6, 13}], LineBox[{7, 14}], LineBox[{7, 15}], 
      LineBox[{8, 16}], LineBox[{8, 17}], LineBox[{9, 18}], LineBox[{9, 19}], 
      LineBox[{10, 20}], LineBox[{10, 21}], LineBox[{11, 22}], 
      LineBox[{11, 23}], LineBox[{12, 24}], LineBox[{12, 25}], 
      LineBox[{13, 26}], LineBox[{13, 27}], LineBox[{14, 28}], 
      LineBox[{14, 29}], LineBox[{15, 30}], LineBox[{15, 31}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "21"],
       Annotation[#, 21, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "22"],
       Annotation[#, 22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "23"],
       Annotation[#, 23, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "24"],
       Annotation[#, 24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "25"],
       Annotation[#, 25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "26"],
       Annotation[#, 26, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        "27"],
       Annotation[#, 27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        "28"],
       Annotation[#, 28, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        "29"],
       Annotation[#, 29, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        "30"],
       Annotation[#, 30, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[31],
        "31"],
       Annotation[#, 31, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{4.330127018922194, 2.3094010767585034`}, {
     2.0207259421636903`, 1.7320508075688776`}, {6.639528095680697, 
     1.7320508075688776`}, {0.8660254037844387, 1.1547005383792517`}, {
     3.1754264805429417`, 1.1547005383792517`}, {5.484827557301445, 
     1.1547005383792517`}, {7.794228634059948, 1.1547005383792517`}, {
     0.2886751345948129, 0.577350269189626}, {1.4433756729740645`, 
     0.577350269189626}, {2.598076211353316, 0.577350269189626}, {
     3.7527767497325675`, 0.577350269189626}, {4.907477288111819, 
     0.577350269189626}, {6.062177826491071, 0.577350269189626}, {
     7.216878364870323, 0.577350269189626}, {8.371578903249574, 
     0.577350269189626}, {0., 0.}, {0.5773502691896258, 0.}, {
     1.1547005383792517`, 0.}, {1.7320508075688774`, 0.}, {
     2.3094010767585034`, 0.}, {2.886751345948129, 0.}, {3.464101615137755, 
     0.}, {4.041451884327381, 0.}, {4.618802153517007, 0.}, {
     5.196152422706632, 0.}, {5.773502691896258, 0.}, {6.3508529610858835`, 
     0.}, {6.92820323027551, 0.}, {7.505553499465135, 0.}, {8.082903768654761,
      0.}, {8.660254037844387, 0.}}]& ],
  AspectRatio->0.5163977794943222,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellLabel->"Out[80]=",
 CellID->212573422]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["EdgeRenderingFunction", "UpgradeDetailLabel",
 CellID->548853516],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["EdgeRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeRenderingFunction"]], "InlineFormula"],
 " to control the way edges are drawn: "
}], "UpgradeDetail",
 CellID->30910388],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "DiscreteMath`GraphPlot`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", "30", "}"}], ",", 
     RowBox[{"{", "30", "}"}]}], "]"}], ",", " ", 
   RowBox[{"EdgeStyleFunction", "\[Rule]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", "}"}], "&"}], ")"}]}]}], "]"}]}], "Input", "LegacyInput",
 CellID->102614903],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", "30", "}"}], ",", 
     RowBox[{"{", "30", "}"}]}], "]"}], ",", " ", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", " ", "None"}]}], 
  "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->142367498],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.1114005126335007`, 1.289301515616812}, {
    1.6370155861833364`, 0.5706210492993329}, {0.1419860643873393, 
    0.36689558814750073`}, {1.3128549112260455`, 1.0051732005827123`}, {
    0.4960392949523978, 0.6508293652450466}, {0.3917649705030759, 
    0.11741921725272897`}, {1.6054699849369687`, 1.1445299916167877`}, {
    0.1688051525963573, 1.2762586282392163`}, {0.98502695790447, 0.}, {
    1.434745284786581, 1.3884800434220756`}, {0.6654896506356242, 
    0.006106656437970037}, {0.2360436160550149, 0.8944191338385613}, {
    0.3703027175525651, 1.5097638236513715`}, {0.9182267145305598, 
    0.6007064527509616}, {0.028280555219938885`, 0.6402823044194568}, {
    0.7841866865551173, 0.27674699737174646`}, {0.42989850910854155`, 
    0.3874620482155069}, {0.8944677228127644, 1.600821841234734}, {
    0.5906182755634598, 0.9139446958226601}, {0., 1.0070854154775484`}, {
    1.1884694388231527`, 1.5820867716842424`}, {0.9502789075733394, 
    0.9510486317550997}, {1.1274833734158378`, 0.3570603925597483}, {
    1.6507814652679687`, 0.8692976527525662}, {1.3030540882580046`, 
    0.11013648465910397`}, {0.4857263769223567, 1.224204203047345}, {
    0.6409572156010862, 1.6021198099013856`}, {1.3252616490494438`, 
    0.6751708815000305}, {0.768795868143376, 1.2376691092499894`}, {
    1.4756194191932133`, 0.3433561406905473}}, {
     {RGBColor[0.5, 0., 0.]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "21"],
       Annotation[#, 21, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "22"],
       Annotation[#, 22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "23"],
       Annotation[#, 23, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "24"],
       Annotation[#, 24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "25"],
       Annotation[#, 25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "26"],
       Annotation[#, 26, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        "27"],
       Annotation[#, 27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        "28"],
       Annotation[#, 28, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        "29"],
       Annotation[#, 29, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        "30"],
       Annotation[#, 30, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.1114005126335007`, 1.289301515616812}, {
     1.6370155861833364`, 0.5706210492993329}, {0.1419860643873393, 
     0.36689558814750073`}, {1.3128549112260455`, 1.0051732005827123`}, {
     0.4960392949523978, 0.6508293652450466}, {0.3917649705030759, 
     0.11741921725272897`}, {1.6054699849369687`, 1.1445299916167877`}, {
     0.1688051525963573, 1.2762586282392163`}, {0.98502695790447, 0.}, {
     1.434745284786581, 1.3884800434220756`}, {0.6654896506356242, 
     0.006106656437970037}, {0.2360436160550149, 0.8944191338385613}, {
     0.3703027175525651, 1.5097638236513715`}, {0.9182267145305598, 
     0.6007064527509616}, {0.028280555219938885`, 0.6402823044194568}, {
     0.7841866865551173, 0.27674699737174646`}, {0.42989850910854155`, 
     0.3874620482155069}, {0.8944677228127644, 1.600821841234734}, {
     0.5906182755634598, 0.9139446958226601}, {0., 1.0070854154775484`}, {
     1.1884694388231527`, 1.5820867716842424`}, {0.9502789075733394, 
     0.9510486317550997}, {1.1274833734158378`, 0.3570603925597483}, {
     1.6507814652679687`, 0.8692976527525662}, {1.3030540882580046`, 
     0.11013648465910397`}, {0.4857263769223567, 1.224204203047345}, {
     0.6409572156010862, 1.6021198099013856`}, {1.3252616490494438`, 
     0.6751708815000305}, {0.768795868143376, 1.2376691092499894`}, {
     1.4756194191932133`, 0.3433561406905473}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellLabel->"Out[11]=",
 CellID->11747071]
}, Open  ]],

Cell["Alternate ways to draw edges as arrows: ", "UpgradeDetail",
 CellID->586390626],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "DiscreteMath`GraphPlot`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GraphPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "2"}], ",", 
      RowBox[{"2", "\[Rule]", "3"}], ",", 
      RowBox[{"3", "\[Rule]", "4"}], ",", 
      RowBox[{"4", "\[Rule]", "5"}], ",", 
      RowBox[{"5", "\[Rule]", "6"}], ",", 
      RowBox[{"6", "\[Rule]", "7"}], ",", 
      RowBox[{"7", "\[Rule]", "8"}], ",", 
      RowBox[{"8", "\[Rule]", "1"}], ",", 
      RowBox[{"1", "\[Rule]", "9"}], ",", 
      RowBox[{"2", "\[Rule]", "9"}], ",", 
      RowBox[{"3", "\[Rule]", "10"}], ",", 
      RowBox[{"4", "\[Rule]", "10"}], ",", 
      RowBox[{"6", "\[Rule]", "11"}], ",", 
      RowBox[{"5", "\[Rule]", "11"}], ",", 
      RowBox[{"7", "\[Rule]", "12"}], ",", 
      RowBox[{"8", "\[Rule]", "12"}]}], "}"}], ",", 
    RowBox[{"EdgeStyleFunction", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{"#1", ",", "#2"}], "}"}], "]"}], "&"}], ")"}]}]}], "]"}], 
  ";"}]}], "Input", "LegacyInput",
 CellID->37977188],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", " ", "->", " ", "2"}], ",", " ", 
     RowBox[{"2", " ", "->", " ", "3"}], ",", " ", 
     RowBox[{"3", " ", "->", " ", "4"}], ",", " ", 
     RowBox[{"4", " ", "->", " ", "5"}], ",", " ", 
     RowBox[{"5", " ", "->", " ", "6"}], ",", " ", 
     RowBox[{"6", " ", "->", " ", "7"}], ",", " ", 
     RowBox[{"7", " ", "->", " ", "8"}], ",", " ", 
     RowBox[{"8", " ", "->", " ", "1"}], ",", " ", "\n", "      ", 
     RowBox[{"1", " ", "->", " ", "9"}], ",", " ", 
     RowBox[{"2", " ", "->", " ", "9"}], ",", " ", 
     RowBox[{"3", " ", "->", " ", "10"}], ",", " ", 
     RowBox[{"4", " ", "->", " ", "10"}], ",", " ", 
     RowBox[{"6", " ", "->", " ", "11"}], ",", " ", 
     RowBox[{"5", " ", "->", " ", "11"}], ",", " ", 
     RowBox[{"7", " ", "->", " ", "12"}], ",", " ", 
     RowBox[{"8", " ", "->", " ", "12"}]}], "}"}], ",", " ", "\n", "    ", 
   RowBox[{"EdgeRenderingFunction", " ", "->", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Arrow", "[", "#1", "]"}], " ", "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->942280834],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{{
      ArrowBox[{{0.8391269830789694, 0.12138662951413726`}, {
       0.1142773945894231, 0.8563072202606672}}], 
      ArrowBox[{{0.8391269830789694, 0.12138662951413726`}, {0., 
       0.01849001411169393}}], 
      ArrowBox[{{0.1142773945894231, 0.8563072202606672}, {
       0.11969485730565244`, 2.084180918103611}}], 
      ArrowBox[{{0.1142773945894231, 0.8563072202606672}, {0., 
       0.01849001411169393}}], 
      ArrowBox[{{0.11969485730565244`, 2.084180918103611}, {
       0.8517429114949044, 2.808668600780761}}], 
      ArrowBox[{{0.11969485730565244`, 2.084180918103611}, {
       0.01439321512867564, 2.9223345263640246`}}], 
      ArrowBox[{{0.8517429114949044, 2.808668600780761}, {2.079311907483209, 
       2.800777504695416}}], 
      ArrowBox[{{0.8517429114949044, 2.808668600780761}, {0.01439321512867564,
        2.9223345263640246`}}], 
      ArrowBox[{{2.079311907483209, 2.800777504695416}, {2.8052846635151383`, 
       2.067147543676492}}], 
      ArrowBox[{{2.079311907483209, 2.800777504695416}, {2.918180466418588, 
       2.9043984501897935`}}], 
      ArrowBox[{{2.8052846635151383`, 2.067147543676492}, {
       2.7999444377920746`, 0.8387393724669082}}], 
      ArrowBox[{{2.8052846635151383`, 2.067147543676492}, {2.918180466418588, 
       2.9043984501897935`}}], 
      ArrowBox[{{2.7999444377920746`, 0.8387393724669082}, {2.066623718278995,
        0.11376009579341195`}}], 
      ArrowBox[{{2.7999444377920746`, 0.8387393724669082}, {
       2.9043104168861964`, 0.}}], 
      ArrowBox[{{2.066623718278995, 0.11376009579341195`}, {
       0.8391269830789694, 0.12138662951413726`}}], 
      ArrowBox[{{2.066623718278995, 0.11376009579341195`}, {
       2.9043104168861964`, 0.}}]}, 
     GraphicsComplexBox[{{0.8391269830789694, 0.12138662951413726`}, {
      0.1142773945894231, 0.8563072202606672}, {0.11969485730565244`, 
      2.084180918103611}, {0.8517429114949044, 2.808668600780761}, {
      2.079311907483209, 2.800777504695416}, {2.8052846635151383`, 
      2.067147543676492}, {2.7999444377920746`, 0.8387393724669082}, {
      2.066623718278995, 0.11376009579341195`}, {0., 0.01849001411169393}, {
      0.01439321512867564, 2.9223345263640246`}, {2.918180466418588, 
      2.9043984501897935`}, {2.9043104168861964`, 0.}}, 
      {RGBColor[0, 0, 0.7], 
       TagBox[
        TooltipBox[PointBox[1],
         "1"],
        Annotation[#, 1, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[2],
         "2"],
        Annotation[#, 2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[3],
         "3"],
        Annotation[#, 3, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[4],
         "4"],
        Annotation[#, 4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[5],
         "5"],
        Annotation[#, 5, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[6],
         "6"],
        Annotation[#, 6, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[7],
         "7"],
        Annotation[#, 7, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[8],
         "8"],
        Annotation[#, 8, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[9],
         "9"],
        Annotation[#, 9, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[10],
         "10"],
        Annotation[#, 10, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[11],
         "11"],
        Annotation[#, 11, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[12],
         "12"],
        Annotation[#, 12, "Tooltip"]& ]}]},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{0.8391269830789694, 0.12138662951413726`}, {
     0.1142773945894231, 0.8563072202606672}, {0.11969485730565244`, 
     2.084180918103611}, {0.8517429114949044, 2.808668600780761}, {
     2.079311907483209, 2.800777504695416}, {2.8052846635151383`, 
     2.067147543676492}, {2.7999444377920746`, 0.8387393724669082}, {
     2.066623718278995, 0.11376009579341195`}, {0., 0.01849001411169393}, {
     0.01439321512867564, 2.9223345263640246`}, {2.918180466418588, 
     2.9043984501897935`}, {2.9043104168861964`, 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellLabel->"Out[2]=",
 CellID->1216897481]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", " ", "->", " ", "2"}], ",", " ", 
     RowBox[{"2", " ", "->", " ", "3"}], ",", " ", 
     RowBox[{"3", " ", "->", " ", "4"}], ",", " ", 
     RowBox[{"4", " ", "->", " ", "5"}], ",", " ", 
     RowBox[{"5", " ", "->", " ", "6"}], ",", " ", 
     RowBox[{"6", " ", "->", " ", "7"}], ",", " ", 
     RowBox[{"7", " ", "->", " ", "8"}], ",", " ", 
     RowBox[{"8", " ", "->", " ", "1"}], ",", " ", "\n", "      ", 
     RowBox[{"1", " ", "->", " ", "9"}], ",", " ", 
     RowBox[{"2", " ", "->", " ", "9"}], ",", " ", 
     RowBox[{"3", " ", "->", " ", "10"}], ",", " ", 
     RowBox[{"4", " ", "->", " ", "10"}], ",", " ", 
     RowBox[{"6", " ", "->", " ", "11"}], ",", " ", 
     RowBox[{"5", " ", "->", " ", "11"}], ",", " ", 
     RowBox[{"7", " ", "->", " ", "12"}], ",", " ", 
     RowBox[{"8", " ", "->", " ", "12"}]}], "}"}], ",", " ", "\n", "    ", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->292654313],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.8391269830789694, 0.12138662951413726`}, {
    0.1142773945894231, 0.8563072202606672}, {0.11969485730565244`, 
    2.084180918103611}, {0.8517429114949044, 2.808668600780761}, {
    2.079311907483209, 2.800777504695416}, {2.8052846635151383`, 
    2.067147543676492}, {2.7999444377920746`, 0.8387393724669082}, {
    2.066623718278995, 0.11376009579341195`}, {0., 0.01849001411169393}, {
    0.01439321512867564, 2.9223345263640246`}, {2.918180466418588, 
    2.9043984501897935`}, {2.9043104168861964`, 0.}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.029253812224241643`, 0.8}}], 
      ArrowBox[{1, 2}], ArrowBox[{1, 9}], ArrowBox[{2, 3}], ArrowBox[{2, 9}], 
      ArrowBox[{3, 4}], ArrowBox[{3, 10}], ArrowBox[{4, 5}], 
      ArrowBox[{4, 10}], ArrowBox[{5, 6}], ArrowBox[{5, 11}], 
      ArrowBox[{6, 7}], ArrowBox[{6, 11}], ArrowBox[{7, 8}], 
      ArrowBox[{7, 12}], ArrowBox[{8, 1}], ArrowBox[{8, 12}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "12"],
       Annotation[#, 12, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.8391269830789694, 0.12138662951413726`}, {
     0.1142773945894231, 0.8563072202606672}, {0.11969485730565244`, 
     2.084180918103611}, {0.8517429114949044, 2.808668600780761}, {
     2.079311907483209, 2.800777504695416}, {2.8052846635151383`, 
     2.067147543676492}, {2.7999444377920746`, 0.8387393724669082}, {
     2.066623718278995, 0.11376009579341195`}, {0., 0.01849001411169393}, {
     0.01439321512867564, 2.9223345263640246`}, {2.918180466418588, 
     2.9043984501897935`}, {2.9043104168861964`, 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellLabel->"Out[3]=",
 CellID->1089754770]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["LayerSizeFunction", "UpgradeDetailLabel",
 CellID->82429385],

Cell["Draw a binary tree: ", "UpgradeDetail",
 CellID->89129401],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "DiscreteMath`GraphPlot`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"g", "=", 
  RowBox[{"Flatten", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"i", "\[Rule]", " ", 
        RowBox[{"2", "*", "i"}]}], ",", " ", 
       RowBox[{"i", "\[Rule]", 
        RowBox[{
         RowBox[{"2", "*", "i"}], "+", "1"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{
        RowBox[{"2", "^", "4"}], "-", "1"}]}], "}"}]}], "]"}], 
   "]"}]}], "\n", 
 RowBox[{
  RowBox[{"TreePlot", "[", "g", "]"}], ";"}]}], "Input", "LegacyInput",
 CellID->294031750],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"g", "=", 
  RowBox[{"Flatten", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"i", "\[Rule]", " ", 
        RowBox[{"2", "*", "i"}]}], ",", " ", 
       RowBox[{"i", "\[Rule]", 
        RowBox[{
         RowBox[{"2", "*", "i"}], "+", "1"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{
        RowBox[{"2", "^", "4"}], "-", "1"}]}], "}"}]}], "]"}], 
   "]"}]}], "\n", 
 RowBox[{"TreePlot", "[", "g", "]"}]}], "Input",
 CellLabel->"In[14]:=",
 CellID->165968328],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Rule]", "2"}], ",", 
   RowBox[{"1", "\[Rule]", "3"}], ",", 
   RowBox[{"2", "\[Rule]", "4"}], ",", 
   RowBox[{"2", "\[Rule]", "5"}], ",", 
   RowBox[{"3", "\[Rule]", "6"}], ",", 
   RowBox[{"3", "\[Rule]", "7"}], ",", 
   RowBox[{"4", "\[Rule]", "8"}], ",", 
   RowBox[{"4", "\[Rule]", "9"}], ",", 
   RowBox[{"5", "\[Rule]", "10"}], ",", 
   RowBox[{"5", "\[Rule]", "11"}], ",", 
   RowBox[{"6", "\[Rule]", "12"}], ",", 
   RowBox[{"6", "\[Rule]", "13"}], ",", 
   RowBox[{"7", "\[Rule]", "14"}], ",", 
   RowBox[{"7", "\[Rule]", "15"}], ",", 
   RowBox[{"8", "\[Rule]", "16"}], ",", 
   RowBox[{"8", "\[Rule]", "17"}], ",", 
   RowBox[{"9", "\[Rule]", "18"}], ",", 
   RowBox[{"9", "\[Rule]", "19"}], ",", 
   RowBox[{"10", "\[Rule]", "20"}], ",", 
   RowBox[{"10", "\[Rule]", "21"}], ",", 
   RowBox[{"11", "\[Rule]", "22"}], ",", 
   RowBox[{"11", "\[Rule]", "23"}], ",", 
   RowBox[{"12", "\[Rule]", "24"}], ",", 
   RowBox[{"12", "\[Rule]", "25"}], ",", 
   RowBox[{"13", "\[Rule]", "26"}], ",", 
   RowBox[{"13", "\[Rule]", "27"}], ",", 
   RowBox[{"14", "\[Rule]", "28"}], ",", 
   RowBox[{"14", "\[Rule]", "29"}], ",", 
   RowBox[{"15", "\[Rule]", "30"}], ",", 
   RowBox[{"15", "\[Rule]", "31"}]}], "}"}]], "Output",
 CellLabel->"Out[14]=",
 CellID->44567173],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{4.330127018922194, 2.3094010767585034`}, {
    2.0207259421636903`, 1.7320508075688776`}, {6.639528095680697, 
    1.7320508075688776`}, {0.8660254037844387, 1.1547005383792517`}, {
    3.1754264805429417`, 1.1547005383792517`}, {5.484827557301445, 
    1.1547005383792517`}, {7.794228634059948, 1.1547005383792517`}, {
    0.2886751345948129, 0.577350269189626}, {1.4433756729740645`, 
    0.577350269189626}, {2.598076211353316, 0.577350269189626}, {
    3.7527767497325675`, 0.577350269189626}, {4.907477288111819, 
    0.577350269189626}, {6.062177826491071, 0.577350269189626}, {
    7.216878364870323, 0.577350269189626}, {8.371578903249574, 
    0.577350269189626}, {0., 0.}, {0.5773502691896258, 0.}, {
    1.1547005383792517`, 0.}, {1.7320508075688774`, 0.}, {2.3094010767585034`,
     0.}, {2.886751345948129, 0.}, {3.464101615137755, 0.}, {
    4.041451884327381, 0.}, {4.618802153517007, 0.}, {5.196152422706632, 
    0.}, {5.773502691896258, 0.}, {6.3508529610858835`, 0.}, {
    6.92820323027551, 0.}, {7.505553499465135, 0.}, {8.082903768654761, 0.}, {
    8.660254037844387, 0.}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 3}], 
      LineBox[{2, 4}], LineBox[{2, 5}], LineBox[{3, 6}], LineBox[{3, 7}], 
      LineBox[{4, 8}], LineBox[{4, 9}], LineBox[{5, 10}], LineBox[{5, 11}], 
      LineBox[{6, 12}], LineBox[{6, 13}], LineBox[{7, 14}], LineBox[{7, 15}], 
      LineBox[{8, 16}], LineBox[{8, 17}], LineBox[{9, 18}], LineBox[{9, 19}], 
      LineBox[{10, 20}], LineBox[{10, 21}], LineBox[{11, 22}], 
      LineBox[{11, 23}], LineBox[{12, 24}], LineBox[{12, 25}], 
      LineBox[{13, 26}], LineBox[{13, 27}], LineBox[{14, 28}], 
      LineBox[{14, 29}], LineBox[{15, 30}], LineBox[{15, 31}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "21"],
       Annotation[#, 21, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "22"],
       Annotation[#, 22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "23"],
       Annotation[#, 23, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "24"],
       Annotation[#, 24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "25"],
       Annotation[#, 25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "26"],
       Annotation[#, 26, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        "27"],
       Annotation[#, 27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        "28"],
       Annotation[#, 28, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        "29"],
       Annotation[#, 29, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        "30"],
       Annotation[#, 30, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[31],
        "31"],
       Annotation[#, 31, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{4.330127018922194, 2.3094010767585034`}, {
     2.0207259421636903`, 1.7320508075688776`}, {6.639528095680697, 
     1.7320508075688776`}, {0.8660254037844387, 1.1547005383792517`}, {
     3.1754264805429417`, 1.1547005383792517`}, {5.484827557301445, 
     1.1547005383792517`}, {7.794228634059948, 1.1547005383792517`}, {
     0.2886751345948129, 0.577350269189626}, {1.4433756729740645`, 
     0.577350269189626}, {2.598076211353316, 0.577350269189626}, {
     3.7527767497325675`, 0.577350269189626}, {4.907477288111819, 
     0.577350269189626}, {6.062177826491071, 0.577350269189626}, {
     7.216878364870323, 0.577350269189626}, {8.371578903249574, 
     0.577350269189626}, {0., 0.}, {0.5773502691896258, 0.}, {
     1.1547005383792517`, 0.}, {1.7320508075688774`, 0.}, {
     2.3094010767585034`, 0.}, {2.886751345948129, 0.}, {3.464101615137755, 
     0.}, {4.041451884327381, 0.}, {4.618802153517007, 0.}, {
     5.196152422706632, 0.}, {5.773502691896258, 0.}, {6.3508529610858835`, 
     0.}, {6.92820323027551, 0.}, {7.505553499465135, 0.}, {8.082903768654761,
      0.}, {8.660254037844387, 0.}}]& ],
  AspectRatio->0.5163977794943222,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellLabel->"Out[15]=",
 CellID->104012440]
}, Open  ]],

Cell[TextData[{
 "This plots the same graph, but with the height of each level ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " proportional to ",
 Cell[BoxData[
  RowBox[{"1", "/", 
   SuperscriptBox[
    StyleBox["i", "TI"], "2"]}]], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->123410418],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "DiscreteMath`GraphPlot`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"g", "=", 
  RowBox[{"Flatten", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"i", "\[Rule]", " ", 
        RowBox[{"2", "*", "i"}]}], ",", " ", 
       RowBox[{"i", "\[Rule]", 
        RowBox[{
         RowBox[{"2", "*", "i"}], "+", "1"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{
        RowBox[{"2", "^", "4"}], "-", "1"}]}], "}"}]}], "]"}], 
   "]"}]}], "\n", 
 RowBox[{
  RowBox[{"TreePlot", "[", 
   RowBox[{"g", ",", " ", 
    RowBox[{"TreeSizeFunction", "\[Rule]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"#", "^", "2"}]}], " ", "&"}], ")"}]}]}], "]"}], 
  ";"}]}], "Input", "LegacyInput",
 CellID->27413745],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{"g", ",", " ", 
   RowBox[{"LayerSizeFunction", "\[Rule]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"#", "^", "2"}]}], " ", "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->802200557],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{5.1998449817835874`, 0.9870076122829958}, {
    2.4265943248323407`, 0.29369494804518415`}, {7.973095638734834, 
    0.29369494804518415`}, {1.0399689963567176`, 0.12036678198573125`}, {
    3.813219653307964, 0.12036678198573125`}, {6.586470310259211, 
    0.12036678198573125`}, {9.359720967210457, 0.12036678198573125`}, {
    0.34665633211890584`, 0.04333204151486325}, {1.7332816605945291`, 
    0.04333204151486325}, {3.1199069890701523`, 0.04333204151486325}, {
    4.506532317545775, 0.04333204151486325}, {5.893157646021399, 
    0.04333204151486325}, {7.279782974497023, 0.04333204151486325}, {
    8.666408302972645, 0.04333204151486325}, {10.053033631448269`, 
    0.04333204151486325}, {0., 0.}, {0.6933126642378117, 0.}, {
    1.3866253284756234`, 0.}, {2.079937992713435, 0.}, {2.7732506569512467`, 
    0.}, {3.4665633211890583`, 0.}, {4.15987598542687, 0.}, {
    4.853188649664681, 0.}, {5.5465013139024935`, 0.}, {6.239813978140305, 
    0.}, {6.933126642378117, 0.}, {7.626439306615928, 0.}, {8.31975197085374, 
    0.}, {9.01306463509155, 0.}, {9.706377299329363, 0.}, {
    10.399689963567175`, 0.}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 3}], 
      LineBox[{2, 4}], LineBox[{2, 5}], LineBox[{3, 6}], LineBox[{3, 7}], 
      LineBox[{4, 8}], LineBox[{4, 9}], LineBox[{5, 10}], LineBox[{5, 11}], 
      LineBox[{6, 12}], LineBox[{6, 13}], LineBox[{7, 14}], LineBox[{7, 15}], 
      LineBox[{8, 16}], LineBox[{8, 17}], LineBox[{9, 18}], LineBox[{9, 19}], 
      LineBox[{10, 20}], LineBox[{10, 21}], LineBox[{11, 22}], 
      LineBox[{11, 23}], LineBox[{12, 24}], LineBox[{12, 25}], 
      LineBox[{13, 26}], LineBox[{13, 27}], LineBox[{14, 28}], 
      LineBox[{14, 29}], LineBox[{15, 30}], LineBox[{15, 31}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "21"],
       Annotation[#, 21, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "22"],
       Annotation[#, 22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "23"],
       Annotation[#, 23, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "24"],
       Annotation[#, 24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "25"],
       Annotation[#, 25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "26"],
       Annotation[#, 26, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        "27"],
       Annotation[#, 27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        "28"],
       Annotation[#, 28, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        "29"],
       Annotation[#, 29, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        "30"],
       Annotation[#, 30, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[31],
        "31"],
       Annotation[#, 31, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{5.1998449817835874`, 0.9870076122829958}, {
     2.4265943248323407`, 0.29369494804518415`}, {7.973095638734834, 
     0.29369494804518415`}, {1.0399689963567176`, 0.12036678198573125`}, {
     3.813219653307964, 0.12036678198573125`}, {6.586470310259211, 
     0.12036678198573125`}, {9.359720967210457, 0.12036678198573125`}, {
     0.34665633211890584`, 0.04333204151486325}, {1.7332816605945291`, 
     0.04333204151486325}, {3.1199069890701523`, 0.04333204151486325}, {
     4.506532317545775, 0.04333204151486325}, {5.893157646021399, 
     0.04333204151486325}, {7.279782974497023, 0.04333204151486325}, {
     8.666408302972645, 0.04333204151486325}, {10.053033631448269`, 
     0.04333204151486325}, {0., 0.}, {0.6933126642378117, 0.}, {
     1.3866253284756234`, 0.}, {2.079937992713435, 0.}, {2.7732506569512467`, 
     0.}, {3.4665633211890583`, 0.}, {4.15987598542687, 0.}, {
     4.853188649664681, 0.}, {5.5465013139024935`, 0.}, {6.239813978140305, 
     0.}, {6.933126642378117, 0.}, {7.626439306615928, 0.}, {8.31975197085374,
      0.}, {9.01306463509155, 0.}, {9.706377299329363, 0.}, {
     10.399689963567175`, 0.}}]& ],
  AspectRatio->0.3080704585113727,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellLabel->"Out[20]=",
 CellID->487591306]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["VertexCoordinates", "UpgradeDetailLabel",
 CellID->483079425],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["VertexCoordinateRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexCoordinateRules"]], "InlineFormula"],
 " to specify explicit coordinates for vertices:"
}], "UpgradeDetail",
 CellID->21337861],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "DiscreteMath`GraphPlot`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "3"}], ",", 
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}], ",", 
     RowBox[{"6", "\[Rule]", "7"}], ",", 
     RowBox[{"7", "\[Rule]", "8"}], ",", 
     RowBox[{"8", "\[Rule]", "9"}], ",", 
     RowBox[{"9", "\[Rule]", "10"}], ",", 
     RowBox[{"6", "\[Rule]", "10"}], ",", 
     RowBox[{"1", "\[Rule]", "6"}], ",", 
     RowBox[{"2", "\[Rule]", "7"}], ",", 
     RowBox[{"3", "\[Rule]", "8"}], ",", 
     RowBox[{"4", "\[Rule]", "9"}], ",", 
     RowBox[{"5", "\[Rule]", "10"}]}], "}"}], ",", 
   RowBox[{"VertexCoordinates", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.30901699437494745`", ",", "0.9510565162951535`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.8090169943749476`"}], ",", 
        RowBox[{"-", "0.587785252292473`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.30901699437494723`", ",", 
        RowBox[{"-", "0.9510565162951536`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.8090169943749473`"}], ",", "0.5877852522924732`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.`", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.6180339887498949`", ",", "1.902113032590307`"}], "}"}], ",",
       
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.6180339887498947`"}], ",", "1.1755705045849465`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.6180339887498951`"}], ",", 
        RowBox[{"-", "1.175570504584946`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.6180339887498945`", ",", 
        RowBox[{"-", "1.9021130325903073`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2.`", ",", "0"}], "}"}]}], "}"}]}]}]}]}], "Input", \
"LegacyInput",
 CellID->204910962],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "3"}], ",", 
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}], ",", 
     RowBox[{"6", "\[Rule]", "7"}], ",", 
     RowBox[{"7", "\[Rule]", "8"}], ",", 
     RowBox[{"8", "\[Rule]", "9"}], ",", 
     RowBox[{"9", "\[Rule]", "10"}], ",", 
     RowBox[{"6", "\[Rule]", "10"}], ",", 
     RowBox[{"1", "\[Rule]", "6"}], ",", 
     RowBox[{"2", "\[Rule]", "7"}], ",", 
     RowBox[{"3", "\[Rule]", "8"}], ",", 
     RowBox[{"4", "\[Rule]", "9"}], ",", 
     RowBox[{"5", "\[Rule]", "10"}]}], "}"}], ",", 
   RowBox[{"VertexCoordinateRules", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.30901699437494745`", ",", "0.9510565162951535`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.8090169943749476`"}], ",", 
        RowBox[{"-", "0.587785252292473`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.30901699437494723`", ",", 
        RowBox[{"-", "0.9510565162951536`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.8090169943749473`"}], ",", "0.5877852522924732`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.`", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.6180339887498949`", ",", "1.902113032590307`"}], "}"}], ",",
       
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.6180339887498947`"}], ",", "1.1755705045849465`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.6180339887498951`"}], ",", 
        RowBox[{"-", "1.175570504584946`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.6180339887498945`", ",", 
        RowBox[{"-", "1.9021130325903073`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2.`", ",", "0"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->5023671],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.30901699437494745`, 
    0.9510565162951535}, {-0.8090169943749476, -0.587785252292473}, {
    0.30901699437494723`, -0.9510565162951536}, {-0.8090169943749473, 
    0.5877852522924732}, {1., 0.}, {0.6180339887498949, 
    1.902113032590307}, {-1.6180339887498947`, 
    1.1755705045849465`}, {-1.6180339887498951`, -1.175570504584946}, {
    0.6180339887498945, -1.9021130325903073`}, {2., 0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {1, 6}, {2, 5}, {2, 8}, {3, 9}, {4, 3}, {4, 
       5}, {4, 7}, {5, 10}, {6, 7}, {6, 10}, {7, 8}, {8, 9}, {9, 10}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.30901699437494745`, 
     0.9510565162951535}, {-0.8090169943749476, -0.587785252292473}, {
     0.30901699437494723`, -0.9510565162951536}, {-0.8090169943749473, 
     0.5877852522924732}, {1., 0.}, {0.6180339887498949, 
     1.902113032590307}, {-1.6180339887498947`, 
     1.1755705045849465`}, {-1.6180339887498951`, -1.175570504584946}, {
     0.6180339887498945, -1.9021130325903073`}, {2., 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellLabel->"Out[4]=",
 CellID->1176270210]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["VertexStyleFunction", "UpgradeDetailLabel",
 CellID->2035676930],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["VertexRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexRenderingFunction"]], "InlineFormula"],
 " to control the way vertices are drawn. This draws no vertices:"
}], "UpgradeDetail",
 CellID->1883593691],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "DiscreteMath`GraphPlot`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", " ", "->", " ", "2"}], ",", " ", 
     RowBox[{"2", " ", "->", " ", "3"}], ",", " ", 
     RowBox[{"3", " ", "->", " ", "4"}], ",", " ", 
     RowBox[{"4", " ", "->", " ", "5"}], ",", " ", 
     RowBox[{"5", " ", "->", " ", "6"}], ",", " ", 
     RowBox[{"6", " ", "->", " ", "1"}]}], "}"}], ",", 
   RowBox[{"VertexStyleFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", "}"}], "&"}], ")"}]}]}], "]"}]}], "Input", "LegacyInput",
 CellID->1632820951],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", " ", "->", " ", "2"}], ",", " ", 
     RowBox[{"2", " ", "->", " ", "3"}], ",", " ", 
     RowBox[{"3", " ", "->", " ", "4"}], ",", " ", 
     RowBox[{"4", " ", "->", " ", "5"}], ",", " ", 
     RowBox[{"5", " ", "->", " ", "6"}], ",", " ", 
     RowBox[{"6", " ", "->", " ", "1"}]}], "}"}], ",", " ", 
   RowBox[{"VertexRenderingFunction", " ", "->", " ", "None"}]}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->2108438191],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.4875669188038463`, 1.7455699225238166`}, {
    1.9996460459354313`, 0.8861424682559871}, {1.511583448071915, 
    0.013316663859109679`}, {0.5114456436282868, 0.}, {0., 
    0.8594781450938977}, {0.48875342845363157`, 1.7322387782110364`}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 1}}]}, 
     {RGBColor[0, 0, 0.7]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.4875669188038463`, 1.7455699225238166`}, {
     1.9996460459354313`, 0.8861424682559871}, {1.511583448071915, 
     0.013316663859109679`}, {0.5114456436282868, 0.}, {0., 
     0.8594781450938977}, {0.48875342845363157`, 1.7322387782110364`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellLabel->"Out[5]=",
 CellID->1184348080]
}, Open  ]],

Cell["This draws large blue vertices:", "UpgradeDetail",
 CellID->664795099],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "DiscreteMath`GraphPlot`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GraphPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "2"}], ",", 
      RowBox[{"1", "\[Rule]", "3"}], ",", 
      RowBox[{"1", "\[Rule]", "4"}], ",", 
      RowBox[{"2", "\[Rule]", "3"}], ",", 
      RowBox[{"2", "\[Rule]", "4"}], ",", 
      RowBox[{"3", "\[Rule]", "5"}], ",", 
      RowBox[{"4", "\[Rule]", "6"}], ",", 
      RowBox[{"5", "\[Rule]", "7"}], ",", 
      RowBox[{"5", "\[Rule]", "8"}], ",", 
      RowBox[{"6", "\[Rule]", "7"}], ",", 
      RowBox[{"6", "\[Rule]", "8"}], ",", 
      RowBox[{"7", "\[Rule]", "8"}]}], "}"}], ",", 
    RowBox[{"VertexStyleFunction", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Hue", "[", "0", "]"}], ",", 
         RowBox[{"Disk", "[", 
          RowBox[{"#", ",", "0.03"}], "]"}]}], "}"}], "&"}], ")"}]}]}], "]"}],
   ";"}]}], "Input", "LegacyInput",
 CellID->1336390772],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", " ", "->", " ", "2"}], ",", " ", 
     RowBox[{"1", " ", "->", " ", "3"}], ",", " ", 
     RowBox[{"1", " ", "->", " ", "4"}], ",", " ", 
     RowBox[{"2", " ", "->", " ", "3"}], ",", " ", 
     RowBox[{"2", " ", "->", " ", "4"}], ",", " ", 
     RowBox[{"3", " ", "->", " ", "5"}], ",", " ", 
     RowBox[{"4", " ", "->", " ", "6"}], ",", " ", 
     RowBox[{"5", " ", "->", " ", "7"}], ",", " ", 
     RowBox[{"5", " ", "->", " ", "8"}], ",", " ", 
     RowBox[{"6", " ", "->", " ", "7"}], ",", " ", 
     RowBox[{"6", " ", "->", " ", "8"}], ",", " ", 
     RowBox[{"7", " ", "->", " ", "8"}]}], "}"}], ",", " ", 
   RowBox[{"VertexRenderingFunction", " ", "->", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Hue", "[", ".7", "]"}], ",", " ", 
        RowBox[{"Disk", "[", 
         RowBox[{"#", ",", " ", "0.05"}], "]"}]}], "}"}], " ", "&"}], 
     ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->2001297199],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{
     GraphicsComplexBox[{{2.8657104164519582`, 0.8355258988493235}, {
      2.8656714517114805`, 0.28338491004629385`}, {2.0868792944563954`, 
      1.1186095077916467`}, {2.0851311487308704`, 0.0002682740337410783}, {
      0.7796583662880692, 1.1184738996167753`}, {0.7800174800454668, 0.}, {0.,
       0.836708649161708}, {0.0004087797754366296, 0.2828568624344529}}, 
      {RGBColor[0.5, 0., 0.], 
       LineBox[{{1, 2}, {1, 3}, {1, 4}, {2, 3}, {2, 4}, {3, 5}, {4, 6}, {5, 
        7}, {5, 8}, {6, 7}, {6, 8}, {7, 8}}]}], {
      {Hue[0.7], DiskBox[{2.8657104164519582`, 0.8355258988493235}, 0.05]}, 
      {Hue[0.7], 
       DiskBox[{2.8656714517114805`, 0.28338491004629385`}, 0.05]}, 
      {Hue[0.7], DiskBox[{2.0868792944563954`, 1.1186095077916467`}, 0.05]}, 
      {Hue[0.7], 
       DiskBox[{2.0851311487308704`, 0.0002682740337410783}, 0.05]}, 
      {Hue[0.7], DiskBox[{0.7796583662880692, 1.1184738996167753`}, 0.05]}, 
      {Hue[0.7], DiskBox[{0.7800174800454668, 0.}, 0.05]}, 
      {Hue[0.7], DiskBox[{0., 0.836708649161708}, 0.05]}, 
      {Hue[0.7], 
       DiskBox[{0.0004087797754366296, 0.2828568624344529}, 0.05]}}},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{2.8657104164519582`, 0.8355258988493235}, {
     2.8656714517114805`, 0.28338491004629385`}, {2.0868792944563954`, 
     1.1186095077916467`}, {2.0851311487308704`, 0.0002682740337410783}, {
     0.7796583662880692, 1.1184738996167753`}, {0.7800174800454668, 0.}, {0., 
     0.836708649161708}, {0.0004087797754366296, 0.2828568624344529}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellLabel->"Out[14]=",
 CellID->630772446]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["RootPosition (argument to TreePlot)", "UpgradeDetailLabel",
 CellID->503827689],

Cell["This plots the tree by placing the root to the left: ", "UpgradeDetail",
 CellID->268345263],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "DiscreteMath`GraphPlot`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "6"}], ",", 
     RowBox[{"4", "\[Rule]", "8"}], ",", 
     RowBox[{"5", "\[Rule]", "10"}], ",", 
     RowBox[{"6", "\[Rule]", "12"}], ",", 
     RowBox[{"1", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"3", "\[Rule]", "7"}], ",", 
     RowBox[{"4", "\[Rule]", "9"}], ",", 
     RowBox[{"5", "\[Rule]", "11"}], ",", 
     RowBox[{"6", "\[Rule]", "13"}]}], "}"}], ",", 
   RowBox[{"RootPosition", "\[Rule]", " ", "Left"}]}], "]"}]}], "Input", \
"LegacyInput",
 CellID->232932587],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "6"}], ",", 
     RowBox[{"4", "\[Rule]", "8"}], ",", 
     RowBox[{"5", "\[Rule]", "10"}], ",", 
     RowBox[{"6", "\[Rule]", "12"}], ",", 
     RowBox[{"1", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"3", "\[Rule]", "7"}], ",", 
     RowBox[{"4", "\[Rule]", "9"}], ",", 
     RowBox[{"5", "\[Rule]", "11"}], ",", 
     RowBox[{"6", "\[Rule]", "13"}]}], "}"}], ",", "Left"}], "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->439256356],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 2.3934940065356387`}, {0.7364596943186601, 
    1.1046895414779865`}, {1.4729193886373197`, 0.3682298471593285}, {
    0.7364596943186573, 3.682298471593292}, {1.4729193886373164`, 
    3.3140686244339634`}, {2.2093790829559787`, 0.}, {1.4729193886373182`, 
    1.841149235796646}, {2.209379082955977, 1.4729193886373173`}, {
    2.2093790829559756`, 2.945838777274635}, {1.4729193886373158`, 
    4.0505283187526215`}, {2.2093790829559783`, 0.7364596943186587}, {
    2.2093790829559765`, 2.209379082955976}, {2.2093790829559747`, 
    3.682298471593294}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 4}], 
      LineBox[{2, 3}], LineBox[{2, 7}], LineBox[{3, 6}], LineBox[{3, 11}], 
      LineBox[{4, 5}], LineBox[{4, 10}], LineBox[{5, 9}], LineBox[{5, 13}], 
      LineBox[{7, 8}], LineBox[{7, 12}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "13"],
       Annotation[#, 13, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 2.3934940065356387`}, {0.7364596943186601, 
     1.1046895414779865`}, {1.4729193886373197`, 0.3682298471593285}, {
     0.7364596943186573, 3.682298471593292}, {1.4729193886373164`, 
     3.3140686244339634`}, {2.2093790829559787`, 0.}, {1.4729193886373182`, 
     1.841149235796646}, {2.209379082955977, 1.4729193886373173`}, {
     2.2093790829559756`, 2.945838777274635}, {1.4729193886373158`, 
     4.0505283187526215`}, {2.2093790829559783`, 0.7364596943186587}, {
     2.2093790829559765`, 2.209379082955976}, {2.2093790829559747`, 
     3.682298471593294}}]& ],
  AspectRatio->1.354006400772659,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellLabel->"Out[23]=",
 CellID->195459646]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graph Utilities Package", "UpgradePackageSection",
 CellID->1087906933],

Cell[TextData[{
 "Many functions from ",
 Cell[BoxData["DiscreteMath`GraphPlot`"], "InlineFormula"],
 " are now available through the newly created ",
 ButtonBox["Graph Utilities Package:",
  BaseStyle->"Link",
  ButtonData->"paclet:GraphUtilities/guide/GraphUtilitiesPackage"]
}], "UpgradeDetail",
 CellID->1074807037],

Cell["This plots a graph of 37 vertices: ", "UpgradeDetail",
 CellID->259115070],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "DiscreteMath`GraphPlot`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GraphPlot", "[", 
   RowBox[{
    TagBox[
     RowBox[{"g", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "2"}], ",", 
        RowBox[{"1", "\[Rule]", "6"}], ",", 
        RowBox[{"1", "\[Rule]", "7"}], ",", 
        RowBox[{"2", "\[Rule]", "3"}], ",", 
        RowBox[{"2", "\[Rule]", "7"}], ",", 
        RowBox[{"3", "\[Rule]", "30"}], ",", 
        RowBox[{"3", "\[Rule]", "26"}], ",", 
        RowBox[{"3", "\[Rule]", "4"}], ",", 
        RowBox[{"3", "\[Rule]", "32"}], ",", 
        RowBox[{"4", "\[Rule]", "5"}], ",", 
        RowBox[{"4", "\[Rule]", "9"}], ",", 
        RowBox[{"5", "\[Rule]", "9"}], ",", 
        RowBox[{"5", "\[Rule]", "10"}], ",", 
        RowBox[{"6", "\[Rule]", "7"}], ",", 
        RowBox[{"6", "\[Rule]", "11"}], ",", 
        RowBox[{"7", "\[Rule]", "8"}], ",", 
        RowBox[{"7", "\[Rule]", "30"}], ",", 
        RowBox[{"7", "\[Rule]", "12"}], ",", 
        RowBox[{"8", "\[Rule]", "9"}], ",", 
        RowBox[{"8", "\[Rule]", "26"}], ",", 
        RowBox[{"8", "\[Rule]", "13"}], ",", 
        RowBox[{"9", "\[Rule]", "10"}], ",", 
        RowBox[{"9", "\[Rule]", "32"}], ",", 
        RowBox[{"9", "\[Rule]", "14"}], ",", 
        RowBox[{"10", "\[Rule]", "15"}], ",", 
        RowBox[{"11", "\[Rule]", "16"}], ",", 
        RowBox[{"11", "\[Rule]", "27"}], ",", 
        RowBox[{"11", "\[Rule]", "30"}], ",", 
        RowBox[{"11", "\[Rule]", "35"}], ",", 
        RowBox[{"12", "\[Rule]", "13"}], ",", 
        RowBox[{"12", "\[Rule]", "17"}], ",", 
        RowBox[{"12", "\[Rule]", "27"}], ",", 
        RowBox[{"13", "\[Rule]", "31"}], ",", 
        RowBox[{"13", "\[Rule]", "33"}], ",", 
        RowBox[{"13", "\[Rule]", "14"}], ",", 
        RowBox[{"13", "\[Rule]", "36"}], ",", 
        RowBox[{"13", "\[Rule]", "18"}], ",", 
        RowBox[{"13", "\[Rule]", "34"}], ",", 
        RowBox[{"14", "\[Rule]", "28"}], ",", 
        RowBox[{"14", "\[Rule]", "19"}], ",", 
        RowBox[{"15", "\[Rule]", "32"}], ",", 
        RowBox[{"15", "\[Rule]", "28"}], ",", 
        RowBox[{"15", "\[Rule]", "37"}], ",", 
        RowBox[{"15", "\[Rule]", "20"}], ",", 
        RowBox[{"16", "\[Rule]", "17"}], ",", 
        RowBox[{"16", "\[Rule]", "21"}], ",", 
        RowBox[{"17", "\[Rule]", "21"}], ",", 
        RowBox[{"17", "\[Rule]", "22"}], ",", 
        RowBox[{"17", "\[Rule]", "35"}], ",", 
        RowBox[{"17", "\[Rule]", "18"}], ",", 
        RowBox[{"18", "\[Rule]", "19"}], ",", 
        RowBox[{"18", "\[Rule]", "29"}], ",", 
        RowBox[{"19", "\[Rule]", "37"}], ",", 
        RowBox[{"19", "\[Rule]", "20"}], ",", 
        RowBox[{"19", "\[Rule]", "24"}], ",", 
        RowBox[{"19", "\[Rule]", "25"}], ",", 
        RowBox[{"20", "\[Rule]", "25"}], ",", 
        RowBox[{"21", "\[Rule]", "22"}], ",", 
        RowBox[{"22", "\[Rule]", "23"}], ",", 
        RowBox[{"23", "\[Rule]", "24"}], ",", 
        RowBox[{"23", "\[Rule]", "29"}], ",", 
        RowBox[{"23", "\[Rule]", "35"}], ",", 
        RowBox[{"23", "\[Rule]", "37"}], ",", 
        RowBox[{"24", "\[Rule]", "25"}], ",", 
        RowBox[{"30", "\[Rule]", "31"}], ",", 
        RowBox[{"32", "\[Rule]", "33"}], ",", 
        RowBox[{"34", "\[Rule]", "35"}], ",", 
        RowBox[{"36", "\[Rule]", "37"}]}], "}"}]}],
     Short[#, 1000]& ], ",", 
    RowBox[{"VertexStyleFunction", "\[Rule]", "Automatic"}]}], "]"}], 
  ";"}]}], "Input", "LegacyInput",
 CellID->259585046],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  TagBox[
   RowBox[{"g", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "2"}], ",", 
      RowBox[{"1", "\[Rule]", "6"}], ",", 
      RowBox[{"1", "\[Rule]", "7"}], ",", 
      RowBox[{"2", "\[Rule]", "3"}], ",", 
      RowBox[{"2", "\[Rule]", "7"}], ",", 
      RowBox[{"3", "\[Rule]", "30"}], ",", 
      RowBox[{"3", "\[Rule]", "26"}], ",", 
      RowBox[{"3", "\[Rule]", "4"}], ",", 
      RowBox[{"3", "\[Rule]", "32"}], ",", 
      RowBox[{"4", "\[Rule]", "5"}], ",", 
      RowBox[{"4", "\[Rule]", "9"}], ",", 
      RowBox[{"5", "\[Rule]", "9"}], ",", 
      RowBox[{"5", "\[Rule]", "10"}], ",", 
      RowBox[{"6", "\[Rule]", "7"}], ",", 
      RowBox[{"6", "\[Rule]", "11"}], ",", 
      RowBox[{"7", "\[Rule]", "8"}], ",", 
      RowBox[{"7", "\[Rule]", "30"}], ",", 
      RowBox[{"7", "\[Rule]", "12"}], ",", 
      RowBox[{"8", "\[Rule]", "9"}], ",", 
      RowBox[{"8", "\[Rule]", "26"}], ",", 
      RowBox[{"8", "\[Rule]", "13"}], ",", 
      RowBox[{"9", "\[Rule]", "10"}], ",", 
      RowBox[{"9", "\[Rule]", "32"}], ",", 
      RowBox[{"9", "\[Rule]", "14"}], ",", 
      RowBox[{"10", "\[Rule]", "15"}], ",", 
      RowBox[{"11", "\[Rule]", "16"}], ",", 
      RowBox[{"11", "\[Rule]", "27"}], ",", 
      RowBox[{"11", "\[Rule]", "30"}], ",", 
      RowBox[{"11", "\[Rule]", "35"}], ",", 
      RowBox[{"12", "\[Rule]", "13"}], ",", 
      RowBox[{"12", "\[Rule]", "17"}], ",", 
      RowBox[{"12", "\[Rule]", "27"}], ",", 
      RowBox[{"13", "\[Rule]", "31"}], ",", 
      RowBox[{"13", "\[Rule]", "33"}], ",", 
      RowBox[{"13", "\[Rule]", "14"}], ",", 
      RowBox[{"13", "\[Rule]", "36"}], ",", 
      RowBox[{"13", "\[Rule]", "18"}], ",", 
      RowBox[{"13", "\[Rule]", "34"}], ",", 
      RowBox[{"14", "\[Rule]", "28"}], ",", 
      RowBox[{"14", "\[Rule]", "19"}], ",", 
      RowBox[{"15", "\[Rule]", "32"}], ",", 
      RowBox[{"15", "\[Rule]", "28"}], ",", 
      RowBox[{"15", "\[Rule]", "37"}], ",", 
      RowBox[{"15", "\[Rule]", "20"}], ",", 
      RowBox[{"16", "\[Rule]", "17"}], ",", 
      RowBox[{"16", "\[Rule]", "21"}], ",", 
      RowBox[{"17", "\[Rule]", "21"}], ",", 
      RowBox[{"17", "\[Rule]", "22"}], ",", 
      RowBox[{"17", "\[Rule]", "35"}], ",", 
      RowBox[{"17", "\[Rule]", "18"}], ",", 
      RowBox[{"18", "\[Rule]", "19"}], ",", 
      RowBox[{"18", "\[Rule]", "29"}], ",", 
      RowBox[{"19", "\[Rule]", "37"}], ",", 
      RowBox[{"19", "\[Rule]", "20"}], ",", 
      RowBox[{"19", "\[Rule]", "24"}], ",", 
      RowBox[{"19", "\[Rule]", "25"}], ",", 
      RowBox[{"20", "\[Rule]", "25"}], ",", 
      RowBox[{"21", "\[Rule]", "22"}], ",", 
      RowBox[{"22", "\[Rule]", "23"}], ",", 
      RowBox[{"23", "\[Rule]", "24"}], ",", 
      RowBox[{"23", "\[Rule]", "29"}], ",", 
      RowBox[{"23", "\[Rule]", "35"}], ",", 
      RowBox[{"23", "\[Rule]", "37"}], ",", 
      RowBox[{"24", "\[Rule]", "25"}], ",", 
      RowBox[{"30", "\[Rule]", "31"}], ",", 
      RowBox[{"32", "\[Rule]", "33"}], ",", 
      RowBox[{"34", "\[Rule]", "35"}], ",", 
      RowBox[{"36", "\[Rule]", "37"}]}], "}"}]}],
   Short[#, 1000]& ], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->144093056],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.062036022304934324`, 0.8298995261403577}, {
    0.7926678142795236, 0.45456460273454025`}, {0.015586893893210885`, 
    1.6280007516325479`}, {0.7701820611604573, 1.2759207902715868`}, {
    1.9507581940237078`, 0.5257796887259589}, {1.1041944130021313`, 
    1.4839762649711639`}, {1.838975097274439, 0.}, {2.9692184952388008`, 
    0.00885552126909328}, {3.1134317751023253`, 1.0980501514658478`}, {
    3.7712397172488794`, 0.05526830252848214}, {3.3240129562519787`, 
    0.7624569261609002}, {4.148324682481112, 0.7897064118469199}, {
    0.5306785016906368, 2.6485408586217334`}, {2.055997968510287, 
    1.0238978748586907`}, {1.0285896576385554`, 2.542565609759389}, {
    2.297132320814199, 2.2909174857870584`}, {3.569022093708574, 
    2.050713559593679}, {4.068715623620707, 1.94831734445668}, {
    0.46630367878575507`, 3.812880080167976}, {0., 2.756016309087825}, {
    1.4934389017256047`, 3.487134267581}, {1.2875161469635217`, 
    3.8259245815937617`}, {1.6254391540065072`, 1.7827330641633652`}, {
    2.807561634053396, 1.6187134926612976`}, {2.953206654788591, 
    2.799341470202164}, {2.5464999416620215`, 3.556445814855464}, {
    1.7961382908025814`, 2.9663770660127753`}, {4.598324397022974, 
    1.8450009608805311`}, {3.826370737499998, 3.3123958477632076`}, {
    3.486908583221485, 3.1028345374839916`}, {4.580287600560403, 
    2.966156551926164}, {0.844591331515425, 4.538329317366291}, {
    1.6414698071512825`, 4.578480713760013}, {2.761688076927784, 
    4.582762520485268}, {3.8090330681964595`, 4.1333806228000025`}, {
    4.534431621706447, 3.762570322110009}, {2.651941969558473, 
    4.05846216176014}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 3}], 
      LineBox[{1, 4}], LineBox[{2, 5}], LineBox[{2, 4}], LineBox[{3, 4}], 
      LineBox[{3, 13}], LineBox[{4, 14}], LineBox[{4, 6}], LineBox[{4, 15}], 
      LineBox[{5, 6}], LineBox[{5, 7}], LineBox[{5, 8}], LineBox[{5, 9}], 
      LineBox[{6, 23}], LineBox[{8, 10}], LineBox[{8, 11}], LineBox[{9, 24}], 
      LineBox[{10, 11}], LineBox[{10, 12}], LineBox[{11, 12}], 
      LineBox[{11, 9}], LineBox[{11, 17}], LineBox[{12, 18}], 
      LineBox[{13, 19}], LineBox[{13, 20}], LineBox[{13, 6}], 
      LineBox[{13, 21}], LineBox[{14, 11}], LineBox[{14, 7}], 
      LineBox[{14, 16}], LineBox[{15, 16}], LineBox[{15, 22}], 
      LineBox[{15, 20}], LineBox[{16, 23}], LineBox[{16, 24}], 
      LineBox[{16, 17}], LineBox[{16, 25}], LineBox[{16, 26}], 
      LineBox[{16, 27}], LineBox[{17, 28}], LineBox[{17, 29}], 
      LineBox[{18, 9}], LineBox[{18, 28}], LineBox[{18, 30}], 
      LineBox[{18, 31}], LineBox[{19, 22}], LineBox[{19, 32}], 
      LineBox[{22, 32}], LineBox[{22, 33}], LineBox[{22, 21}], 
      LineBox[{22, 26}], LineBox[{25, 30}], LineBox[{26, 29}], 
      LineBox[{26, 34}], LineBox[{27, 21}], LineBox[{29, 30}], 
      LineBox[{29, 31}], LineBox[{29, 35}], LineBox[{29, 36}], 
      LineBox[{31, 36}], LineBox[{32, 33}], LineBox[{33, 37}], 
      LineBox[{35, 36}], LineBox[{37, 35}], LineBox[{37, 34}], 
      LineBox[{37, 21}], LineBox[{37, 30}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "30"],
       Annotation[#, 30, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "26"],
       Annotation[#, 26, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "32"],
       Annotation[#, 32, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "27"],
       Annotation[#, 27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "35"],
       Annotation[#, 35, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "31"],
       Annotation[#, 31, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "33"],
       Annotation[#, 33, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "36"],
       Annotation[#, 36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        "34"],
       Annotation[#, 34, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        "28"],
       Annotation[#, 28, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        "37"],
       Annotation[#, 37, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[31],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[32],
        "21"],
       Annotation[#, 21, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[33],
        "22"],
       Annotation[#, 22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[34],
        "29"],
       Annotation[#, 29, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[35],
        "24"],
       Annotation[#, 24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[36],
        "25"],
       Annotation[#, 25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[37],
        "23"],
       Annotation[#, 23, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.062036022304934324`, 0.8298995261403577}, {
     0.7926678142795236, 0.45456460273454025`}, {0.015586893893210885`, 
     1.6280007516325479`}, {0.7701820611604573, 1.2759207902715868`}, {
     1.9507581940237078`, 0.5257796887259589}, {1.1041944130021313`, 
     1.4839762649711639`}, {1.838975097274439, 0.}, {2.9692184952388008`, 
     0.00885552126909328}, {3.1134317751023253`, 1.0980501514658478`}, {
     3.7712397172488794`, 0.05526830252848214}, {3.3240129562519787`, 
     0.7624569261609002}, {4.148324682481112, 0.7897064118469199}, {
     0.5306785016906368, 2.6485408586217334`}, {2.055997968510287, 
     1.0238978748586907`}, {1.0285896576385554`, 2.542565609759389}, {
     2.297132320814199, 2.2909174857870584`}, {3.569022093708574, 
     2.050713559593679}, {4.068715623620707, 1.94831734445668}, {
     0.46630367878575507`, 3.812880080167976}, {0., 2.756016309087825}, {
     1.4934389017256047`, 3.487134267581}, {1.2875161469635217`, 
     3.8259245815937617`}, {1.6254391540065072`, 1.7827330641633652`}, {
     2.807561634053396, 1.6187134926612976`}, {2.953206654788591, 
     2.799341470202164}, {2.5464999416620215`, 3.556445814855464}, {
     1.7961382908025814`, 2.9663770660127753`}, {4.598324397022974, 
     1.8450009608805311`}, {3.826370737499998, 3.3123958477632076`}, {
     3.486908583221485, 3.1028345374839916`}, {4.580287600560403, 
     2.966156551926164}, {0.844591331515425, 4.538329317366291}, {
     1.6414698071512825`, 4.578480713760013}, {2.761688076927784, 
     4.582762520485268}, {3.8090330681964595`, 4.1333806228000025`}, {
     4.534431621706447, 3.762570322110009}, {2.651941969558473, 
     4.05846216176014}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellLabel->"Out[5]=",
 CellID->5671206]
}, Open  ]],

Cell["This calculates the pseudo-diameter of the graph: ", "UpgradeDetail",
 CellID->679391213],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "DiscreteMath`GraphPlot`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ug", " ", "=", " ", 
   RowBox[{"Join", "[", 
    RowBox[{"g", ",", " ", 
     RowBox[{"Reverse", "/@", "g"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"PseudoDiameter", "[", "ug", "]"}]}], "Input", "LegacyInput",
 CellID->268655413],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "GraphUtilities`"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ug", " ", "=", " ", 
   RowBox[{"Join", "[", 
    RowBox[{"g", ",", " ", 
     RowBox[{"Reverse", "/@", "g"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"PseudoDiameter", "[", "ug", "]"}]}], "Input",
 CellLabel->"In[7]:=",
 CellID->393670025],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"6", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "25"}], "}"}]}], "}"}], "}"}]], "Output",
 CellLabel->"Out[8]=",
 CellID->287487894]
}, Open  ]],

Cell["\<\
This confirms that the distance between vertices 1 and 25 is indeed 6: \
\>", "UpgradeDetail",
 CellID->619852036],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "DiscreteMath`GraphPlot`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphDistance", "[", 
  RowBox[{"ug", ",", "1", ",", "25"}], "]"}]}], "Input", "LegacyInput",
 CellID->110573409],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "GraphUtilities`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"GraphDistance", "[", 
  RowBox[{"ug", ",", "1", ",", "25"}], "]"}]}], "Input",
 CellLabel->"In[9]:=",
 CellID->188173508],

Cell[BoxData["6"], "Output",
 CellLabel->"Out[9]=",
 CellID->50102109]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 55, 14.6887834}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/GraphPlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 73, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[885, 35, 4447, 145, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[CellGroupData[{
Cell[5357, 184, 59, 1, 70, "UpgradeDetailLabel",
 CellID->305554978],
Cell[5419, 187, 85, 1, 70, "UpgradeDetail",
 CellID->1457835045],
Cell[5507, 190, 533, 15, 70, "Input",
 CellID->680503780],
Cell[CellGroupData[{
Cell[6065, 209, 450, 13, 70, "Input",
 CellID->81334614],
Cell[6518, 224, 1274, 38, 70, "Output",
 CellID->897025052]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7841, 268, 61, 1, 70, "UpgradeDetailLabel",
 CellID->235896513],
Cell[7905, 271, 67, 1, 70, "UpgradeDetail",
 CellID->28242450],
Cell[7975, 274, 500, 13, 70, "Input",
 CellID->96311716],
Cell[CellGroupData[{
Cell[8500, 291, 421, 12, 70, "Input",
 CellID->334615587],
Cell[8924, 305, 1457, 40, 70, "Output",
 CellID->1516381488]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10430, 351, 58, 1, 70, "UpgradeDetailLabel",
 CellID->749583176],
Cell[10491, 354, 65, 1, 70, "UpgradeDetail",
 CellID->352272671],
Cell[10559, 357, 660, 21, 70, "Input",
 CellID->730029133],
Cell[CellGroupData[{
Cell[11244, 382, 565, 19, 70, "Input",
 CellID->451904711],
Cell[11812, 403, 1330, 34, 70, "Output",
 CellID->72431850],
Cell[13145, 439, 6280, 176, 70, "Output",
 CellID->212573422]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19474, 621, 71, 1, 70, "UpgradeDetailLabel",
 CellID->548853516],
Cell[19548, 624, 250, 8, 70, "UpgradeDetail",
 CellID->30910388],
Cell[19801, 634, 454, 13, 70, "Input",
 CellID->102614903],
Cell[CellGroupData[{
Cell[20280, 651, 317, 10, 70, "Input",
 CellID->142367498],
Cell[20600, 663, 6077, 170, 70, "Output",
 CellID->11747071]
}, Open  ]],
Cell[26692, 836, 85, 1, 70, "UpgradeDetail",
 CellID->586390626],
Cell[26780, 839, 1147, 31, 70, "Input",
 CellID->37977188],
Cell[CellGroupData[{
Cell[27952, 874, 1171, 27, 70, "Input",
 CellID->942280834],
Cell[29126, 903, 4369, 107, 70, "Output",
 CellID->1216897481]
}, Open  ]],
Cell[CellGroupData[{
Cell[33532, 1015, 1070, 23, 70, "Input",
 CellID->292654313],
Cell[34605, 1040, 2929, 79, 70, "Output",
 CellID->1089754770]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[37583, 1125, 66, 1, 70, "UpgradeDetailLabel",
 CellID->82429385],
Cell[37652, 1128, 64, 1, 70, "UpgradeDetail",
 CellID->89129401],
Cell[37719, 1131, 660, 21, 70, "Input",
 CellID->294031750],
Cell[CellGroupData[{
Cell[38404, 1156, 565, 19, 70, "Input",
 CellID->165968328],
Cell[38972, 1177, 1330, 34, 70, "Output",
 CellID->44567173],
Cell[40305, 1213, 6280, 176, 70, "Output",
 CellID->104012440]
}, Open  ]],
Cell[46600, 1392, 313, 11, 70, "UpgradeDetail",
 CellID->123410418],
Cell[46916, 1405, 852, 28, 70, "Input",
 CellID->27413745],
Cell[CellGroupData[{
Cell[47793, 1437, 290, 9, 70, "Input",
 CellID->802200557],
Cell[48086, 1448, 6332, 176, 70, "Output",
 CellID->487591306]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[54467, 1630, 67, 1, 70, "UpgradeDetailLabel",
 CellID->483079425],
Cell[54537, 1633, 259, 8, 70, "UpgradeDetail",
 CellID->21337861],
Cell[54799, 1643, 2107, 58, 70, "Input",
 CellID->204910962],
Cell[CellGroupData[{
Cell[56931, 1705, 2032, 56, 70, "Input",
 CellID->5023671],
Cell[58966, 1763, 2272, 66, 70, "Output",
 CellID->1176270210]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[61287, 1835, 70, 1, 70, "UpgradeDetailLabel",
 CellID->2035676930],
Cell[61360, 1838, 282, 8, 70, "UpgradeDetail",
 CellID->1883593691],
Cell[61645, 1848, 661, 17, 70, "Input",
 CellID->1632820951],
Cell[CellGroupData[{
Cell[62331, 1869, 533, 14, 70, "Input",
 CellID->2108438191],
Cell[62867, 1885, 881, 19, 70, "Output",
 CellID->1184348080]
}, Open  ]],
Cell[63763, 1907, 76, 1, 70, "UpgradeDetail",
 CellID->664795099],
Cell[63842, 1910, 1041, 29, 70, "Input",
 CellID->1336390772],
Cell[CellGroupData[{
Cell[64908, 1943, 1069, 27, 70, "Input",
 CellID->2001297199],
Cell[65980, 1972, 1776, 34, 70, "Output",
 CellID->630772446]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[67805, 2012, 85, 1, 70, "UpgradeDetailLabel",
 CellID->503827689],
Cell[67893, 2015, 98, 1, 70, "UpgradeDetail",
 CellID->268345263],
Cell[67994, 2018, 795, 21, 70, "Input",
 CellID->232932587],
Cell[CellGroupData[{
Cell[68814, 2043, 668, 18, 70, "Input",
 CellID->439256356],
Cell[69485, 2063, 2994, 83, 70, "Output",
 CellID->195459646]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[72540, 2153, 77, 1, 70, "UpgradePackageSection",
 CellID->1087906933],
Cell[72620, 2156, 319, 8, 70, "UpgradeDetail",
 CellID->1074807037],
Cell[72942, 2166, 80, 1, 70, "UpgradeDetail",
 CellID->259115070],
Cell[73025, 2169, 3544, 81, 70, "Input",
 CellID->259585046],
Cell[CellGroupData[{
Cell[76594, 2254, 3216, 76, 70, "Input",
 CellID->144093056],
Cell[79813, 2332, 8796, 229, 70, "Output",
 CellID->5671206]
}, Open  ]],
Cell[88624, 2564, 95, 1, 70, "UpgradeDetail",
 CellID->679391213],
Cell[88722, 2567, 348, 9, 70, "Input",
 CellID->268655413],
Cell[CellGroupData[{
Cell[89095, 2580, 331, 10, 70, "Input",
 CellID->393670025],
Cell[89429, 2592, 192, 7, 70, "Output",
 CellID->287487894]
}, Open  ]],
Cell[89636, 2602, 124, 3, 70, "UpgradeDetail",
 CellID->619852036],
Cell[89763, 2607, 224, 5, 70, "Input",
 CellID->110573409],
Cell[CellGroupData[{
Cell[90012, 2616, 224, 6, 70, "Input",
 CellID->188173508],
Cell[90239, 2624, 70, 2, 70, "Output",
 CellID->50102109]
}, Open  ]]
}, Open  ]],
Cell[90336, 2630, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

