(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    196208,       4126]
NotebookOptionsPosition[    190575,       3940]
NotebookOutlinePosition[    191539,       3968]
CellTagsIndexPosition[    191496,       3965]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["Graphics`Graphics`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogPlot"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ListLogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLogPlot"]], "InlineFormula"],
 ", and related functions have been added to the built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel.\n",
 Cell[BoxData[
  ButtonBox["PolarPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolarPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ListPolarPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPolarPlot"]], "InlineFormula"],
 " have been added to the built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel.\n",
 Cell[BoxData[
  ButtonBox["GraphicsGrid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsGrid"]], "InlineFormula"],
 " has been added to the built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel.\n",
 Cell[BoxData[
  ButtonBox["BarChart",
   BaseStyle->"Link",
   ButtonData->"paclet:BarCharts/ref/BarChart"]], "InlineFormula"],
 " and related functions are available in the newly created ",
 ButtonBox["Bar Charts Package",
  BaseStyle->"Link",
  ButtonData->"paclet:BarCharts/guide/BarChartsPackage"],
 ". \n",
 Cell[BoxData[
  ButtonBox["PieChart",
   BaseStyle->"Link",
   ButtonData->"paclet:PieCharts/ref/PieChart"]], "InlineFormula"],
 " is available in the newly created ",
 ButtonBox["Pie Charts Package",
  BaseStyle->"Link",
  ButtonData->"paclet:PieCharts/guide/PieChartsPackage"],
 ".\n",
 Cell[BoxData[
  ButtonBox["Histogram",
   BaseStyle->"Link",
   ButtonData->"paclet:Histograms/ref/Histogram"]], "InlineFormula"],
 " is available in the newly created created ",
 ButtonBox["Histograms Package",
  BaseStyle->"Link",
  ButtonData->"paclet:Histograms/guide/HistogramsPackage"],
 ".\n",
 Cell[BoxData[
  ButtonBox["ErrorListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ErrorBarPlots/ref/ErrorListPlot"]], "InlineFormula"],
 " is available in the newly created ",
 ButtonBox["ErrorBar Plotting Package",
  BaseStyle->"Link",
  ButtonData->"paclet:ErrorBarPlots/guide/ErrorBarPlottingPackage"],
 "."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[CellGroupData[{

Cell["New system functions", "UpgradeDetailLabel",
 CellID->305554978],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogPlot"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["LogLinearPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogLinearPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["LogLogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogLogPlot"]], "InlineFormula"],
 " are part of the built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel:"
}], "UpgradeDetail",
 CellID->1457835045],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Graphics`Graphics`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"Sinh", "[", "x", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", "3"}], "}"}]}], "]"}]}], "Input", \
"LegacyInput",
 CellID->588129106],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"Sinh", "[", "x", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1966141048],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVzmk8lI0exvGZsYzIUsdW6sk6diqydfK/LREtKFmrx5IRSZLKTlkfmRZb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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, -3.928214489280436},
  FrameTicks->{Automatic, {{-4.605170185988091, 
      FormBox["0.01`", TraditionalForm]}, {-2.995732273553991, 
      FormBox["0.05`", TraditionalForm]}, {-2.3025850929940455`, 
      FormBox["0.1`", TraditionalForm]}, {-0.6931471805599453, 
      FormBox["0.5`", TraditionalForm]}, {0, 
      FormBox["1", TraditionalForm]}, {
      NCache[
       Log[5], 1.6094379124341003`], 
      FormBox["5", TraditionalForm]}, {
      NCache[
       Log[10], 2.302585092994046], 
      FormBox["10", TraditionalForm]}, {
      NCache[
       Log[50], 3.912023005428146], 
      FormBox["50", TraditionalForm]}, {-3.912023005428146, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-3.506557897319982, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-3.2188758248682006`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.8134107167600364`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.6592600369327783`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.5257286443082556`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.4079456086518722`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-1.6094379124341003`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-1.203972804325936, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.916290731874155, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.5108256237659907, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.35667494393873245`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.2231435513142097, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.10536051565782628`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.6931471805599453, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.0986122886681098`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.3862943611198906`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.791759469228055, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.9459101490553132`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.0794415416798357`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.1972245773362196`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.995732273553991, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {3.4011973816621555`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {3.6888794541139363`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}}, Automatic, {{-4.605170185988091, 
      FormBox["0.01`", TraditionalForm]}, {-2.995732273553991, 
      FormBox["0.05`", TraditionalForm]}, {-2.3025850929940455`, 
      FormBox["0.1`", TraditionalForm]}, {-0.6931471805599453, 
      FormBox["0.5`", TraditionalForm]}, {0, 
      FormBox["1", TraditionalForm]}, {
      NCache[
       Log[5], 1.6094379124341003`], 
      FormBox["5", TraditionalForm]}, {
      NCache[
       Log[10], 2.302585092994046], 
      FormBox["10", TraditionalForm]}, {
      NCache[
       Log[50], 3.912023005428146], 
      FormBox["50", TraditionalForm]}, {-3.912023005428146, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-3.506557897319982, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-3.2188758248682006`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.8134107167600364`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.6592600369327783`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.5257286443082556`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.4079456086518722`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-1.6094379124341003`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-1.203972804325936, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.916290731874155, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.5108256237659907, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.35667494393873245`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.2231435513142097, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.10536051565782628`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.6931471805599453, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.0986122886681098`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.3862943611198906`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.791759469228055, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.9459101490553132`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.0794415416798357`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.1972245773362196`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.995732273553991, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {3.4011973816621555`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {3.6888794541139363`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}}},
  GridLines->{None, None},
  Method->{"MappingFunctions" -> {{#, 
       Log[#2]}& , {#, #2}& }, "MessagesHead" -> LogPlot},
  PlotRange->{{0, 3}, {-3.928214489280436, 2.30437092854233}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, {{-4.605170185988091, 
      FormBox["0.01`", TraditionalForm]}, {-2.995732273553991, 
      FormBox["0.05`", TraditionalForm]}, {-2.3025850929940455`, 
      FormBox["0.1`", TraditionalForm]}, {-0.6931471805599453, 
      FormBox["0.5`", TraditionalForm]}, {0, 
      FormBox["1", TraditionalForm]}, {
      NCache[
       Log[5], 1.6094379124341003`], 
      FormBox["5", TraditionalForm]}, {
      NCache[
       Log[10], 2.302585092994046], 
      FormBox["10", TraditionalForm]}, {
      NCache[
       Log[50], 3.912023005428146], 
      FormBox["50", TraditionalForm]}, {-3.912023005428146, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-3.506557897319982, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-3.2188758248682006`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.8134107167600364`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.6592600369327783`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.5257286443082556`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.4079456086518722`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-1.6094379124341003`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-1.203972804325936, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.916290731874155, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.5108256237659907, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.35667494393873245`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.2231435513142097, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.10536051565782628`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.6931471805599453, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.0986122886681098`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.3862943611198906`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.791759469228055, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.9459101490553132`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.0794415416798357`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.1972245773362196`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.995732273553991, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {3.4011973816621555`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {3.6888794541139363`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}}}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1601717347]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1062413713],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListLogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLogPlot"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ListLogLinearPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLogLinearPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ListLogLogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLogLogPlot"]], "InlineFormula"],
 " have the same functionality as ",
 Cell[BoxData["LogListPlot"], "InlineFormula"],
 ", ",
 Cell[BoxData["LogLinearListPlot"], "InlineFormula"],
 ", and ",
 Cell[BoxData["LogLogListPlot"], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->1287020621],

Cell[BoxData[
 RowBox[{"LogListPlot", "[", 
  RowBox[{"Exp", "[", 
   RowBox[{"Range", "[", 
    RowBox[{"0", ",", "3", ",", "0.2"}], "]"}], "]"}], "]"}]], "Input", \
"LegacyInput",
 CellLabel->"In[1]:=",
 CellID->1500284563],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{"Exp", "[", 
   RowBox[{"Range", "[", 
    RowBox[{"0", ",", "3", ",", "0.2"}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1677150914],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{1., 0.}, {2., 0.2}, {3., 0.4}, {4., 0.6000000000000001}, {5., 
     0.8000000000000002}, {6., 1.}, {7., 1.2000000000000002`}, {8., 
     1.4000000000000001`}, {9., 1.6}, {10., 1.8}, {11., 2.}, {12., 2.2}, {13.,
      2.4000000000000004`}, {14., 2.6}, {15., 2.8000000000000003`}, {16., 
     3.}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0., 0.},
  FrameTicks->{Automatic, {{0., 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"1.0\"", 1.`2.9999999999999973, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
     2.302585092994046, 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"10.0\"", 10.`2.9999999999999973, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
     1.6094379124341003`, 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"5.0\"", 5.`2.9999999999999973, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
     3.912023005428146, 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"50.0\"", 50.`2.9999999999999973, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
     0.6931471803691238, 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"2.0\"", 2.`2.9999999999999973, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
     2.995732273553991, 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"20.0\"", 20.`2.9999999999999973, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
     1.0986122886681098`, 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"3.0\"", 3.`3.000000000000001, AutoDelete -> True], NumberForm[#, {
          DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
     3.4011973816621555`, 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"30.0\"", 30.`3.0000000000000027, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
     0.4054651081081644, 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"1.5\"", 1.5`3.0000000000000027, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}]& ], TraditionalForm]}, {2.70805020110221, 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"15.0\"", 15.`3.0000000000000027, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
     1.9459101490553132`, 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"7.0\"", 7.`2.9999999999999973, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
     4.248495242049359, 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"70.0\"", 70.`2.9999999999999973, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
     0.09531017980432493, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.1823215567939548, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.26236426446749106`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.336472236621213, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.47000362924573563`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.5306282510621705, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.5877866649021191, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.6418538861723948, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {
      NCache[
       Log[4], 1.3862943611198906`], 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {
      NCache[
       Log[6], 1.791759469228055], 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.0794415416798357`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.1972245773362196`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.3978952727983707`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.4849066497880004`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.5649493574615367`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.6390573296152584`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.772588722239781, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.833213344056216, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.8903717578961645`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.9444389791664403`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {
      NCache[
       Log[40], 3.6888794541139363`], 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {
      NCache[
       Log[60], 4.0943445622221], 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}}, Automatic, {{0., 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"1.0\"", 1.`2.9999999999999973, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
     2.302585092994046, 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"10.0\"", 10.`2.9999999999999973, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
     1.6094379124341003`, 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"5.0\"", 5.`2.9999999999999973, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
     3.912023005428146, 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"50.0\"", 50.`2.9999999999999973, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
     0.6931471803691238, 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"2.0\"", 2.`2.9999999999999973, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
     2.995732273553991, 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"20.0\"", 20.`2.9999999999999973, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
     1.0986122886681098`, 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"3.0\"", 3.`3.000000000000001, AutoDelete -> True], NumberForm[#, {
          DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
     3.4011973816621555`, 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"30.0\"", 30.`3.0000000000000027, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
     0.4054651081081644, 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"1.5\"", 1.5`3.0000000000000027, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}]& ], TraditionalForm]}, {2.70805020110221, 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"15.0\"", 15.`3.0000000000000027, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
     1.9459101490553132`, 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"7.0\"", 7.`2.9999999999999973, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
     4.248495242049359, 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"70.0\"", 70.`2.9999999999999973, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
     0.09531017980432493, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.1823215567939548, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.26236426446749106`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.336472236621213, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.47000362924573563`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.5306282510621705, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.5877866649021191, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.6418538861723948, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {
      NCache[
       Log[4], 1.3862943611198906`], 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {
      NCache[
       Log[6], 1.791759469228055], 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.0794415416798357`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.1972245773362196`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.3978952727983707`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.4849066497880004`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.5649493574615367`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.6390573296152584`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.772588722239781, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.833213344056216, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.8903717578961645`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.9444389791664403`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {
      NCache[
       Log[40], 3.6888794541139363`], 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {
      NCache[
       Log[60], 4.0943445622221], 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}}},
  GridLines->{None, None},
  Method->{"MessagesHead" -> ListLogPlot},
  PlotRange->{{0., 16.}, {0., 3.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, {{0., 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"1.0\"", 1.`2.9999999999999973, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
     2.302585092994046, 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"10.0\"", 10.`2.9999999999999973, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
     1.6094379124341003`, 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"5.0\"", 5.`2.9999999999999973, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
     3.912023005428146, 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"50.0\"", 50.`2.9999999999999973, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
     0.6931471803691238, 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"2.0\"", 2.`2.9999999999999973, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
     2.995732273553991, 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"20.0\"", 20.`2.9999999999999973, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
     1.0986122886681098`, 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"3.0\"", 3.`3.000000000000001, AutoDelete -> True], NumberForm[#, {
          DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
     3.4011973816621555`, 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"30.0\"", 30.`3.0000000000000027, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
     0.4054651081081644, 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"1.5\"", 1.5`3.0000000000000027, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}]& ], TraditionalForm]}, {2.70805020110221, 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"15.0\"", 15.`3.0000000000000027, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
     1.9459101490553132`, 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"7.0\"", 7.`2.9999999999999973, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
     4.248495242049359, 
      FormBox[
       TagBox[
        InterpretationBox[
        "\"70.0\"", 70.`2.9999999999999973, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}]& ], TraditionalForm]}, {
     0.09531017980432493, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.1823215567939548, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.26236426446749106`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.336472236621213, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.47000362924573563`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.5306282510621705, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.5877866649021191, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.6418538861723948, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {
      NCache[
       Log[4], 1.3862943611198906`], 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {
      NCache[
       Log[6], 1.791759469228055], 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.0794415416798357`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.1972245773362196`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.3978952727983707`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.4849066497880004`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.5649493574615367`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.6390573296152584`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.772588722239781, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.833213344056216, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.8903717578961645`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.9444389791664403`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {
      NCache[
       Log[40], 3.6888794541139363`], 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {
      NCache[
       Log[60], 4.0943445622221], 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}}}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1309642099]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1808233233],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PolarPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolarPlot"]], "InlineFormula"],
 " is now part of the built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel:"
}], "UpgradeDetail",
 CellID->2065092323],

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "t", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", " ", "0", ",", " ", "20"}], "}"}]}], "]"}]], "Input", \
"LegacyInput",
 CellLabel->"In[1]:=",
 CellID->375969847],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "t", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", " ", "0", ",", " ", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1028329055],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxcmXk81N/3x2cMYyyRSkIJhSSSstbHeSORlERIiCylkrKEokikbEkbJREp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     "]]}},
  Axes->True,
  AxesOrigin->{0, 0},
  Method->{"MessagesHead" -> PolarPlot},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellLabel->"Out[2]=",
 CellID->811861232]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1934858334],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListPolarPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPolarPlot"]], "InlineFormula"],
 " has the same functionality as ",
 Cell[BoxData["PolarListPlot"], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->1988116833],

Cell[BoxData[
 RowBox[{"PolarListPlot", "[", 
  RowBox[{"Range", "[", 
   RowBox[{"0", ",", " ", "10", ",", " ", "0.2"}], "]"}], "]"}]], "Input", \
"LegacyInput",
 CellLabel->"In[1]:=",
 CellID->1581548558],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{"Range", "[", 
   RowBox[{"0", ",", " ", "10", ",", " ", "0.2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1681515387],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{0., 0.}, {0.19848410193438715`, 0.024577658132942826`}, {
     0.3879187744140038, 0.09756548804335086}, {0.5594833376426136, 
     0.21674499971229177`}, {0.7048097554286277, 0.37847484546880805`}, {
     0.8161969123562217, 0.5777738314082511}, {0.8868107006647911, 
     0.8084347723758688}, {0.910865620285939, 1.0631668833165901`}, {
     0.8837839567368093, 1.3337638163537913`}, {0.8023290403977689, 
     1.6112939244391122`}, {0.6647095989593194, 1.886308868942555}, {
     0.4706527830542944, 2.1490662990711216`}, {0.2214440627119248, 
     2.389762023108083}, {-0.08006715224604292, 
     2.5987668712547514`}, {-0.42949663366031904`, 
     2.7668633218275267`}, {-0.8209889702162485, 
     2.885476929518457}, {-1.247314794536574, 
     2.946897657423852}, {-1.7000000000000002`, 
     2.9444863728670914`}, {-2.169484690965323, 
     2.8728620182088624`}, {-2.6453089946591213`, 
     2.7280653076448798`}, {-3.1163222981026815`, 
     2.507695223576426}, {-3.5709119700643797`, 
     2.2110150840848943`}, {-3.997247196005904, 
     1.8390255175018473`}, {-4.383533201964921, 
     1.3945023009200004`}, {-4.71827087848273, 
     0.8819976855195377}, {-4.99051664368522, 
     0.3078045306697142}, {-5.19013730943263, -0.32011671189650276`}, \
{-5.30805473829307, -0.9922473962094799}, {-5.336475202392077, \
-1.6976549750330439`}, {-5.269098576553238, -2.424170000343344}, \
{-5.101302814377686, -3.158592977264134}, {-4.830299562059157, \
-3.88692759654346}, {-4.45525725416273, -4.594636307612428}, \
{-3.977388600103092, -5.266913700049582}, {-3.4000000000000004`, \
-5.888972745734183}, {-2.7285011130487553`, -6.4463386256146755`}, \
{-1.9703735285189965`, -6.925144630844297}, {-1.1350982461022718`, \
-7.31242449340132}, {-0.2340424450268947, -7.596395469821581}, {
     0.7196932038137556, -7.76672657510127}, {
     1.7114646656519796`, -7.8147865420768055`}, {
     2.7253093557332098`, -7.733866362664476}, {
     3.7442021885229213`, -7.519371647382524}, {
     4.75033876746035, -7.168980512901627}, {
     5.725441041797331, -6.682763266561423}, {
     6.651080254985931, -6.0632607928190145`}, {
     7.509011593677241, -5.315519248955911}, {
     8.281514626286375, -4.4470794342584945`}, {
     8.951733402281818, -3.4679199953966684`}, {
     9.504009973143093, -2.390354457062096}, {
     9.924205096719357, -1.2288829066471412`}}]}, {}},
  Axes->True,
  AxesOrigin->{0, 0},
  Method->{"MessagesHead" -> ListPolarPlot},
  PlotRange->{{-5.336475202392077, 9.924205096719357}, {-7.8147865420768055`, 
   2.946897657423852}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1577713705]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1853347272],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Show",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Show"]], "InlineFormula"],
 " can be used in place of ",
 Cell[BoxData["DisplayTogether"], "InlineFormula"],
 " since graphics are no longer displayed as side-effects:"
}], "UpgradeDetail",
 CellID->139473056],

Cell[BoxData[
 RowBox[{"DisplayTogether", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{"x", ",", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", " ", "0", ",", " ", "1"}], "}"}]}], "]"}], ",", " ", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"x", "^", "2"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", " ", "0", ",", " ", "1"}], "}"}]}], "]"}]}], 
  "]"}]], "Input", "LegacyInput",
 CellLabel->"In[1]:=",
 CellID->671458247],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{"x", ",", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", " ", "0", ",", " ", "1"}], "}"}]}], "]"}], ",", " ", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"x", "^", "2"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", " ", "0", ",", " ", "1"}], "}"}]}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->172192344],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxNxX0s1GEcAPBzEWU7jsl+Z8eOUyuaJiNKp9iU13lbbNdp8hJGstvQZpzR
C661Zrp1yetW4lzc0ZpEXGySlwjlXnJd13FCW8eOuOoP3+f547MPI+V6bBqZ
RCJF/fP/sDTd1MBSwtm9zYNpeSrCh7X3yXrBYwkRAod/mOuqI+LhS6mbfQ+I
VFjhdTuYT3DhBofoW5VEOcyzkhy5S9TAiUmN4vVfLbC1iccOdRbD7jGruqEq
KVww7s8S/H4FO0qpSjOzfrhHHTw2cWYQHsyqc0pakcGGw4E2opwRmGxss3Vy
H4V9TVd64jrG4LFyn/HhYxOwy329sXV1EtZvqpSfTnyEW5Z7Ryn3pmEK/ema
RjMDV2d2pzcwZ+GNoDbNtZI5mOstkx4amodVHbKqKcYXeDtrRnj05gLscc5y
N71XDoc2MTI6HZVwAT3ZdZGtgj1XEqznIr/C9jbrVrIttHm/UOz2eBHO9un9
fCBcDbddTGl4s4E26Gm22tpvcHdc6L6aEA1ccqGiXqpFMxRh880V3+EAv/Ia
wlsLs50njGbTaMMoX53H+wELzDncWKYOtld2N5FlaItiXrz/jSWY1MoRq+2W
4fxHYr7dILrP444VNVcPU8PyPcsoK7D8+OR00Wv0iycspobzE74s9qXSd9Gl
FY08+fNVWKSjCykRa3AMlXJqZAtdaUF2kmPLjIaddWxftWKIto2mSUTRudjq
+MgMhz9orqC69uoOWlRdWlSIrS3lsvnYiZls15fYgQGeHQd30fvl7991YrMm
+58NYxfKJFUL2MvtwhgLE3q8OFuRiG2ZnzyQgx2UHtdcht0VdTqzHVt/3ivi
LTbTz81rFpvj4Winx37oYm0wYf8FVp6K0A==
      "]]}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1nk81NsfBnA7qYSuNIPrZq1ouBEl5iHKmuzZmshOWUqUrjUqFy03P4Qi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      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  Method->{},
  PlotRange->{{0, 1}, {0., 0.9999999795918367}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1376253099]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1761046328],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GraphicsGrid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsGrid"]], "InlineFormula"],
 " can be used in place of ",
 Cell[BoxData["DisplayTogetherArray"], "InlineFormula"],
 " since graphics are no longer displayed as side-effects:"
}], "UpgradeDetail",
 CellID->1839217050],

Cell[BoxData[
 RowBox[{"DisplayTogetherArray", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"DensityPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"x", "+", "a"}], "]"}], 
       RowBox[{"Cos", "[", 
        RowBox[{"y", "+", "b"}], "]"}]}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"x", ",", " ", "0", ",", " ", "Pi"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "0", ",", "Pi"}], "}"}]}], "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"a", ",", " ", "0", ",", " ", "2"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"b", ",", " ", "0", ",", " ", "2"}], "}"}]}], "]"}], 
  "]"}]], "Input", "LegacyInput",
 CellLabel->"In[1]:=",
 CellID->1218993315],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"DensityPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"x", "+", "a"}], "]"}], 
       RowBox[{"Cos", "[", 
        RowBox[{"y", "+", "b"}], "]"}]}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"x", ",", " ", "0", ",", " ", "Pi"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "0", ",", "Pi"}], "}"}]}], "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"a", ",", " ", "0", ",", " ", "2"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"b", ",", " ", "0", ",", " ", "2"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->626652825],

Cell[BoxData[
 GraphicsBox[{{{}, {}, {}}, {{InsetBox[
      GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx1lz9oFUEQh+/UU68RK7GTdBaKYKv4tojYiiQW2ohgQBAULMReQQIWIhZ2
2oogYgrFgK1FWkkzrdicoIRDjEcUefnNMd/upRl+b3dn35f5t2/h+u1LN/ZU
VdXUVfXf8i+9/Hjm2IeNWdTm+sf7jVubq1+x3rn+vLj88N3WT+zvXR89ubj0
Z+E3zg+u11afP1k4XqXor3ZtO4fvn/+01/Xcf+N6391H125ePuB6fl/rmpxl
a67FG9c71+KN+3vX4o3nB9fijf5q1+KN/hvX4o33tWkqjmXO0UZeA6+B18Br
4DXwGngNvAZeA6+B18Cb52k5jiMnrXilxRv39a7FG88PrsUb/dWuxRv9N67F
G+9r01QdlvPUMq64PtoY3w7x7RDfDvHtEN8O8e0Q3w7x7RDfDvHN+0y5Di2L
G7mkacUrLd54fnAt3uindi3e6L9xLd54X5um+mi5z1iWl4wbueL+0cZ87pHP
PfK5Rz73yOce+dwjn3vkcz4nyn3UsrpjXjJu5JKmFa+0eKO/2rV4o//GtXjj
PW2amoPlOWFZX2HdMS8ZN3LF86ON9TugfgfU74D6HVC/A+o3n/PlOWhZ32Rf
Yd0xLxk3cknTildavNF/41q88b42Tb1jynPesrnAvsm+wrpjXjJu5Ir+Rhv7
VZ1iv6pT7Fd1iv0qf6eV3zGWzT3OBfZN9hXWHfOScSOXNK14pcUb72vT1Du0
/E6zbK5z7nEusG+yr7DumJeMG7mi/9HG/tyk2J/zd3b5HWrZu4VznXOPc4F9
k32Fdce8ZNzIJU0r3qnfEeV3tmXvMr5bONc59zgX2DfZV1h3zEvGjVzxvtHO
71vfrZ+t2aGLK1dOnz2YpLU+9/NrN+++uN5+9mrlxZ39SVrnpXX+xLe/Fx5/
3/bz0jovrfPSOr909d6ptw92fF1a67Jxvq77fmlyc5/OS09Z+uE5fg/+3+P3
ej2TfXpuefPIm+nPaeM94z5+zvt5Tznvx895r/b9A5SkGUE=
        "], {{
          {GrayLevel[0.8], EdgeForm[None], 
           GraphicsGroupBox[PolygonBox[CompressedData["
1:eJxNmHnYTVUUh/dnaNJAE80+hZJoIJnSIBFNUlSIL30NZCqEDAlFSlLJmDRT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             "]]]}, {}, {}, {}}, {}},
        VertexColors->CompressedData["
1:eJztmGdQlVcexkFAURNQUSGKKFVApCQUUfRhIxKKLYKFqECIEAkCa3fRIErR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         "]],
       AspectRatio->1,
       Frame->True,
       FrameTicks->True,
       Method->{},
       PlotRange->
        NCache[{{0, Pi}, {0, Pi}}, {{0, 3.141592653589793}, {
          0, 3.141592653589793}}],
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}], {193.5, -193.5}, Scaled[{0.5, 0.5}], {360., 360.}], 
     InsetBox[
      GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx1l6+LFVEUx2dcR50iJrHJaxaLVfHdsHYR17BJBBcEQcHkHyDINhGDTasI
Bg2KC1bDVtlyisEgTFBkgjqIyPg9l/O5dyyH73v3nvM+nl93VzfuXLl5qGma
jbZp/ln+S8/fnz/9bn8dtbn+9nb/9sHuF3w/uP64ufXg9Y/vOD+6PnV28+rv
1U/cn1y/2X36aHWmSdFf69r+nLh/6cOG69l/5/rwvYfXb1076nqO17smZ92a
a/HG7wfX4o3nR9fijfcn1+KN/lrX4o3+O9fijfH6tJTHOme2kdfAa+A18Bp4
DbwGXgOvgdfAa+A18JZ1Ws9j5qQVr7R447nRtXjj/cm1eKO/1rV4o//OtXhj
vD4t9WG9Tq3git9nG/M7IL8D8jsgvwPyOyC/A/I7IL8D8jsgv+WcqfehFXkj
lzSteKXFG+9PrsUb/bSuxRv9d67FG+P1aWmO1ueMFXXJvJErns821vOIeh5R
zyPqeUQ9j6jnEfU8op7LPVGfo1b0HeuSeSOXNK14pcUb/bWuxRv9d67FG+P0
aWkP1veEFXOFfce6ZN7IFe9nG/t3Qv9O6N8J/Tuhfyf0b7nn63vQirnJucK+
Y10yb+SSphWvtHij/861eGO8Pi29Y+p73oq9wLnJucK+Y10yb+SK/rKN86pN
cV61Kc6rNsV5Vb7T6u8YK/Ye9wLnJucK+451ybyRS5pWvNLijfH6tPQOrb/T
rNjr3HvcC5ybnCvsO9Yl80au6D/bOJ+7FOdz+c6uv0OteLdwr3PvcS9wbnKu
sO9Yl8wbuaRpxbv0d0T9nW3Fu4zvFu517j3uBc5NzhX2HeuSeSNXjJftHG/v
fz19Wv968mLn2d0jSfr45Z3tcxeOudb5+Xd89nvSui+t+9K6P8f/6veldV5a
52Xj/tzz89Fv5uI53ZdesvTDe/wd/H+Nv+vlWvbxxa2Dk6+WP6eNcfI5fs74
jFOv6/w54+rcX5xpDZM=
        "], {{
          {GrayLevel[0.8], EdgeForm[None], 
           GraphicsGroupBox[PolygonBox[CompressedData["
1:eJxNmHfcl1MYh89bNmVnFZGUQiEl7fAmq6GSSIOSkXZECGVEIZmVlBHKKISW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             "]]]}, {}, {}, {}}, {}},
        VertexColors->CompressedData["
1:eJydmHk0lmkfxy3TZqRepE1aEIm2odDyNSi9lpG1QjUJI/vSokwZlRlr0k5G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         "]],
       AspectRatio->1,
       Frame->True,
       FrameTicks->True,
       Method->{},
       PlotRange->
        NCache[{{0, Pi}, {0, Pi}}, {{0, 3.141592653589793}, {
          0, 3.141592653589793}}],
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}], {580.5, -193.5}, Scaled[{0.5, 0.5}], {360., 360.}], 
     InsetBox[
      GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyFly+IFVEUh2d2d9Qpi0ls8prFolHx3bB2EddgEsGFBUHRJAgmQbaJGGwa
LCIYNCgKVsMmQRbxVE2DrMgEdRCR5+8M57t3cMvhNzPn3Pdx/t2dXbxy5tJS
VVXLdVX9tfxLj14fP/Rqex61ud59uX15Z+sz3neu362t337+/Ru+710fPLJ2
9tfsB/wH1y+2HtydHa5SjFe7tt/7b5x6u+x6Eb9xvXL9zoXNc3tdL85rXZOz
bM21eOP7zrV44/e9a/FG/8G1eGO82rV4Y/zGtXjjeW2aymOZc7SR18Br4DXw
GngNvAZeA6+B18Br4DXw5nVazuPISSteafHG73rX4o3+g2vxxni1a/HG+I1r
8cbz2jTVh+U6tYwrvh9tzG+H/HbIb4f8dshvh/x2yG+H/HbIb4f85nOm3IeW
5Y1c0rTilRZv9B9cizfGqV2LN8ZvXIs3ntemqTlanjOW1SXzRq74/WhjPfeo
5x713KOee9Rzj3ruUc896jnfE+U5alnfsS6ZN3JJ04pXWrwxXu1avDF+41q8
8Zw2Te3B8p6wbK6w71iXzBu5ov9oY/8O6N8B/Tugfwf074D+zfd8eQ9aNjc5
V9h3rEvmjVzStOKVFm+M37gWbzyvTVP3mPKet2wvcG5yrrDvWJfMG7livNHG
eVWnOK/qFOdVneK8yu9p5XuMZXuPe4Fzk3OFfce6ZN7IJU0rXmnxxvPaNHUP
Ld/TLNvr3HvcC5ybnCvsO9Yl80auGH+0cT43Kc7n/J5dvodadm/hXufe417g
3ORcYd+xLpk3cknTinfq/4jyPduyexnvLdzr3HvcC5ybnCvsO9Yl80aueN5o
F+e9mb+fHbt18+NSWj29cf7oiX1JWu+/fPp6bfXxyr/4H1z/vP9k4+HVPUla
/tLy13fyl6aVv7T89ZxW72Xjfh39pMnN5/KXn57zXMahX/wdT+ey906u7xx4
pt+TP6edisM8/s+vXNfjc/rruz8DXwgt
        "], {{
          {GrayLevel[0.8], EdgeForm[None], 
           GraphicsGroupBox[PolygonBox[CompressedData["
1:eJxNmHe8jmUYx59DpaWh0tJQRDqJEgnJOtLCKRqcSJwWISshFIWigYaRJKPS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             "]]]}, {}, {}, {}}, {}},
        VertexColors->CompressedData["
1:eJyVl3lUjWsbxjXgi5IhZUhUSKJOmksuJ2ODg69yDmVoEFISlWhQ6XQSzocM
GTJFOChDSmkOmaJ52tKuXXt637dRRYa+94/XH19rPd9a/bHXXute97r277re
/d7Pc2u6+/17q+ywYcPkZNgP+10UoJMVpSKBwr3gS6udKHjIHrtp3kXjg8HK
7ESxCEnit1df/iZF7cd35+oWMsj3Wfp0SqYQbbb87unbxPhQFbOqzYTB6ECL
jKpbrdhncrr09gMhTG8nOGcaMOj1y3sV+LwFouEzGp2XtmJUe+DmuLkMLp1N
y3ab0oI9PbUlgYYt0B5t3JM0m8ERPfmU+fcFUOu00C2PEWCesYeO+UwGEdYO
HfOOCpBHmfh8cRBgyla3UV7a5H6SPomHxE/yS8qHlCep/uv3gNQlziLs2mD6
ZqS7BAudwm6GWTBIk2rPe32uFW8fVQeEnRMidFjXX24sTyXt0NQ7ugVapx5c
tmf9HUxZW7aa9WX2p+yt7LxmpD71OHVQvhm8Tqv2bA0GF+1ULIV3mzBXz1T/
0CI+Cr0/Xkw4Q0PPxvJudR0fN4NfvB13uQFXm7WzaF8K6cVTB2xP8mGjqGpv
k/wBKmqLfDYoUMR+kv5gng8cT8Ug/giOn+SXlM9QczbXUpVzrBPi5i8911vO
izFx0Zl1/5gycA4Lq5p+qwXXr4/cZzSxFfx5K/UadRnw+2n1B/ebIW95w9yR
bsIM29OaW1n+9adT/zx/n4+yJ/km95QboJv2rrjXiIKWrK1cpvxHONZqPo8x
q8Hhrx71xjVi9GjtcDnSxsNLxzeK2WcqEBFdWli8WQTlpVeXB1rwYHa2oqHR
pRwhT3NLo/hCYj9Jn8Tzk1+O49fk+J04v0mD/JLyGWrOe0U2mbIhQjxKzQ5z
kRNDpceaPmTMwHNBY7dFhwCN6UXbsxgBsmIsOu7NYqDo7VY2EN2EY7fEusu7
GvH8RfCIQ5toxLXXUW94DWhI6W3f2FENLesQf/8sMXY/udzV3VOHZenThe66
pRCW5DOzvreiriCwMyKuBvnMxru3xcVwr/zR8dqWfT/Szz+JelKNJFOZxJ1j
noPudJ9ski4g9pP0f/LwOB5Njucn/xGO/xnH78H5/cj5zeT8kvIZas5H9slF
K0GIDCrz9PAkEVS3qsrONmLgOr7IZG2IABZxHhAYCqAjn3NTjp2TdabfzkZc
4cNhQ8Cm1JoPaA11kDhNo1DtJheXe4mHYckr6r+OrkAU33veQx0RbFJH1Me7
1aD+/EjZPzYU49tE1diR81vQb1+2msqrhGmf4+U927LhaOW4NN6xGTdgd/Eo
rwILNuha6hilw45ZNG7CoyZiP0m/iuMZuPG/PLUc/0qOv4Xj38D5NR/kN47L
J31QPkPNeeXJLOXAOUIMX3wyPiNchEN6XdrXFjBw25fmYrNagADLncsmU80I
LLCMldVicLIgdKmnHR9WsQNTre/y8PvVh51216Xwnj9L49WLevCCI/3CTpUh
z1k0IP2PEFt6jEWPt1djAu+LGfW5CG2rvkdNDxdAeT4v+vLDCmxNC209pPoY
rfrrbq0+04SgppEix+JybJS1V1D3vIes6CV+nR18Yj9J/ydPHceTy/Gc4Pgt
OP51HP8Wgt8VXD7yg/IZas7G2yhvF3MhrNMuRi5JEKE0+GzbD1an39m+z2aX
AC2m8oYSdQHOa20MymB/t2haq9W3GD6K0pPWd4d/gKHfY0HQFynuquoJ8zbx
UPA+rSH9YjkKxyxb+aRfCJM7X15WqtVg1IPM9y3rXyB5l84Moy8C8OJ2hmvs
roTq4mVV/guz4HyWuRc2tRlBU3x8Hx6uwH/GlB7nf3mE8N2+OLq/idhP0r/D
8eQP4ink+As4/l84/s+cXwHn9xznl5TPUHMeq/fmwCdfITa5bvRzaxMhZsLH
LDN2/ugWyCs/rxYgVbHzZMUzdn6E/L15MjuvLGojby1ybAITm2v067JGfOsY
tz1+Eo01mZe05Dc3wFd1YO12tWpMiu2Ry3MXY/Zdt7A5XnUI8Ry/6+mmd9D9
w2SvakIrEhPiHojaqqGxyWNW/JvnWHx/UYbfBwEWG7+fKJlUjYMHu8q9BYXo
uH2WVlguIPaT9FdzPDsH8Zhz/BTH/5XjJ/kl5TPUnJ0KHM2OvxCiMweCvFAx
6jW86xay56nX+RETjhxqwWN7qdCnvgVBDX4pCuz5W5jy7/7poc2gy0PWN5xt
QqfbmfULprH3Va1pn7rW8bGDGq8kruHBw1I2vvOxFE+SDUarmTbgM10RitIq
PHyleOHrMjGOOj9X6R7Dw2dNwzu948rxzLvxwbVCIZ6p3u5Rd6pHyAYDmakl
pZDpUDZwZOcjqZ+k38PxeHE87hxPAcdPDeL35Pw+GuSXlM9Qc35UHaiXYy1C
lVOwrdVCCbYI5V0/mTOgU65qUTtboR/9+var1UKcHL6nwlmfgY3aqbmKrwVo
rwu56c7uDfRF+xnv2X1h50xrPxXfZixem/P9/sEmmGW2H6lXZ3C77x3+0GuC
Ns9SJjLrI3443C0L41PYPf6mTvIqPrYmrKWOZ/AQoPBxfOMtKXyfNhwOl+XD
SF5Cmz2sx3k9nX1WkBL7SfreBB4Sv5TzO2+Q3zQun8pB+Qw15z6n2PDIEhGe
6gUlWGhLMUcuxN2K3XeOO8otWRQtxFiBwijD8WJU3+CXZLLvy+mZR882urYi
Slbxt0QzIWpc3wz/MZ/Bs5vPNEy82HuWtCzc7k4Lfptqc2DTHAZtLgbLE+8K
MPUdb/6kSAHe98Zv0GZ9vV446qCXhQDDS+ev6C9uxqmu9N4oTTaHB+rFv48X
YO7hKxoWh5tROk1lxOUZ5H6SPonnFIH/p98xg/yS8hlqzm2HimxoXzGytv8z
p1CdQnbhI6t6Vufq6z3dgbkijP0nY6HSaCm7D1WeElgxmNBiZLZthggnujc3
TVKSwHxmjY4t+3wnu4bv2n6RnWMH54bLW7D35vN+lcvZvbV5XJzsJAshInpi
/txzToQogZmVHHsvmnjVsXr311Z0yZZv8DAVQa9qt88FQwYZ2TLr44StKPvT
9cI7FRE6JtN7NA3J/ST9SRzPxkE8JP4rnF/lQX5J+Qw150mtN4oHRkiw48DX
2e9WU7D/V6TN8s80VNc7r5jbL8YvrbtjYuwpqD1eozviB42UDsHn5DYxDKas
uZe6goLtqrXH9OUY6MVdTlZoFUP7pFPLgaUUYstemIeNZBBpbZdd0iBGokW1
4zgbCkqG5fysUQyWhBWqrqkTQ911b/eJxRQ0JlpSOYoMVNo7XF6z+9y1mLhv
ymz9aVVQtI8SuZ+kT+Ih8ZP8kvIZas60bWZu/hUJInTxbcIhCrmfdE97PqKR
X+kS2jtLCtnwWpmIVApZ7XH/ythHI3yERldgohTJSbf819dQeLt1gaq+DQ2p
l+nMX2UoqKx7nn/lM/vcd67oC55IIzn80sjfHSh4ep3J+Wccjc3GRfFV3RRK
u9Jyuw9QUD+e8tVEk8aTHJun3R/Zuars0JYfRyFAr6nzwGwa1tHisMYacj9J
n8RD4if5bRuUTw6Xz1Bz9vFs2LXfSIrr9533y6RRKJec8b3tz95D+iJ3KLL/
g15RkEg4ht3Pb4yOOtpH4Ztdys3j5jTEmasm+m+hMW9M5B4ZNpcv/eqORfIM
RPukdoev07j2Ut8/Rp+CufrV2dsusXPxbuL25zU0tn/OKHsgkaJk7JzG4u8M
skzks+P7aIQl+c/uy5XiaG+w5jSNNpw+V97vIsvg8Y0xXQfuk/tJ+iQeEj/J
LykfUp5+/n91Rl8QY9+JgdRePQqKL/OafNhzgVS3+ctjtFQohkO0ttrUZRQm
fI+QSR7BzqWm4QMyf7PnxKYo80AdCp9KHoUe0CfXB+uocDrnyncEJRhLMDtp
TYrsZgoXlI6JawU0drr2KM/ZK0HRMGlA414Kfu3T2suKyXWSjhodJHsnQgIP
o230lmAKMRJdp2cF5LrZylMpim5ivKtxcbcdS8FB4cTeBJDn8FD7lbpnRgiv
S/BDe49SUDSF5tBX0tgHQ38vSDr7e3U/aUSLoWJ60EB3JgXBX2s8xew+RaqL
R7l2BhSJwZzx0VhpQWHLwJi4WFVyfcHh9Rm1jhI0K3kd27WDAn+/fUltFU2s
k/iDnhlkl7lKoFYhd9THh8Lya2tzKsr+z343a/oTo7difI1h7i9YSCHC/eWJ
xPEMsT7UPEk8/wXHE1XD
         "]],
       AspectRatio->1,
       Frame->True,
       FrameTicks->True,
       Method->{},
       PlotRange->
        NCache[{{0, Pi}, {0, Pi}}, {{0, 3.141592653589793}, {
          0, 3.141592653589793}}],
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}], {967.5, -193.5}, 
      Scaled[{0.5, 0.5}], {360., 360.}]}, {InsetBox[
      GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx1l0+ITVEcx981btwFWclOb2dBiiV5ZzGylWYs2EghpSwsJqVsKI0sZGVp
ryQWZGJrMSubSf22UrqKpptwG9Lz/d1+n3PubH593znnd97n/f6dmV68fubS
tslkslBNJv8s/9KTN8f2v16fRW2uv71av7ax+gnrrev3i8t3X2x+x/7O9b5D
i0u/pz9xvnf9cvXxw+mBSYr+Kte2tefmyXcLruf+a9fbb9y7cPXsDtfz+xrX
5Cxbcy3euN66Fm/c37kWbzzfuxZv9Fe5Fm/0X7sWb7yvSWNxLHMONvIaeA28
Bl4Dr4HXwGvgNfAaeA28Bt48T8txHDhpxSst3rivcy3eeL53Ld7or3It3ui/
di3eeF+TxuqwnKeWccX1wcb4tohvi/i2iG+L+LaIb4v4tohvi/i2iG/eZ8p1
aFncyCVNK15p8cbzvWvxRj+Va/FG/7Vr8cb7mjTWR8t9xrK8ZNzIFfcPNuZz
h3zukM8d8rlDPnfI5w753CGf8zlR7qOW1R3zknEjlzSteKXFG/1VrsUb/deu
xRvvadLYHCzPCcv6CuuOecm4kSueH2ys3x7126N+e9Rvj/rtUb/5nC/PQcv6
JvsK6455ybiRS5pWvNLijf5r1+KN9zVp7B1TnvOWzQX2TfYV1h3zknEjV/Q3
2NivqhT7VZViv6pS7Ff5O638jrFs7nEusG+yr7DumJeMG7mkacUrLd54X5PG
3qHld5plc51zj3OBfZN9hXXHvGTcyBX9Dzb25zrF/py/s8vvUMveLZzrnHuc
C+yb7CusO+Yl40YuaVrxjv0fUX5nW/Yu47uFc51zj3OBfZN9hXXHvGTcyBXv
G+zS+ZXDz+9s/a+fzdnbKyv3v+xSvWzOtD7388PXpT9Mj96+9XGba+0/+PnP
qQdff/l+ae3nus5pXXr+e6y5jfNzbbb79OVzR47vTNLxdxzOaZ/OS49Z+uE5
fg/+rvF7PZ3JPjqxvLH32fjntPGeYR8/5/28p5zXw+e8V/v+AjctCtg=
        "], {{
          {GrayLevel[0.8], EdgeForm[None], 
           GraphicsGroupBox[PolygonBox[CompressedData["
1:eJxNmHfcj1UYh89LeyiUdhFKpVKJlCLxSgtv0SIyW0JDQ4lIpWjQREZDZqVQ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             "]]]}, {}, {}, {}}, {}},
        VertexColors->CompressedData["
1:eJzdWHk0lt+/DWmQFM0IDaREpELKVvka6qtRSoZoEEUoU0SJiiapzGMZylTG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         "]],
       AspectRatio->1,
       Frame->True,
       FrameTicks->True,
       Method->{},
       PlotRange->
        NCache[{{0, Pi}, {0, Pi}}, {{0, 3.141592653589793}, {
          0, 3.141592653589793}}],
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}], {193.5, -580.5}, Scaled[{0.5, 0.5}], {360., 360.}], 
     InsetBox[
      GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx1lz9oFEEUh29PF91CsRI7uc4mCFoq3hSxF0kstJGAiiBYWARBsFGQWImV
pb0gooXBoK1FKiEE4TUWFsoWimwhLkHh/L3lfTMbCI/f3syb/e79m5ut3b54
bTqZTKbVv/9J/peevztzfHN7HrW5/vF2+9buxld83rr+uLz68PWvn1jfuT62
tLzyZ/Yb+3vXbzaePZmdmKTor3Jte0funv+wz/XCf+16/51HV29eOuB6cV7j
mpxla67FGz9vXYs3ru9cizfu712LN/qrXIs3+q9dizee16SxOJY5Bxt5DbwG
XgOvgdfAa+A18Bp4DbwGXgNvnqflOA6ctOKVFm9c17kWb9zfuxZv9Fe5Fm/0
X7sWbzyvSWN1WM5Ty7ji54ON8W0R3xbxbRHfFvFtEd8W8W0R3xbxbRHfvM+U
69CyuJFLmla80uKN+3vX4o1+Ktfijf5r1+KN5zVprI+W+4xlecm4kSuuH2zM
5w753CGfO+Rzh3zukM8d8rlDPudzotxHLas75iXjRi5pWvFKizf6q1yLN/qv
XYs3ntOksTlYnhOW9RXWHfOScSNX3D/YWL896rdH/fao3x7126N+8zlfnoOW
9U32FdYd85JxI5c0rXilxRv9167FG89r0tg9pjznLZsL7JvsK6w75iXjRq7o
b7CxX1Up9qsqxX5Vpdiv8nta+R5j2dzjXGDfZF9h3TEvGTdySdOKV1q88bwm
jd1Dy/c0y+Y65x7nAvsm+wrrjnnJuJEr+h9s7M91iv05v2eX76GW3Vs41zn3
OBfYN9lXWHfMS8aNXNK04h37HVG+Z1t2L+O9hXOdc49zgX2TfYV1x7xk3MgV
zxvsypX1k68e7P3Pp535+xvrj78fUv7szD/NTt+/93nqWusX7/HF10trvbTW
L8775uultV56wb/lNs7LrfnhC9cvnzp7MEnH723Yp3XaLz1m6Yf7+B78HuN7
vZjLPj23unv05fhz2njOsI7PeT7PKefx8Jznat1f0PgE/g==
        "], {{
          {GrayLevel[0.8], EdgeForm[None], 
           GraphicsGroupBox[PolygonBox[CompressedData["
1:eJxNmHmY11MUh+9kX4tkyVbIlBJJWixJmpAUoUhipJCKJFtUSlGpLJEWRAmV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             "]]]}, {}, {}, {}}, {}},
        VertexColors->CompressedData["
1:eJx9mHlUTe37xhNNhlSkKIqUaB4kQ11FKiqEUKZIKEoDKSVkaEAqDfSGEDJm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         "]],
       AspectRatio->1,
       Frame->True,
       FrameTicks->True,
       Method->{},
       PlotRange->
        NCache[{{0, Pi}, {0, Pi}}, {{0, 3.141592653589793}, {
          0, 3.141592653589793}}],
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}], {580.5, -580.5}, Scaled[{0.5, 0.5}], {360., 360.}], 
     InsetBox[
      GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx1lz9oFEEUh2+TnLqFwUrs5DobEbRUvCliL5JYaCOCEUFQtAiCYKMgsRKx
sNPCJggiWigGbS1S2QTxtVrIIopsoS5BJPze8r6ZTfP43cy8ue/ev8nk/JVT
F2ZGo9FsNRr9t/xLT94e3f9mYxq1uf7xeuPy5uoXrDeuPyws3Xn56yf2t673
HVxY/Dv5jfOd61erj+5PDoxS9Fe5tq09N068n3W97X/seu763XOXTu90vX1f
7ZqcZWuuxRvXG9fijftb1+KN5zvX4o3+Ktfijf7HrsUb76vTUBzLnL2NvAZe
A6+B18Br4DXwGngNvAZeA6+BN8/Tchx7TlrxSos37mtdizee71yLN/qrXIs3
+h+7Fm+8r05DdVjOU8u44npvY3wbxLdBfBvEt0F8G8S3QXwbxLdBfBvEN+8z
5Tq0LG7kkqYVr7R44/nOtXijn8q1eKP/sWvxxvvqNNRHy33Gsrxk3MgV9/c2
5nOLfG6Rzy3yuUU+t8jnFvncIp/zOVHuo5bVHfOScSOXNK14pcUb/VWuxRv9
j12LN95Tp6E5WJ4TlvUV1h3zknEjVzzf21i/Heq3Q/12qN8O9duhfvM5X56D
lvVN9hXWHfOScSOXNK14pcUb/Y9dizfeV6ehd0x5zls2F9g32VdYd8xLxo1c
0V9vY7+qUuxXVYr9qkqxX+XvtPI7xrK5x7nAvsm+wrpjXjJu5JKmFa+0eON9
dRp6h5bfaZbNdc49zgX2TfYV1h3zknEjV/Tf29ifxyn25/ydXX6HWvZu4Vzn
3ONcYN9kX2HdMS8ZN3JJ04p36P+I8jvbsncZ3y2c65x7nAvsm+wrrDvmJeNG
rnhfbxfPrhx6cXtr+nFy5NbNTzPp3cWVe992V0la618/f782/3TO16W1T1r7
/zxcW358dYfvl9Z+rs+fXD5z+NguX5fe/j3Wp7Jxfq5PuS/+jv057dN56SFL
PzzH78HfNX6vZ1PZB8eXNvc+H/6cNt7T7+PnvJ/3lPO6/5z3at8/gp0DPw==

        "], {{
          {GrayLevel[0.8], EdgeForm[None], 
           GraphicsGroupBox[PolygonBox[CompressedData["
1:eJxVmHfcT2UYh89LWyqJFkUhRaWIhJTxGg2jlJTIChGyGoRKISsRRSEZlayS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             "]]]}, {}, {}, {}}, {}},
        VertexColors->CompressedData["
1:eJx1eHk0VW/cvaHM9S1SiiTJHMpQadjSKBpEKkWTJESklCKERDMVJVEpERUZ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         "]],
       AspectRatio->1,
       Frame->True,
       FrameTicks->True,
       Method->{},
       PlotRange->
        NCache[{{0, Pi}, {0, Pi}}, {{0, 3.141592653589793}, {
          0, 3.141592653589793}}],
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}], {967.5, -580.5}, 
      Scaled[{0.5, 0.5}], {360., 360.}]}, {InsetBox[
      GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx1lz9oFUEQh9+ph14jVmInr7NQBFvFt0XEViSx0EYEBUGwsBB7BQlYiJWl
vSCihWIgrUX6NNOKCCtEwiHqEUVefnPMt3tpht/d7uz7bv5t5rfuX719YDab
tc1s9t/yL736dP7kx61F1OZ658PWve31L3ifXX9eWXvybvcH1veuT5xZWf0z
/4X9g+v36y+fz0/NUvTXuLa9Y48ubR50vfTfuj704OnNu9cOu16e17kmZ92a
a/HG99m1eOP63rV44/7BtXijv8a1eKP/1rV443ldmopjnXO0kdfAa+A18Bp4
DbwGXgOvgdfAa+A18JZ5Wo/jyEkrXmnxxnW9a/HG/YNr8UZ/jWvxRv+ta/HG
87o0VYf1PLWCK74fbYxvRnwz4psR34z4ZsQ3I74Z8c2Ib0Z8yz5Tr0Mr4kYu
aVrxSos37h9cizf6aVyLN/pvXYs3ntelqT5a7zNW5CXjRq64frQxn3vkc498
7pHPPfK5Rz73yOce+VzOiXoftaLumJeMG7mkacUrLd7or3Et3ui/dS3eeE6X
puZgfU5Y0VdYd8xLxo1ccf9oY/0OqN8B9TugfgfU74D6Led8fQ5a0TfZV1h3
zEvGjVzStOKVFm/037oWbzyvS1P3mPqct2IusG+yr7DumJeMG7miv9HGftWk
2K+aFPtVk2K/Ku9p9XuMFXOPc4F9k32Fdce8ZNzIJU0rXmnxxvO6NHUPrd/T
rJjrnHucC+yb7CusO+Yl40au6H+0sT+3Kfbn8p5dv4dacW/hXOfc41xg32Rf
Yd0xLxk3cknTinfq/4j6PduKexnvLZzrnHucC+yb7CusO+Yl40aueF6HvrWz
Xz+7hV2u+7b//X8utF5a66Rptf/017+Xn33/7fultV9a+7h+9cbDs28f7/l6
6eX32nAb5+vG4uiVO9fPXTiSpON3HvdpnfZLT1n64T7+Dn73+LteL2RfXFzb
Pv5m+jltPGdcx+c8n+fU8358znO17h+2Cx+D
        "], {{
          {GrayLevel[0.8], EdgeForm[None], 
           GraphicsGroupBox[PolygonBox[CompressedData["
1:eJxNmHm4VlMUh/dNmYcylbkrKklRKpWEkjJLRCSuBkNzitAgGaIiN5KUFKKQ
ShFKpIEmDUSTRBQZMlbG9T7f+z3HH+vZZ+2111rvPufcs3/fLSzq0rxziZTS
nIKUdovxhzD8MmGHhJUK2z3sQOdZc5BjybCjwvYL2z/sYOfIOdS8PcKOCNsn
bN+wss7tGXZY2F5he4cd7si6csaJnRdWL6x+2JHWoN+J1mXuOHvDWyg7vMc6
wls+rLSxP8O2h/0Udrx58FaRg7oVnYO3skzwnuDIukrGiVWwDxxV5eLenBV2
SliNsJqug/dkmQqNF8pb371VNedYc041D966csBbyzl468gE72mOrKttnFj1
sGPsXc8a9DtJ3qPDzv4fb0Nz4D3TEd4zwqoZO11eajQyD96mcsDb2Dl4m8gE
77mOrDvHOLH7wnqF3RbWzBrw3hvW09il3l94L5IJ3osd4b3KfN6jS5wjp7l5
8LaUA97LnIP3cpngvcKRdS2ME7swrIG9r7QG/TpYl7lNsl4X1toceK91hPea
sAuMtZL3/LAvZb0+rL0c1C1yHt62MsHbzpF1NxhvYa36Pqsb5eLebAnrHNYn
bLOMXcI6ygRvJ8drfR4drPFVWBvzv5axq8+nnbzfyNotrIdM8N7qyLruriF2
S9jV9u5lDfrdJC/3ZquMfcPuNAfeuxzhvSPsZmO3y0uNb2XsFzZQDni/k7F/
2ACZ4L3HkXV3u6a7++a58U7d732hz6dhC8M+CNsm45CwB2WC9yFHeB9LuXea
932wczyL72UcGlYsB7wPOw/nMJngfdSRdY8YJ/Zs2HD7DLcG/cZbl7mn7A3n
yLBB8j7pCO8TYQ8Ye1xe9j3aPDjHyUHdMc7BO1YmeJ9xZN3TxomNsg8cz8lL
nzfDJoZN0kbJ+4JM8L7oCO9Lxkeb96Q5LzsH11RZuQeT5YBxinzE/gorGWfi
LzG+Yh7rJoSNsPc0a3CPZ4Q9b/wtWWF5Q1YYZzrC9bprib1mDfb9tnnwvisT
vLOcg+UduV8Nm+PIutnGJ/uceqfcO/eeNeCdFzZd3g+9v/AukAnehY7wrjB/
bsq90zPNWWQevB/JAe9i5+BdKhO8yxxZt8Q4sfmy0Hu5Nei30brMfWZveD8x
B97VjvB+7N6I/ez1qrA15sH7uRzUXescvOtlgneDI+vWGV/i/qf5rHaG/eq9
4bznXOaMRu+gGdATeZ2E/ijpOnw0B+cseqmUa4mhicqaj8ZBP6BD0EHljOV1
EvpjH+P4eznHuhL2ROfsZy9q/Zhy2q60PY+XO6+TCuWroF/GufLmMB4jX0Xz
6Y92qCJfJWN5nVRZvir65ZyrJFNV82E8SZ8eaIpqKdNGJ8tUQx/Gmvrs4VR9
anHG1bPW6fr0Q2PUTpk2qiNTXf0q5tV1b7WsW9G8WjJxzjfQ5/xvnDJt1FC+
s/ThO1sfvkb69OF8b+ZeG1qXPk2sm9dGTeRrql/XvKbyNbYu5zlnHGcl5+RN
+tRFY1yYMm10kXyX6MN3qT58zfWbWetKeVvpw4fGaJEybXS5fC31m5rXUr7L
rMvzON966B3O+auNc/4XpUwbtZavjf4mr+FEF10nZwP3l9dPra0LX1vr5rVR
W/na67f0nrWXj/7Xe19byAUfOgI90T/lzquHU6aN0BxfeQ0nOqqzrOiiLrLS
B53Qy2dzuz58aIzuKdNGPeTrqd/ePHw0VVc5i8zrJh/f+976d8ub10Zoji1e
w4qO6iMruqivrPThfL/Xfd9pXfoMsG5eGw2Qb6B+T/Pw0VT9ZEVncMaN99l0
tDZ10RiDUqaNHpRxsP42r/O6aIis9MnrGngf14dvmM8pr42GyVesP9C8Yhl5
nkN9HvdbD73DOT/COOf/mJRpo5HyjdKH8Sl9GEfr93Z/ef000rrwjbVuXhuN
lW+cfrH3bJx8Y6xbPuW+O9Xd83PeX+qiKSbYGy0xKWU66QVZJ+qTw5k2Te5J
xujxsvn0Rj9Msf8rxmBFe0yWdYr+086xjnNyY8qd4+PtM1XjnH/XnmiJN+VD
e7yeMs30hvthLq+zGKfL97b5U6w3R75ZxmBBe8xOmWZ6R77Zrpto/5kyzpUP
bYGmX20cLfGBLGiP+SnTTAvMWeF+Z7p2oXyLzKc/GmSZfIuNwYL2WJIyzbRU
viWum2HPee51ubWmO/e+PT+Tm7Vopo9Tppk+cS1zaCS0Ljr3Z/nWmE9/NNMG
+dYagwXNtC5lmmm9fOtcB9NG8/lG8+3muz3CZ8kz5Hv7Zcp+G3PNN43vJt9T
vqWdvO6sbXHuLq/7mPN1yn67cs03h2/jNyn7Xcp1N9dtTtlv183mYVud42+Z
784Qc79N2W9OrvtZ67uU/Z7kun/YP2G7Uk5z9bFmX9d8n7LfhFwPde3vKdNn
jGVct80abbyHsP+Rcjpyf0f+l8X/bXjv+Htb7vPlefI+7PB6lUy77MHcL675
O+w38wsKcn5e5/7ms/w35f53Rv9UkHtvdlgLfrRniYJc/RjSbgW59QeknMb7
Sc6S5q40/y9ZdspBz1IyfGG/P83f5f0tMI+Llcb/tRd/42NT7pv0t/v5wjUw
bbcOrL+7hn7s8z9aroxJ
             "]]]}, {}, {}, {}}, {}},
        VertexColors->CompressedData["
1:eJzlWGk0lt3fpWRqUI9oECqzkJAStSuSIZI8qNBEkSYVpVGlUCqkDE9JEZKI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         "]],
       AspectRatio->1,
       Frame->True,
       FrameTicks->True,
       Method->{},
       PlotRange->
        NCache[{{0, Pi}, {0, Pi}}, {{0, 3.141592653589793}, {
          0, 3.141592653589793}}],
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}], {193.5, -967.5}, Scaled[{0.5, 0.5}], {360., 360.}], 
     InsetBox[
      GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx1l79rFkEQhu+Mh14jVmInX2djY6v4bRF7EWNhJYKCIKRI5R8QkHRiZWkv
WGihGLC1SCtpprGwELZICIeIh4hc3jnm2b00w3u3O3vPN782q0fbdx+faZpm
o22a/5Z/6c3nG1c+HayjNtdHHw+eHe79wPvs+uvm1u77k2OsH1xfvrZ578/q
N/aPrj/svX65utqk6K91bX8vPr/9ZcP15L9zfXbnxcOn98+5ns7rXZOzbs21
eOP77Fq8cf3gWrxx/+havNFf61q80X/nWrzxvD4txbHOOdvIa+A18Bp4DbwG
XgOvgdfAa+A18Bp4yzytx3HmpBWvtHjjusG1eOP+0bV4o7/WtXij/861eON5
fVqqw3qeWsEV3882xjcjvhnxzYhvRnwz4psR34z4ZsQ3I75ln6nXoRVxI5c0
rXilxRv3j67FG/20rsUb/XeuxRvP69NSH633GSvyknEjV1w/25jPA/J5QD4P
yOcB+Twgnwfk84B8LudEvY9aUXfMS8aNXNK04pUWb/TXuhZv9N+5Fm88p09L
c7A+J6zoK6w75iXjRq64f7axfkfU74j6HVG/I+p3RP2Wc74+B63om+wrrDvm
JeNGLmla8UqLN/rvXIs3ntenpXtMfc5bMRfYN9lXWHfMS8aNXNHfbGO/alPs
V22K/apNsV+V97T6PcaKuce5wL7JvsK6Y14ybuSSphWvtHjjeX1auofW72lW
zHXOPc4F9k32FdYd85JxI1f0P9vYn7sU+3N5z67fQ624t3Cuc+5xLrBvsq+w
7piXjBu5pGnFu/R/RP2ebcW9jPcWznXOPc4F9k32FdYd85JxI1c8j/bnaT59
O+2TR64n/yeutX76ju++XlrrpafzfxXr5UfrpbVeevo99t3G+bm/vnDnyYPr
N88n6fg7zvu0Tvullyz9cB+/g79r/K63a9lXt7YOL71bfk4bz5nX8TnP5zn1
vJ6f81yt+wdFTBDa
        "], {{
          {GrayLevel[0.8], EdgeForm[None], 
           GraphicsGroupBox[PolygonBox[CompressedData["
1:eJxFmHfcllMYx89byAxFNqUhCfVWsttvshqUmZIWSqVltIxSURlZDUlIaclu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             "]]]}, {}, {}, {}}, {}},
        VertexColors->CompressedData["
1:eJx1mPlbTe/7xRMNKkkiUyUqlUQoElYoUoY0KbyJiqJIpjSIDA0qKWVKZCY0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         "]],
       AspectRatio->1,
       Frame->True,
       FrameTicks->True,
       Method->{},
       PlotRange->
        NCache[{{0, Pi}, {0, Pi}}, {{0, 3.141592653589793}, {
          0, 3.141592653589793}}],
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}], {580.5, -967.5}, Scaled[{0.5, 0.5}], {360., 360.}], 
     InsetBox[
      GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx1lz9oFUEQh+80F70mWImdvM7GRkvFt0XsRYyFlQgGBEHRShCsBEknYmGn
hY0IFlooBmwtUtkEcVoF4ZBIOEQ9ROT5m2O+3Usz/N6bnc2X+beZXbp29vKe
qqqW66r6Z/mTnrw9cfjN1jxqc73zeuvq9sZnfN+5fr+6dvfl7nf4964PHV09
93v2E+cH1682Ht2fHalSjFe7tj8Hbp1+t9f1In7jeunmvYtXzu9zvbivdU3O
sjXX4o3fd67FG/171+KN5wfX4o3xatfijfEb1+KN97VpKo9lztFGXgOvgdfA
a+A18Bp4DbwGXgOvgdfAm9dpOY8jJ614pcUb/XrX4o3nB9fijfFq1+KN8RvX
4o33tWmqD8t1ahlX/H60Mb8d8tshvx3y2yG/HfLbIb8d8tshvx3ym8+Zch9a
ljdySdOKV1q88fzgWrwxTu1avDF+41q88b42Tc3R8pyxrC6ZN3JF/9HGeu5R
zz3quUc996jnHvXco5571HO+J8pz1LK+Y10yb+SSphWvtHhjvNq1eGP8xrV4
4z1tmtqD5T1h2Vxh37EumTdyxfOjjf07oH8H9O+A/h3QvwP6N9/z5T1o2dzk
XGHfsS6ZN3JJ04pXWrwxfuNavPG+Nk29Y8p73rK9wLnJucK+Y10yb+SK8UYb
51Wd4ryqU5xXdYrzKn+nld8xlu097gXOTc4V9h3rknkjlzSteKXFG+9r09Q7
tPxOs2yvc+9xL3Bucq6w71iXzBu5YvzRxvncpDif83d2+R1q2buFe517j3uB
c5NzhX3HumTeyCVNK96p/yPK72zL3mV8t3Cvc+9xL3Bucq6w71iXzBu54n0t
5tbO/MPs+J3bH/f8j7freuH3df7l07cbK0+X3F9a/tKL+3641vlfD5+tP76+
7OeldV5a5+m/cmb9wrGT+91fWv7Si7/f5lw27tvNzC/+3cdz8tN56SnLODzH
34N5iL/X87nsg1Nr2wdfTH9OG+8Z/fg57+c95T4YP+e98vsLt9ocwA==
        "], {{
          {GrayLevel[0.8], EdgeForm[None], 
           GraphicsGroupBox[PolygonBox[CompressedData["
1:eJxVmHmYllMYh8+02ZfsuxaRkJAieylCURoS7ZFsKQyRJSktpFJoVSKlKEuq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             "]]]}, {}, {}, {}}, {}},
        VertexColors->CompressedData["
1:eJx1WHk0VWvcjlLRhAwNSEm3ohQikqeUElFRKI00q0glUpGkEuqSsYgGDTKF
0KBBUhkazOMZnHnvrQyhVPd71/rc9a11v3X+Ouv81jn7ffezn+ndU929HHfJ
DhkyZLjMkCFDySel+kZ84BobQ3sM341424Jj/nFjDNUoZOVr7r9hxYGJm13J
kVEsGNORuiYyNH5q9df3anCR5zP+fd8fNjxcnvwePpkBZ9Fnn/08Lh6lM5sP
gQsLT70/UVMYVK5qPDxQ0o5RwxpabqW14/aU+Cfp0xksN7DvOJLNw9+WpTNi
pvFhutXs7bjZDBZt+bSpP4kP/wljOo1TBIi4H8b4GzAYaXnhyY0gAUJzC922
jxYhLiE587YxAzv17JDR9kLE51KxNevFMOfuyLc3Y/BDf3jYn34h3nYMt5+4
T4IamXEGZosZ9NiMnVriL8LO93tYedoURmTr7Q03ZZCdmSLyfSNC5YPX05PN
KNy+EtqvosZg3pJRdUlsEQyrF/nKLKPgfFdthZ88uS/jm6FVFSLg3Z21uy0o
THfcaOqqzKBxnOuKEWEiqEVNPDN1BoW1xbEsq3kM9C9F7nh/vAWsEeqpm8/V
YHijvaPFSyHokIN57tvbIHd0j7Wwrh7htXHvU9TFeDoxI/uNHxudSy4OBNu3
wEYgqxzAl+CRz6KP0+W4yHqzZlJXPRtXrGv33iTryqonrlpj347fA8v39Am5
EKTd+atvKoN9ISdY1Wk8dB+ImaA1no9Dc3oS6mcxSLW172HJCHDaYNWnoiVC
TP8x8sfL+dLx3PjS+oWqrwh2Pru7TkyhkHxAT9eQzCUJquceu4hhHD0lpXA/
hSuF1FbNGhpB96+b7R0qQaNt7dCftygkFvvOMDxP+HNnen2ktwTuIT1Tt7+j
sNfamGvnTEPJqc04J0GCu4vvP1GvoxCX+3tV2zIazuVeq16clGDDcFGBdwUF
2fEzmdq1NHoa19zRn0yu86pGRphO4dChzxvCT9JQ9DDyeOvfgHW5rkqFM8uR
Wad1pqeTh+VOGR3jeU24xqxv9Cz7DI3qV5ZnbgtwocTCPkOnDUO8eH2uB+vx
aMVm7V5aBJXXjx94jeBgeYSG3s3FbWjyW31hWCaF0gI12dNiLpz2VO6MXclF
z6z9ydmE59sNE9c8TeZBQr9T1BjOR83SY5vuEZz9LDfJizYIoDTyaPHzMiEm
7y7fkW4knZ/S8NTJcj5vcUyCm07J57++p9DULuNotJ7Gt169RcEOFAwdHnI9
lGl02vc0tHRR4Ng3nbvZQCG39WnCkSU0wjnM8YE8ClPmX7TNHk0jpCDF4+M6
Gio51hfvJ1FY2H/JaZyIQrlJg2e8NQ32x2N7lcn97v+hXRNzgML48F+nPTVo
eGXaeHnwKXS9G7tO0bsWL/RGHbSKfwmz/WcnbfvIRUaq7C/FxQ2wue/oe23D
B9SsbK9fVcZD762X3H0yLWDMRCMvFVQjY9eofIWDhP9hs3jbVrDxwp3Vvzy5
GaoO9V53kiWYrXyo50ISF4rxFxMvVXIwVKFl/XdNBrWHe/Wi4nk4LPtQweQX
Dzfdl+4OITgXqjjxG2MEmPcwNCJgrgghtgFXtBdI17s0fkrD86zT1WpfWxon
BSGa+3bTqBjuf+vXGQpqwVcyb0lorD/jOr36Go3kIrkgc3MKI7vP3x7yF4P6
OoltTxaN2t+7Yg2Iboy3mdeG/qKxdHH+7A+pRCerd48yNaQwqfd1sMtBGq+/
9cYp+NAIdIyO3+xDIWJhXHTamWrkjqg4LnmVC6u1mld4Rzi4M3Ga9e6IOni8
mV8R5PcGH35VXBHFtWOge8JxnbQmuNtMf1bk9hkma7b+9cNPgEO39OJXxrFw
rXpqs293I66+j83R7hLj4UYZAxzk4nqRU8b3QA6S0j3PNWswCO6ZEXb3Kg8u
LivVqe885Cpzww4SnDGrOiOoWABluatuFV4iPPw7tmqMiXT/lKZ39iA/H/2H
n9LwTO9f2lUTz+AGK7dKXEtDTafz1Tya8CR7qdmJJgZKIw5SlRQNhQ0zZN9V
SSD5Vlxt85D49BX547tbaBwLOvvWv10Cz5RlT/9WZJA+08HA/x7ZR6LKXotZ
FHw5I4ROZV+wRdZOXmNnBp6ELPPq/MZGS1jG2CJJLVyo5sWVVq9x2yWeFa3b
Do2JET+X6TSBFeC4UN/vE3K2u0b80RAga9XzulJzFlYHP8lIdmyEIHi9SCNH
jIrfxVdGu3HxbLYkqtCdg4pP6esOE5zVlNqy50TzYPFs0Z9L3Tzcb3rJ7CQ4
0yX0pS+VBOeamfn7LohgIn/XZA/B2WAwj4z+k0fS/FOa3v/lZ90gP+sG+SkN
z/Bev6maWh2ISfjy002WQf6dsV0nsslz7bSdcq6DQUCX3LeTXTT236rZWlkq
QWdu0V+qDgxO6nac//WMRlXS7OiMMRTOTJVM8ratxsrm2E2SpY/wvsAhX82e
A4btc33+ljp0d5emtX0qQaqoynOEbzsi2OsOuQU2Icog5IrdhM9wuhSZUrBF
gA8Hooa1BbDQGxJkUFnSiHiF2gctbWJ09Itym/ZwsedIe4rdcQ7SdKjRzwjO
JpUhUaaEz753y+eZEj6vKfP+vZ/gvDKrr06hRIC72vtT1I+LkJzTv3omwbni
P/muO5jv0vJImn9K07s0fkrD82rRkWPiFwys5xaM6uLSGFeSX5zZJEF9tkCn
YhqDQOf3DhGZNEyqFFuUplLoe50ybe+wWsTE3xzydlkx2ta0h+Sf5cL4eOQJ
ZVY9jnOOK74Y+x7+1HJf83M8XDf2SyvPb4by0L9tFY2rcSHK7iLfVIid5pet
0vTYGGbn6r9haTN2atg/UvGXYEiGq6lcNBdJjuFP0p5xEHi5vq+A+POUONmm
gjgequuVltX/5CHx57QDgQRntSHjOnOTBehkLI7lWYgwLW+G2foF0vuStHyX
lkf/+uerQf8MGvRPaXqXxk9peOJ46QbuFRqnF2h95J2isaIpb723OwWjQTx9
BvH0G8QzTS1NX3ZLExZnOR+PavmENz+23Yy2Jj48yu3voQWt0ButeHhfdh0u
nhx6IS5FhN8X8qxGcthQPTjQoFrYioIdhvbyfhROfkj+taOJC6Mvqy6vMeBC
uy/e25X0DTaLG3MmiQf1hN9/dIbxsfZkhFEqwdnH465zijtZp0i5YE6LEEsW
Xk/6TvrGrCenYuTGi/DKpOi7JEoCFb0HKp9J32AWy39u9RejRn2ujYYvhecb
C3Z8ekP8oD605miKBJsCuudsJD49prPjXB3x6Zvms5+kBJF9HY85O0mHxsdf
veV7WyhMK3pepzOOhve55nspjjSavMx3XblOgb2N9aJhOY3McKXIiztpZJSu
5QeFkP54eNTIsVNoPNbfYPfVhYZc/qxZXjEUbGKefrp3g/SLLa13j8yhIfAx
bjpTRUnlpzQ8ZU+Un7tlzMbSia/k4rc3o/vdit0F5yRo2pGV9KuGg8Uh2nkm
IWzMytx+u7OK5EyZQedm83acdT6F0PdcDCn9cfUC6c9Vscv8be/w8DHXdmia
Ih9lxso3qwjOXQnrzKuVBBBx/AM3bRJiebfiOC1DBps9nR5nkV7jGJA1zvqi
GM5tHnNHmzO4ey7qtJjsS/FFoGLJHApX4b1LdgaD6YHKBaIIMSyHlq0uP0lB
896u4tqnNFoTz8xcaiWBvGKD5ddCkptjYx0VPGmo/ywtFuZJENTsyp3NIrj8
ZbQqw5Tw13dcgQZbggfhVgeiGQqK580G1k2nsXZ53oH8VxJoX9UVerVT2LL/
aPu3+TRiT0yYtdBNglglX3+rVxTol2Uzm7fR8JCid2n8lIanWU3P7KSnXAR8
GZPH+s1BxPSdrNtaDH49Z37rZrbDZmT17Mtn23G/MMBBn5wHH51JjsnM5GH9
jR8vnk3ho3vRKW85ch4sSv7asDGbj5xjQrfnzwVoaWo05JPz4DGHE5Mt0gRw
tKoNqLIREZ10zQkifjJ3TN2PISFCJH59lKWdIcbliYoHIwn+l6Jbb1y0FIG3
4rmwtkGCW2+VFD5aMkiwzHxq8FqEpXvC0psXEl/+krpokjqDi67VI83Hi2Gl
DlmuE+GrboyonPhxaFui55v5YnRyDyxS2kphdYXzSk0+jbeBGg0rNMQIO+yR
KHAm/htV//N5B43IB9FzaqtF2Ko6SavYkuTfwS5Pw3EM/nn4v/55/T/+KU3v
0vgpDU+7SI+PHQY82E4OM1Zbz0PQNeGTqSTvBaUJWxYU8aD3wets2jw+ircu
Y1kRnI1NynzVl5Hv/6x/Nm+sAPrjt13eM4dB2BIfjfS3fAyIJQPxHAFU1UIP
7yH+vOFIznKXxQKM7Dp12DpFiC+RfsM0iM9EfTEOn5kqwKPQ70fSlojwZlRe
hDt5Lvp+rQmajADfN5hZ5jwR4bGeVb0m6eEP5tlu26MpxF5jL72VI8WYHPYo
zXQheV7h4b8TDIRYVdJgHaIrBrXTpymVzPf97d5UPk2IGydYpp2KYqgoG01x
IXOX1i7n1D4B9l0z0YotF8E8bYWxG7m+1mAefflPHknzT2l6l8bPf/GcPYjn
s0E8q6zCs13e8PA4gD8vzIqPQp/3jWfJvHCPRmroRx6OWh7RCV7PR2/CV81S
Mldx+3PDsInMs37n3N3FR3A9b9dQPQYdcp8zv7TzMP7MnJdax/iwGzk7ahGZ
97rkWFIUDxoyP8u0g/ngd9/7vJ/MgydscFfp4uEqpVY1PJwP9eqW0kgyr4uZ
Puwf0nsyYwNerYviY7iOReodMl/if7DVr4+HD/PPN2Vf5UPRbYtlJplPff52
4FAvD5dX9N2Vi+Zj36GMuffIfGG3TV4Hub6hWk7Mrgg+tBYNvIgmc1Up+S4t
j6T5pzS9S+OnNDwz95Q0+rjx4KkXOUMmkYexpmuyp8xkMHlOgFEm3Y7w2nzh
CFE79MOjLRN0SZ/Fn4S3F9oRWuw/8uzKdly1UDVy1GHQZtcZUmzcjh6+w6TA
l1wkf3T8sIfo7sax/nsVPVxyzrewe7WRiwXUzWtdRKfqO/zYuhVcdIvmnvKe
wMXo2+e3yJG559utsjXPuOiZmKhT/Q8HZ/WPf08nfqjY7FRwrYyLrZWuC3WV
uJgcosuSkPnSMIukLooLlSGhHhfsuIg709dVPOX/96V1g31JWr5LyyNp/ilN
79L4KQ3PtatLqocrtCPQXOFUSwAX064HnjqkzWD0kWvyiYu5OGRev3SvEfE9
p2e+pZMZhOrlMXK7OXi3JN02MpQF84VW1/oNSc/N/eA/Lo+NVbq5CY8mtyIq
Njr7C/HpjgabDNqKjfuu81Kto5qhweH1l5PzT8ClPw2rJrCRGVD4QuZPE0I2
/2pu3SJB3vw4e1sTNqYqB5g5727GrISZ6fIXJKAH33+OGHz/6Tv4/pPfF/xM
bi0PKtVrHO6cJzxSXSPTSvzz0Zp8kzZ1PvbHTvz+/B0fy88ddvDUZ6T+fvXm
E95aCTy4Kz/Yp/6bh8+85vjzxE/2PkxPOsTjIdAo3XaiLx+36XnaIHiGdJqe
MJjLR56CZkwCzcfpl5oRjP7/rbtvcF3rwXWlXUfrz69crywe0kMz5Lu1+Ril
faFenujC5jP37cUAHha0Oy25UsnDz+zHvU0zpa8r7ffBJW4r4ira8UbzW6Vf
XjuWKuv3t5LcsR7gTQo5zULY/PmGe9814rp7x6IithjZB5+6VL5uw/3HJp1y
wQ0Q1TbXl28W49tCx84Kwktz7+rLBwIojFWv+/rwOekhm9G7baMY0U2vA1d4
Uihqokq3VtNAkKhO97AQfZ4WX2oixVhXVbdDm/B5qo1WZHuiEE/3Dynnfxbj
rW/FwPhFDF7ts3pwt4gDYZItP3s9Gy+nvb8aSs4B9q63bhhtZ6NH5aKMan8z
nmu8H979WoJ/ngQGmwrZeF1+4kJcZSt+7up58YT03eH3vdWm5Yhw9Ed/vZ4R
hYhlZfLFRKfR6TmMmTPRXRYVwf8jgZi1f9VGMDiy2dp3mICD4TG7V1ensvHp
IaeDI6BBF85VXzOdDZNXDc+q/mpGl6bIruQQ+V+G7vIiBTFSbjtpjl5Hwf+k
zcRrvTRS/HLEd/4IUajCq57rI0Hai645m4iut23qUdDQ4eDkFL3K1qQ2lO6s
PSGpIT1u7BLVuf0s3E0S3+q61oTpXPMecxMJ4pWeHR1IFkF9UsNaLdI/058m
FrFI/8wI/O7p7CNC2YJo+UVaFDJ5ijSL4NnFWtwltOTA2K5P6fyfNljuNir+
NUB0oXVPxeEFG9srPWorrFphlfhRkmJDIWyhgZNFtwhdrn7fTVaRc/EBDZ62
DOk577SmvVIleWDN++YQJ4GMtuUIDtl/yLsFouwANoImn2I/dGnBtMzkslix
BP8D8/qt8A==
         "]],
       AspectRatio->1,
       Frame->True,
       FrameTicks->True,
       Method->{},
       PlotRange->
        NCache[{{0, Pi}, {0, Pi}}, {{0, 3.141592653589793}, {
          0, 3.141592653589793}}],
       PlotRangeClipping->True,
       PlotRangePadding->{
         Scaled[0.02], 
         Scaled[0.02]}], {967.5, -967.5}, 
      Scaled[{0.5, 0.5}], {360., 360.}]}}, {{}, {{{}, {}, {}}, {{}, {}, {}}, \
{{}, {}, {}}, {{}, {}, {}}, {{}, {}, {}}, {{}, {}, {}}, {{}, {}, {}}, {{}, \
{}, {}}}}},
  PlotRange->{{0, 1161.}, {0, -1161.}},
  PlotRangePadding->{5, 5}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1147114103]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Histograms package", "UpgradePackageSection",
 CellID->1087906933],

Cell[TextData[{
 Cell[BoxData["Histogram"], "InlineFormula"],
 " from ",
 Cell[BoxData["Graphics`Graphics`"], "InlineFormula"],
 " is now found in the ",
 ButtonBox["Histograms Package",
  BaseStyle->"Link",
  ButtonData->"paclet:Histograms/guide/HistogramsPackage"],
 "."
}], "UpgradeDetail",
 CellID->1074807037],

Cell[TextData[{
 "Load ",
 Cell[BoxData["Histograms`"], "InlineFormula"],
 " to use ",
 Cell[BoxData[
  ButtonBox["Histogram",
   BaseStyle->"Link",
   ButtonData->"paclet:Histograms/ref/Histogram"]], "InlineFormula"],
 " functionality:"
}], "UpgradeDetail",
 CellID->1286011742],

Cell[BoxData[
 RowBox[{"Histogram", "[", 
  RowBox[{"{", 
   RowBox[{
   "0.9", ",", "0.0", ",", "0.2", ",", "0.8", ",", "0.6", ",", "0.9", ",", 
    "0.6", ",", "0.9", ",", "0.6", ",", "0.3"}], "}"}], "]"}]], "Input", \
"LegacyInput",
 CellID->1915518068],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Histograms`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Histogram", "[", 
  RowBox[{"{", 
   RowBox[{
   "0.9", ",", "0.0", ",", "0.2", ",", "0.8", ",", "0.6", ",", "0.9", ",", 
    "0.6", ",", "0.9", ",", "0.6", ",", "0.3"}], "}"}], "]"}]}], "Input",
 CellLabel->"In[12]:=",
 CellID->1184816699],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
    EdgeForm[GrayLevel[0]], RectangleBox[{0., 0}, {0.25, 2}]}, 
   {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
    EdgeForm[GrayLevel[0]], RectangleBox[{0.25, 0}, {0.5, 1}]}, 
   {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
    EdgeForm[GrayLevel[0]], RectangleBox[{0.5, 0}, {0.75, 3}]}, 
   {RGBColor[0.7771114671549554, 0.7981689173723965, 0.92304875257496], 
    EdgeForm[GrayLevel[0]], RectangleBox[{0.75, 0}, {1., 4}]}},
  AlignmentPoint->Center,
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->None,
  AxesOrigin->{0., 0},
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DefaultAxesStyle->"GraphicsAxes",
  DefaultBaseStyle->"Graphics",
  DefaultFrameStyle->"GraphicsFrame",
  DefaultLabelStyle->"GraphicsLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->{{0., 1.}, All},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  PlotRegion->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->{{{0., 
      FormBox["0", TraditionalForm]}, {0.2, 
      FormBox["0.2`", TraditionalForm]}, {0.4, 
      FormBox["0.4`", TraditionalForm]}, {0.6000000000000001, 
      FormBox["0.6000000000000001`", TraditionalForm]}, {0.8, 
      FormBox["0.8`", TraditionalForm]}, {1., 
      FormBox["1", TraditionalForm]}}, Automatic},
  TicksStyle->{}]], "Output",
 CellLabel->"Out[13]=",
 CellID->307728594]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Bar charts package", "UpgradePackageSection",
 CellID->1411404028],

Cell[TextData[{
 "Many functions from ",
 Cell[BoxData["Graphics`Graphics`"], "InlineFormula"],
 " are now found in the ",
 ButtonBox["Bar Charts Package",
  BaseStyle->"Link",
  ButtonData->"paclet:BarCharts/guide/BarChartsPackage"],
 "."
}], "UpgradeDetail",
 CellID->363133834],

Cell[TextData[{
 Cell[BoxData["BarChart"], "InlineFormula"],
 "\n",
 Cell[BoxData["PercentileBarChart"], "InlineFormula"],
 "\n",
 Cell[BoxData["StackedBarChart"], "InlineFormula"],
 "\n",
 Cell[BoxData["GeneralizedBarChart"], "InlineFormula"]
}], "UpgradePackageListing",
 CellID->41823264],

Cell[TextData[{
 "Load ",
 Cell[BoxData["BarCharts`"], "InlineFormula"],
 " to use ",
 Cell[BoxData[
  ButtonBox["BarChart",
   BaseStyle->"Link",
   ButtonData->"paclet:BarCharts/ref/BarChart"]], "InlineFormula"],
 " functionality:"
}], "UpgradeDetail",
 CellID->1909047094],

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{"Range", "[", "3", "]"}], "]"}]], "Input", "LegacyInput",
 CellID->1653650426],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "BarCharts`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"BarChart", "[", 
  RowBox[{"Range", "[", "3", "]"}], "]"}]}], "Input",
 CellLabel->"In[14]:=",
 CellID->169350308],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[{0.615, 0}, {1.385, 1}]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[{1.615, 0}, {2.385, 2}]}, 
   {Hue[0.67, 0.45, 0.65], EdgeForm[Opacity[0.5]], 
    RectangleBox[{2.615, 0}, {3.385, 3}]}},
  AlignmentPoint->Center,
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->None,
  AxesOrigin->{0.3999999999999999, 0},
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DefaultAxesStyle->"GraphicsAxes",
  DefaultBaseStyle->"Graphics",
  DefaultFrameStyle->"GraphicsFrame",
  DefaultLabelStyle->"GraphicsLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->{{{1, 
      FormBox["1", TraditionalForm], 0}, {2, 
      FormBox["2", TraditionalForm], 0}, {3, 
      FormBox["3", TraditionalForm], 0}}, Automatic},
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->{{0.3999999999999999, 3.6}, All},
  PlotRangeClipping->True,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->{{{1, 
      FormBox["1", TraditionalForm], 0}, {2, 
      FormBox["2", TraditionalForm], 0}, {3, 
      FormBox["3", TraditionalForm], 0}}, Automatic},
  TicksStyle->{}]], "Output",
 CellLabel->"Out[15]=",
 CellID->100302923]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Pie charts package", "UpgradePackageSection",
 CellID->696445479],

Cell[TextData[{
 Cell[BoxData["PieChart"], "InlineFormula"],
 " from ",
 Cell[BoxData["Graphics`Graphics`"], "InlineFormula"],
 " is now found in the ",
 ButtonBox["Pie Charts Package",
  BaseStyle->"Link",
  ButtonData->"paclet:PieCharts/guide/PieChartsPackage"],
 "."
}], "UpgradeDetail",
 CellID->1373289403],

Cell[BoxData[
 RowBox[{"PieChart", "[", 
  RowBox[{"Range", "[", "4", "]"}], "]"}]], "Input", "LegacyInput",
 CellID->2009365984],

Cell[TextData[{
 "Load ",
 Cell[BoxData["PieCharts`"], "InlineFormula"],
 " to use ",
 Cell[BoxData[
  ButtonBox["PieChart",
   BaseStyle->"Link",
   ButtonData->"paclet:PieCharts/ref/PieChart"]], "InlineFormula"],
 " functionality:"
}], "UpgradeDetail",
 CellID->1966636664],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "PieCharts`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"PieChart", "[", 
  RowBox[{"Range", "[", "4", "]"}], "]"}]}], "Input",
 CellLabel->"In[16]:=",
 CellID->86260366],

Cell[BoxData[
 GraphicsBox[{{
    {Hue[0.67, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {6.283185307179586, 6.911503837897546}]}, 
    {Hue[0.9060679774997897, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {6.911503837897546, 8.168140899333462}]}, 
    {Hue[0.1421359549995791, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {8.168140899333462, 10.053096491487338`}]}, 
    {Hue[0.37820393249936846`, 0.35, 0.75], EdgeForm[GrayLevel[0]], 
     DiskBox[{0, 0}, 1, {10.053096491487338`, 12.566370614359172`}]}}, {
    InsetBox["1", {0.5706339097770922, 0.1854101966249683}], 
    InsetBox["2", {0.18541019662496863`, 0.570633909777092}], 
    InsetBox["3", {-0.570633909777092, 0.18541019662496866`}], 
    InsetBox["4", {0.1854101966249682, -0.5706339097770923}]}},
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->False,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DefaultAxesStyle->"GraphicsAxes",
  DefaultBaseStyle->"Graphics",
  DefaultFrameStyle->"GraphicsFrame",
  DefaultLabelStyle->"GraphicsLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->All,
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 CellLabel->"Out[17]=",
 CellID->98513475]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PieEdgeStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:PieCharts/ref/PieEdgeStyle"]], "InlineFormula"],
 " is a new ",
 Cell[BoxData["PieChart"], "InlineFormula"],
 " option:"
}], "UpgradeDetail",
 CellID->1738265250],

Cell[BoxData[
 RowBox[{"PieChart", "[", 
  RowBox[{
   RowBox[{"Range", "[", "4", "]"}], ",", " ", 
   RowBox[{"PieLineStyle", "\[Rule]", 
    RowBox[{"Thickness", "[", "0.01", "]"}]}]}], "]"}]], "Input", \
"LegacyInput",
 CellLabel->"In[13]:=",
 CellID->615640572],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PieChart", "[", 
  RowBox[{
   RowBox[{"Range", "[", "4", "]"}], ",", " ", 
   RowBox[{"PieEdgeStyle", "\[Rule]", "Thick"}]}], "]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->656522962],

Cell[BoxData[
 GraphicsBox[{{
    {Hue[0.67, 0.35, 0.75], EdgeForm[Thickness[Large]], 
     DiskBox[{0, 0}, 1, {6.283185307179586, 6.911503837897546}]}, 
    {Hue[0.9060679774997897, 0.35, 0.75], EdgeForm[Thickness[Large]], 
     DiskBox[{0, 0}, 1, {6.911503837897546, 8.168140899333462}]}, 
    {Hue[0.1421359549995791, 0.35, 0.75], EdgeForm[Thickness[Large]], 
     DiskBox[{0, 0}, 1, {8.168140899333462, 10.053096491487338`}]}, 
    {Hue[0.37820393249936846`, 0.35, 0.75], EdgeForm[Thickness[Large]], 
     DiskBox[{0, 0}, 1, {10.053096491487338`, 12.566370614359172`}]}}, {
    InsetBox["1", {0.5706339097770922, 0.1854101966249683}], 
    InsetBox["2", {0.18541019662496863`, 0.570633909777092}], 
    InsetBox["3", {-0.570633909777092, 0.18541019662496866`}], 
    InsetBox["4", {0.1854101966249682, -0.5706339097770923}]}},
  AlignmentPoint->Center,
  AspectRatio->Automatic,
  Axes->False,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DefaultAxesStyle->"GraphicsAxes",
  DefaultBaseStyle->"Graphics",
  DefaultFrameStyle->"GraphicsFrame",
  DefaultLabelStyle->"GraphicsLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->Automatic,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  Method->Automatic,
  PlotLabel->None,
  PlotRange->All,
  PlotRangeClipping->False,
  PlotRangePadding->Automatic,
  PlotRegion->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 CellLabel->"Out[18]=",
 CellID->56299793]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Error bar plots package", "UpgradePackageSection",
 CellID->1183412197],

Cell[TextData[{
 Cell[BoxData["ErrorListPlot"], "InlineFormula"],
 " from ",
 Cell[BoxData["Graphics`Graphics`"], "InlineFormula"],
 " is now found in the ",
 ButtonBox["ErrorBar Plotting Package",
  BaseStyle->"Link",
  ButtonData->"paclet:ErrorBarPlots/guide/ErrorBarPlottingPackage"],
 "."
}], "UpgradeDetail",
 CellID->1762740112],

Cell[BoxData[
 RowBox[{"ErrorListPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "0.2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "0.3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1.5", ",", "0.1"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"0.8", ",", " ", "0.25"}], "}"}]}], "}"}], "]"}]], "Input", \
"LegacyInput",
 CellID->1606446575],

Cell[TextData[{
 "Load ",
 Cell[BoxData["ErrorBarPlots`"], "InlineFormula"],
 " to use ",
 Cell[BoxData[
  ButtonBox["ErrorListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ErrorBarPlots/ref/ErrorListPlot"]], "InlineFormula"],
 " functionality:"
}], "UpgradeDetail",
 CellID->1341600871],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "ErrorBarPlots`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ErrorListPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "0.2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "0.3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1.5", ",", "0.1"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"0.8", ",", " ", "0.25"}], "}"}]}], "}"}], "]"}]}], "Input",
 CellLabel->"In[54]:=",
 CellID->1383175941],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{1., 1.}, {2., 2.}, {3., 1.5}, {4., 
     0.8}}], {{LineBox[{{1., 1.2}, {1., 0.8}}], 
      LineBox[{Offset[{1.5, 0}, {1., 1.2}], Offset[{-1.5, 0}, {1., 1.2}]}], 
      LineBox[{Offset[{1.5, 0}, {1., 0.8}], Offset[{-1.5, 0}, {1., 0.8}]}]}, {
      LineBox[{{2., 2.3}, {2., 1.7}}], 
      LineBox[{Offset[{1.5, 0}, {2., 2.3}], Offset[{-1.5, 0}, {2., 2.3}]}], 
      LineBox[{Offset[{1.5, 0}, {2., 1.7}], Offset[{-1.5, 0}, {2., 1.7}]}]}, {
      LineBox[{{3., 1.6}, {3., 1.4}}], 
      LineBox[{Offset[{1.5, 0}, {3., 1.6}], Offset[{-1.5, 0}, {3., 1.6}]}], 
      LineBox[{Offset[{1.5, 0}, {3., 1.4}], Offset[{-1.5, 0}, {3., 1.4}]}]}, {
      LineBox[{{4., 1.05}, {4., 0.55}}], 
      LineBox[{Offset[{1.5, 0}, {4., 1.05}], Offset[{-1.5, 0}, {4., 1.05}]}], 
      LineBox[{Offset[{1.5, 0}, {4., 0.55}], 
        Offset[{-1.5, 0}, {4., 0.55}]}]}}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  ImageMargins->{{0., 0.}, {0., 0.}},
  ImageSize->Automatic,
  PlotRange->{{1., 4.}, {0.8, 2.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellLabel->"Out[55]=",
 CellID->1215552277]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 55, 25.0796744}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/Graphics"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 68, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[880, 35, 2244, 72, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[CellGroupData[{
Cell[3149, 111, 70, 1, 70, "UpgradeDetailLabel",
 CellID->305554978],
Cell[3222, 114, 535, 20, 70, "UpgradeDetail",
 CellID->1457835045],
Cell[3760, 136, 309, 9, 70, "Input",
 CellID->588129106],
Cell[CellGroupData[{
Cell[4094, 149, 233, 7, 70, "Input",
 CellID->1966141048],
Cell[4330, 158, 12881, 251, 70, "Output",
 CellID->1601717347]
}, Open  ]],
Cell[17226, 412, 126, 3, 70, "ExampleDelimiter",
 CellID->1062413713],
Cell[17355, 417, 680, 23, 70, "UpgradeDetail",
 CellID->1287020621],
Cell[18038, 442, 225, 7, 70, "Input",
 CellID->1500284563],
Cell[CellGroupData[{
Cell[18288, 453, 208, 6, 70, "Input",
 CellID->1677150914],
Cell[18499, 461, 16442, 423, 70, "Output",
 CellID->1309642099]
}, Open  ]],
Cell[34956, 887, 126, 3, 70, "ExampleDelimiter",
 CellID->1808233233],
Cell[35085, 892, 273, 10, 70, "UpgradeDetail",
 CellID->2065092323],
Cell[35361, 904, 252, 8, 70, "Input",
 CellID->375969847],
Cell[CellGroupData[{
Cell[35638, 916, 236, 7, 70, "Input",
 CellID->1028329055],
Cell[35877, 925, 34940, 579, 70, "Output",
 CellID->811861232]
}, Open  ]],
Cell[70832, 1507, 126, 3, 70, "ExampleDelimiter",
 CellID->1934858334],
Cell[70961, 1512, 277, 9, 70, "UpgradeDetail",
 CellID->1988116833],
Cell[71241, 1523, 206, 6, 70, "Input",
 CellID->1581548558],
Cell[CellGroupData[{
Cell[71472, 1533, 189, 5, 70, "Input",
 CellID->1681515387],
Cell[71664, 1540, 2774, 55, 70, "Output",
 CellID->1577713705]
}, Open  ]],
Cell[74453, 1598, 126, 3, 70, "ExampleDelimiter",
 CellID->1853347272],
Cell[74582, 1603, 309, 9, 70, "UpgradeDetail",
 CellID->139473056],
Cell[74894, 1614, 453, 14, 70, "Input",
 CellID->671458247],
Cell[CellGroupData[{
Cell[75372, 1632, 427, 14, 70, "Input",
 CellID->172192344],
Cell[75802, 1648, 4638, 84, 70, "Output",
 CellID->1376253099]
}, Open  ]],
Cell[80455, 1735, 126, 3, 70, "ExampleDelimiter",
 CellID->1761046328],
Cell[80584, 1740, 331, 9, 70, "UpgradeDetail",
 CellID->1839217050],
Cell[80918, 1751, 726, 21, 70, "Input",
 CellID->1218993315],
Cell[CellGroupData[{
Cell[81669, 1776, 702, 21, 70, "Input",
 CellID->626652825],
Cell[82374, 1799, 93469, 1625, 70, "Output",
 CellID->1147114103]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[175904, 3431, 72, 1, 70, "UpgradePackageSection",
 CellID->1087906933],
Cell[175979, 3434, 314, 10, 70, "UpgradeDetail",
 CellID->1074807037],
Cell[176296, 3446, 279, 10, 70, "UpgradeDetail",
 CellID->1286011742],
Cell[176578, 3458, 256, 7, 70, "Input",
 CellID->1915518068],
Cell[CellGroupData[{
Cell[176859, 3469, 339, 9, 70, "Input",
 CellID->1184816699],
Cell[177201, 3480, 1941, 58, 70, "Output",
 CellID->307728594]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[179191, 3544, 72, 1, 70, "UpgradePackageSection",
 CellID->1411404028],
Cell[179266, 3547, 280, 9, 70, "UpgradeDetail",
 CellID->363133834],
Cell[179549, 3558, 291, 9, 70, "UpgradePackageListing",
 CellID->41823264],
Cell[179843, 3569, 275, 10, 70, "UpgradeDetail",
 CellID->1909047094],
Cell[180121, 3581, 129, 3, 70, "Input",
 CellID->1653650426],
Cell[CellGroupData[{
Cell[180275, 3588, 212, 6, 70, "Input",
 CellID->169350308],
Cell[180490, 3596, 1653, 54, 70, "Output",
 CellID->100302923]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[182192, 3656, 71, 1, 70, "UpgradePackageSection",
 CellID->696445479],
Cell[182266, 3659, 311, 10, 70, "UpgradeDetail",
 CellID->1373289403],
Cell[182580, 3671, 129, 3, 70, "Input",
 CellID->2009365984],
Cell[182712, 3676, 275, 10, 70, "UpgradeDetail",
 CellID->1966636664],
Cell[CellGroupData[{
Cell[183012, 3690, 211, 6, 70, "Input",
 CellID->86260366],
Cell[183226, 3698, 1790, 54, 70, "Output",
 CellID->98513475]
}, Open  ]],
Cell[185031, 3755, 266, 9, 70, "UpgradeDetail",
 CellID->1738265250],
Cell[185300, 3766, 265, 8, 70, "Input",
 CellID->615640572],
Cell[CellGroupData[{
Cell[185590, 3778, 211, 6, 70, "Input",
 CellID->656522962],
Cell[185804, 3786, 1806, 54, 70, "Output",
 CellID->56299793]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[187659, 3846, 77, 1, 70, "UpgradePackageSection",
 CellID->1183412197],
Cell[187739, 3849, 334, 10, 70, "UpgradeDetail",
 CellID->1762740112],
Cell[188076, 3861, 398, 13, 70, "Input",
 CellID->1606446575],
Cell[188477, 3876, 293, 10, 70, "UpgradeDetail",
 CellID->1341600871],
Cell[CellGroupData[{
Cell[188795, 3890, 484, 15, 70, "Input",
 CellID->1383175941],
Cell[189282, 3907, 1239, 27, 70, "Output",
 CellID->1215552277]
}, Open  ]]
}, Open  ]],
Cell[190548, 3938, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

