(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22966,        761]
NotebookOptionsPosition[     19439,        645]
NotebookOutlinePosition[     20411,        673]
CellTagsIndexPosition[     20368,        670]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["Graphics`MultipleListPlot`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 Cell[BoxData["MultipleListPlot"], "InlineFormula"],
 " is replaced by ",
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ListLinePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLinePlot"]], "InlineFormula"],
 " accepting multiple sets of data.\n",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dashing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dashing"], "[", 
   RowBox[{"{", 
    RowBox[{"Dot", ",", " ", "Dash", ",", " ", "LongDash"}], "}"}], "]"}]], 
  "InlineFormula"],
 " is replaced with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dashing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dashing"], "[", 
   RowBox[{"{", 
    RowBox[{
     ButtonBox["Tiny",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Tiny"], ",", " ", 
     ButtonBox["Small",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Small"], ",", " ", 
     ButtonBox["Medium",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Medium"], ",", " ", 
     ButtonBox["Large",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Large"]}], "}"}], "]"}]], "InlineFormula"],
 ".\nA new ",
 ButtonBox["ErrorBar Plotting Package",
  BaseStyle->"Link",
  ButtonData->"paclet:ErrorBarPlots/guide/ErrorBarPlottingPackage"],
 " has been created. "
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 " now works with multiple sets of data:"
}], "UpgradeDetail",
 CellID->1457835045],

Cell[BoxData[
 RowBox[{"MultipleListPlot", "[", 
  RowBox[{
   RowBox[{"Range", "[", "5", "]"}], ",", 
   RowBox[{
    RowBox[{"Range", "[", "5", "]"}], "^", "2"}]}], "]"}]], "Input", \
"LegacyInput",
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Range", "[", "5", "]"}], ",", 
    RowBox[{
     RowBox[{"Range", "[", "5", "]"}], "^", "2"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1746043248],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 1.}, {2., 2.}, {3., 3.}, {4., 4.}, {5., 5.}, {1., 
   1.}, {2., 4.}, {3., 9.}, {4., 16.}, {5., 25.}, {1., 1.}, {2., 2.}, {3., 
   3.}, {4., 4.}, {5., 5.}, {1., 1.}, {2., 4.}, {3., 9.}, {4., 16.}, {5., 
   25.}}, {{}, 
    {Hue[0.67, 0.6, 0.6], PointBox[{11, 12, 13, 14, 15}]}, 
    {Hue[0.90606797749979, 0.6, 0.6], PointBox[{16, 17, 18, 19, 20}]}, {}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  Axes->True,
  PlotRange->{{1., 5.}, {0., 25.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellLabel->"Out[5]=",
 CellID->582572104]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1360688204],

Cell[TextData[{
 "The new ",
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 " option ",
 Cell[BoxData[
  ButtonBox["Joined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Joined"]], "InlineFormula"],
 " replaces the ",
 Cell[BoxData[
  ButtonBox["PlotJoined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotJoined"]], "InlineFormula"],
 " option to ",
 Cell[BoxData["MultipleListPlot"], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->533287725],

Cell[BoxData[
 RowBox[{"MultipleListPlot", "[", 
  RowBox[{
   RowBox[{"Range", "[", "5", "]"}], ",", " ", 
   RowBox[{
    RowBox[{"Range", "[", "5", "]"}], "^", "2"}], ",", " ", 
   RowBox[{"PlotJoined", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"True", ",", " ", "False"}], "}"}]}]}], "]"}]], "Input", \
"LegacyInput",
 CellLabel->"In[1]:=",
 CellID->1517535144],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Range", "[", "5", "]"}], ",", " ", 
     RowBox[{
      RowBox[{"Range", "[", "5", "]"}], "^", "2"}]}], "}"}], ",", " ", 
   RowBox[{"Joined", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"True", ",", " ", "False"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1697373436],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 1.}, {2., 2.}, {3., 3.}, {4., 4.}, {5., 5.}, {1., 
   1.}, {2., 4.}, {3., 9.}, {4., 16.}, {5., 25.}, {1., 1.}, {2., 4.}, {3., 
   9.}, {4., 16.}, {5., 25.}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[{1, 2, 3, 4, 5}]}}, {{}, {}, 
     {Hue[0.90606797749979, 0.6, 0.6], PointBox[{11, 12, 13, 14, 15}]}, {}}}],
  
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  Axes->True,
  PlotRange->{{1., 5.}, {0., 25.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellLabel->"Out[2]=",
 CellID->911405255]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2134750381],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"SymbolShape", " ", "->", " ", "Stem"}]], "InlineFormula"],
 " is replaced by the ",
 Cell[BoxData[
  ButtonBox["Filling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Filling"]], "InlineFormula"],
 " option to ",
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 "."
}], "UpgradeDetail",
 CellID->740363038],

Cell[BoxData[
 RowBox[{"MultipleListPlot", "[", 
  RowBox[{
   RowBox[{"Range", "[", "5", "]"}], ",", " ", 
   RowBox[{"SymbolShape", "\[Rule]", "Stem"}]}], "]"}]], "Input", \
"LegacyInput",
 CellLabel->"In[1]:=",
 CellID->761328948],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Range", "[", "5", "]"}], ",", " ", 
   RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->948060210],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 1.}, {2., 2.}, {3., 3.}, {4., 4.}, {5., 5.}, {2., 
   1.}, {3., 1.}, {4., 1.}, {5., 1.}, {1., 1.}, {2., 2.}, {3., 3.}, {4., 
   4.}, {5., 5.}}, {{{}, {}, {}, {}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.2], LineBox[{6, 2}], LineBox[{7, 3}], 
      LineBox[{8, 4}], LineBox[{9, 5}]}}, {{}, 
     {Hue[0.67, 0.6, 0.6], PointBox[{10, 11, 12, 13, 14}]}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  Axes->True,
  PlotRange->{{1., 5.}, {1., 5.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellLabel->"Out[2]=",
 CellID->107257569]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->939182350],

Cell[TextData[{
 "Other uses of ",
 Cell[BoxData["SymbolShape"], "InlineFormula"],
 " are replaced by the ",
 Cell[BoxData[
  ButtonBox["PlotMarkers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotMarkers"]], "InlineFormula"],
 " option to ",
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->832951000],

Cell[BoxData[
 RowBox[{"MultipleListPlot", "[", 
  RowBox[{
   RowBox[{"Range", "[", "5", "]"}], ",", " ", 
   RowBox[{"SymbolShape", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PlotSymbol", "[", "Triangle", "]"}], ",", " ", 
      RowBox[{"PlotSymbol", "[", "Box", "]"}]}], "}"}]}]}], "]"}]], "Input", \
"LegacyInput",
 CellLabel->"In[1]:=",
 CellID->2109045854],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Range", "[", "5", "]"}], ",", 
     RowBox[{
      RowBox[{"Range", "[", "5", "]"}], "+", "2"}]}], "}"}], ",", " ", 
   RowBox[{"PlotMarkers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      GraphicsBox[
       PolygonBox[{{0.31361111111111, 0.569141111111111}, {0.0202777777777772,
         0.0358077777777774}, {0.611388888888888, 0.0358077777777774}}],
       ImageSize->{19., 16.},
       PlotRange->{{0, 1}, {0, 0.61803}},
       PlotRegion->{{0., 1.57342657342657}, {0., 1.}}], ",", " ", 
      GraphicsBox[RectangleBox[{0, 0}],
       ImageSize->{11., Automatic}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->368590796],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0.67, 0.6, 0.6], InsetBox[
     GraphicsBox[
      PolygonBox[{{0.31361111111111, 0.569141111111111}, {0.0202777777777772, 
       0.0358077777777774}, {0.611388888888888, 0.0358077777777774}}],
      ImageSize->{19., 16.},
      PlotRange->{{0, 1}, {0, 0.61803}},
      PlotRegion->{{0., 1.57342657342657}, {0., 1.}}], {1, 1}], InsetBox[
     GraphicsBox[
      PolygonBox[{{0.31361111111111, 0.569141111111111}, {0.0202777777777772, 
       0.0358077777777774}, {0.611388888888888, 0.0358077777777774}}],
      ImageSize->{19., 16.},
      PlotRange->{{0, 1}, {0, 0.61803}},
      PlotRegion->{{0., 1.57342657342657}, {0., 1.}}], {2, 2}], InsetBox[
     GraphicsBox[
      PolygonBox[{{0.31361111111111, 0.569141111111111}, {0.0202777777777772, 
       0.0358077777777774}, {0.611388888888888, 0.0358077777777774}}],
      ImageSize->{19., 16.},
      PlotRange->{{0, 1}, {0, 0.61803}},
      PlotRegion->{{0., 1.57342657342657}, {0., 1.}}], {3, 3}], InsetBox[
     GraphicsBox[
      PolygonBox[{{0.31361111111111, 0.569141111111111}, {0.0202777777777772, 
       0.0358077777777774}, {0.611388888888888, 0.0358077777777774}}],
      ImageSize->{19., 16.},
      PlotRange->{{0, 1}, {0, 0.61803}},
      PlotRegion->{{0., 1.57342657342657}, {0., 1.}}], {4, 4}], InsetBox[
     GraphicsBox[
      PolygonBox[{{0.31361111111111, 0.569141111111111}, {0.0202777777777772, 
       0.0358077777777774}, {0.611388888888888, 0.0358077777777774}}],
      ImageSize->{19., 16.},
      PlotRange->{{0, 1}, {0, 0.61803}},
      PlotRegion->{{0., 1.57342657342657}, {0., 1.}}], {5, 5}]}, 
   {Hue[0.90606797749979, 0.6, 0.6], InsetBox[
     GraphicsBox[RectangleBox[{0, 0}],
      ImageSize->{11., Automatic}], {1, 3}], InsetBox[
     GraphicsBox[RectangleBox[{0, 0}],
      ImageSize->{11., Automatic}], {2, 4}], InsetBox[
     GraphicsBox[RectangleBox[{0, 0}],
      ImageSize->{11., Automatic}], {3, 5}], InsetBox[
     GraphicsBox[RectangleBox[{0, 0}],
      ImageSize->{11., Automatic}], {4, 6}], InsetBox[
     GraphicsBox[RectangleBox[{0, 0}],
      ImageSize->{11., Automatic}], {5, 7}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  Axes->True,
  PlotRange->{{1., 5.}, {1., 7.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellLabel->"Out[2]=",
 CellID->453482369]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1528880497],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Tiny",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tiny"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Small",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Small"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Medium",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Medium"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Large",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Large"]], "InlineFormula"],
 " can be used to specify ",
 Cell[BoxData[
  ButtonBox["Dashing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dashing"]], "InlineFormula"],
 " lengths:"
}], "UpgradeDetail",
 CellID->1155371860],

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Dashing", "[", 
     RowBox[{"{", 
      RowBox[{
      "Dot", ",", " ", "Dash", ",", " ", "LongDash", ",", " ", "Dash"}], 
      "}"}], "]"}], ",", " ", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input", "LegacyInput",
 CellLabel->"In[1]:=",
 CellID->787714846],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Dashing", "[", 
     RowBox[{"{", 
      RowBox[{
      "Tiny", ",", " ", "Medium", ",", " ", "Large", ",", " ", "Medium"}], 
      "}"}], "]"}], ",", " ", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2034216614],

Cell[BoxData[
 GraphicsBox[
  {Dashing[{Tiny, Medium, Large, Medium}], 
   LineBox[{{0, 0}, {1, 1}}]}]], "Output",
 CellLabel->"Out[2]=",
 CellID->20703848]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1252676724],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ErrorBar",
   BaseStyle->"Link",
   ButtonData->"paclet:ErrorBarPlots/ref/ErrorBar"]], "InlineFormula"],
 " and related styling options are now found in the ",
 ButtonBox["ErrorBar Plotting Package",
  BaseStyle->"Link",
  ButtonData->"paclet:ErrorBarPlots/guide/ErrorBarPlottingPackage"],
 " package:"
}], "UpgradeDetail",
 CellID->798804466],

Cell[BoxData[
 RowBox[{"<<", "ErrorBarPlots`"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->881689808],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ErrorListPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", 
      RowBox[{"ErrorBar", "[", "0.3", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}], ",", 
      RowBox[{"ErrorBar", "[", "0.3", "]"}]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", "6"}], "}"}], ",", " ", 
      RowBox[{"ErrorBar", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.1"}], ",", "0.5"}], "}"}], "]"}]}], "}"}], ",", " ", 
    
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"6", ",", "2"}], "}"}], ",", " ", 
      RowBox[{"ErrorBar", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.2"}], ",", "0.1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.5"}], ",", "0.8"}], "}"}]}], "]"}]}], "}"}]}], 
   "}"}], " ", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->923438756],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 2.}, {2., 3.}, {3., 6.}, {6., 2.}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{1, 2, 3, 
      4}], {{LineBox[{{1., 2.3}, {1., 2.3}}], 
       LineBox[{Offset[{1.5, 0}, {1., 2.3}], Offset[{-1.5, 0}, {1., 2.3}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1., 2.3}], Offset[{-1.5, 0}, {1., 2.3}]}]}, {
       LineBox[{{2., 3.3}, {2., 3.3}}], 
       LineBox[{Offset[{1.5, 0}, {2., 3.3}], Offset[{-1.5, 0}, {2., 3.3}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2., 3.3}], Offset[{-1.5, 0}, {2., 3.3}]}]}, {
       LineBox[{{3., 6.5}, {3., 5.9}}], 
       LineBox[{Offset[{1.5, 0}, {3., 6.5}], Offset[{-1.5, 0}, {3., 6.5}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3., 5.9}], Offset[{-1.5, 0}, {3., 5.9}]}]}, {
       LineBox[{{6.1, 2.}, {5.8, 2.}}], 
       LineBox[{Offset[{0, 1.5}, {6.1, 2.}], Offset[{0, -1.5}, {6.1, 2.}]}], 
       LineBox[{Offset[{0, 1.5}, {5.8, 2.}], Offset[{0, -1.5}, {5.8, 2.}]}], 
       LineBox[{{6., 2.8}, {6., 1.5}}], 
       LineBox[{Offset[{1.5, 0}, {6., 2.8}], Offset[{-1.5, 0}, {6., 2.8}]}], 
       LineBox[{
        Offset[{1.5, 0}, {6., 1.5}], Offset[{-1.5, 0}, {6., 1.5}]}]}}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  Axes->True,
  PlotRange->{{1., 6.}, {2., 6.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellLabel->"Out[2]=",
 CellID->149540689]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1955508727],

Cell[TextData[{
 Cell[BoxData["RegularPolygon"], "InlineFormula"],
 " can be replaced by the following simple definition:"
}], "UpgradeDetail",
 CellID->1938665483],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"RegularPolygon", "[", 
    RowBox[{"n_", ",", " ", 
     RowBox[{"rad_:", "1"}], ",", " ", 
     RowBox[{"ctr_:", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"tilt_:", "0"}], ",", " ", 
     RowBox[{"k_:", "1"}]}], "]"}], ":=", 
   RowBox[{"Line", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"ctr", "+", 
        RowBox[{"rad", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Cos", "[", 
            RowBox[{"t", "+", "tilt"}], "]"}], ",", 
           RowBox[{"Sin", "[", 
            RowBox[{"t", "+", "tilt"}], "]"}]}], "}"}]}]}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"t", ",", " ", "0", ",", " ", 
         RowBox[{"2", "Pi"}], ",", " ", 
         RowBox[{"2", 
          RowBox[{"Pi", "/", "n"}]}]}], "}"}]}], "]"}], 
     "\[LeftDoubleBracket]", 
     RowBox[{"NestList", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Mod", "[", 
         RowBox[{
          RowBox[{"#", "+", "k"}], ",", "n", ",", "1"}], "]"}], "&"}], ",", 
       "1", ",", "n"}], "]"}], "\[RightDoubleBracket]"}], 
    "\[IndentingNewLine]", "]"}]}], " ", ";"}], "\[IndentingNewLine]", 
 RowBox[{"Graphics", "[", 
  RowBox[{"RegularPolygon", "[", 
   RowBox[{"7", ",", " ", "1", ",", " ", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", "0", ",", "3"}], "]"}], 
  "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->702405974],

Cell[BoxData[
 GraphicsBox[
  LineBox[NCache[{{1, 0}, {-Cos[Rational[1, 7] Pi], Sin[Rational[1, 7] Pi]}, {
     Sin[Rational[3, 14] Pi], -Cos[Rational[3, 14] Pi]}, {-
      Sin[Rational[1, 14] Pi], Cos[Rational[1, 14] Pi]}, {-
      Sin[Rational[1, 14] Pi], -Cos[Rational[1, 14] Pi]}, {
     Sin[Rational[3, 14] Pi], Cos[Rational[3, 14] Pi]}, {-
      Cos[Rational[1, 7] Pi], -Sin[Rational[1, 7] Pi]}, {1, 0}}, {{1, 
     0}, {-0.900968867902419, 0.433883739117558}, {
     0.623489801858734, -0.78183148246803}, {-0.222520933956314, 
     0.974927912181824}, {-0.222520933956314, -0.974927912181824}, {
     0.623489801858734, 
     0.78183148246803}, {-0.900968867902419, -0.433883739117558}, {1, 
     0}}]]]], "Output",
 CellLabel->"Out[1]=",
 CellID->619597459]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 55, 30.1735548}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/MultipleListPlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 76, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[888, 35, 1418, 47, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[2309, 84, 218, 7, 70, "UpgradeDetail",
 CellID->1457835045],
Cell[2530, 93, 221, 7, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[2776, 104, 246, 8, 70, "Input",
 CellID->1746043248],
Cell[3025, 114, 661, 16, 70, "Output",
 CellID->582572104]
}, Open  ]],
Cell[3701, 133, 126, 3, 70, "ExampleDelimiter",
 CellID->1360688204],
Cell[3830, 138, 532, 20, 70, "UpgradeDetail",
 CellID->533287725],
Cell[4365, 160, 366, 11, 70, "Input",
 CellID->1517535144],
Cell[CellGroupData[{
Cell[4756, 175, 382, 12, 70, "Input",
 CellID->1697373436],
Cell[5141, 189, 622, 16, 70, "Output",
 CellID->911405255]
}, Open  ]],
Cell[5778, 208, 126, 3, 70, "ExampleDelimiter",
 CellID->2134750381],
Cell[5907, 213, 423, 15, 70, "UpgradeDetail",
 CellID->740363038],
Cell[6333, 230, 233, 7, 70, "Input",
 CellID->761328948],
Cell[CellGroupData[{
Cell[6591, 241, 204, 6, 70, "Input",
 CellID->948060210],
Cell[6798, 249, 659, 16, 70, "Output",
 CellID->107257569]
}, Open  ]],
Cell[7472, 268, 125, 3, 70, "ExampleDelimiter",
 CellID->939182350],
Cell[7600, 273, 414, 15, 70, "UpgradeDetail",
 CellID->832951000],
Cell[8017, 290, 378, 11, 70, "Input",
 CellID->2109045854],
Cell[CellGroupData[{
Cell[8420, 305, 742, 20, 70, "Input",
 CellID->368590796],
Cell[9165, 327, 2379, 52, 70, "Output",
 CellID->453482369]
}, Open  ]],
Cell[11559, 382, 126, 3, 70, "ExampleDelimiter",
 CellID->1528880497],
Cell[11688, 387, 692, 27, 70, "UpgradeDetail",
 CellID->1155371860],
Cell[12383, 416, 527, 18, 70, "Input",
 CellID->787714846],
Cell[CellGroupData[{
Cell[12935, 438, 515, 18, 70, "Input",
 CellID->2034216614],
Cell[13453, 458, 156, 5, 70, "Output",
 CellID->20703848]
}, Open  ]],
Cell[13624, 466, 126, 3, 70, "ExampleDelimiter",
 CellID->1252676724],
Cell[13753, 471, 387, 11, 70, "UpgradeDetail",
 CellID->798804466],
Cell[14143, 484, 101, 3, 70, "Input",
 CellID->881689808],
Cell[CellGroupData[{
Cell[14269, 491, 1086, 37, 70, "Input",
 CellID->923438756],
Cell[15358, 530, 1439, 32, 70, "Output",
 CellID->149540689]
}, Open  ]],
Cell[16812, 565, 126, 3, 70, "ExampleDelimiter",
 CellID->1955508727],
Cell[16941, 570, 164, 4, 70, "UpgradeDetail",
 CellID->1938665483],
Cell[CellGroupData[{
Cell[17130, 578, 1486, 44, 70, "Input",
 CellID->702405974],
Cell[18619, 624, 766, 15, 70, "Output",
 CellID->619597459]
}, Open  ]]
}, Open  ]],
Cell[19412, 643, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

