(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    102807,       2164]
NotebookOptionsPosition[     99645,       2062]
NotebookOutlinePosition[    100610,       2090]
CellTagsIndexPosition[    100567,       2087]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["Graphics`PlotField`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "All the functionality of ",
 Cell[BoxData["Graphics`PlotField`"], "InlineFormula"],
 " is available in the newly created ",
 ButtonBox["Vector Field Plots",
  BaseStyle->"Link",
  ButtonData->"paclet:VectorFieldPlots/guide/VectorFieldPlottingPackage"],
 " package."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 "Load ",
 Cell[BoxData["VectorFieldPlots"], "InlineFormula"],
 "` to use ",
 Cell[BoxData["Graphics`PlotField`"], "InlineFormula"],
 " functionality: "
}], "UpgradeDetail",
 CellID->556646693],

Cell[BoxData[
 RowBox[{
  RowBox[{"<<", "Graphics`PlotField`"}], ";"}]], "Input", "LegacyInput",
 CellID->1663071679],

Cell[BoxData[
 RowBox[{
  RowBox[{"<<", "VectorFieldPlots`"}], ";"}]], "Input",
 CellLabel->"In[38]:=",
 CellID->1746043248],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->139481879],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["VectorFieldPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorFieldPlots/ref/VectorFieldPlot"]], 
  "InlineFormula"],
 " contains the functionality of ",
 Cell[BoxData["PlotVectorField"], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->510952580],

Cell[BoxData[
 RowBox[{"PlotVectorField", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input", \
"LegacyInput",
 CellLabel->"In[1]:=",
 CellID->998512136],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorFieldPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "y"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", " ", "0", ",", " ", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1725607045],

Cell[BoxData[
 GraphicsBox[
  {Thickness[Small], Arrowheads[0.02], PointBox[{0., 0.}], 
   ArrowBox[{{0., 0.07142857142857142}, {0., 0.07503625908768646}}], 
   ArrowBox[{{0., 0.14285714285714285`}, {0., 0.15007251817537293`}}], 
   ArrowBox[{{0., 0.21428571428571427`}, {0., 0.2251087772630594}}], 
   ArrowBox[{{0., 0.2857142857142857}, {0., 0.30014503635074585`}}], 
   ArrowBox[{{0., 0.35714285714285715`}, {0., 0.3751812954384323}}], 
   ArrowBox[{{0., 0.42857142857142855`}, {0., 0.4502175545261188}}], 
   ArrowBox[{{0., 0.5}, {0., 0.5252538136138053}}], 
   ArrowBox[{{0., 0.5714285714285714}, {0., 0.6002900727014917}}], 
   ArrowBox[{{0., 0.6428571428571429}, {0., 0.6753263317891782}}], 
   ArrowBox[{{0., 0.7142857142857143}, {0., 0.7503625908768646}}], 
   ArrowBox[{{0., 0.7857142857142857}, {0., 0.8253988499645512}}], 
   ArrowBox[{{0., 0.8571428571428571}, {0., 0.9004351090522376}}], 
   ArrowBox[{{0., 0.9285714285714286}, {0., 0.9754713681399241}}], 
   ArrowBox[{{0., 1.}, {0., 1.0505076272276106`}}], 
   ArrowBox[{{0.07142857142857142, 0.}, {0.07503625908768646, 0.}}], 
   ArrowBox[{{0.07142857142857142, 0.07142857142857142}, {0.07503625908768646,
     0.07503625908768646}}], 
   ArrowBox[{{0.07142857142857142, 0.14285714285714285`}, {
    0.07503625908768646, 0.15007251817537293`}}], 
   ArrowBox[{{0.07142857142857142, 0.21428571428571427`}, {
    0.07503625908768646, 0.2251087772630594}}], 
   ArrowBox[{{0.07142857142857142, 0.2857142857142857}, {0.07503625908768646, 
    0.30014503635074585`}}], 
   ArrowBox[{{0.07142857142857142, 0.35714285714285715`}, {
    0.07503625908768646, 0.3751812954384323}}], 
   ArrowBox[{{0.07142857142857142, 0.42857142857142855`}, {
    0.07503625908768646, 0.4502175545261188}}], 
   ArrowBox[{{0.07142857142857142, 0.5}, {0.07503625908768646, 
    0.5252538136138053}}], 
   ArrowBox[{{0.07142857142857142, 0.5714285714285714}, {0.07503625908768646, 
    0.6002900727014917}}], 
   ArrowBox[{{0.07142857142857142, 0.6428571428571429}, {0.07503625908768646, 
    0.6753263317891782}}], 
   ArrowBox[{{0.07142857142857142, 0.7142857142857143}, {0.07503625908768646, 
    0.7503625908768646}}], 
   ArrowBox[{{0.07142857142857142, 0.7857142857142857}, {0.07503625908768646, 
    0.8253988499645512}}], 
   ArrowBox[{{0.07142857142857142, 0.8571428571428571}, {0.07503625908768646, 
    0.9004351090522376}}], 
   ArrowBox[{{0.07142857142857142, 0.9285714285714286}, {0.07503625908768646, 
    0.9754713681399241}}], 
   ArrowBox[{{0.07142857142857142, 1.}, {0.07503625908768646, 
    1.0505076272276106`}}], 
   ArrowBox[{{0.14285714285714285`, 0.}, {0.15007251817537293`, 0.}}], 
   ArrowBox[{{0.14285714285714285`, 0.07142857142857142}, {
    0.15007251817537293`, 0.07503625908768646}}], 
   ArrowBox[{{0.14285714285714285`, 0.14285714285714285`}, {
    0.15007251817537293`, 0.15007251817537293`}}], 
   ArrowBox[{{0.14285714285714285`, 0.21428571428571427`}, {
    0.15007251817537293`, 0.2251087772630594}}], 
   ArrowBox[{{0.14285714285714285`, 0.2857142857142857}, {
    0.15007251817537293`, 0.30014503635074585`}}], 
   ArrowBox[{{0.14285714285714285`, 0.35714285714285715`}, {
    0.15007251817537293`, 0.3751812954384323}}], 
   ArrowBox[{{0.14285714285714285`, 0.42857142857142855`}, {
    0.15007251817537293`, 0.4502175545261188}}], 
   ArrowBox[{{0.14285714285714285`, 0.5}, {0.15007251817537293`, 
    0.5252538136138053}}], 
   ArrowBox[{{0.14285714285714285`, 0.5714285714285714}, {
    0.15007251817537293`, 0.6002900727014917}}], 
   ArrowBox[{{0.14285714285714285`, 0.6428571428571429}, {
    0.15007251817537293`, 0.6753263317891782}}], 
   ArrowBox[{{0.14285714285714285`, 0.7142857142857143}, {
    0.15007251817537293`, 0.7503625908768646}}], 
   ArrowBox[{{0.14285714285714285`, 0.7857142857142857}, {
    0.15007251817537293`, 0.8253988499645512}}], 
   ArrowBox[{{0.14285714285714285`, 0.8571428571428571}, {
    0.15007251817537293`, 0.9004351090522376}}], 
   ArrowBox[{{0.14285714285714285`, 0.9285714285714286}, {
    0.15007251817537293`, 0.9754713681399241}}], 
   ArrowBox[{{0.14285714285714285`, 1.}, {0.15007251817537293`, 
    1.0505076272276106`}}], 
   ArrowBox[{{0.21428571428571427`, 0.}, {0.2251087772630594, 0.}}], 
   ArrowBox[{{0.21428571428571427`, 0.07142857142857142}, {0.2251087772630594,
     0.07503625908768646}}], 
   ArrowBox[{{0.21428571428571427`, 0.14285714285714285`}, {
    0.2251087772630594, 0.15007251817537293`}}], 
   ArrowBox[{{0.21428571428571427`, 0.21428571428571427`}, {
    0.2251087772630594, 0.2251087772630594}}], 
   ArrowBox[{{0.21428571428571427`, 0.2857142857142857}, {0.2251087772630594, 
    0.30014503635074585`}}], 
   ArrowBox[{{0.21428571428571427`, 0.35714285714285715`}, {
    0.2251087772630594, 0.3751812954384323}}], 
   ArrowBox[{{0.21428571428571427`, 0.42857142857142855`}, {
    0.2251087772630594, 0.4502175545261188}}], 
   ArrowBox[{{0.21428571428571427`, 0.5}, {0.2251087772630594, 
    0.5252538136138053}}], 
   ArrowBox[{{0.21428571428571427`, 0.5714285714285714}, {0.2251087772630594, 
    0.6002900727014917}}], 
   ArrowBox[{{0.21428571428571427`, 0.6428571428571429}, {0.2251087772630594, 
    0.6753263317891782}}], 
   ArrowBox[{{0.21428571428571427`, 0.7142857142857143}, {0.2251087772630594, 
    0.7503625908768646}}], 
   ArrowBox[{{0.21428571428571427`, 0.7857142857142857}, {0.2251087772630594, 
    0.8253988499645512}}], 
   ArrowBox[{{0.21428571428571427`, 0.8571428571428571}, {0.2251087772630594, 
    0.9004351090522376}}], 
   ArrowBox[{{0.21428571428571427`, 0.9285714285714286}, {0.2251087772630594, 
    0.9754713681399241}}], 
   ArrowBox[{{0.21428571428571427`, 1.}, {0.2251087772630594, 
    1.0505076272276106`}}], 
   ArrowBox[{{0.2857142857142857, 0.}, {0.30014503635074585`, 0.}}], 
   ArrowBox[{{0.2857142857142857, 0.07142857142857142}, {0.30014503635074585`,
     0.07503625908768646}}], 
   ArrowBox[{{0.2857142857142857, 0.14285714285714285`}, {
    0.30014503635074585`, 0.15007251817537293`}}], 
   ArrowBox[{{0.2857142857142857, 0.21428571428571427`}, {
    0.30014503635074585`, 0.2251087772630594}}], 
   ArrowBox[{{0.2857142857142857, 0.2857142857142857}, {0.30014503635074585`, 
    0.30014503635074585`}}], 
   ArrowBox[{{0.2857142857142857, 0.35714285714285715`}, {
    0.30014503635074585`, 0.3751812954384323}}], 
   ArrowBox[{{0.2857142857142857, 0.42857142857142855`}, {
    0.30014503635074585`, 0.4502175545261188}}], 
   ArrowBox[{{0.2857142857142857, 0.5}, {0.30014503635074585`, 
    0.5252538136138053}}], 
   ArrowBox[{{0.2857142857142857, 0.5714285714285714}, {0.30014503635074585`, 
    0.6002900727014917}}], 
   ArrowBox[{{0.2857142857142857, 0.6428571428571429}, {0.30014503635074585`, 
    0.6753263317891782}}], 
   ArrowBox[{{0.2857142857142857, 0.7142857142857143}, {0.30014503635074585`, 
    0.7503625908768646}}], 
   ArrowBox[{{0.2857142857142857, 0.7857142857142857}, {0.30014503635074585`, 
    0.8253988499645512}}], 
   ArrowBox[{{0.2857142857142857, 0.8571428571428571}, {0.30014503635074585`, 
    0.9004351090522376}}], 
   ArrowBox[{{0.2857142857142857, 0.9285714285714286}, {0.30014503635074585`, 
    0.9754713681399241}}], 
   ArrowBox[{{0.2857142857142857, 1.}, {0.30014503635074585`, 
    1.0505076272276106`}}], 
   ArrowBox[{{0.35714285714285715`, 0.}, {0.3751812954384323, 0.}}], 
   ArrowBox[{{0.35714285714285715`, 0.07142857142857142}, {0.3751812954384323,
     0.07503625908768646}}], 
   ArrowBox[{{0.35714285714285715`, 0.14285714285714285`}, {
    0.3751812954384323, 0.15007251817537293`}}], 
   ArrowBox[{{0.35714285714285715`, 0.21428571428571427`}, {
    0.3751812954384323, 0.2251087772630594}}], 
   ArrowBox[{{0.35714285714285715`, 0.2857142857142857}, {0.3751812954384323, 
    0.30014503635074585`}}], 
   ArrowBox[{{0.35714285714285715`, 0.35714285714285715`}, {
    0.3751812954384323, 0.3751812954384323}}], 
   ArrowBox[{{0.35714285714285715`, 0.42857142857142855`}, {
    0.3751812954384323, 0.4502175545261188}}], 
   ArrowBox[{{0.35714285714285715`, 0.5}, {0.3751812954384323, 
    0.5252538136138053}}], 
   ArrowBox[{{0.35714285714285715`, 0.5714285714285714}, {0.3751812954384323, 
    0.6002900727014917}}], 
   ArrowBox[{{0.35714285714285715`, 0.6428571428571429}, {0.3751812954384323, 
    0.6753263317891782}}], 
   ArrowBox[{{0.35714285714285715`, 0.7142857142857143}, {0.3751812954384323, 
    0.7503625908768646}}], 
   ArrowBox[{{0.35714285714285715`, 0.7857142857142857}, {0.3751812954384323, 
    0.8253988499645512}}], 
   ArrowBox[{{0.35714285714285715`, 0.8571428571428571}, {0.3751812954384323, 
    0.9004351090522376}}], 
   ArrowBox[{{0.35714285714285715`, 0.9285714285714286}, {0.3751812954384323, 
    0.9754713681399241}}], 
   ArrowBox[{{0.35714285714285715`, 1.}, {0.3751812954384323, 
    1.0505076272276106`}}], 
   ArrowBox[{{0.42857142857142855`, 0.}, {0.4502175545261188, 0.}}], 
   ArrowBox[{{0.42857142857142855`, 0.07142857142857142}, {0.4502175545261188,
     0.07503625908768646}}], 
   ArrowBox[{{0.42857142857142855`, 0.14285714285714285`}, {
    0.4502175545261188, 0.15007251817537293`}}], 
   ArrowBox[{{0.42857142857142855`, 0.21428571428571427`}, {
    0.4502175545261188, 0.2251087772630594}}], 
   ArrowBox[{{0.42857142857142855`, 0.2857142857142857}, {0.4502175545261188, 
    0.30014503635074585`}}], 
   ArrowBox[{{0.42857142857142855`, 0.35714285714285715`}, {
    0.4502175545261188, 0.3751812954384323}}], 
   ArrowBox[{{0.42857142857142855`, 0.42857142857142855`}, {
    0.4502175545261188, 0.4502175545261188}}], 
   ArrowBox[{{0.42857142857142855`, 0.5}, {0.4502175545261188, 
    0.5252538136138053}}], 
   ArrowBox[{{0.42857142857142855`, 0.5714285714285714}, {0.4502175545261188, 
    0.6002900727014917}}], 
   ArrowBox[{{0.42857142857142855`, 0.6428571428571429}, {0.4502175545261188, 
    0.6753263317891782}}], 
   ArrowBox[{{0.42857142857142855`, 0.7142857142857143}, {0.4502175545261188, 
    0.7503625908768646}}], 
   ArrowBox[{{0.42857142857142855`, 0.7857142857142857}, {0.4502175545261188, 
    0.8253988499645512}}], 
   ArrowBox[{{0.42857142857142855`, 0.8571428571428571}, {0.4502175545261188, 
    0.9004351090522376}}], 
   ArrowBox[{{0.42857142857142855`, 0.9285714285714286}, {0.4502175545261188, 
    0.9754713681399241}}], 
   ArrowBox[{{0.42857142857142855`, 1.}, {0.4502175545261188, 
    1.0505076272276106`}}], ArrowBox[{{0.5, 0.}, {0.5252538136138053, 0.}}], 
   ArrowBox[{{0.5, 0.07142857142857142}, {0.5252538136138053, 
    0.07503625908768646}}], 
   ArrowBox[{{0.5, 0.14285714285714285`}, {0.5252538136138053, 
    0.15007251817537293`}}], 
   ArrowBox[{{0.5, 0.21428571428571427`}, {0.5252538136138053, 
    0.2251087772630594}}], 
   ArrowBox[{{0.5, 0.2857142857142857}, {0.5252538136138053, 
    0.30014503635074585`}}], 
   ArrowBox[{{0.5, 0.35714285714285715`}, {0.5252538136138053, 
    0.3751812954384323}}], 
   ArrowBox[{{0.5, 0.42857142857142855`}, {0.5252538136138053, 
    0.4502175545261188}}], 
   ArrowBox[{{0.5, 0.5}, {0.5252538136138053, 0.5252538136138053}}], 
   ArrowBox[{{0.5, 0.5714285714285714}, {0.5252538136138053, 
    0.6002900727014917}}], 
   ArrowBox[{{0.5, 0.6428571428571429}, {0.5252538136138053, 
    0.6753263317891782}}], 
   ArrowBox[{{0.5, 0.7142857142857143}, {0.5252538136138053, 
    0.7503625908768646}}], 
   ArrowBox[{{0.5, 0.7857142857142857}, {0.5252538136138053, 
    0.8253988499645512}}], 
   ArrowBox[{{0.5, 0.8571428571428571}, {0.5252538136138053, 
    0.9004351090522376}}], 
   ArrowBox[{{0.5, 0.9285714285714286}, {0.5252538136138053, 
    0.9754713681399241}}], 
   ArrowBox[{{0.5, 1.}, {0.5252538136138053, 1.0505076272276106`}}], 
   ArrowBox[{{0.5714285714285714, 0.}, {0.6002900727014917, 0.}}], 
   ArrowBox[{{0.5714285714285714, 0.07142857142857142}, {0.6002900727014917, 
    0.07503625908768646}}], 
   ArrowBox[{{0.5714285714285714, 0.14285714285714285`}, {0.6002900727014917, 
    0.15007251817537293`}}], 
   ArrowBox[{{0.5714285714285714, 0.21428571428571427`}, {0.6002900727014917, 
    0.2251087772630594}}], 
   ArrowBox[{{0.5714285714285714, 0.2857142857142857}, {0.6002900727014917, 
    0.30014503635074585`}}], 
   ArrowBox[{{0.5714285714285714, 0.35714285714285715`}, {0.6002900727014917, 
    0.3751812954384323}}], 
   ArrowBox[{{0.5714285714285714, 0.42857142857142855`}, {0.6002900727014917, 
    0.4502175545261188}}], 
   ArrowBox[{{0.5714285714285714, 0.5}, {0.6002900727014917, 
    0.5252538136138053}}], 
   ArrowBox[{{0.5714285714285714, 0.5714285714285714}, {0.6002900727014917, 
    0.6002900727014917}}], 
   ArrowBox[{{0.5714285714285714, 0.6428571428571429}, {0.6002900727014917, 
    0.6753263317891782}}], 
   ArrowBox[{{0.5714285714285714, 0.7142857142857143}, {0.6002900727014917, 
    0.7503625908768646}}], 
   ArrowBox[{{0.5714285714285714, 0.7857142857142857}, {0.6002900727014917, 
    0.8253988499645512}}], 
   ArrowBox[{{0.5714285714285714, 0.8571428571428571}, {0.6002900727014917, 
    0.9004351090522376}}], 
   ArrowBox[{{0.5714285714285714, 0.9285714285714286}, {0.6002900727014917, 
    0.9754713681399241}}], 
   ArrowBox[{{0.5714285714285714, 1.}, {0.6002900727014917, 
    1.0505076272276106`}}], 
   ArrowBox[{{0.6428571428571429, 0.}, {0.6753263317891782, 0.}}], 
   ArrowBox[{{0.6428571428571429, 0.07142857142857142}, {0.6753263317891782, 
    0.07503625908768646}}], 
   ArrowBox[{{0.6428571428571429, 0.14285714285714285`}, {0.6753263317891782, 
    0.15007251817537293`}}], 
   ArrowBox[{{0.6428571428571429, 0.21428571428571427`}, {0.6753263317891782, 
    0.2251087772630594}}], 
   ArrowBox[{{0.6428571428571429, 0.2857142857142857}, {0.6753263317891782, 
    0.30014503635074585`}}], 
   ArrowBox[{{0.6428571428571429, 0.35714285714285715`}, {0.6753263317891782, 
    0.3751812954384323}}], 
   ArrowBox[{{0.6428571428571429, 0.42857142857142855`}, {0.6753263317891782, 
    0.4502175545261188}}], 
   ArrowBox[{{0.6428571428571429, 0.5}, {0.6753263317891782, 
    0.5252538136138053}}], 
   ArrowBox[{{0.6428571428571429, 0.5714285714285714}, {0.6753263317891782, 
    0.6002900727014917}}], 
   ArrowBox[{{0.6428571428571429, 0.6428571428571429}, {0.6753263317891782, 
    0.6753263317891782}}], 
   ArrowBox[{{0.6428571428571429, 0.7142857142857143}, {0.6753263317891782, 
    0.7503625908768646}}], 
   ArrowBox[{{0.6428571428571429, 0.7857142857142857}, {0.6753263317891782, 
    0.8253988499645512}}], 
   ArrowBox[{{0.6428571428571429, 0.8571428571428571}, {0.6753263317891782, 
    0.9004351090522376}}], 
   ArrowBox[{{0.6428571428571429, 0.9285714285714286}, {0.6753263317891782, 
    0.9754713681399241}}], 
   ArrowBox[{{0.6428571428571429, 1.}, {0.6753263317891782, 
    1.0505076272276106`}}], 
   ArrowBox[{{0.7142857142857143, 0.}, {0.7503625908768646, 0.}}], 
   ArrowBox[{{0.7142857142857143, 0.07142857142857142}, {0.7503625908768646, 
    0.07503625908768646}}], 
   ArrowBox[{{0.7142857142857143, 0.14285714285714285`}, {0.7503625908768646, 
    0.15007251817537293`}}], 
   ArrowBox[{{0.7142857142857143, 0.21428571428571427`}, {0.7503625908768646, 
    0.2251087772630594}}], 
   ArrowBox[{{0.7142857142857143, 0.2857142857142857}, {0.7503625908768646, 
    0.30014503635074585`}}], 
   ArrowBox[{{0.7142857142857143, 0.35714285714285715`}, {0.7503625908768646, 
    0.3751812954384323}}], 
   ArrowBox[{{0.7142857142857143, 0.42857142857142855`}, {0.7503625908768646, 
    0.4502175545261188}}], 
   ArrowBox[{{0.7142857142857143, 0.5}, {0.7503625908768646, 
    0.5252538136138053}}], 
   ArrowBox[{{0.7142857142857143, 0.5714285714285714}, {0.7503625908768646, 
    0.6002900727014917}}], 
   ArrowBox[{{0.7142857142857143, 0.6428571428571429}, {0.7503625908768646, 
    0.6753263317891782}}], 
   ArrowBox[{{0.7142857142857143, 0.7142857142857143}, {0.7503625908768646, 
    0.7503625908768646}}], 
   ArrowBox[{{0.7142857142857143, 0.7857142857142857}, {0.7503625908768646, 
    0.8253988499645512}}], 
   ArrowBox[{{0.7142857142857143, 0.8571428571428571}, {0.7503625908768646, 
    0.9004351090522376}}], 
   ArrowBox[{{0.7142857142857143, 0.9285714285714286}, {0.7503625908768646, 
    0.9754713681399241}}], 
   ArrowBox[{{0.7142857142857143, 1.}, {0.7503625908768646, 
    1.0505076272276106`}}], 
   ArrowBox[{{0.7857142857142857, 0.}, {0.8253988499645512, 0.}}], 
   ArrowBox[{{0.7857142857142857, 0.07142857142857142}, {0.8253988499645512, 
    0.07503625908768646}}], 
   ArrowBox[{{0.7857142857142857, 0.14285714285714285`}, {0.8253988499645512, 
    0.15007251817537293`}}], 
   ArrowBox[{{0.7857142857142857, 0.21428571428571427`}, {0.8253988499645512, 
    0.2251087772630594}}], 
   ArrowBox[{{0.7857142857142857, 0.2857142857142857}, {0.8253988499645512, 
    0.30014503635074585`}}], 
   ArrowBox[{{0.7857142857142857, 0.35714285714285715`}, {0.8253988499645512, 
    0.3751812954384323}}], 
   ArrowBox[{{0.7857142857142857, 0.42857142857142855`}, {0.8253988499645512, 
    0.4502175545261188}}], 
   ArrowBox[{{0.7857142857142857, 0.5}, {0.8253988499645512, 
    0.5252538136138053}}], 
   ArrowBox[{{0.7857142857142857, 0.5714285714285714}, {0.8253988499645512, 
    0.6002900727014917}}], 
   ArrowBox[{{0.7857142857142857, 0.6428571428571429}, {0.8253988499645512, 
    0.6753263317891782}}], 
   ArrowBox[{{0.7857142857142857, 0.7142857142857143}, {0.8253988499645512, 
    0.7503625908768646}}], 
   ArrowBox[{{0.7857142857142857, 0.7857142857142857}, {0.8253988499645512, 
    0.8253988499645512}}], 
   ArrowBox[{{0.7857142857142857, 0.8571428571428571}, {0.8253988499645512, 
    0.9004351090522376}}], 
   ArrowBox[{{0.7857142857142857, 0.9285714285714286}, {0.8253988499645512, 
    0.9754713681399241}}], 
   ArrowBox[{{0.7857142857142857, 1.}, {0.8253988499645512, 
    1.0505076272276106`}}], 
   ArrowBox[{{0.8571428571428571, 0.}, {0.9004351090522376, 0.}}], 
   ArrowBox[{{0.8571428571428571, 0.07142857142857142}, {0.9004351090522376, 
    0.07503625908768646}}], 
   ArrowBox[{{0.8571428571428571, 0.14285714285714285`}, {0.9004351090522376, 
    0.15007251817537293`}}], 
   ArrowBox[{{0.8571428571428571, 0.21428571428571427`}, {0.9004351090522376, 
    0.2251087772630594}}], 
   ArrowBox[{{0.8571428571428571, 0.2857142857142857}, {0.9004351090522376, 
    0.30014503635074585`}}], 
   ArrowBox[{{0.8571428571428571, 0.35714285714285715`}, {0.9004351090522376, 
    0.3751812954384323}}], 
   ArrowBox[{{0.8571428571428571, 0.42857142857142855`}, {0.9004351090522376, 
    0.4502175545261188}}], 
   ArrowBox[{{0.8571428571428571, 0.5}, {0.9004351090522376, 
    0.5252538136138053}}], 
   ArrowBox[{{0.8571428571428571, 0.5714285714285714}, {0.9004351090522376, 
    0.6002900727014917}}], 
   ArrowBox[{{0.8571428571428571, 0.6428571428571429}, {0.9004351090522376, 
    0.6753263317891782}}], 
   ArrowBox[{{0.8571428571428571, 0.7142857142857143}, {0.9004351090522376, 
    0.7503625908768646}}], 
   ArrowBox[{{0.8571428571428571, 0.7857142857142857}, {0.9004351090522376, 
    0.8253988499645512}}], 
   ArrowBox[{{0.8571428571428571, 0.8571428571428571}, {0.9004351090522376, 
    0.9004351090522376}}], 
   ArrowBox[{{0.8571428571428571, 0.9285714285714286}, {0.9004351090522376, 
    0.9754713681399241}}], 
   ArrowBox[{{0.8571428571428571, 1.}, {0.9004351090522376, 
    1.0505076272276106`}}], 
   ArrowBox[{{0.9285714285714286, 0.}, {0.9754713681399241, 0.}}], 
   ArrowBox[{{0.9285714285714286, 0.07142857142857142}, {0.9754713681399241, 
    0.07503625908768646}}], 
   ArrowBox[{{0.9285714285714286, 0.14285714285714285`}, {0.9754713681399241, 
    0.15007251817537293`}}], 
   ArrowBox[{{0.9285714285714286, 0.21428571428571427`}, {0.9754713681399241, 
    0.2251087772630594}}], 
   ArrowBox[{{0.9285714285714286, 0.2857142857142857}, {0.9754713681399241, 
    0.30014503635074585`}}], 
   ArrowBox[{{0.9285714285714286, 0.35714285714285715`}, {0.9754713681399241, 
    0.3751812954384323}}], 
   ArrowBox[{{0.9285714285714286, 0.42857142857142855`}, {0.9754713681399241, 
    0.4502175545261188}}], 
   ArrowBox[{{0.9285714285714286, 0.5}, {0.9754713681399241, 
    0.5252538136138053}}], 
   ArrowBox[{{0.9285714285714286, 0.5714285714285714}, {0.9754713681399241, 
    0.6002900727014917}}], 
   ArrowBox[{{0.9285714285714286, 0.6428571428571429}, {0.9754713681399241, 
    0.6753263317891782}}], 
   ArrowBox[{{0.9285714285714286, 0.7142857142857143}, {0.9754713681399241, 
    0.7503625908768646}}], 
   ArrowBox[{{0.9285714285714286, 0.7857142857142857}, {0.9754713681399241, 
    0.8253988499645512}}], 
   ArrowBox[{{0.9285714285714286, 0.8571428571428571}, {0.9754713681399241, 
    0.9004351090522376}}], 
   ArrowBox[{{0.9285714285714286, 0.9285714285714286}, {0.9754713681399241, 
    0.9754713681399241}}], 
   ArrowBox[{{0.9285714285714286, 1.}, {0.9754713681399241, 
    1.0505076272276106`}}], ArrowBox[{{1., 0.}, {1.0505076272276106`, 0.}}], 
   ArrowBox[{{1., 0.07142857142857142}, {1.0505076272276106`, 
    0.07503625908768646}}], 
   ArrowBox[{{1., 0.14285714285714285`}, {1.0505076272276106`, 
    0.15007251817537293`}}], 
   ArrowBox[{{1., 0.21428571428571427`}, {1.0505076272276106`, 
    0.2251087772630594}}], 
   ArrowBox[{{1., 0.2857142857142857}, {1.0505076272276106`, 
    0.30014503635074585`}}], 
   ArrowBox[{{1., 0.35714285714285715`}, {1.0505076272276106`, 
    0.3751812954384323}}], 
   ArrowBox[{{1., 0.42857142857142855`}, {1.0505076272276106`, 
    0.4502175545261188}}], 
   ArrowBox[{{1., 0.5}, {1.0505076272276106`, 0.5252538136138053}}], 
   ArrowBox[{{1., 0.5714285714285714}, {1.0505076272276106`, 
    0.6002900727014917}}], 
   ArrowBox[{{1., 0.6428571428571429}, {1.0505076272276106`, 
    0.6753263317891782}}], 
   ArrowBox[{{1., 0.7142857142857143}, {1.0505076272276106`, 
    0.7503625908768646}}], 
   ArrowBox[{{1., 0.7857142857142857}, {1.0505076272276106`, 
    0.8253988499645512}}], 
   ArrowBox[{{1., 0.8571428571428571}, {1.0505076272276106`, 
    0.9004351090522376}}], 
   ArrowBox[{{1., 0.9285714285714286}, {1.0505076272276106`, 
    0.9754713681399241}}], 
   ArrowBox[{{1., 1.}, {1.0505076272276106`, 
    1.0505076272276106`}}]}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1940391354]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->265009851],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListVectorFieldPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorFieldPlots/ref/ListVectorFieldPlot"]], 
  "InlineFormula"],
 " contains the functionality of ",
 Cell[BoxData["ListPlotVectorField"], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->1063477682],

Cell[BoxData[
 RowBox[{"ListPlotVectorField", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", " ", "0", ",", "1", ",", ".2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "1", ",", "0.2"}], "}"}]}], "]"}], 
  "]"}]], "Input", "LegacyInput",
 CellLabel->"In[1]:=",
 CellID->363007393],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListVectorFieldPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", " ", "0", ",", "1", ",", ".2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "1", ",", "0.2"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->64213024],

Cell[BoxData[
 GraphicsBox[
  {Thickness[Small], Arrowheads[0.02], ArrowBox[{{1., 1.}, {2., 1.}}], 
   ArrowBox[{{2., 1.}, {3., 1.2}}], ArrowBox[{{3., 1.}, {4., 1.4}}], 
   ArrowBox[{{4., 1.}, {5., 1.6}}], ArrowBox[{{5., 1.}, {6., 1.8}}], 
   ArrowBox[{{6., 1.}, {7., 2.}}], ArrowBox[{{1., 2.}, {1.8, 2.}}], 
   ArrowBox[{{2., 2.}, {2.8, 2.2}}], ArrowBox[{{3., 2.}, {3.8, 2.4}}], 
   ArrowBox[{{4., 2.}, {4.8, 2.6}}], ArrowBox[{{5., 2.}, {5.8, 2.8}}], 
   ArrowBox[{{6., 2.}, {6.8, 3.}}], ArrowBox[{{1., 3.}, {1.6, 3.}}], 
   ArrowBox[{{2., 3.}, {2.6, 3.2}}], ArrowBox[{{3., 3.}, {3.6, 3.4}}], 
   ArrowBox[{{4., 3.}, {4.6, 3.6}}], ArrowBox[{{5., 3.}, {5.6, 3.8}}], 
   ArrowBox[{{6., 3.}, {6.6, 4.}}], ArrowBox[{{1., 4.}, {1.4, 4.}}], 
   ArrowBox[{{2., 4.}, {2.4, 4.2}}], ArrowBox[{{3., 4.}, {3.4, 4.4}}], 
   ArrowBox[{{4., 4.}, {4.4, 4.6}}], ArrowBox[{{5., 4.}, {5.4, 4.8}}], 
   ArrowBox[{{6., 4.}, {6.4, 5.}}], ArrowBox[{{1., 5.}, {1.2, 5.}}], 
   ArrowBox[{{2., 5.}, {2.2, 5.2}}], ArrowBox[{{3., 5.}, {3.2, 5.4}}], 
   ArrowBox[{{4., 5.}, {4.2, 5.6}}], ArrowBox[{{5., 5.}, {5.2, 5.8}}], 
   ArrowBox[{{6., 5.}, {6.2, 6.}}], PointBox[{1., 6.}], 
   ArrowBox[{{2., 6.}, {2., 6.2}}], ArrowBox[{{3., 6.}, {3., 6.4}}], 
   ArrowBox[{{4., 6.}, {4., 6.6}}], ArrowBox[{{5., 6.}, {5., 6.8}}], 
   ArrowBox[{{6., 6.}, {6., 7.}}]}]], "Output",
 CellLabel->"Out[2]=",
 CellID->315559943]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1418425714],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GradientFieldPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorFieldPlots/ref/GradientFieldPlot"]], 
  "InlineFormula"],
 " contains the functionality of ",
 Cell[BoxData["PlotGradientField"], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->470823336],

Cell[BoxData[
 RowBox[{"PlotGradientField", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], 
    RowBox[{"Cos", "[", "y", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input", \
"LegacyInput",
 CellLabel->"In[1]:=",
 CellID->1798052604],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GradientFieldPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], 
    RowBox[{"Cos", "[", "y", "]"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->480234844],

Cell[BoxData[
 GraphicsBox[
  {Thickness[Small], Arrowheads[0.02], 
   ArrowBox[{{0., 0.}, {0.4487989505128276, 0.}}], 
   ArrowBox[{{0., 0.4487989505128276}, {0.4043538823593361, 
    0.4487989505128276}}], 
   ArrowBox[{{0., 0.8975979010256552}, {0.2798215687296504, 
    0.8975979010256552}}], 
   ArrowBox[{{0., 1.3463968515384828`}, {0.09986716162672812, 
    1.3463968515384828`}}], 
   ArrowBox[{{0., 1.7951958020513104`}, {-0.09986716162672812, 
    1.7951958020513104`}}], 
   ArrowBox[{{0., 2.243994752564138}, {-0.2798215687296504, 
    2.243994752564138}}], 
   ArrowBox[{{0., 2.6927937030769655`}, {-0.4043538823593361, 
    2.6927937030769655`}}], 
   ArrowBox[{{0., 3.141592653589793}, {-0.4487989505128276, 
    3.141592653589793}}], 
   ArrowBox[{{0., 3.5903916041026207`}, {-0.4043538823593361, 
    3.5903916041026207`}}], 
   ArrowBox[{{0., 4.039190554615448}, {-0.2798215687296504, 
    4.039190554615448}}], 
   ArrowBox[{{0., 4.487989505128276}, {-0.09986716162672812, 
    4.487989505128276}}], 
   ArrowBox[{{0., 4.9367884556411035`}, {0.09986716162672812, 
    4.9367884556411035`}}], 
   ArrowBox[{{0., 5.385587406153931}, {0.2798215687296504, 
    5.385587406153931}}], 
   ArrowBox[{{0., 5.834386356666759}, {0.4043538823593361, 
    5.834386356666759}}], 
   ArrowBox[{{0., 6.283185307179586}, {0.4487989505128276, 
    6.283185307179586}}], 
   ArrowBox[{{0.4487989505128276, 0.}, {0.8531528328721637, 0.}}], 
   ArrowBox[{{0.4487989505128276, 0.4487989505128276}, {0.8131092101340667, 
    0.36431025962123903`}}], 
   ArrowBox[{{0.4487989505128276, 0.8975979010256552}, {0.7009094725058597, 
    0.7453545406593511}}], 
   ArrowBox[{{0.4487989505128276, 1.3463968515384828`}, {0.5387761540642887, 
    1.1565524863602934`}}], 
   ArrowBox[{{0.4487989505128276, 1.7951958020513104`}, {0.35882174696136643`,
     1.605351436873121}}], 
   ArrowBox[{{0.4487989505128276, 2.243994752564138}, {0.1966884285197955, 
    2.091751392197834}}], 
   ArrowBox[{{0.4487989505128276, 2.6927937030769655`}, {0.08448869089158856, 
    2.608305012185377}}], 
   ArrowBox[{{0.4487989505128276, 3.141592653589793}, {0.044445068153491474`, 
    3.141592653589793}}], 
   ArrowBox[{{0.4487989505128276, 3.5903916041026207`}, {0.08448869089158856, 
    3.6748802949942094`}}], 
   ArrowBox[{{0.4487989505128276, 4.039190554615448}, {0.1966884285197955, 
    4.1914339149817526`}}], 
   ArrowBox[{{0.4487989505128276, 4.487989505128276}, {0.35882174696136643`, 
    4.677833870306465}}], 
   ArrowBox[{{0.4487989505128276, 4.9367884556411035`}, {0.5387761540642887, 
    5.126632820819292}}], 
   ArrowBox[{{0.4487989505128276, 5.385587406153931}, {0.7009094725058597, 
    5.537830766520235}}], 
   ArrowBox[{{0.4487989505128276, 5.834386356666759}, {0.8131092101340667, 
    5.918875047558347}}], 
   ArrowBox[{{0.4487989505128276, 6.283185307179586}, {0.8531528328721637, 
    6.283185307179586}}], 
   ArrowBox[{{0.8975979010256552, 0.}, {1.1774194697553055`, 0.}}], 
   ArrowBox[{{0.8975979010256552, 0.4487989505128276}, {1.1497084230186871`, 
    0.2965555901465236}}], 
   ArrowBox[{{0.8975979010256552, 0.8975979010256552}, {1.072063795468705, 
    0.6232648449558773}}], 
   ArrowBox[{{0.8975979010256552, 1.3463968515384828`}, {0.959864057840498, 
    1.0043091259939896`}}], 
   ArrowBox[{{0.8975979010256552, 1.7951958020513104`}, {0.8353317442108124, 
    1.4531080765068172`}}], 
   ArrowBox[{{0.8975979010256552, 2.243994752564138}, {0.7231320065826055, 
    1.96966169649436}}], 
   ArrowBox[{{0.8975979010256552, 2.6927937030769655`}, {0.6454873790326231, 
    2.5405503427106617`}}], 
   ArrowBox[{{0.8975979010256552, 3.141592653589793}, {0.6177763322960048, 
    3.141592653589793}}], 
   ArrowBox[{{0.8975979010256552, 3.5903916041026207`}, {0.6454873790326231, 
    3.7426349644689245`}}], 
   ArrowBox[{{0.8975979010256552, 4.039190554615448}, {0.7231320065826055, 
    4.313523610685226}}], 
   ArrowBox[{{0.8975979010256552, 4.487989505128276}, {0.8353317442108124, 
    4.830077230672769}}], 
   ArrowBox[{{0.8975979010256552, 4.9367884556411035`}, {0.959864057840498, 
    5.278876181185597}}], 
   ArrowBox[{{0.8975979010256552, 5.385587406153931}, {1.072063795468705, 
    5.659920462223709}}], 
   ArrowBox[{{0.8975979010256552, 5.834386356666759}, {1.1497084230186871`, 
    5.986629717033063}}], 
   ArrowBox[{{0.8975979010256552, 6.283185307179586}, {1.1774194697553055`, 
    6.283185307179586}}], 
   ArrowBox[{{1.3463968515384828`, 0.}, {1.446264013165211, 0.}}], 
   ArrowBox[{{1.3463968515384828`, 0.4487989505128276}, {1.436374055089944, 
    0.25895458533463833`}}], 
   ArrowBox[{{1.3463968515384828`, 0.8975979010256552}, {1.4086630083533256`, 
    0.555510175481162}}], 
   ArrowBox[{{1.3463968515384828`, 1.3463968515384828`}, {1.3686193856152284`,
     0.9198204351024009}}], 
   ArrowBox[{{1.3463968515384828`, 1.7951958020513104`}, {1.324174317461737, 
    1.3686193856152284`}}], 
   ArrowBox[{{1.3463968515384828`, 2.243994752564138}, {1.28413069472364, 
    1.9019070270196448`}}], 
   ArrowBox[{{1.3463968515384828`, 2.6927937030769655`}, {1.2564196479870215`,
     2.502949337898776}}], 
   ArrowBox[{{1.3463968515384828`, 3.141592653589793}, {1.2465296899117546`, 
    3.141592653589793}}], 
   ArrowBox[{{1.3463968515384828`, 3.5903916041026207`}, {1.2564196479870215`,
     3.78023596928081}}], 
   ArrowBox[{{1.3463968515384828`, 4.039190554615448}, {1.28413069472364, 
    4.3812782801599415`}}], 
   ArrowBox[{{1.3463968515384828`, 4.487989505128276}, {1.324174317461737, 
    4.914565921564358}}], 
   ArrowBox[{{1.3463968515384828`, 4.9367884556411035`}, {1.3686193856152284`,
     5.363364872077185}}], 
   ArrowBox[{{1.3463968515384828`, 5.385587406153931}, {1.4086630083533256`, 
    5.727675131698424}}], 
   ArrowBox[{{1.3463968515384828`, 5.834386356666759}, {1.436374055089944, 
    6.024230721844948}}], 
   ArrowBox[{{1.3463968515384828`, 6.283185307179586}, {1.446264013165211, 
    6.283185307179586}}], 
   ArrowBox[{{1.7951958020513104`, 0.}, {1.6953286404245822`, 0.}}], 
   ArrowBox[{{1.7951958020513104`, 0.4487989505128276}, {1.7052185984998491`, 
    0.25895458533463833`}}], 
   ArrowBox[{{1.7951958020513104`, 0.8975979010256552}, {1.7329296452364675`, 
    0.555510175481162}}], 
   ArrowBox[{{1.7951958020513104`, 1.3463968515384828`}, {1.7729732679745647`,
     0.9198204351024009}}], 
   ArrowBox[{{1.7951958020513104`, 1.7951958020513104`}, {1.817418336128056, 
    1.3686193856152284`}}], 
   ArrowBox[{{1.7951958020513104`, 2.243994752564138}, {1.8574619588661532`, 
    1.9019070270196448`}}], 
   ArrowBox[{{1.7951958020513104`, 2.6927937030769655`}, {1.8851730056027716`,
     2.502949337898776}}], 
   ArrowBox[{{1.7951958020513104`, 3.141592653589793}, {1.8950629636780385`, 
    3.141592653589793}}], 
   ArrowBox[{{1.7951958020513104`, 3.5903916041026207`}, {1.8851730056027716`,
     3.78023596928081}}], 
   ArrowBox[{{1.7951958020513104`, 4.039190554615448}, {1.8574619588661532`, 
    4.3812782801599415`}}], 
   ArrowBox[{{1.7951958020513104`, 4.487989505128276}, {1.817418336128056, 
    4.914565921564358}}], 
   ArrowBox[{{1.7951958020513104`, 4.9367884556411035`}, {1.7729732679745647`,
     5.363364872077185}}], 
   ArrowBox[{{1.7951958020513104`, 5.385587406153931}, {1.7329296452364675`, 
    5.727675131698424}}], 
   ArrowBox[{{1.7951958020513104`, 5.834386356666759}, {1.7052185984998491`, 
    6.024230721844948}}], 
   ArrowBox[{{1.7951958020513104`, 6.283185307179586}, {1.6953286404245822`, 
    6.283185307179586}}], 
   ArrowBox[{{2.243994752564138, 0.}, {1.9641731838344876`, 0.}}], 
   ArrowBox[{{2.243994752564138, 0.4487989505128276}, {1.991884230571106, 
    0.2965555901465236}}], 
   ArrowBox[{{2.243994752564138, 0.8975979010256552}, {2.0695288581210884`, 
    0.6232648449558773}}], 
   ArrowBox[{{2.243994752564138, 1.3463968515384828`}, {2.181728595749295, 
    1.0043091259939896`}}], 
   ArrowBox[{{2.243994752564138, 1.7951958020513104`}, {2.306260909378981, 
    1.4531080765068172`}}], 
   ArrowBox[{{2.243994752564138, 2.243994752564138}, {2.4184606470071874`, 
    1.96966169649436}}], 
   ArrowBox[{{2.243994752564138, 2.6927937030769655`}, {2.49610527455717, 
    2.5405503427106617`}}], 
   ArrowBox[{{2.243994752564138, 3.141592653589793}, {2.5238163212937885`, 
    3.141592653589793}}], 
   ArrowBox[{{2.243994752564138, 3.5903916041026207`}, {2.49610527455717, 
    3.7426349644689245`}}], 
   ArrowBox[{{2.243994752564138, 4.039190554615448}, {2.4184606470071874`, 
    4.313523610685226}}], 
   ArrowBox[{{2.243994752564138, 4.487989505128276}, {2.306260909378981, 
    4.830077230672769}}], 
   ArrowBox[{{2.243994752564138, 4.9367884556411035`}, {2.181728595749295, 
    5.278876181185597}}], 
   ArrowBox[{{2.243994752564138, 5.385587406153931}, {2.0695288581210884`, 
    5.659920462223709}}], 
   ArrowBox[{{2.243994752564138, 5.834386356666759}, {1.991884230571106, 
    5.986629717033063}}], 
   ArrowBox[{{2.243994752564138, 6.283185307179586}, {1.9641731838344876`, 
    6.283185307179586}}], 
   ArrowBox[{{2.6927937030769655`, 0.}, {2.2884398207176293`, 0.}}], 
   ArrowBox[{{2.6927937030769655`, 0.4487989505128276}, {2.3284834434557267`, 
    0.36431025962123903`}}], 
   ArrowBox[{{2.6927937030769655`, 0.8975979010256552}, {2.4406831810839336`, 
    0.7453545406593511}}], 
   ArrowBox[{{2.6927937030769655`, 1.3463968515384828`}, {2.6028164995255043`,
     1.1565524863602934`}}], 
   ArrowBox[{{2.6927937030769655`, 1.7951958020513104`}, {2.7827709066284267`,
     1.605351436873121}}], 
   ArrowBox[{{2.6927937030769655`, 2.243994752564138}, {2.9449042250699975`, 
    2.091751392197834}}], 
   ArrowBox[{{2.6927937030769655`, 2.6927937030769655`}, {3.0571039626982044`,
     2.608305012185377}}], 
   ArrowBox[{{2.6927937030769655`, 3.141592653589793}, {3.0971475854363018`, 
    3.141592653589793}}], 
   ArrowBox[{{2.6927937030769655`, 3.5903916041026207`}, {3.0571039626982044`,
     3.6748802949942094`}}], 
   ArrowBox[{{2.6927937030769655`, 4.039190554615448}, {2.9449042250699975`, 
    4.1914339149817526`}}], 
   ArrowBox[{{2.6927937030769655`, 4.487989505128276}, {2.7827709066284267`, 
    4.677833870306465}}], 
   ArrowBox[{{2.6927937030769655`, 4.9367884556411035`}, {2.6028164995255043`,
     5.126632820819292}}], 
   ArrowBox[{{2.6927937030769655`, 5.385587406153931}, {2.4406831810839336`, 
    5.537830766520235}}], 
   ArrowBox[{{2.6927937030769655`, 5.834386356666759}, {2.3284834434557267`, 
    5.918875047558347}}], 
   ArrowBox[{{2.6927937030769655`, 6.283185307179586}, {2.2884398207176293`, 
    6.283185307179586}}], 
   ArrowBox[{{3.141592653589793, 0.}, {2.6927937030769655`, 0.}}], 
   ArrowBox[{{3.141592653589793, 0.4487989505128276}, {2.737238771230457, 
    0.4487989505128276}}], 
   ArrowBox[{{3.141592653589793, 0.8975979010256552}, {2.8617710848601425`, 
    0.8975979010256552}}], 
   ArrowBox[{{3.141592653589793, 1.3463968515384828`}, {3.041725491963065, 
    1.3463968515384828`}}], 
   ArrowBox[{{3.141592653589793, 1.7951958020513104`}, {3.2414598152165213`, 
    1.7951958020513104`}}], 
   ArrowBox[{{3.141592653589793, 2.243994752564138}, {3.4214142223194437`, 
    2.243994752564138}}], 
   ArrowBox[{{3.141592653589793, 2.6927937030769655`}, {3.5459465359491293`, 
    2.6927937030769655`}}], 
   ArrowBox[{{3.141592653589793, 3.141592653589793}, {3.5903916041026207`, 
    3.141592653589793}}], 
   ArrowBox[{{3.141592653589793, 3.5903916041026207`}, {3.5459465359491293`, 
    3.5903916041026207`}}], 
   ArrowBox[{{3.141592653589793, 4.039190554615448}, {3.4214142223194437`, 
    4.039190554615448}}], 
   ArrowBox[{{3.141592653589793, 4.487989505128276}, {3.2414598152165213`, 
    4.487989505128276}}], 
   ArrowBox[{{3.141592653589793, 4.9367884556411035`}, {3.041725491963065, 
    4.9367884556411035`}}], 
   ArrowBox[{{3.141592653589793, 5.385587406153931}, {2.8617710848601425`, 
    5.385587406153931}}], 
   ArrowBox[{{3.141592653589793, 5.834386356666759}, {2.737238771230457, 
    5.834386356666759}}], 
   ArrowBox[{{3.141592653589793, 6.283185307179586}, {2.6927937030769655`, 
    6.283185307179586}}], 
   ArrowBox[{{3.5903916041026207`, 0.}, {3.1860377217432845`, 0.}}], 
   ArrowBox[{{3.5903916041026207`, 0.4487989505128276}, {3.226081344481382, 
    0.5332876414044162}}], 
   ArrowBox[{{3.5903916041026207`, 0.8975979010256552}, {3.3382810821095887`, 
    1.0498412613919592`}}], 
   ArrowBox[{{3.5903916041026207`, 1.3463968515384828`}, {3.5004144005511595`,
     1.5362412167166721`}}], 
   ArrowBox[{{3.5903916041026207`, 1.7951958020513104`}, {3.680368807654082, 
    1.9850401672294997`}}], 
   ArrowBox[{{3.5903916041026207`, 2.243994752564138}, {3.8425021260956527`, 
    2.3962381129304418`}}], 
   ArrowBox[{{3.5903916041026207`, 2.6927937030769655`}, {3.9547018637238596`,
     2.7772823939685543`}}], 
   ArrowBox[{{3.5903916041026207`, 3.141592653589793}, {3.994745486461957, 
    3.141592653589793}}], 
   ArrowBox[{{3.5903916041026207`, 3.5903916041026207`}, {3.9547018637238596`,
     3.505902913211032}}], 
   ArrowBox[{{3.5903916041026207`, 4.039190554615448}, {3.8425021260956527`, 
    3.8869471942491445`}}], 
   ArrowBox[{{3.5903916041026207`, 4.487989505128276}, {3.680368807654082, 
    4.298145139950087}}], 
   ArrowBox[{{3.5903916041026207`, 4.9367884556411035`}, {3.5004144005511595`,
     4.7469440904629145`}}], 
   ArrowBox[{{3.5903916041026207`, 5.385587406153931}, {3.3382810821095887`, 
    5.233344045787627}}], 
   ArrowBox[{{3.5903916041026207`, 5.834386356666759}, {3.226081344481382, 
    5.74989766577517}}], 
   ArrowBox[{{3.5903916041026207`, 6.283185307179586}, {3.1860377217432845`, 
    6.283185307179586}}], 
   ArrowBox[{{4.039190554615448, 0.}, {3.7593689858857977`, 0.}}], 
   ArrowBox[{{4.039190554615448, 0.4487989505128276}, {3.7870800326224163`, 
    0.6010423108791316}}], 
   ArrowBox[{{4.039190554615448, 0.8975979010256552}, {3.864724660172399, 
    1.171930957095433}}], 
   ArrowBox[{{4.039190554615448, 1.3463968515384828`}, {3.9769243978006052`, 
    1.688484577082976}}], 
   ArrowBox[{{4.039190554615448, 1.7951958020513104`}, {4.101456711430291, 
    2.1372835275958035`}}], 
   ArrowBox[{{4.039190554615448, 2.243994752564138}, {4.213656449058498, 
    2.5183278086339156`}}], 
   ArrowBox[{{4.039190554615448, 2.6927937030769655`}, {4.29130107660848, 
    2.8450370634432693`}}], 
   ArrowBox[{{4.039190554615448, 3.141592653589793}, {4.319012123345098, 
    3.141592653589793}}], 
   ArrowBox[{{4.039190554615448, 3.5903916041026207`}, {4.29130107660848, 
    3.438148243736317}}], 
   ArrowBox[{{4.039190554615448, 4.039190554615448}, {4.213656449058498, 
    3.7648574985456706`}}], 
   ArrowBox[{{4.039190554615448, 4.487989505128276}, {4.101456711430291, 
    4.145901779583783}}], 
   ArrowBox[{{4.039190554615448, 4.9367884556411035`}, {3.9769243978006052`, 
    4.59470073009661}}], 
   ArrowBox[{{4.039190554615448, 5.385587406153931}, {3.864724660172399, 
    5.111254350084153}}], 
   ArrowBox[{{4.039190554615448, 5.834386356666759}, {3.7870800326224163`, 
    5.682142996300454}}], 
   ArrowBox[{{4.039190554615448, 6.283185307179586}, {3.7593689858857977`, 
    6.283185307179586}}], 
   ArrowBox[{{4.487989505128276, 0.}, {4.388122343501548, 0.}}], 
   ArrowBox[{{4.487989505128276, 0.4487989505128276}, {4.398012301576815, 
    0.6386433156910168}}], 
   ArrowBox[{{4.487989505128276, 0.8975979010256552}, {4.425723348313433, 
    1.2396856265701484`}}], 
   ArrowBox[{{4.487989505128276, 1.3463968515384828`}, {4.46576697105153, 
    1.7729732679745647`}}], 
   ArrowBox[{{4.487989505128276, 1.7951958020513104`}, {4.510212039205022, 
    2.2217722184873923`}}], 
   ArrowBox[{{4.487989505128276, 2.243994752564138}, {4.550255661943119, 
    2.586082478108631}}], 
   ArrowBox[{{4.487989505128276, 2.6927937030769655`}, {4.577966708679737, 
    2.882638068255155}}], 
   ArrowBox[{{4.487989505128276, 3.141592653589793}, {4.587856666755004, 
    3.141592653589793}}], 
   ArrowBox[{{4.487989505128276, 3.5903916041026207`}, {4.577966708679737, 
    3.4005472389244313`}}], 
   ArrowBox[{{4.487989505128276, 4.039190554615448}, {4.550255661943119, 
    3.697102829070955}}], 
   ArrowBox[{{4.487989505128276, 4.487989505128276}, {4.510212039205022, 
    4.061413088692194}}], 
   ArrowBox[{{4.487989505128276, 4.9367884556411035`}, {4.46576697105153, 
    4.510212039205022}}], 
   ArrowBox[{{4.487989505128276, 5.385587406153931}, {4.425723348313433, 
    5.043499680609438}}], 
   ArrowBox[{{4.487989505128276, 5.834386356666759}, {4.398012301576815, 
    5.64454199148857}}], 
   ArrowBox[{{4.487989505128276, 6.283185307179586}, {4.388122343501548, 
    6.283185307179586}}], 
   ArrowBox[{{4.9367884556411035`, 0.}, {5.036655617267831, 0.}}], 
   ArrowBox[{{4.9367884556411035`, 0.4487989505128276}, {5.026765659192565, 
    0.6386433156910168}}], 
   ArrowBox[{{4.9367884556411035`, 0.8975979010256552}, {4.9990546124559465`, 
    1.2396856265701484`}}], 
   ArrowBox[{{4.9367884556411035`, 1.3463968515384828`}, {4.959010989717849, 
    1.7729732679745647`}}], 
   ArrowBox[{{4.9367884556411035`, 1.7951958020513104`}, {4.914565921564358, 
    2.2217722184873923`}}], 
   ArrowBox[{{4.9367884556411035`, 2.243994752564138}, {4.87452229882626, 
    2.586082478108631}}], 
   ArrowBox[{{4.9367884556411035`, 2.6927937030769655`}, {4.846811252089642, 
    2.882638068255155}}], 
   ArrowBox[{{4.9367884556411035`, 3.141592653589793}, {4.836921294014376, 
    3.141592653589793}}], 
   ArrowBox[{{4.9367884556411035`, 3.5903916041026207`}, {4.846811252089642, 
    3.4005472389244313`}}], 
   ArrowBox[{{4.9367884556411035`, 4.039190554615448}, {4.87452229882626, 
    3.697102829070955}}], 
   ArrowBox[{{4.9367884556411035`, 4.487989505128276}, {4.914565921564358, 
    4.061413088692194}}], 
   ArrowBox[{{4.9367884556411035`, 4.9367884556411035`}, {4.959010989717849, 
    4.510212039205022}}], 
   ArrowBox[{{4.9367884556411035`, 5.385587406153931}, {4.9990546124559465`, 
    5.043499680609438}}], 
   ArrowBox[{{4.9367884556411035`, 5.834386356666759}, {5.026765659192565, 
    5.64454199148857}}], 
   ArrowBox[{{4.9367884556411035`, 6.283185307179586}, {5.036655617267831, 
    6.283185307179586}}], 
   ArrowBox[{{5.385587406153931, 0.}, {5.665408974883581, 0.}}], 
   ArrowBox[{{5.385587406153931, 0.4487989505128276}, {5.637697928146963, 
    0.6010423108791316}}], 
   ArrowBox[{{5.385587406153931, 0.8975979010256552}, {5.560053300596981, 
    1.171930957095433}}], 
   ArrowBox[{{5.385587406153931, 1.3463968515384828`}, {5.447853562968774, 
    1.688484577082976}}], 
   ArrowBox[{{5.385587406153931, 1.7951958020513104`}, {5.323321249339088, 
    2.1372835275958035`}}], 
   ArrowBox[{{5.385587406153931, 2.243994752564138}, {5.211121511710881, 
    2.5183278086339156`}}], 
   ArrowBox[{{5.385587406153931, 2.6927937030769655`}, {5.133476884160899, 
    2.8450370634432693`}}], 
   ArrowBox[{{5.385587406153931, 3.141592653589793}, {5.105765837424281, 
    3.141592653589793}}], 
   ArrowBox[{{5.385587406153931, 3.5903916041026207`}, {5.133476884160899, 
    3.438148243736317}}], 
   ArrowBox[{{5.385587406153931, 4.039190554615448}, {5.211121511710881, 
    3.7648574985456706`}}], 
   ArrowBox[{{5.385587406153931, 4.487989505128276}, {5.323321249339088, 
    4.145901779583783}}], 
   ArrowBox[{{5.385587406153931, 4.9367884556411035`}, {5.447853562968774, 
    4.59470073009661}}], 
   ArrowBox[{{5.385587406153931, 5.385587406153931}, {5.560053300596981, 
    5.111254350084153}}], 
   ArrowBox[{{5.385587406153931, 5.834386356666759}, {5.637697928146963, 
    5.682142996300454}}], 
   ArrowBox[{{5.385587406153931, 6.283185307179586}, {5.665408974883581, 
    6.283185307179586}}], 
   ArrowBox[{{5.834386356666759, 0.}, {6.238740239026095, 0.}}], 
   ArrowBox[{{5.834386356666759, 0.4487989505128276}, {6.1986966162879975`, 
    0.5332876414044162}}], 
   ArrowBox[{{5.834386356666759, 0.8975979010256552}, {6.086496878659791, 
    1.0498412613919592`}}], 
   ArrowBox[{{5.834386356666759, 1.3463968515384828`}, {5.92436356021822, 
    1.5362412167166721`}}], 
   ArrowBox[{{5.834386356666759, 1.7951958020513104`}, {5.744409153115297, 
    1.9850401672294997`}}], 
   ArrowBox[{{5.834386356666759, 2.243994752564138}, {5.582275834673727, 
    2.3962381129304418`}}], 
   ArrowBox[{{5.834386356666759, 2.6927937030769655`}, {5.47007609704552, 
    2.7772823939685543`}}], 
   ArrowBox[{{5.834386356666759, 3.141592653589793}, {5.430032474307422, 
    3.141592653589793}}], 
   ArrowBox[{{5.834386356666759, 3.5903916041026207`}, {5.47007609704552, 
    3.505902913211032}}], 
   ArrowBox[{{5.834386356666759, 4.039190554615448}, {5.582275834673727, 
    3.8869471942491445`}}], 
   ArrowBox[{{5.834386356666759, 4.487989505128276}, {5.744409153115297, 
    4.298145139950087}}], 
   ArrowBox[{{5.834386356666759, 4.9367884556411035`}, {5.92436356021822, 
    4.7469440904629145`}}], 
   ArrowBox[{{5.834386356666759, 5.385587406153931}, {6.086496878659791, 
    5.233344045787627}}], 
   ArrowBox[{{5.834386356666759, 5.834386356666759}, {6.1986966162879975`, 
    5.74989766577517}}], 
   ArrowBox[{{5.834386356666759, 6.283185307179586}, {6.238740239026095, 
    6.283185307179586}}], 
   ArrowBox[{{6.283185307179586, 0.}, {6.731984257692414, 0.}}], 
   ArrowBox[{{6.283185307179586, 0.4487989505128276}, {6.6875391895389225`, 
    0.4487989505128276}}], 
   ArrowBox[{{6.283185307179586, 0.8975979010256552}, {6.563006875909236, 
    0.8975979010256552}}], 
   ArrowBox[{{6.283185307179586, 1.3463968515384828`}, {6.383052468806314, 
    1.3463968515384828`}}], 
   ArrowBox[{{6.283185307179586, 1.7951958020513104`}, {6.1833181455528585`, 
    1.7951958020513104`}}], 
   ArrowBox[{{6.283185307179586, 2.243994752564138}, {6.003363738449936, 
    2.243994752564138}}], 
   ArrowBox[{{6.283185307179586, 2.6927937030769655`}, {5.87883142482025, 
    2.6927937030769655`}}], 
   ArrowBox[{{6.283185307179586, 3.141592653589793}, {5.834386356666759, 
    3.141592653589793}}], 
   ArrowBox[{{6.283185307179586, 3.5903916041026207`}, {5.87883142482025, 
    3.5903916041026207`}}], 
   ArrowBox[{{6.283185307179586, 4.039190554615448}, {6.003363738449936, 
    4.039190554615448}}], 
   ArrowBox[{{6.283185307179586, 4.487989505128276}, {6.1833181455528585`, 
    4.487989505128276}}], 
   ArrowBox[{{6.283185307179586, 4.9367884556411035`}, {6.383052468806314, 
    4.9367884556411035`}}], 
   ArrowBox[{{6.283185307179586, 5.385587406153931}, {6.563006875909236, 
    5.385587406153931}}], 
   ArrowBox[{{6.283185307179586, 5.834386356666759}, {6.6875391895389225`, 
    5.834386356666759}}], 
   ArrowBox[{{6.283185307179586, 6.283185307179586}, {6.731984257692414, 
    6.283185307179586}}]}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1089498291]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->147790178],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HamiltonianFieldPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorFieldPlots/ref/HamiltonianFieldPlot"]], 
  "InlineFormula"],
 " contains the functionality of ",
 Cell[BoxData["PlotHamiltonianField"], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->1994590575],

Cell[BoxData[
 RowBox[{"PlotHamiltonianField", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], 
    RowBox[{"Cos", "[", "y", "]"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input", "LegacyInput",
 CellLabel->"In[1]:=",
 CellID->864064355],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HamiltonianFieldPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], 
    RowBox[{"Cos", "[", "y", "]"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1045193471],

Cell[BoxData[
 GraphicsBox[
  {Thickness[Small], Arrowheads[0.02], 
   ArrowBox[{{0., 0.}, {0., -0.4487989505128276}}], 
   ArrowBox[{{0., 0.4487989505128276}, {0., 0.044445068153491474`}}], 
   ArrowBox[{{0., 0.8975979010256552}, {0., 0.6177763322960048}}], 
   ArrowBox[{{0., 1.3463968515384828`}, {0., 1.2465296899117546`}}], 
   ArrowBox[{{0., 1.7951958020513104`}, {0., 1.8950629636780385`}}], 
   ArrowBox[{{0., 2.243994752564138}, {0., 2.5238163212937885`}}], 
   ArrowBox[{{0., 2.6927937030769655`}, {0., 3.0971475854363018`}}], 
   ArrowBox[{{0., 3.141592653589793}, {0., 3.5903916041026207`}}], 
   ArrowBox[{{0., 3.5903916041026207`}, {0., 3.994745486461957}}], 
   ArrowBox[{{0., 4.039190554615448}, {0., 4.319012123345098}}], 
   ArrowBox[{{0., 4.487989505128276}, {0., 4.587856666755004}}], 
   ArrowBox[{{0., 4.9367884556411035`}, {0., 4.836921294014376}}], 
   ArrowBox[{{0., 5.385587406153931}, {0., 5.105765837424281}}], 
   ArrowBox[{{0., 5.834386356666759}, {0., 5.430032474307422}}], 
   ArrowBox[{{0., 6.283185307179586}, {0., 5.834386356666759}}], 
   ArrowBox[{{0.4487989505128276, 0.}, {
    0.4487989505128276, -0.4043538823593361}}], 
   ArrowBox[{{0.4487989505128276, 0.4487989505128276}, {0.36431025962123903`, 
    0.08448869089158856}}], 
   ArrowBox[{{0.4487989505128276, 0.8975979010256552}, {0.2965555901465236, 
    0.6454873790326231}}], 
   ArrowBox[{{0.4487989505128276, 1.3463968515384828`}, {0.25895458533463833`,
     1.2564196479870215`}}], 
   ArrowBox[{{0.4487989505128276, 1.7951958020513104`}, {0.25895458533463833`,
     1.8851730056027716`}}], 
   ArrowBox[{{0.4487989505128276, 2.243994752564138}, {0.2965555901465236, 
    2.49610527455717}}], 
   ArrowBox[{{0.4487989505128276, 2.6927937030769655`}, {0.36431025962123903`,
     3.0571039626982044`}}], 
   ArrowBox[{{0.4487989505128276, 3.141592653589793}, {0.4487989505128276, 
    3.5459465359491293`}}], 
   ArrowBox[{{0.4487989505128276, 3.5903916041026207`}, {0.5332876414044162, 
    3.9547018637238596`}}], 
   ArrowBox[{{0.4487989505128276, 4.039190554615448}, {0.6010423108791316, 
    4.29130107660848}}], 
   ArrowBox[{{0.4487989505128276, 4.487989505128276}, {0.6386433156910168, 
    4.577966708679737}}], 
   ArrowBox[{{0.4487989505128276, 4.9367884556411035`}, {0.6386433156910168, 
    4.846811252089642}}], 
   ArrowBox[{{0.4487989505128276, 5.385587406153931}, {0.6010423108791316, 
    5.133476884160899}}], 
   ArrowBox[{{0.4487989505128276, 5.834386356666759}, {0.5332876414044162, 
    5.47007609704552}}], 
   ArrowBox[{{0.4487989505128276, 6.283185307179586}, {0.4487989505128276, 
    5.87883142482025}}], 
   ArrowBox[{{0.8975979010256552, 0.}, {
    0.8975979010256552, -0.2798215687296504}}], 
   ArrowBox[{{0.8975979010256552, 0.4487989505128276}, {0.7453545406593511, 
    0.1966884285197955}}], 
   ArrowBox[{{0.8975979010256552, 0.8975979010256552}, {0.6232648449558773, 
    0.7231320065826055}}], 
   ArrowBox[{{0.8975979010256552, 1.3463968515384828`}, {0.555510175481162, 
    1.28413069472364}}], 
   ArrowBox[{{0.8975979010256552, 1.7951958020513104`}, {0.555510175481162, 
    1.8574619588661532`}}], 
   ArrowBox[{{0.8975979010256552, 2.243994752564138}, {0.6232648449558773, 
    2.4184606470071874`}}], 
   ArrowBox[{{0.8975979010256552, 2.6927937030769655`}, {0.7453545406593511, 
    2.9449042250699975`}}], 
   ArrowBox[{{0.8975979010256552, 3.141592653589793}, {0.8975979010256552, 
    3.4214142223194437`}}], 
   ArrowBox[{{0.8975979010256552, 3.5903916041026207`}, {1.0498412613919592`, 
    3.8425021260956527`}}], 
   ArrowBox[{{0.8975979010256552, 4.039190554615448}, {1.171930957095433, 
    4.213656449058498}}], 
   ArrowBox[{{0.8975979010256552, 4.487989505128276}, {1.2396856265701484`, 
    4.550255661943119}}], 
   ArrowBox[{{0.8975979010256552, 4.9367884556411035`}, {1.2396856265701484`, 
    4.87452229882626}}], 
   ArrowBox[{{0.8975979010256552, 5.385587406153931}, {1.171930957095433, 
    5.211121511710881}}], 
   ArrowBox[{{0.8975979010256552, 5.834386356666759}, {1.0498412613919592`, 
    5.582275834673727}}], 
   ArrowBox[{{0.8975979010256552, 6.283185307179586}, {0.8975979010256552, 
    6.003363738449936}}], 
   ArrowBox[{{1.3463968515384828`, 0.}, {
    1.3463968515384828`, -0.09986716162672812}}], 
   ArrowBox[{{1.3463968515384828`, 0.4487989505128276}, {1.1565524863602934`, 
    0.35882174696136643`}}], 
   ArrowBox[{{1.3463968515384828`, 0.8975979010256552}, {1.0043091259939896`, 
    0.8353317442108124}}], 
   ArrowBox[{{1.3463968515384828`, 1.3463968515384828`}, {0.9198204351024009, 
    1.324174317461737}}], 
   ArrowBox[{{1.3463968515384828`, 1.7951958020513104`}, {0.9198204351024009, 
    1.817418336128056}}], 
   ArrowBox[{{1.3463968515384828`, 2.243994752564138}, {1.0043091259939896`, 
    2.306260909378981}}], 
   ArrowBox[{{1.3463968515384828`, 2.6927937030769655`}, {1.1565524863602934`,
     2.7827709066284267`}}], 
   ArrowBox[{{1.3463968515384828`, 3.141592653589793}, {1.3463968515384828`, 
    3.2414598152165213`}}], 
   ArrowBox[{{1.3463968515384828`, 3.5903916041026207`}, {1.5362412167166721`,
     3.680368807654082}}], 
   ArrowBox[{{1.3463968515384828`, 4.039190554615448}, {1.688484577082976, 
    4.101456711430291}}], 
   ArrowBox[{{1.3463968515384828`, 4.487989505128276}, {1.7729732679745647`, 
    4.510212039205022}}], 
   ArrowBox[{{1.3463968515384828`, 4.9367884556411035`}, {1.7729732679745647`,
     4.914565921564358}}], 
   ArrowBox[{{1.3463968515384828`, 5.385587406153931}, {1.688484577082976, 
    5.323321249339088}}], 
   ArrowBox[{{1.3463968515384828`, 5.834386356666759}, {1.5362412167166721`, 
    5.744409153115297}}], 
   ArrowBox[{{1.3463968515384828`, 6.283185307179586}, {1.3463968515384828`, 
    6.1833181455528585`}}], 
   ArrowBox[{{1.7951958020513104`, 0.}, {1.7951958020513104`, 
    0.09986716162672812}}], 
   ArrowBox[{{1.7951958020513104`, 0.4487989505128276}, {1.605351436873121, 
    0.5387761540642887}}], 
   ArrowBox[{{1.7951958020513104`, 0.8975979010256552}, {1.4531080765068172`, 
    0.959864057840498}}], 
   ArrowBox[{{1.7951958020513104`, 1.3463968515384828`}, {1.3686193856152284`,
     1.3686193856152284`}}], 
   ArrowBox[{{1.7951958020513104`, 1.7951958020513104`}, {1.3686193856152284`,
     1.7729732679745647`}}], 
   ArrowBox[{{1.7951958020513104`, 2.243994752564138}, {1.4531080765068172`, 
    2.181728595749295}}], 
   ArrowBox[{{1.7951958020513104`, 2.6927937030769655`}, {1.605351436873121, 
    2.6028164995255043`}}], 
   ArrowBox[{{1.7951958020513104`, 3.141592653589793}, {1.7951958020513104`, 
    3.041725491963065}}], 
   ArrowBox[{{1.7951958020513104`, 3.5903916041026207`}, {1.9850401672294997`,
     3.5004144005511595`}}], 
   ArrowBox[{{1.7951958020513104`, 4.039190554615448}, {2.1372835275958035`, 
    3.9769243978006052`}}], 
   ArrowBox[{{1.7951958020513104`, 4.487989505128276}, {2.2217722184873923`, 
    4.46576697105153}}], 
   ArrowBox[{{1.7951958020513104`, 4.9367884556411035`}, {2.2217722184873923`,
     4.959010989717849}}], 
   ArrowBox[{{1.7951958020513104`, 5.385587406153931}, {2.1372835275958035`, 
    5.447853562968774}}], 
   ArrowBox[{{1.7951958020513104`, 5.834386356666759}, {1.9850401672294997`, 
    5.92436356021822}}], 
   ArrowBox[{{1.7951958020513104`, 6.283185307179586}, {1.7951958020513104`, 
    6.383052468806314}}], 
   ArrowBox[{{2.243994752564138, 0.}, {2.243994752564138, 
    0.2798215687296504}}], 
   ArrowBox[{{2.243994752564138, 0.4487989505128276}, {2.091751392197834, 
    0.7009094725058597}}], 
   ArrowBox[{{2.243994752564138, 0.8975979010256552}, {1.96966169649436, 
    1.072063795468705}}], 
   ArrowBox[{{2.243994752564138, 1.3463968515384828`}, {1.9019070270196448`, 
    1.4086630083533256`}}], 
   ArrowBox[{{2.243994752564138, 1.7951958020513104`}, {1.9019070270196448`, 
    1.7329296452364675`}}], 
   ArrowBox[{{2.243994752564138, 2.243994752564138}, {1.96966169649436, 
    2.0695288581210884`}}], 
   ArrowBox[{{2.243994752564138, 2.6927937030769655`}, {2.091751392197834, 
    2.4406831810839336`}}], 
   ArrowBox[{{2.243994752564138, 3.141592653589793}, {2.243994752564138, 
    2.8617710848601425`}}], 
   ArrowBox[{{2.243994752564138, 3.5903916041026207`}, {2.3962381129304418`, 
    3.3382810821095887`}}], 
   ArrowBox[{{2.243994752564138, 4.039190554615448}, {2.5183278086339156`, 
    3.864724660172399}}], 
   ArrowBox[{{2.243994752564138, 4.487989505128276}, {2.586082478108631, 
    4.425723348313433}}], 
   ArrowBox[{{2.243994752564138, 4.9367884556411035`}, {2.586082478108631, 
    4.9990546124559465`}}], 
   ArrowBox[{{2.243994752564138, 5.385587406153931}, {2.5183278086339156`, 
    5.560053300596981}}], 
   ArrowBox[{{2.243994752564138, 5.834386356666759}, {2.3962381129304418`, 
    6.086496878659791}}], 
   ArrowBox[{{2.243994752564138, 6.283185307179586}, {2.243994752564138, 
    6.563006875909236}}], 
   ArrowBox[{{2.6927937030769655`, 0.}, {2.6927937030769655`, 
    0.4043538823593361}}], 
   ArrowBox[{{2.6927937030769655`, 0.4487989505128276}, {2.608305012185377, 
    0.8131092101340667}}], 
   ArrowBox[{{2.6927937030769655`, 0.8975979010256552}, {2.5405503427106617`, 
    1.1497084230186871`}}], 
   ArrowBox[{{2.6927937030769655`, 1.3463968515384828`}, {2.502949337898776, 
    1.436374055089944}}], 
   ArrowBox[{{2.6927937030769655`, 1.7951958020513104`}, {2.502949337898776, 
    1.7052185984998491`}}], 
   ArrowBox[{{2.6927937030769655`, 2.243994752564138}, {2.5405503427106617`, 
    1.991884230571106}}], 
   ArrowBox[{{2.6927937030769655`, 2.6927937030769655`}, {2.608305012185377, 
    2.3284834434557267`}}], 
   ArrowBox[{{2.6927937030769655`, 3.141592653589793}, {2.6927937030769655`, 
    2.737238771230457}}], 
   ArrowBox[{{2.6927937030769655`, 3.5903916041026207`}, {2.7772823939685543`,
     3.226081344481382}}], 
   ArrowBox[{{2.6927937030769655`, 4.039190554615448}, {2.8450370634432693`, 
    3.7870800326224163`}}], 
   ArrowBox[{{2.6927937030769655`, 4.487989505128276}, {2.882638068255155, 
    4.398012301576815}}], 
   ArrowBox[{{2.6927937030769655`, 4.9367884556411035`}, {2.882638068255155, 
    5.026765659192565}}], 
   ArrowBox[{{2.6927937030769655`, 5.385587406153931}, {2.8450370634432693`, 
    5.637697928146963}}], 
   ArrowBox[{{2.6927937030769655`, 5.834386356666759}, {2.7772823939685543`, 
    6.1986966162879975`}}], 
   ArrowBox[{{2.6927937030769655`, 6.283185307179586}, {2.6927937030769655`, 
    6.6875391895389225`}}], 
   ArrowBox[{{3.141592653589793, 0.}, {3.141592653589793, 
    0.4487989505128276}}], 
   ArrowBox[{{3.141592653589793, 0.4487989505128276}, {3.141592653589793, 
    0.8531528328721637}}], 
   ArrowBox[{{3.141592653589793, 0.8975979010256552}, {3.141592653589793, 
    1.1774194697553055`}}], 
   ArrowBox[{{3.141592653589793, 1.3463968515384828`}, {3.141592653589793, 
    1.446264013165211}}], 
   ArrowBox[{{3.141592653589793, 1.7951958020513104`}, {3.141592653589793, 
    1.6953286404245822`}}], 
   ArrowBox[{{3.141592653589793, 2.243994752564138}, {3.141592653589793, 
    1.9641731838344876`}}], 
   ArrowBox[{{3.141592653589793, 2.6927937030769655`}, {3.141592653589793, 
    2.2884398207176293`}}], 
   ArrowBox[{{3.141592653589793, 3.141592653589793}, {3.141592653589793, 
    2.6927937030769655`}}], 
   ArrowBox[{{3.141592653589793, 3.5903916041026207`}, {3.141592653589793, 
    3.1860377217432845`}}], 
   ArrowBox[{{3.141592653589793, 4.039190554615448}, {3.141592653589793, 
    3.7593689858857977`}}], 
   ArrowBox[{{3.141592653589793, 4.487989505128276}, {3.141592653589793, 
    4.388122343501548}}], 
   ArrowBox[{{3.141592653589793, 4.9367884556411035`}, {3.141592653589793, 
    5.036655617267831}}], 
   ArrowBox[{{3.141592653589793, 5.385587406153931}, {3.141592653589793, 
    5.665408974883581}}], 
   ArrowBox[{{3.141592653589793, 5.834386356666759}, {3.141592653589793, 
    6.238740239026095}}], 
   ArrowBox[{{3.141592653589793, 6.283185307179586}, {3.141592653589793, 
    6.731984257692414}}], 
   ArrowBox[{{3.5903916041026207`, 0.}, {3.5903916041026207`, 
    0.4043538823593361}}], 
   ArrowBox[{{3.5903916041026207`, 0.4487989505128276}, {3.6748802949942094`, 
    0.8131092101340667}}], 
   ArrowBox[{{3.5903916041026207`, 0.8975979010256552}, {3.7426349644689245`, 
    1.1497084230186871`}}], 
   ArrowBox[{{3.5903916041026207`, 1.3463968515384828`}, {3.78023596928081, 
    1.436374055089944}}], 
   ArrowBox[{{3.5903916041026207`, 1.7951958020513104`}, {3.78023596928081, 
    1.7052185984998491`}}], 
   ArrowBox[{{3.5903916041026207`, 2.243994752564138}, {3.7426349644689245`, 
    1.991884230571106}}], 
   ArrowBox[{{3.5903916041026207`, 2.6927937030769655`}, {3.6748802949942094`,
     2.3284834434557267`}}], 
   ArrowBox[{{3.5903916041026207`, 3.141592653589793}, {3.5903916041026207`, 
    2.737238771230457}}], 
   ArrowBox[{{3.5903916041026207`, 3.5903916041026207`}, {3.505902913211032, 
    3.226081344481382}}], 
   ArrowBox[{{3.5903916041026207`, 4.039190554615448}, {3.438148243736317, 
    3.7870800326224163`}}], 
   ArrowBox[{{3.5903916041026207`, 4.487989505128276}, {3.4005472389244313`, 
    4.398012301576815}}], 
   ArrowBox[{{3.5903916041026207`, 4.9367884556411035`}, {3.4005472389244313`,
     5.026765659192565}}], 
   ArrowBox[{{3.5903916041026207`, 5.385587406153931}, {3.438148243736317, 
    5.637697928146963}}], 
   ArrowBox[{{3.5903916041026207`, 5.834386356666759}, {3.505902913211032, 
    6.1986966162879975`}}], 
   ArrowBox[{{3.5903916041026207`, 6.283185307179586}, {3.5903916041026207`, 
    6.6875391895389225`}}], 
   ArrowBox[{{4.039190554615448, 0.}, {4.039190554615448, 
    0.2798215687296504}}], 
   ArrowBox[{{4.039190554615448, 0.4487989505128276}, {4.1914339149817526`, 
    0.7009094725058597}}], 
   ArrowBox[{{4.039190554615448, 0.8975979010256552}, {4.313523610685226, 
    1.072063795468705}}], 
   ArrowBox[{{4.039190554615448, 1.3463968515384828`}, {4.3812782801599415`, 
    1.4086630083533256`}}], 
   ArrowBox[{{4.039190554615448, 1.7951958020513104`}, {4.3812782801599415`, 
    1.7329296452364675`}}], 
   ArrowBox[{{4.039190554615448, 2.243994752564138}, {4.313523610685226, 
    2.0695288581210884`}}], 
   ArrowBox[{{4.039190554615448, 2.6927937030769655`}, {4.1914339149817526`, 
    2.4406831810839336`}}], 
   ArrowBox[{{4.039190554615448, 3.141592653589793}, {4.039190554615448, 
    2.8617710848601425`}}], 
   ArrowBox[{{4.039190554615448, 3.5903916041026207`}, {3.8869471942491445`, 
    3.3382810821095887`}}], 
   ArrowBox[{{4.039190554615448, 4.039190554615448}, {3.7648574985456706`, 
    3.864724660172399}}], 
   ArrowBox[{{4.039190554615448, 4.487989505128276}, {3.697102829070955, 
    4.425723348313433}}], 
   ArrowBox[{{4.039190554615448, 4.9367884556411035`}, {3.697102829070955, 
    4.9990546124559465`}}], 
   ArrowBox[{{4.039190554615448, 5.385587406153931}, {3.7648574985456706`, 
    5.560053300596981}}], 
   ArrowBox[{{4.039190554615448, 5.834386356666759}, {3.8869471942491445`, 
    6.086496878659791}}], 
   ArrowBox[{{4.039190554615448, 6.283185307179586}, {4.039190554615448, 
    6.563006875909236}}], 
   ArrowBox[{{4.487989505128276, 0.}, {4.487989505128276, 
    0.09986716162672812}}], 
   ArrowBox[{{4.487989505128276, 0.4487989505128276}, {4.677833870306465, 
    0.5387761540642887}}], 
   ArrowBox[{{4.487989505128276, 0.8975979010256552}, {4.830077230672769, 
    0.959864057840498}}], 
   ArrowBox[{{4.487989505128276, 1.3463968515384828`}, {4.914565921564358, 
    1.3686193856152284`}}], 
   ArrowBox[{{4.487989505128276, 1.7951958020513104`}, {4.914565921564358, 
    1.7729732679745647`}}], 
   ArrowBox[{{4.487989505128276, 2.243994752564138}, {4.830077230672769, 
    2.181728595749295}}], 
   ArrowBox[{{4.487989505128276, 2.6927937030769655`}, {4.677833870306465, 
    2.6028164995255043`}}], 
   ArrowBox[{{4.487989505128276, 3.141592653589793}, {4.487989505128276, 
    3.041725491963065}}], 
   ArrowBox[{{4.487989505128276, 3.5903916041026207`}, {4.298145139950087, 
    3.5004144005511595`}}], 
   ArrowBox[{{4.487989505128276, 4.039190554615448}, {4.145901779583783, 
    3.9769243978006052`}}], 
   ArrowBox[{{4.487989505128276, 4.487989505128276}, {4.061413088692194, 
    4.46576697105153}}], 
   ArrowBox[{{4.487989505128276, 4.9367884556411035`}, {4.061413088692194, 
    4.959010989717849}}], 
   ArrowBox[{{4.487989505128276, 5.385587406153931}, {4.145901779583783, 
    5.447853562968774}}], 
   ArrowBox[{{4.487989505128276, 5.834386356666759}, {4.298145139950087, 
    5.92436356021822}}], 
   ArrowBox[{{4.487989505128276, 6.283185307179586}, {4.487989505128276, 
    6.383052468806314}}], 
   ArrowBox[{{4.9367884556411035`, 0.}, {
    4.9367884556411035`, -0.09986716162672812}}], 
   ArrowBox[{{4.9367884556411035`, 0.4487989505128276}, {5.126632820819292, 
    0.35882174696136643`}}], 
   ArrowBox[{{4.9367884556411035`, 0.8975979010256552}, {5.278876181185597, 
    0.8353317442108124}}], 
   ArrowBox[{{4.9367884556411035`, 1.3463968515384828`}, {5.363364872077185, 
    1.324174317461737}}], 
   ArrowBox[{{4.9367884556411035`, 1.7951958020513104`}, {5.363364872077185, 
    1.817418336128056}}], 
   ArrowBox[{{4.9367884556411035`, 2.243994752564138}, {5.278876181185597, 
    2.306260909378981}}], 
   ArrowBox[{{4.9367884556411035`, 2.6927937030769655`}, {5.126632820819292, 
    2.7827709066284267`}}], 
   ArrowBox[{{4.9367884556411035`, 3.141592653589793}, {4.9367884556411035`, 
    3.2414598152165213`}}], 
   ArrowBox[{{4.9367884556411035`, 3.5903916041026207`}, {4.7469440904629145`,
     3.680368807654082}}], 
   ArrowBox[{{4.9367884556411035`, 4.039190554615448}, {4.59470073009661, 
    4.101456711430291}}], 
   ArrowBox[{{4.9367884556411035`, 4.487989505128276}, {4.510212039205022, 
    4.510212039205022}}], 
   ArrowBox[{{4.9367884556411035`, 4.9367884556411035`}, {4.510212039205022, 
    4.914565921564358}}], 
   ArrowBox[{{4.9367884556411035`, 5.385587406153931}, {4.59470073009661, 
    5.323321249339088}}], 
   ArrowBox[{{4.9367884556411035`, 5.834386356666759}, {4.7469440904629145`, 
    5.744409153115297}}], 
   ArrowBox[{{4.9367884556411035`, 6.283185307179586}, {4.9367884556411035`, 
    6.1833181455528585`}}], 
   ArrowBox[{{5.385587406153931, 0.}, {
    5.385587406153931, -0.2798215687296504}}], 
   ArrowBox[{{5.385587406153931, 0.4487989505128276}, {5.537830766520235, 
    0.1966884285197955}}], 
   ArrowBox[{{5.385587406153931, 0.8975979010256552}, {5.659920462223709, 
    0.7231320065826055}}], 
   ArrowBox[{{5.385587406153931, 1.3463968515384828`}, {5.727675131698424, 
    1.28413069472364}}], 
   ArrowBox[{{5.385587406153931, 1.7951958020513104`}, {5.727675131698424, 
    1.8574619588661532`}}], 
   ArrowBox[{{5.385587406153931, 2.243994752564138}, {5.659920462223709, 
    2.4184606470071874`}}], 
   ArrowBox[{{5.385587406153931, 2.6927937030769655`}, {5.537830766520235, 
    2.9449042250699975`}}], 
   ArrowBox[{{5.385587406153931, 3.141592653589793}, {5.385587406153931, 
    3.4214142223194437`}}], 
   ArrowBox[{{5.385587406153931, 3.5903916041026207`}, {5.233344045787627, 
    3.8425021260956527`}}], 
   ArrowBox[{{5.385587406153931, 4.039190554615448}, {5.111254350084153, 
    4.213656449058498}}], 
   ArrowBox[{{5.385587406153931, 4.487989505128276}, {5.043499680609438, 
    4.550255661943119}}], 
   ArrowBox[{{5.385587406153931, 4.9367884556411035`}, {5.043499680609438, 
    4.87452229882626}}], 
   ArrowBox[{{5.385587406153931, 5.385587406153931}, {5.111254350084153, 
    5.211121511710881}}], 
   ArrowBox[{{5.385587406153931, 5.834386356666759}, {5.233344045787627, 
    5.582275834673727}}], 
   ArrowBox[{{5.385587406153931, 6.283185307179586}, {5.385587406153931, 
    6.003363738449936}}], 
   ArrowBox[{{5.834386356666759, 0.}, {
    5.834386356666759, -0.4043538823593361}}], 
   ArrowBox[{{5.834386356666759, 0.4487989505128276}, {5.918875047558347, 
    0.08448869089158856}}], 
   ArrowBox[{{5.834386356666759, 0.8975979010256552}, {5.986629717033063, 
    0.6454873790326231}}], 
   ArrowBox[{{5.834386356666759, 1.3463968515384828`}, {6.024230721844948, 
    1.2564196479870215`}}], 
   ArrowBox[{{5.834386356666759, 1.7951958020513104`}, {6.024230721844948, 
    1.8851730056027716`}}], 
   ArrowBox[{{5.834386356666759, 2.243994752564138}, {5.986629717033063, 
    2.49610527455717}}], 
   ArrowBox[{{5.834386356666759, 2.6927937030769655`}, {5.918875047558347, 
    3.0571039626982044`}}], 
   ArrowBox[{{5.834386356666759, 3.141592653589793}, {5.834386356666759, 
    3.5459465359491293`}}], 
   ArrowBox[{{5.834386356666759, 3.5903916041026207`}, {5.74989766577517, 
    3.9547018637238596`}}], 
   ArrowBox[{{5.834386356666759, 4.039190554615448}, {5.682142996300454, 
    4.29130107660848}}], 
   ArrowBox[{{5.834386356666759, 4.487989505128276}, {5.64454199148857, 
    4.577966708679737}}], 
   ArrowBox[{{5.834386356666759, 4.9367884556411035`}, {5.64454199148857, 
    4.846811252089642}}], 
   ArrowBox[{{5.834386356666759, 5.385587406153931}, {5.682142996300454, 
    5.133476884160899}}], 
   ArrowBox[{{5.834386356666759, 5.834386356666759}, {5.74989766577517, 
    5.47007609704552}}], 
   ArrowBox[{{5.834386356666759, 6.283185307179586}, {5.834386356666759, 
    5.87883142482025}}], 
   ArrowBox[{{6.283185307179586, 0.}, {
    6.283185307179586, -0.4487989505128276}}], 
   ArrowBox[{{6.283185307179586, 0.4487989505128276}, {6.283185307179586, 
    0.044445068153491474`}}], 
   ArrowBox[{{6.283185307179586, 0.8975979010256552}, {6.283185307179586, 
    0.6177763322960048}}], 
   ArrowBox[{{6.283185307179586, 1.3463968515384828`}, {6.283185307179586, 
    1.2465296899117546`}}], 
   ArrowBox[{{6.283185307179586, 1.7951958020513104`}, {6.283185307179586, 
    1.8950629636780385`}}], 
   ArrowBox[{{6.283185307179586, 2.243994752564138}, {6.283185307179586, 
    2.5238163212937885`}}], 
   ArrowBox[{{6.283185307179586, 2.6927937030769655`}, {6.283185307179586, 
    3.0971475854363018`}}], 
   ArrowBox[{{6.283185307179586, 3.141592653589793}, {6.283185307179586, 
    3.5903916041026207`}}], 
   ArrowBox[{{6.283185307179586, 3.5903916041026207`}, {6.283185307179586, 
    3.994745486461957}}], 
   ArrowBox[{{6.283185307179586, 4.039190554615448}, {6.283185307179586, 
    4.319012123345098}}], 
   ArrowBox[{{6.283185307179586, 4.487989505128276}, {6.283185307179586, 
    4.587856666755004}}], 
   ArrowBox[{{6.283185307179586, 4.9367884556411035`}, {6.283185307179586, 
    4.836921294014376}}], 
   ArrowBox[{{6.283185307179586, 5.385587406153931}, {6.283185307179586, 
    5.105765837424281}}], 
   ArrowBox[{{6.283185307179586, 5.834386356666759}, {6.283185307179586, 
    5.430032474307422}}], 
   ArrowBox[{{6.283185307179586, 6.283185307179586}, {6.283185307179586, 
    5.834386356666759}}]}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1420237512]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1723924386],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PolyaFieldPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:VectorFieldPlots/ref/PolyaFieldPlot"]], 
  "InlineFormula"],
 " contains the functionality of ",
 Cell[BoxData["PlotPolyaField"], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->766691540],

Cell[BoxData[
 RowBox[{"PlotPolyaField", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "+", 
     RowBox[{"I", "*", "y"}]}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input", "LegacyInput",
 CellLabel->"In[1]:=",
 CellID->882830780],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyaFieldPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "+", 
     RowBox[{"I", "*", "y"}]}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", " ", "0", ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->772402337],

Cell[BoxData[
 GraphicsBox[
  {Thickness[Small], Arrowheads[0.02], PointBox[{0., 0.}], 
   ArrowBox[{{0., 0.4487989505128276}, {0., 0.4182157821494634}}], 
   ArrowBox[{{0., 0.8975979010256552}, {0., 0.8410648917111329}}], 
   ArrowBox[{{0., 1.3463968515384828`}, {0., 1.2640270224882848`}}], 
   ArrowBox[{{0., 1.7951958020513104`}, {0., 1.6854427701857373`}}], 
   ArrowBox[{{0., 2.243994752564138}, {0., 2.1048840962112365`}}], 
   ArrowBox[{{0., 2.6927937030769655`}, {0., 2.5224955757360004`}}], 
   ArrowBox[{{0., 3.141592653589793}, {0., 2.9386363180127346`}}], 
   ArrowBox[{{0., 3.5903916041026207`}, {0., 3.3536889642715186`}}], 
   ArrowBox[{{0., 4.039190554615448}, {0., 3.76797763539934}}], 
   ArrowBox[{{0., 4.487989505128276}, {0., 4.18174771887556}}], 
   ArrowBox[{{0., 4.9367884556411035`}, {0., 4.595173401808433}}], 
   ArrowBox[{{0., 5.385587406153931}, {0., 5.008373574843063}}], 
   ArrowBox[{{0., 5.834386356666759}, {0., 5.4214274249252705`}}], 
   ArrowBox[{{0., 6.283185307179586}, {0., 5.8343868865717505`}}], 
   ArrowBox[{{0.4487989505128276, 0.}, {0.47771347154372373`, 0.}}], 
   ArrowBox[{{0.4487989505128276, 0.4487989505128276}, {0.4785088962901015, 
    0.42283153100977644`}}], 
   ArrowBox[{{0.4487989505128276, 0.8975979010256552}, {0.4822889139501606, 
    0.8478661451257027}}], 
   ArrowBox[{{0.4487989505128276, 1.3463968515384828`}, {0.4892900353907903, 
    1.272977655362021}}], 
   ArrowBox[{{0.4487989505128276, 1.7951958020513104`}, {0.49887228066313, 
    1.696800449911704}}], 
   ArrowBox[{{0.4487989505128276, 2.243994752564138}, {0.5103897931076432, 
    2.118943973187228}}], 
   ArrowBox[{{0.4487989505128276, 2.6927937030769655`}, {0.5232929679413986, 
    2.5395164263607506`}}], 
   ArrowBox[{{0.4487989505128276, 3.141592653589793}, {0.5371482608673265, 
    2.958817342304696}}], 
   ArrowBox[{{0.4487989505128276, 3.5903916041026207`}, {0.5516367927199326, 
    3.377171423196496}}], 
   ArrowBox[{{0.4487989505128276, 4.039190554615448}, {0.5665370216094979, 
    3.794856549328011}}], 
   ArrowBox[{{0.4487989505128276, 4.487989505128276}, {0.5817011733673795, 
    4.212084958791566}}], 
   ArrowBox[{{0.4487989505128276, 4.9367884556411035`}, {0.5970332305765494, 
    4.629008515506703}}], 
   ArrowBox[{{0.4487989505128276, 5.385587406153931}, {0.6124717497536165, 
    5.045731608072128}}], 
   ArrowBox[{{0.4487989505128276, 5.834386356666759}, {0.6279777165547127, 
    5.462324182620645}}], 
   ArrowBox[{{0.4487989505128276, 6.283185307179586}, {0.6435264353715333, 
    5.878832338614072}}], 
   ArrowBox[{{0.8975979010256552, 0.}, {0.9439432195784505, 0.}}], 
   ArrowBox[{{0.8975979010256552, 0.4487989505128276}, {0.9467839875794902, 
    0.432288877497054}}], 
   ArrowBox[{{0.8975979010256552, 0.8975979010256552}, {0.9552710262817304, 
    0.8647072556356372}}], 
   ArrowBox[{{0.8975979010256552, 1.3463968515384828`}, {0.9689331693035304, 
    1.2967222604611537`}}], 
   ArrowBox[{{0.8975979010256552, 1.7951958020513104`}, {0.9868559968683818, 
    1.7278368198760845`}}], 
   ArrowBox[{{0.8975979010256552, 2.243994752564138}, {1.0080240141830241`, 
    2.1578910488985668`}}], 
   ArrowBox[{{0.8975979010256552, 2.6927937030769655`}, {1.0315264818672347`, 
    2.5869635472023}}], 
   ArrowBox[{{0.8975979010256552, 3.141592653589793}, {1.056637768255632, 
    3.015235404506129}}], 
   ArrowBox[{{0.8975979010256552, 3.5903916041026207`}, {1.082824287838554, 
    3.442903159203244}}], 
   ArrowBox[{{0.8975979010256552, 4.039190554615448}, {1.1097148088337612`, 
    3.8701378689226145`}}], 
   ArrowBox[{{0.8975979010256552, 4.487989505128276}, {1.1370603822731118`, 
    4.297072822401795}}], 
   ArrowBox[{{0.8975979010256552, 4.9367884556411035`}, {1.164697897571073, 
    4.723805262344828}}], 
   ArrowBox[{{0.8975979010256552, 5.385587406153931}, {1.1925219596603, 
    5.150403193751965}}], 
   ArrowBox[{{0.8975979010256552, 5.834386356666759}, {1.2204649951542343`, 
    5.576912847340701}}], 
   ArrowBox[{{0.8975979010256552, 6.283185307179586}, {1.2484838533394047`, 
    6.003365049341592}}], 
   ArrowBox[{{1.3463968515384828`, 0.}, {1.4009972455301871`, 0.}}], 
   ArrowBox[{{1.3463968515384828`, 0.4487989505128276}, {1.4048761267884424`, 
    0.4431808322667151}}], 
   ArrowBox[{{1.3463968515384828`, 0.8975979010256552}, {1.416154784080737, 
    0.8862118092567247}}], 
   ArrowBox[{{1.3463968515384828`, 1.3463968515384828`}, {1.4338765701152771`,
     1.3289619480037924`}}], 
   ArrowBox[{{1.3463968515384828`, 1.7951958020513104`}, {1.4567709003315847`,
     1.771356307562438}}], 
   ArrowBox[{{1.3463968515384828`, 2.243994752564138}, {1.4835498513095748`, 
    2.213386571110192}}], 
   ArrowBox[{{1.3463968515384828`, 2.6927937030769655`}, {1.5131005786741807`,
     2.6550917673700103`}}], 
   ArrowBox[{{1.3463968515384828`, 3.141592653589793}, {1.5445567956050483`, 
    3.0965325486699506`}}], 
   ArrowBox[{{1.3463968515384828`, 3.5903916041026207`}, {1.577289496022695, 
    3.5377720202530156`}}], 
   ArrowBox[{{1.3463968515384828`, 4.039190554615448}, {1.6108625682985214`, 
    3.9788654146070286`}}], 
   ArrowBox[{{1.3463968515384828`, 4.487989505128276}, {1.6449826371103442`, 
    4.419856475612559}}], 
   ArrowBox[{{1.3463968515384828`, 4.9367884556411035`}, {1.6794561538918864`,
     4.860777675562926}}], 
   ArrowBox[{{1.3463968515384828`, 5.385587406153931}, {1.714157002840312, 
    5.301652076178337}}], 
   ArrowBox[{{1.3463968515384828`, 5.834386356666759}, {1.749003646805081, 
    5.742495555516071}}], 
   ArrowBox[{{1.3463968515384828`, 6.283185307179586}, {1.783943626459488, 
    6.183318807603188}}], 
   ArrowBox[{{1.7951958020513104`, 0.}, {1.8497961960430147`, 0.}}], 
   ArrowBox[{{1.7951958020513104`, 0.4487989505128276}, {1.85367507730127, 
    0.45441706875894006`}}], 
   ArrowBox[{{1.7951958020513104`, 0.8975979010256552}, {1.8649537345935645`, 
    0.9089839927945856}}], 
   ArrowBox[{{1.7951958020513104`, 1.3463968515384828`}, {1.8826755206281047`,
     1.3638317550731731`}}], 
   ArrowBox[{{1.7951958020513104`, 1.7951958020513104`}, {1.9055698508444123`,
     1.8190352965401828`}}], 
   ArrowBox[{{1.7951958020513104`, 2.243994752564138}, {1.9323488018224024`, 
    2.274602934018084}}], 
   ArrowBox[{{1.7951958020513104`, 2.6927937030769655`}, {1.9618995291870083`,
     2.7304956387839208`}}], 
   ArrowBox[{{1.7951958020513104`, 3.141592653589793}, {1.993355746117876, 
    3.1866527585096356`}}], 
   ArrowBox[{{1.7951958020513104`, 3.5903916041026207`}, {2.0260884465355224`,
     3.643011187952226}}], 
   ArrowBox[{{1.7951958020513104`, 4.039190554615448}, {2.0596615188113487`, 
    4.099515694623868}}], 
   ArrowBox[{{1.7951958020513104`, 4.487989505128276}, {2.093781587623172, 
    4.556122534643992}}], 
   ArrowBox[{{1.7951958020513104`, 4.9367884556411035`}, {2.128255104404714, 
    5.012799235719281}}], 
   ArrowBox[{{1.7951958020513104`, 5.385587406153931}, {2.1629559533531397`, 
    5.469522736129525}}], 
   ArrowBox[{{1.7951958020513104`, 5.834386356666759}, {2.1978025973179083`, 
    5.926277157817446}}], 
   ArrowBox[{{1.7951958020513104`, 6.283185307179586}, {2.2327425769723157`, 
    6.383051806755985}}], 
   ArrowBox[{{2.243994752564138, 0.}, {2.2903400711169333`, 0.}}], 
   ArrowBox[{{2.243994752564138, 0.4487989505128276}, {2.293180839117973, 
    0.46530902352860115`}}], 
   ArrowBox[{{2.243994752564138, 0.8975979010256552}, {2.301667877820213, 
    0.9304885464156731}}], 
   ArrowBox[{{2.243994752564138, 1.3463968515384828`}, {2.315330020842013, 
    1.3960714426158118`}}], 
   ArrowBox[{{2.243994752564138, 1.7951958020513104`}, {2.3332528484068646`, 
    1.8625547842265362`}}], 
   ArrowBox[{{2.243994752564138, 2.243994752564138}, {2.3544208657215067`, 
    2.330098456229709}}], 
   ArrowBox[{{2.243994752564138, 2.6927937030769655`}, {2.3779233334057173`, 
    2.7986238589516312`}}], 
   ArrowBox[{{2.243994752564138, 3.141592653589793}, {2.4030346197941146`, 
    3.267949902673457}}], 
   ArrowBox[{{2.243994752564138, 3.5903916041026207`}, {2.4292211393770367`, 
    3.737880049001997}}], 
   ArrowBox[{{2.243994752564138, 4.039190554615448}, {2.456111660372244, 
    4.208243240308282}}], 
   ArrowBox[{{2.243994752564138, 4.487989505128276}, {2.4834572338115946`, 
    4.678906187854757}}], 
   ArrowBox[{{2.243994752564138, 4.9367884556411035`}, {2.5110947491095557`, 
    5.149771648937379}}], 
   ArrowBox[{{2.243994752564138, 5.385587406153931}, {2.5389188111987826`, 
    5.620771618555897}}], 
   ArrowBox[{{2.243994752564138, 5.834386356666759}, {2.566861846692717, 
    6.0918598659928165`}}], 
   ArrowBox[{{2.243994752564138, 6.283185307179586}, {2.5948807048778875`, 
    6.563005565017581}}], 
   ArrowBox[{{2.6927937030769655`, 0.}, {2.7217082241078616`, 0.}}], 
   ArrowBox[{{2.6927937030769655`, 0.4487989505128276}, {2.7225036488542393`, 
    0.47476637001587874`}}], 
   ArrowBox[{{2.6927937030769655`, 0.8975979010256552}, {2.7262836665142984`, 
    0.9473296569256077}}], 
   ArrowBox[{{2.6927937030769655`, 1.3463968515384828`}, {2.7332847879549282`,
     1.4198160477149446`}}], 
   ArrowBox[{{2.6927937030769655`, 1.7951958020513104`}, {2.742867033227268, 
    1.8935911541909167`}}], 
   ArrowBox[{{2.6927937030769655`, 2.243994752564138}, {2.754384545671781, 
    2.369045531941048}}], 
   ArrowBox[{{2.6927937030769655`, 2.6927937030769655`}, {2.7672877205055366`,
     2.8460709797931805`}}], 
   ArrowBox[{{2.6927937030769655`, 3.141592653589793}, {2.7811430134314645`, 
    3.3243679648748903`}}], 
   ArrowBox[{{2.6927937030769655`, 3.5903916041026207`}, {2.7956315452840705`,
     3.803611785008745}}], 
   ArrowBox[{{2.6927937030769655`, 4.039190554615448}, {2.810531774173636, 
    4.283524559902886}}], 
   ArrowBox[{{2.6927937030769655`, 4.487989505128276}, {2.8256959259315173`, 
    4.763894051464986}}], 
   ArrowBox[{{2.6927937030769655`, 4.9367884556411035`}, {2.8410279831406875`,
     5.244568395775504}}], 
   ArrowBox[{{2.6927937030769655`, 5.385587406153931}, {2.8564665023177542`, 
    5.725443204235734}}], 
   ArrowBox[{{2.6927937030769655`, 5.834386356666759}, {2.8719724691188504`, 
    6.206448530712873}}], 
   ArrowBox[{{2.6927937030769655`, 6.283185307179586}, {2.887521187935671, 
    6.6875382757451005`}}], PointBox[{3.141592653589793, 0.}], 
   ArrowBox[{{3.141592653589793, 0.4487989505128276}, {3.141592653589793, 
    0.47938211887619175`}}], 
   ArrowBox[{{3.141592653589793, 0.8975979010256552}, {3.141592653589793, 
    0.9541309103401775}}], 
   ArrowBox[{{3.141592653589793, 1.3463968515384828`}, {3.141592653589793, 
    1.4287666805886807`}}], 
   ArrowBox[{{3.141592653589793, 1.7951958020513104`}, {3.141592653589793, 
    1.9049488339168834`}}], 
   ArrowBox[{{3.141592653589793, 2.243994752564138}, {3.141592653589793, 
    2.3831054089170394`}}], 
   ArrowBox[{{3.141592653589793, 2.6927937030769655`}, {3.141592653589793, 
    2.8630918304179307`}}], 
   ArrowBox[{{3.141592653589793, 3.141592653589793}, {3.141592653589793, 
    3.3445489891668516`}}], 
   ArrowBox[{{3.141592653589793, 3.5903916041026207`}, {3.141592653589793, 
    3.8270942439337228`}}], 
   ArrowBox[{{3.141592653589793, 4.039190554615448}, {3.141592653589793, 
    4.310403473831556}}], 
   ArrowBox[{{3.141592653589793, 4.487989505128276}, {3.141592653589793, 
    4.794231291380992}}], 
   ArrowBox[{{3.141592653589793, 4.9367884556411035`}, {3.141592653589793, 
    5.278403509473774}}], 
   ArrowBox[{{3.141592653589793, 5.385587406153931}, {3.141592653589793, 
    5.762801237464799}}], 
   ArrowBox[{{3.141592653589793, 5.834386356666759}, {3.141592653589793, 
    6.247345288408247}}], 
   ArrowBox[{{3.141592653589793, 6.283185307179586}, {3.141592653589793, 
    6.731983727787422}}], 
   ArrowBox[{{3.5903916041026207`, 0.}, {3.5614770830717246`, 0.}}], 
   ArrowBox[{{3.5903916041026207`, 0.4487989505128276}, {3.560681658325347, 
    0.47476637001587874`}}], 
   ArrowBox[{{3.5903916041026207`, 0.8975979010256552}, {3.556901640665288, 
    0.9473296569256077}}], 
   ArrowBox[{{3.5903916041026207`, 1.3463968515384828`}, {3.549900519224658, 
    1.4198160477149446`}}], 
   ArrowBox[{{3.5903916041026207`, 1.7951958020513104`}, {3.5403182739523182`,
     1.8935911541909167`}}], 
   ArrowBox[{{3.5903916041026207`, 2.243994752564138}, {3.528800761507805, 
    2.369045531941048}}], 
   ArrowBox[{{3.5903916041026207`, 2.6927937030769655`}, {3.5158975866740496`,
     2.8460709797931805`}}], 
   ArrowBox[{{3.5903916041026207`, 3.141592653589793}, {3.5020422937481217`, 
    3.3243679648748903`}}], 
   ArrowBox[{{3.5903916041026207`, 3.5903916041026207`}, {3.4875537618955157`,
     3.803611785008745}}], 
   ArrowBox[{{3.5903916041026207`, 4.039190554615448}, {3.4726535330059503`, 
    4.283524559902886}}], 
   ArrowBox[{{3.5903916041026207`, 4.487989505128276}, {3.457489381248069, 
    4.763894051464986}}], 
   ArrowBox[{{3.5903916041026207`, 4.9367884556411035`}, {3.4421573240388987`,
     5.244568395775504}}], 
   ArrowBox[{{3.5903916041026207`, 5.385587406153931}, {3.426718804861832, 
    5.725443204235734}}], 
   ArrowBox[{{3.5903916041026207`, 5.834386356666759}, {3.411212838060736, 
    6.206448530712873}}], 
   ArrowBox[{{3.5903916041026207`, 6.283185307179586}, {3.395664119243915, 
    6.6875382757451005`}}], 
   ArrowBox[{{4.039190554615448, 0.}, {3.992845236062653, 0.}}], 
   ArrowBox[{{4.039190554615448, 0.4487989505128276}, {3.9900044680616134`, 
    0.46530902352860115`}}], 
   ArrowBox[{{4.039190554615448, 0.8975979010256552}, {3.981517429359373, 
    0.9304885464156731}}], 
   ArrowBox[{{4.039190554615448, 1.3463968515384828`}, {3.9678552863375733`, 
    1.3960714426158118`}}], 
   ArrowBox[{{4.039190554615448, 1.7951958020513104`}, {3.9499324587727216`, 
    1.8625547842265362`}}], 
   ArrowBox[{{4.039190554615448, 2.243994752564138}, {3.9287644414580796`, 
    2.330098456229709}}], 
   ArrowBox[{{4.039190554615448, 2.6927937030769655`}, {3.905261973773869, 
    2.7986238589516312`}}], 
   ArrowBox[{{4.039190554615448, 3.141592653589793}, {3.8801506873854716`, 
    3.267949902673457}}], 
   ArrowBox[{{4.039190554615448, 3.5903916041026207`}, {3.8539641678025496`, 
    3.737880049001997}}], 
   ArrowBox[{{4.039190554615448, 4.039190554615448}, {3.8270736468073423`, 
    4.208243240308282}}], 
   ArrowBox[{{4.039190554615448, 4.487989505128276}, {3.7997280733679917`, 
    4.678906187854757}}], 
   ArrowBox[{{4.039190554615448, 4.9367884556411035`}, {3.7720905580700306`, 
    5.149771648937379}}], 
   ArrowBox[{{4.039190554615448, 5.385587406153931}, {3.7442664959808036`, 
    5.620771618555897}}], 
   ArrowBox[{{4.039190554615448, 5.834386356666759}, {3.716323460486869, 
    6.0918598659928165`}}], 
   ArrowBox[{{4.039190554615448, 6.283185307179586}, {3.6883046023016988`, 
    6.563005565017581}}], 
   ArrowBox[{{4.487989505128276, 0.}, {4.433389111136571, 0.}}], 
   ArrowBox[{{4.487989505128276, 0.4487989505128276}, {4.429510229878316, 
    0.45441706875894006`}}], 
   ArrowBox[{{4.487989505128276, 0.8975979010256552}, {4.418231572586022, 
    0.9089839927945856}}], 
   ArrowBox[{{4.487989505128276, 1.3463968515384828`}, {4.400509786551481, 
    1.3638317550731731`}}], 
   ArrowBox[{{4.487989505128276, 1.7951958020513104`}, {4.377615456335174, 
    1.8190352965401828`}}], 
   ArrowBox[{{4.487989505128276, 2.243994752564138}, {4.350836505357184, 
    2.274602934018084}}], 
   ArrowBox[{{4.487989505128276, 2.6927937030769655`}, {4.3212857779925775`, 
    2.7304956387839208`}}], 
   ArrowBox[{{4.487989505128276, 3.141592653589793}, {4.28982956106171, 
    3.1866527585096356`}}], 
   ArrowBox[{{4.487989505128276, 3.5903916041026207`}, {4.257096860644063, 
    3.643011187952226}}], 
   ArrowBox[{{4.487989505128276, 4.039190554615448}, {4.2235237883682375`, 
    4.099515694623868}}], 
   ArrowBox[{{4.487989505128276, 4.487989505128276}, {4.189403719556415, 
    4.556122534643992}}], 
   ArrowBox[{{4.487989505128276, 4.9367884556411035`}, {4.154930202774873, 
    5.012799235719281}}], 
   ArrowBox[{{4.487989505128276, 5.385587406153931}, {4.1202293538264465`, 
    5.469522736129525}}], 
   ArrowBox[{{4.487989505128276, 5.834386356666759}, {4.085382709861678, 
    5.926277157817446}}], 
   ArrowBox[{{4.487989505128276, 6.283185307179586}, {4.050442730207271, 
    6.383051806755985}}], 
   ArrowBox[{{4.9367884556411035`, 0.}, {4.882188061649399, 0.}}], 
   ArrowBox[{{4.9367884556411035`, 0.4487989505128276}, {4.878309180391144, 
    0.4431808322667151}}], 
   ArrowBox[{{4.9367884556411035`, 0.8975979010256552}, {4.867030523098849, 
    0.8862118092567247}}], 
   ArrowBox[{{4.9367884556411035`, 1.3463968515384828`}, {4.849308737064309, 
    1.3289619480037924`}}], 
   ArrowBox[{{4.9367884556411035`, 1.7951958020513104`}, {4.826414406848001, 
    1.771356307562438}}], 
   ArrowBox[{{4.9367884556411035`, 2.243994752564138}, {4.799635455870011, 
    2.213386571110192}}], 
   ArrowBox[{{4.9367884556411035`, 2.6927937030769655`}, {4.770084728505405, 
    2.6550917673700103`}}], 
   ArrowBox[{{4.9367884556411035`, 3.141592653589793}, {4.738628511574538, 
    3.0965325486699506`}}], 
   ArrowBox[{{4.9367884556411035`, 3.5903916041026207`}, {4.705895811156891, 
    3.5377720202530156`}}], 
   ArrowBox[{{4.9367884556411035`, 4.039190554615448}, {4.672322738881065, 
    3.9788654146070286`}}], 
   ArrowBox[{{4.9367884556411035`, 4.487989505128276}, {4.6382026700692425`, 
    4.419856475612559}}], 
   ArrowBox[{{4.9367884556411035`, 4.9367884556411035`}, {4.6037291532877, 
    4.860777675562926}}], 
   ArrowBox[{{4.9367884556411035`, 5.385587406153931}, {4.569028304339274, 
    5.301652076178337}}], 
   ArrowBox[{{4.9367884556411035`, 5.834386356666759}, {4.5341816603745055`, 
    5.742495555516071}}], 
   ArrowBox[{{4.9367884556411035`, 6.283185307179586}, {4.499241680720099, 
    6.183318807603188}}], 
   ArrowBox[{{5.385587406153931, 0.}, {5.339242087601136, 0.}}], 
   ArrowBox[{{5.385587406153931, 0.4487989505128276}, {5.336401319600096, 
    0.432288877497054}}], 
   ArrowBox[{{5.385587406153931, 0.8975979010256552}, {5.327914280897856, 
    0.8647072556356372}}], 
   ArrowBox[{{5.385587406153931, 1.3463968515384828`}, {5.314252137876056, 
    1.2967222604611537`}}], 
   ArrowBox[{{5.385587406153931, 1.7951958020513104`}, {5.296329310311204, 
    1.7278368198760845`}}], 
   ArrowBox[{{5.385587406153931, 2.243994752564138}, {5.275161292996562, 
    2.1578910488985668`}}], 
   ArrowBox[{{5.385587406153931, 2.6927937030769655`}, {5.251658825312352, 
    2.5869635472023}}], 
   ArrowBox[{{5.385587406153931, 3.141592653589793}, {5.226547538923954, 
    3.015235404506129}}], 
   ArrowBox[{{5.385587406153931, 3.5903916041026207`}, {5.200361019341032, 
    3.442903159203244}}], 
   ArrowBox[{{5.385587406153931, 4.039190554615448}, {5.173470498345825, 
    3.8701378689226145`}}], 
   ArrowBox[{{5.385587406153931, 4.487989505128276}, {5.146124924906474, 
    4.297072822401795}}], 
   ArrowBox[{{5.385587406153931, 4.9367884556411035`}, {5.118487409608513, 
    4.723805262344828}}], 
   ArrowBox[{{5.385587406153931, 5.385587406153931}, {5.090663347519286, 
    5.150403193751965}}], 
   ArrowBox[{{5.385587406153931, 5.834386356666759}, {5.062720312025352, 
    5.576912847340701}}], 
   ArrowBox[{{5.385587406153931, 6.283185307179586}, {5.0347014538401815`, 
    6.003365049341592}}], 
   ArrowBox[{{5.834386356666759, 0.}, {5.8054718356358626`, 0.}}], 
   ArrowBox[{{5.834386356666759, 0.4487989505128276}, {5.804676410889485, 
    0.42283153100977644`}}], 
   ArrowBox[{{5.834386356666759, 0.8975979010256552}, {5.800896393229426, 
    0.8478661451257027}}], 
   ArrowBox[{{5.834386356666759, 1.3463968515384828`}, {5.793895271788796, 
    1.272977655362021}}], 
   ArrowBox[{{5.834386356666759, 1.7951958020513104`}, {5.784313026516457, 
    1.696800449911704}}], 
   ArrowBox[{{5.834386356666759, 2.243994752564138}, {5.772795514071943, 
    2.118943973187228}}], 
   ArrowBox[{{5.834386356666759, 2.6927937030769655`}, {5.7598923392381876`, 
    2.5395164263607506`}}], 
   ArrowBox[{{5.834386356666759, 3.141592653589793}, {5.74603704631226, 
    2.958817342304696}}], 
   ArrowBox[{{5.834386356666759, 3.5903916041026207`}, {5.731548514459654, 
    3.377171423196496}}], 
   ArrowBox[{{5.834386356666759, 4.039190554615448}, {5.716648285570089, 
    3.794856549328011}}], 
   ArrowBox[{{5.834386356666759, 4.487989505128276}, {5.701484133812206, 
    4.212084958791566}}], 
   ArrowBox[{{5.834386356666759, 4.9367884556411035`}, {5.686152076603037, 
    4.629008515506703}}], 
   ArrowBox[{{5.834386356666759, 5.385587406153931}, {5.6707135574259695`, 
    5.045731608072128}}], 
   ArrowBox[{{5.834386356666759, 5.834386356666759}, {5.655207590624873, 
    5.462324182620645}}], 
   ArrowBox[{{5.834386356666759, 6.283185307179586}, {5.639658871808053, 
    5.878832338614072}}], PointBox[{6.283185307179586, 0.}], 
   ArrowBox[{{6.283185307179586, 0.4487989505128276}, {6.283185307179586, 
    0.4182157821494634}}], 
   ArrowBox[{{6.283185307179586, 0.8975979010256552}, {6.283185307179586, 
    0.8410648917111329}}], 
   ArrowBox[{{6.283185307179586, 1.3463968515384828`}, {6.283185307179586, 
    1.2640270224882848`}}], 
   ArrowBox[{{6.283185307179586, 1.7951958020513104`}, {6.283185307179586, 
    1.6854427701857373`}}], 
   ArrowBox[{{6.283185307179586, 2.243994752564138}, {6.283185307179586, 
    2.1048840962112365`}}], 
   ArrowBox[{{6.283185307179586, 2.6927937030769655`}, {6.283185307179586, 
    2.5224955757360004`}}], 
   ArrowBox[{{6.283185307179586, 3.141592653589793}, {6.283185307179586, 
    2.9386363180127346`}}], 
   ArrowBox[{{6.283185307179586, 3.5903916041026207`}, {6.283185307179586, 
    3.3536889642715186`}}], 
   ArrowBox[{{6.283185307179586, 4.039190554615448}, {6.283185307179586, 
    3.76797763539934}}], 
   ArrowBox[{{6.283185307179586, 4.487989505128276}, {6.283185307179586, 
    4.18174771887556}}], 
   ArrowBox[{{6.283185307179586, 4.9367884556411035`}, {6.283185307179586, 
    4.595173401808433}}], 
   ArrowBox[{{6.283185307179586, 5.385587406153931}, {6.283185307179586, 
    5.008373574843063}}], 
   ArrowBox[{{6.283185307179586, 5.834386356666759}, {6.283185307179586, 
    5.4214274249252705`}}], 
   ArrowBox[{{6.283185307179586, 6.283185307179586}, {6.283185307179586, 
    5.8343868865717505`}}]}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1927414980]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 55, 31.8610980}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/PlotField"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 69, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[881, 35, 326, 9, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[1210, 46, 209, 7, 70, "UpgradeDetail",
 CellID->556646693],
Cell[1422, 55, 117, 3, 70, "Input",
 CellID->1663071679],
Cell[1542, 60, 124, 4, 70, "Input",
 CellID->1746043248],
Cell[1669, 66, 125, 3, 70, "ExampleDelimiter",
 CellID->139481879],
Cell[1797, 71, 302, 10, 70, "UpgradeDetail",
 CellID->510952580],
Cell[2102, 83, 328, 11, 70, "Input",
 CellID->998512136],
Cell[CellGroupData[{
Cell[2455, 98, 347, 10, 70, "Input",
 CellID->1725607045],
Cell[2805, 110, 22124, 419, 70, "Output",
 CellID->1940391354]
}, Open  ]],
Cell[24944, 532, 125, 3, 70, "ExampleDelimiter",
 CellID->265009851],
Cell[25072, 537, 315, 10, 70, "UpgradeDetail",
 CellID->1063477682],
Cell[25390, 549, 405, 12, 70, "Input",
 CellID->363007393],
Cell[CellGroupData[{
Cell[25820, 565, 389, 12, 70, "Input",
 CellID->64213024],
Cell[26212, 579, 1382, 22, 70, "Output",
 CellID->315559943]
}, Open  ]],
Cell[27609, 604, 126, 3, 70, "ExampleDelimiter",
 CellID->1418425714],
Cell[27738, 609, 308, 10, 70, "UpgradeDetail",
 CellID->470823336],
Cell[28049, 621, 365, 12, 70, "Input",
 CellID->1798052604],
Cell[CellGroupData[{
Cell[28439, 637, 421, 13, 70, "Input",
 CellID->480234844],
Cell[28863, 652, 22813, 439, 70, "Output",
 CellID->1089498291]
}, Open  ]],
Cell[51691, 1094, 125, 3, 70, "ExampleDelimiter",
 CellID->147790178],
Cell[51819, 1099, 318, 10, 70, "UpgradeDetail",
 CellID->1994590575],
Cell[52140, 1111, 439, 13, 70, "Input",
 CellID->864064355],
Cell[CellGroupData[{
Cell[52604, 1128, 425, 13, 70, "Input",
 CellID->1045193471],
Cell[53032, 1143, 22814, 439, 70, "Output",
 CellID->1420237512]
}, Open  ]],
Cell[75861, 1585, 126, 3, 70, "ExampleDelimiter",
 CellID->1723924386],
Cell[75990, 1590, 299, 10, 70, "UpgradeDetail",
 CellID->766691540],
Cell[76292, 1602, 432, 13, 70, "Input",
 CellID->882830780],
Cell[CellGroupData[{
Cell[76749, 1619, 417, 13, 70, "Input",
 CellID->772402337],
Cell[77169, 1634, 22422, 422, 70, "Output",
 CellID->1927414980]
}, Open  ]]
}, Open  ]],
Cell[99618, 2060, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

