(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9935,        333]
NotebookOptionsPosition[      7581,        256]
NotebookOutlinePosition[      8546,        284]
CellTagsIndexPosition[      8503,        281]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["Graphics`Polyhedra`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PolyhedronData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolyhedronData"]], "InlineFormula"],
 " has been added to the built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel.\nA new ",
 ButtonBox["Polyhedron Operations Package",
  BaseStyle->"Link",
  ButtonData->
   "paclet:PolyhedronOperations/guide/PolyhedronOperationsPackage"],
 " has been created."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[CellGroupData[{

Cell["New system function", "UpgradeDetailLabel",
 CellID->305554978],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PolyhedronData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolyhedronData"]], "InlineFormula"],
 " has basic information about named polyhedra:"
}], "UpgradeDetail",
 CellID->1457835045],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Graphics`Polyhedra`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"Polyhedron", "[", "Octahedron", "]"}], "]"}]}], "Input", \
"LegacyInput",
 CellID->1645505262],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", "\"\<Octahedron\>\"", "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->276477127],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[
   NCache[{{Rational[-1, 2], Rational[-1, 2], 0}, {
     Rational[-1, 2], Rational[1, 2], 0}, {0, 0, -2^Rational[-1, 2]}, {
     0, 0, 2^Rational[-1, 2]}, {Rational[1, 2], Rational[-1, 2], 0}, {
     Rational[1, 2], Rational[1, 2], 0}}, {{-0.5, -0.5, 0}, {-0.5, 0.5, 0}, {
     0, 0, -0.7071067811865475}, {0, 0, 0.7071067811865475}, {0.5, -0.5, 0}, {
     0.5, 0.5, 0}}], 
   Polygon3DBox[{{4, 5, 6}, {4, 6, 2}, {4, 2, 1}, {4, 1, 5}, {5, 1, 3}, {5, 3,
     6}, {3, 1, 2}, {6, 3, 2}}]]]], "Output",
 CellLabel->"Out[8]=",
 CellID->1743945028]
}, Open  ]],

Cell["\<\
Get the list of coordinates for the vertices of an octahedron:\
\>", "UpgradeDetail",
 CellID->1137538067],

Cell[BoxData[
 RowBox[{"Vertices", "[", "Octahedron", "]"}]], "Input", "LegacyInput",
 CellID->571469293],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Octahedron\>\"", ",", " ", "\"\<VertexCoordinates\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->712532368],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "2"]}], ",", 
     RowBox[{"-", 
      FractionBox["1", "2"]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "2"]}], ",", 
     FractionBox["1", "2"], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox["1", 
      SqrtBox["2"]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], ",", 
     RowBox[{"-", 
      FractionBox["1", "2"]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], ",", 
     FractionBox["1", "2"], ",", "0"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[14]=",
 CellID->1251827736]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Polyhedron operations package", "UpgradePackageSection",
 CellID->1087906933],

Cell[TextData[{
 "Many functions from ",
 Cell[BoxData["Graphics`Polyhedra`"], "InlineFormula"],
 " are now found in the ",
 ButtonBox["Polyhedron Operations Package",
  BaseStyle->"Link",
  ButtonData->
   "paclet:PolyhedronOperations/guide/PolyhedronOperationsPackage"],
 ":"
}], "UpgradeDetail",
 CellID->1074807037],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Stellate",
   BaseStyle->"Link",
   ButtonData->"paclet:PolyhedronOperations/ref/Stellate"]], 
  "InlineFormula"],
 "\n",
 Cell[BoxData[
  ButtonBox["Geodesate",
   BaseStyle->"Link",
   ButtonData->"paclet:PolyhedronOperations/ref/Geodesate"]], 
  "InlineFormula"],
 "\n",
 Cell[BoxData[
  ButtonBox["Truncate",
   BaseStyle->"Link",
   ButtonData->"paclet:PolyhedronOperations/ref/Truncate"]], 
  "InlineFormula"],
 "\n",
 Cell[BoxData[
  ButtonBox["OpenTruncate",
   BaseStyle->"Link",
   ButtonData->"paclet:PolyhedronOperations/ref/OpenTruncate"]], 
  "InlineFormula"]
}], "UpgradePackageListing",
 CellID->701993520],

Cell["Generate a stellated octahedron:", "UpgradeDetail",
 CellID->562281756],

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"Stellate", "[", 
   RowBox[{"Polyhedron", "[", "Octahedron", "]"}], "]"}], "]"}]], "Input", \
"LegacyInput",
 CellID->342402225],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "PolyhedronOperations`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Stellate", "[", 
  RowBox[{"PolyhedronData", "[", "\"\<Octahedron\>\"", "]"}], "]"}]}], "Input",\

 CellLabel->"In[9]:=",
 CellID->1627271340],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[
   NCache[{{Rational[-1, 2], Rational[-1, 2], 0}, {
     Rational[-1, 2], Rational[1, 2], 0}, {0, 0, -2^Rational[-1, 2]}, {
     0, 0, 2^Rational[-1, 2]}, {Rational[1, 2], Rational[-1, 2], 0}, {
     Rational[1, 2], Rational[1, 2], 0}, {
     Rational[2, 3], 0, Rational[1, 3] 2^Rational[1, 2]}, {
     0, Rational[2, 3], Rational[1, 3] 2^Rational[1, 2]}, {
     Rational[-2, 3], 0, Rational[1, 3] 2^Rational[1, 2]}, {
     0, Rational[-2, 3], Rational[1, 3] 2^Rational[1, 2]}, {
     0, Rational[-2, 3], Rational[-1, 3] 2^Rational[1, 2]}, {
     Rational[2, 3], 0, Rational[-1, 3] 2^Rational[1, 2]}, {
     Rational[-2, 3], 0, Rational[-1, 3] 2^Rational[1, 2]}, {
     0, Rational[2, 3], Rational[-1, 3] 2^Rational[1, 2]}}, {{-0.5, -0.5, 
      0}, {-0.5, 0.5, 0}, {0, 0, -0.7071067811865475}, {
     0, 0, 0.7071067811865475}, {0.5, -0.5, 0}, {0.5, 0.5, 0}, {
     0.6666666666666666, 0, 0.4714045207910317}, {
     0, 0.6666666666666666, 0.4714045207910317}, {-0.6666666666666666, 0, 
      0.4714045207910317}, {0, -0.6666666666666666, 0.4714045207910317}, {
     0, -0.6666666666666666, -0.4714045207910317}, {
     0.6666666666666666, 0, -0.4714045207910317}, {-0.6666666666666666, 
      0, -0.4714045207910317}, {0, 0.6666666666666666, -0.4714045207910317}}],
    Polygon3DBox[{{7, 4, 5}, {7, 5, 6}, {7, 6, 4}, {8, 4, 6}, {8, 6, 2}, {8, 
    2, 4}, {9, 4, 2}, {9, 2, 1}, {9, 1, 4}, {10, 4, 1}, {10, 1, 5}, {10, 5, 
    4}, {11, 5, 1}, {11, 1, 3}, {11, 3, 5}, {12, 5, 3}, {12, 3, 6}, {12, 6, 
    5}, {13, 3, 1}, {13, 1, 2}, {13, 2, 3}, {14, 6, 3}, {14, 3, 2}, {14, 2, 
    6}}]],
  Method->{
   "CylinderPoints" -> {40, 3}, "SpherePoints" -> {40, 30}, "RotationControl" -> 
    "ArcBall"},
  ViewPoint->{1.3, -2.4, 2.},
  ViewVector->Automatic,
  ViewVertical->{0., 0., 1.}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 55, 32.1579806}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/Polyhedra"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 69, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[881, 35, 467, 15, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[CellGroupData[{
Cell[1373, 54, 69, 1, 70, "UpgradeDetailLabel",
 CellID->305554978],
Cell[1445, 57, 237, 7, 70, "UpgradeDetail",
 CellID->1457835045],
Cell[1685, 66, 225, 6, 70, "Input",
 CellID->1645505262],
Cell[CellGroupData[{
Cell[1935, 76, 127, 3, 70, "Input",
 CellID->276477127],
Cell[2065, 81, 596, 12, 70, "Output",
 CellID->1743945028]
}, Open  ]],
Cell[2676, 96, 116, 3, 70, "UpgradeDetail",
 CellID->1137538067],
Cell[2795, 101, 105, 2, 70, "Input",
 CellID->571469293],
Cell[CellGroupData[{
Cell[2925, 107, 183, 5, 70, "Input",
 CellID->712532368],
Cell[3111, 114, 895, 33, 70, "Output",
 CellID->1251827736]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4067, 154, 83, 1, 70, "UpgradePackageSection",
 CellID->1087906933],
Cell[4153, 157, 319, 10, 70, "UpgradeDetail",
 CellID->1074807037],
Cell[4475, 169, 666, 25, 70, "UpgradePackageListing",
 CellID->701993520],
Cell[5144, 196, 77, 1, 70, "UpgradeDetail",
 CellID->562281756],
Cell[5224, 199, 176, 5, 70, "Input",
 CellID->342402225],
Cell[CellGroupData[{
Cell[5425, 208, 251, 7, 70, "Input",
 CellID->1627271340],
Cell[5679, 217, 1848, 33, 70, "Output"]
}, Open  ]]
}, Open  ]],
Cell[7554, 254, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

