(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14795,        575]
NotebookOptionsPosition[     11549,        465]
NotebookOutlinePosition[     12522,        493]
CellTagsIndexPosition[     12479,        490]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["LinearAlgebra`Orthogonalization`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Orthogonalize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Orthogonalize"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Normalize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Normalize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Projection",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Projection"]], "InlineFormula"],
 " have been added to the built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel. ",
 Cell[BoxData[
  ButtonBox["Normalize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Normalize"]], "InlineFormula"],
 " can now take an arbitrary norm function. "
}], "UpgradeSummary",
 CellID->1010000471],

Cell[CellGroupData[{

Cell["Orthogonalize", "UpgradeDetailLabel",
 CellID->305554978],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Orthogonalize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Orthogonalize"]], "InlineFormula"],
 " gives an orthonormal basis found by orthogonalizing the vectors:"
}], "UpgradeDetail",
 CellID->1457835045],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "LinearAlgebra`Orthogonalization`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"GramSchmidt", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", "4", ",", "2"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"2", ",", "5", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "6"}], "}"}]}], "}"}], "]"}]}], "Input", \
"LegacyInput",
 CellID->92144840],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Orthogonalize", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", "4", ",", "2"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"2", ",", "5", ",", "2"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "6"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->137384579],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["3", 
      SqrtBox["29"]], ",", 
     FractionBox["4", 
      SqrtBox["29"]], ",", 
     FractionBox["2", 
      SqrtBox["29"]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["32", 
       SqrtBox["1653"]]}], ",", 
     FractionBox["25", 
      SqrtBox["1653"]], ",", 
     RowBox[{"-", 
      FractionBox["2", 
       SqrtBox["1653"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["2", 
       SqrtBox["57"]]}], ",", 
     RowBox[{"-", 
      FractionBox["2", 
       SqrtBox["57"]]}], ",", 
     FractionBox["7", 
      SqrtBox["57"]]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->17795839]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->753810796],

Cell["\<\
Orthogonalize can generate a basis for the vectors with respect to an inner \
product function:\
\>", "UpgradeDetail",
 CellID->735896229],

Cell[BoxData[
 RowBox[{
  RowBox[{"GramSchmidt", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "x", ",", 
      RowBox[{"x", "^", "2"}], ",", 
      RowBox[{"x", "^", "3"}], ",", 
      RowBox[{"x", "^", "4"}]}], "}"}], ",", 
    RowBox[{"InnerProduct", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Integrate", "[", 
        RowBox[{
         RowBox[{"#1", " ", "#2"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], "&"}], ")"}]}]}], 
   "]"}], "//", "Simplify"}]], "Input", "LegacyInput",
 CellLabel->"In[1]:=",
 CellID->15357145],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Orthogonalize", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "x", ",", 
      RowBox[{"x", "^", "2"}], ",", 
      RowBox[{"x", "^", "3"}], ",", 
      RowBox[{"x", "^", "4"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"Integrate", "[", 
      RowBox[{
       RowBox[{"#1", " ", "#2"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], "&"}]}], "]"}], "//",
   "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->353274920],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", 
    SqrtBox["2"]], ",", 
   RowBox[{
    SqrtBox[
     FractionBox["3", "2"]], " ", "x"}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SqrtBox[
     FractionBox["5", "2"]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SqrtBox[
     FractionBox["7", "2"]], " ", "x", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}]}], ",", 
   FractionBox[
    RowBox[{"3", " ", 
     RowBox[{"(", 
      RowBox[{"3", "-", 
       RowBox[{"30", " ", 
        SuperscriptBox["x", "2"]}], "+", 
       RowBox[{"35", " ", 
        SuperscriptBox["x", "4"]}]}], ")"}]}], 
    RowBox[{"8", " ", 
     SqrtBox["2"]}]]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->192314046]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Normalize", "UpgradeDetailLabel",
 CellID->14105507],

Cell["Normalize symbolic vectors: ", "UpgradeDetail",
 CellID->600485325],

Cell[BoxData[
 RowBox[{"Normalize", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input", "LegacyInput",
 CellID->26556727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normalize", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", " ", "b", ",", " ", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[74]:=",
 CellID->64312923],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["a", 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Abs", "[", "a", "]"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"Abs", "[", "b", "]"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"Abs", "[", "c", "]"}], "2"]}]]], ",", 
   FractionBox["b", 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Abs", "[", "a", "]"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"Abs", "[", "b", "]"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"Abs", "[", "c", "]"}], "2"]}]]], ",", 
   FractionBox["c", 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Abs", "[", "a", "]"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"Abs", "[", "b", "]"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"Abs", "[", "c", "]"}], "2"]}]]]}], "}"}]], "Output",
 CellLabel->"Out[74]=",
 CellID->44945606]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->379905689],

Cell["Use an arbitrary norm function: ", "UpgradeDetail",
 CellID->283891341],

Cell[BoxData[
 StyleBox[
  RowBox[{"Normalize", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", " ", "y", ",", " ", "z"}], "}"}], ",", " ", "f"}], 
   "]"}],
  FontWeight->"Bold"]], "UpgradeDetail", "LegacyInputError",
 CellID->931446075],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normalize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "y", ",", " ", "z"}], "}"}], ",", " ", "f"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->698892115],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["x", 
    RowBox[{"f", "[", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}]], ",", 
   FractionBox["y", 
    RowBox[{"f", "[", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}]], ",", 
   FractionBox["z", 
    RowBox[{"f", "[", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}]]}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->83800841]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Projection", "UpgradeDetailLabel",
 CellID->786261959],

Cell[TextData[{
 "This finds the projection assuming  ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 ",",
 Cell[BoxData[
  RowBox[{" ", 
   StyleBox["b", "TI"]}]], "InlineFormula"],
 " are Real:"
}], "UpgradeDetail",
 CellID->1493508231],

Cell[BoxData[
 RowBox[{"Projection", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}]}], "]"}]], "Input", "LegacyInput",
 CellID->573379608],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Projection", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "y"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", " ", "Dot"}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->183358276],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", "x"}], "+", 
       RowBox[{"b", " ", "y"}]}], ")"}]}], 
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]], ",", 
   FractionBox[
    RowBox[{"b", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", "x"}], "+", 
       RowBox[{"b", " ", "y"}]}], ")"}]}], 
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]]}], "}"}]], "Output",
 CellLabel->"Out[9]=",
 CellID->376168115]
}, Open  ]],

Cell["Use symbolic vectors: ", "UpgradeDetail",
 CellID->204066492],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Projection", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "y"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->49176907],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"Conjugate", "[", "x", "]"}]}], "+", 
       RowBox[{"b", " ", 
        RowBox[{"Conjugate", "[", "y", "]"}]}]}], ")"}]}], 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"Conjugate", "[", "a", "]"}]}], "+", 
     RowBox[{"b", " ", 
      RowBox[{"Conjugate", "[", "b", "]"}]}]}]], ",", 
   FractionBox[
    RowBox[{"b", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"Conjugate", "[", "x", "]"}]}], "+", 
       RowBox[{"b", " ", 
        RowBox[{"Conjugate", "[", "y", "]"}]}]}], ")"}]}], 
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"Conjugate", "[", "a", "]"}]}], "+", 
     RowBox[{"b", " ", 
      RowBox[{"Conjugate", "[", "b", "]"}]}]}]]}], "}"}]], "Output",
 CellLabel->"Out[8]=",
 CellID->304944386]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 55, 33.1892570}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/Orthogonalization"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 82, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[894, 35, 716, 25, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[CellGroupData[{
Cell[1635, 64, 63, 1, 70, "UpgradeDetailLabel",
 CellID->305554978],
Cell[1701, 67, 255, 7, 70, "UpgradeDetail",
 CellID->1457835045],
Cell[1959, 76, 445, 14, 70, "Input",
 CellID->92144840],
Cell[CellGroupData[{
Cell[2429, 94, 359, 11, 70, "Input",
 CellID->137384579],
Cell[2791, 107, 771, 32, 70, "Output",
 CellID->17795839]
}, Open  ]],
Cell[3577, 142, 125, 3, 70, "ExampleDelimiter",
 CellID->753810796],
Cell[3705, 147, 148, 4, 70, "UpgradeDetail",
 CellID->735896229],
Cell[3856, 153, 632, 20, 70, "Input",
 CellID->15357145],
Cell[CellGroupData[{
Cell[4513, 177, 537, 18, 70, "Input",
 CellID->353274920],
Cell[5053, 197, 970, 37, 70, "Output",
 CellID->192314046]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6072, 240, 58, 1, 70, "UpgradeDetailLabel",
 CellID->14105507],
Cell[6133, 243, 73, 1, 70, "UpgradeDetail",
 CellID->600485325],
Cell[6209, 246, 153, 4, 70, "Input",
 CellID->26556727],
Cell[CellGroupData[{
Cell[6387, 254, 172, 5, 70, "Input",
 CellID->64312923],
Cell[6562, 261, 909, 31, 70, "Output",
 CellID->44945606]
}, Open  ]],
Cell[7486, 295, 125, 3, 70, "ExampleDelimiter",
 CellID->379905689],
Cell[7614, 300, 77, 1, 70, "UpgradeDetail",
 CellID->283891341],
Cell[7694, 303, 249, 8, 70, "UpgradeDetail",
 CellID->931446075],
Cell[CellGroupData[{
Cell[7968, 315, 205, 7, 70, "Input",
 CellID->698892115],
Cell[8176, 324, 470, 16, 70, "Output",
 CellID->83800841]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8695, 346, 60, 1, 70, "UpgradeDetailLabel",
 CellID->786261959],
Cell[8758, 349, 379, 16, 70, "UpgradeDetail",
 CellID->1493508231],
Cell[9140, 367, 219, 7, 70, "Input",
 CellID->573379608],
Cell[CellGroupData[{
Cell[9384, 378, 254, 8, 70, "Input",
 CellID->183358276],
Cell[9641, 388, 586, 22, 70, "Output",
 CellID->376168115]
}, Open  ]],
Cell[10242, 413, 67, 1, 70, "UpgradeDetail",
 CellID->204066492],
Cell[CellGroupData[{
Cell[10334, 418, 236, 8, 70, "Input",
 CellID->49176907],
Cell[10573, 428, 910, 30, 70, "Output",
 CellID->304944386]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[11522, 463, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

