(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9973,        368]
NotebookOptionsPosition[      7548,        288]
NotebookOutlinePosition[      8515,        316]
CellTagsIndexPosition[      8472,        313]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["LinearAlgebra`Tridiagonal`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s built-in ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " function should be used to create tridiagonal matrices. \n",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel's built-in sparse solver ",
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 " has replaced ",
 Cell[BoxData["TridiagonalSolve"], "InlineFormula"],
 " as a faster solver of tridiagonal matrices. "
}], "UpgradeSummary",
 CellID->1010000471],

Cell[CellGroupData[{

Cell["Suggestion for replacing Tridiagonal", "UpgradeDetailLabel",
 CellID->305554978],

Cell["This loads the package in version 5.2: ", "UpgradeDetail",
 CellID->735192702],

Cell[BoxData[
 RowBox[{
  RowBox[{"<<", "LinearAlgebra`Tridiagonal`"}], ";"}]], "Input", \
"LegacyInput",
 CellID->1663071679],

Cell["\<\
This defines the list that will give the nonzero diagonals of a matrix:\
\>", "UpgradeDetail",
 CellID->1457835045],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"7", ",", "1", ",", "11"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "8", ",", "2", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "9", ",", "3"}], "}"}]}], "}"}]}], ";"}]], "Input", \
"LegacyInput",
 CellID->86234656],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", " ", "b", ",", " ", "c"}], "}"}], " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"7", ",", "1", ",", "11"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"4", ",", " ", "8", ",", " ", "2", ",", " ", "12"}], "}"}], ",",
      " ", 
     RowBox[{"{", 
      RowBox[{"5", ",", "9", ",", "3"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->517572370],

Cell[TextData[{
 "Here is the matrix ",
 StyleBox["m", "MR",
  GridBoxOptions->{
  GridBoxDividers->{
   "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
    "RowsIndexed" -> {}},
  GridBoxSpacings->{"Columns" -> {
      Offset[0.27999999999999997`], {
       Offset[0.5599999999999999]}, 
      Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
      Offset[0.2], {
       Offset[0.16]}, 
      Offset[0.2]}, "RowsIndexed" -> {}}}],
 " constructed from the list",
 ":"
}], "UpgradeDetail",
 CellID->447953987],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Switch", "[", 
      RowBox[{
       RowBox[{"j", "-", "i"}], ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"a", "[", 
        RowBox[{"[", "j", "]"}], "]"}], ",", "0", ",", 
       RowBox[{"b", "[", 
        RowBox[{"[", "j", "]"}], "]"}], ",", "1", ",", 
       RowBox[{"c", "[", 
        RowBox[{"[", 
         RowBox[{"j", "-", "1"}], "]"}], "]"}], ",", "_", ",", "0"}], "]"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "4"}], "}"}]}], "]"}]}], ";"}]], "Input", \
"LegacyInput",
 CellID->378404887],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Band", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], "]"}], "\[Rule]", "c"}], ",", 
      RowBox[{
       RowBox[{"Band", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], "]"}], "\[Rule]", "b"}], ",", 
      RowBox[{
       RowBox[{"Band", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}], "]"}], "\[Rule]", "a"}]}], "}"}], 
    ",", "4"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->53234711],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "10", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 10, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "4"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[2]=",
 CellID->3954247]
}, Open  ]],

Cell[TextData[{
 "This displays the matrix using ",
 Cell[BoxData[
  ButtonBox["MatrixForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
 ": "
}], "UpgradeDetail",
 CellID->884712803],

Cell[BoxData[
 RowBox[{
  RowBox[{"MatrixForm", "[", "m", "]"}], ";"}]], "Input", "LegacyInput",
 CellID->709086308],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"Normal", "[", "m", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->69553634],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"4", "5", "0", "0"},
     {"7", "8", "9", "0"},
     {"0", "1", "2", "3"},
     {"0", "0", "11", "12"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[3]//MatrixForm=",
 CellID->422062443]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel's built-in sparse solver ",
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 " should be used in place of ",
 Cell[BoxData["TridiagonalSolve"], "InlineFormula"]
}], "UpgradeDetail",
 CellID->987679328],

Cell[BoxData[
 RowBox[{
  RowBox[{"TridiagonalSolve", "[", 
   RowBox[{"a", ",", "b", ",", "c", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "4", ",", "5"}], "}"}]}], "]"}], 
  ";"}]], "Input", "LegacyInput",
 CellID->94968957],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearSolve", "[", 
  RowBox[{"m", ",", " ", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->140022516],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["28", "9"]}], ",", 
   FractionBox["26", "9"], ",", 
   FractionBox["5", "27"], ",", 
   FractionBox["20", "81"]}], "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->13411948]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 55, 33.3611364}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/Tridiagonal"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 76, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[888, 35, 646, 20, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[CellGroupData[{
Cell[1559, 59, 86, 1, 70, "UpgradeDetailLabel",
 CellID->305554978],
Cell[1648, 62, 84, 1, 70, "UpgradeDetail",
 CellID->735192702],
Cell[1735, 65, 126, 4, 70, "Input",
 CellID->1663071679],
Cell[1864, 71, 125, 3, 70, "UpgradeDetail",
 CellID->1457835045],
Cell[1992, 76, 422, 14, 70, "Input",
 CellID->86234656],
Cell[2417, 92, 480, 15, 70, "Input",
 CellID->517572370],
Cell[2900, 109, 548, 17, 70, "UpgradeDetail",
 CellID->447953987],
Cell[3451, 128, 684, 22, 70, "Input",
 CellID->378404887],
Cell[CellGroupData[{
Cell[4160, 154, 603, 20, 70, "Input",
 CellID->53234711],
Cell[4766, 176, 391, 14, 70, "Output",
 CellID->3954247]
}, Open  ]],
Cell[5172, 193, 221, 8, 70, "UpgradeDetail",
 CellID->884712803],
Cell[5396, 203, 116, 3, 70, "Input",
 CellID->709086308],
Cell[CellGroupData[{
Cell[5537, 210, 138, 4, 70, "Input",
 CellID->69553634],
Cell[5678, 216, 714, 21, 70, "Output",
 CellID->422062443]
}, Open  ]],
Cell[6407, 240, 353, 11, 70, "UpgradeDetail",
 CellID->987679328],
Cell[6763, 253, 239, 7, 70, "Input",
 CellID->94968957],
Cell[CellGroupData[{
Cell[7027, 264, 204, 6, 70, "Input",
 CellID->140022516],
Cell[7234, 272, 248, 9, 70, "Output",
 CellID->13411948]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[7521, 286, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

