(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6638,        225]
NotebookOptionsPosition[      4913,        171]
NotebookOutlinePosition[      5887,        199]
CellTagsIndexPosition[      5844,        196]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["Miscellaneous`StandardAtmosphere`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "All the functionality of ",
 Cell[BoxData["Miscellaneous`StandardAtmosphere`"], "InlineFormula"],
 "is now available in the newly created ",
 ButtonBox["Standard Atmosphere Package",
  BaseStyle->"Link",
  ButtonData->"paclet:StandardAtmosphere/guide/StandardAtmospherePackage"],
 "."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 "To access functionality from the new ",
 ButtonBox["Standard Atmosphere Package",
  BaseStyle->"Link",
  ButtonData->"paclet:StandardAtmosphere/guide/StandardAtmospherePackage"],
 " load ",
 Cell[BoxData["StandardAtmosphere`"], "InlineFormula"],
 ":",
 " "
}], "UpgradeDetail",
 CellID->556646693],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Miscellaneous`StandardAtmosphere`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"MeanParticleSpeed", "[", 
  RowBox[{"5000", " ", "Meter"}], "]"}]}], "Input", "LegacyInput",
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "StandardAtmosphere`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"MeanParticleSpeed", "[", 
  RowBox[{"5000", " ", "Meter"}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->1746043248],

Cell[BoxData[
 FractionBox[
  RowBox[{"432.31`", " ", "Meter"}], "Second"]], "Output",
 CellLabel->"Out[4]=",
 CellID->163680560]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Standard Atmosphere package", "UpgradePackageSection",
 CellID->1087906933],

Cell[TextData[{
 "Many functions from ",
 Cell[BoxData["Miscellaneous`StandardAtmosphere`"], "InlineFormula"],
 " are now found in the ",
 ButtonBox["Standard Atmosphere Package",
  BaseStyle->"Link",
  ButtonData->"paclet:StandardAtmosphere/guide/StandardAtmospherePackage"],
 ":"
}], "UpgradeDetail",
 CellID->1074807037],

Cell[TextData[Cell[BoxData[
 TagBox[GridBox[{
    {
     ButtonBox["AtmosphericPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:StandardAtmosphere/ref/AtmosphericPlot"]},
    {
     ButtonBox["CollisionFrequency",
      BaseStyle->"Link",
      ButtonData->"paclet:StandardAtmosphere/ref/CollisionFrequency"]},
    {
     ButtonBox["DynamicViscosity",
      BaseStyle->"Link",
      ButtonData->"paclet:StandardAtmosphere/ref/DynamicViscosity"]},
    {
     ButtonBox["GravityAcceleration",
      BaseStyle->"Link",
      ButtonData->"paclet:StandardAtmosphere/ref/GravityAcceleration"]},
    {
     ButtonBox["KinematicViscosity",
      BaseStyle->"Link",
      ButtonData->"paclet:StandardAtmosphere/ref/KinematicViscosity"]},
    {
     ButtonBox["KineticTemperature",
      BaseStyle->"Link",
      ButtonData->"paclet:StandardAtmosphere/ref/KineticTemperature"]},
    {
     ButtonBox["MeanDensity",
      BaseStyle->"Link",
      ButtonData->"paclet:StandardAtmosphere/ref/MeanDensity"]},
    {
     ButtonBox["MeanFreePath",
      BaseStyle->"Link",
      ButtonData->"paclet:StandardAtmosphere/ref/MeanFreePath"]},
    {
     ButtonBox["MeanMolecularWeight",
      BaseStyle->"Link",
      ButtonData->"paclet:StandardAtmosphere/ref/MeanMolecularWeight"]},
    {
     ButtonBox["MeanParticleSpeed",
      BaseStyle->"Link",
      ButtonData->"paclet:StandardAtmosphere/ref/MeanParticleSpeed"]},
    {
     ButtonBox["NumberDensity",
      BaseStyle->"Link",
      ButtonData->"paclet:StandardAtmosphere/ref/NumberDensity"]},
    {
     ButtonBox["Pressure",
      BaseStyle->"Link",
      ButtonData->"paclet:StandardAtmosphere/ref/Pressure"]},
    {
     ButtonBox["PressureScaleHeight",
      BaseStyle->"Link",
      ButtonData->"paclet:StandardAtmosphere/ref/PressureScaleHeight"]},
    {
     ButtonBox["SoundSpeed",
      BaseStyle->"Link",
      ButtonData->"paclet:StandardAtmosphere/ref/SoundSpeed"]},
    {
     ButtonBox["ThermalConductivityCoefficient",
      BaseStyle->"Link",
      ButtonData->
       "paclet:StandardAtmosphere/ref/ThermalConductivityCoefficient"]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}}],
  "Column"]], "InlineFormula"]], "UpgradePackageListing",
 CellID->701993520]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 55, 46.3927200}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/StandardAtmosphere"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 83, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[895, 35, 345, 9, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[1243, 46, 315, 10, 70, "UpgradeDetail",
 CellID->556646693],
Cell[1561, 58, 237, 6, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[1823, 68, 228, 6, 70, "Input",
 CellID->1746043248],
Cell[2054, 76, 129, 4, 70, "Output",
 CellID->163680560]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[2232, 86, 81, 1, 70, "UpgradePackageSection",
 CellID->1087906933],
Cell[2316, 89, 323, 9, 70, "UpgradeDetail",
 CellID->1074807037],
Cell[2642, 100, 2229, 66, 70, "UpgradePackageListing",
 CellID->701993520]
}, Open  ]],
Cell[4886, 169, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

