(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26644,       1010]
NotebookOptionsPosition[     21673,        836]
NotebookOutlinePosition[     22650,        864]
CellTagsIndexPosition[     22607,        861]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["NumberTheory`AlgebraicNumberFields`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 Cell[BoxData["Algebraic"], "InlineFormula"],
 " is now available as the newly added built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel function ",
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 ".\n",
 Cell[BoxData["ToCommonField"], "InlineFormula"],
 " and ",
 Cell[BoxData["ToNumberFieldElement"], "InlineFormula"],
 " are now available as the newly added built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel function ",
 Cell[BoxData[
  ButtonBox["ToNumberField",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToNumberField"]], "InlineFormula"],
 ".\n",
 Cell[BoxData[
  ButtonBox["MinimalPolynomial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MinimalPolynomial"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["AlgebraicIntegerQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicIntegerQ"]], "InlineFormula"],
 ",  ",
 Cell[BoxData[
  ButtonBox["AlgebraicNumberDenominator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumberDenominator"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["AlgebraicNumberTrace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumberTrace"]], "InlineFormula"],
 ",  ",
 Cell[BoxData[
  ButtonBox["AlgebraicNumberNorm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumberNorm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["AlgebraicUnitQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicUnitQ"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RootOfUnityQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootOfUnityQ"]], "InlineFormula"],
 ", have been added to the built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel. \n",
 Cell[BoxData["IntegralBasis"], "InlineFormula"],
 " is now available as the newly added built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel function ",
 Cell[BoxData[
  ButtonBox["NumberFieldIntegralBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberFieldIntegralBasis"]], "InlineFormula"],
 ".\n",
 Cell[BoxData["FundamentalUnits"], "InlineFormula"],
 " is now available as the newly added built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel function ",
 Cell[BoxData[
  ButtonBox["NumberFieldFundamentalUnits",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberFieldFundamentalUnits"]], "InlineFormula"],
 ".\n",
 Cell[BoxData["NormRepresentatives"], "InlineFormula"],
 " is now available as the newly added newly added built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel function ",
 Cell[BoxData[
  ButtonBox["NumberFieldNormRepresentatives",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberFieldNormRepresentatives"]], 
  "InlineFormula"],
 ".\n",
 Cell[BoxData[
  ButtonBox["NumberFieldSignature",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberFieldSignature"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["NumberFieldDiscriminant",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberFieldDiscriminant"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["NumberFieldRegulator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberFieldRegulator"]], "InlineFormula"],
 " have been added to the built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel. \n",
 Cell[BoxData["RootsOfUnity"], "InlineFormula"],
 " is now available as the newly added built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel function ",
 Cell[BoxData[
  ButtonBox["NumberFieldRootsOfUnity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberFieldRootsOfUnity"]], "InlineFormula"],
 "."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[CellGroupData[{

Cell["AlgebraicNumber", "UpgradeDetailLabel",
 CellID->305554978],

Cell["\<\
Represent an algebraic number and get a numerical approximation:\
\>", "UpgradeDetail",
 CellID->267347351],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumberTheory`AlgebraicNumberFields`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"Algebraic", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["#1", "3"], "-", "#1", "+", "1"}], " ", "&"}], ",", " ",
      
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", " ", "1"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"N", "[", 
  RowBox[{"a", ",", "20"}], "]"}]}], "Input", "LegacyInput",
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "=", " ", 
  RowBox[{"AlgebraicNumber", "[", 
   RowBox[{
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["#1", "3"], "-", "#1", "+", "1"}], "&"}], ",", "1"}], 
     "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}], " "}]], "Input",
 CellLabel->"In[90]:=",
 CellID->1746043248],

Cell[BoxData[
 RowBox[{"AlgebraicNumber", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", "#1", "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]], "Output",
 CellLabel->"Out[90]=",
 CellID->296749355]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"a", ",", "20"}], "]"}]], "Input",
 CellLabel->"In[91]:=",
 CellID->68078628],

Cell[BoxData["3.6151970842505862282267089801193856096`20."], "Output",
 CellLabel->"Out[91]=",
 CellID->89828519]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ToNumberField", "UpgradeDetailLabel",
 CellID->73965015],

Cell["\<\
This finds a common finite extension of rationals containing the given \
algebraic numbers: \
\>", "UpgradeDetail",
 CellID->277818128],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumberTheory`AlgebraicNumberFields`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ToCommonField", "[", 
  RowBox[{"{", 
   RowBox[{
    SqrtBox["2"], ",", 
    SqrtBox["3"]}], "}"}], "]"}]}], "Input", "LegacyInput",
 CellID->176443349],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToNumberField", "[", 
  RowBox[{"{", 
   RowBox[{
    SqrtBox["2"], ",", 
    SqrtBox["3"]}], "}"}], "]"}]], "Input",
 CellLabel->"In[102]:=",
 CellID->564851838],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", 
        FractionBox["9", "2"]}], ",", "0", ",", 
       FractionBox["1", "2"]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       FractionBox["11", "2"], ",", "0", ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}]}], "]"}]}], "}"}]], "Output",
 CellLabel->"Out[102]=",
 CellID->317730415]
}, Open  ]],

Cell["\<\
This finds the smallest common finite extension of rationals containing the \
given algebraic numbers:\
\>", "UpgradeDetail",
 CellID->41393925],

Cell[BoxData[
 RowBox[{"ToCommonField", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Algebraic", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", 
         RowBox[{"10", " ", 
          RowBox[{"#1", "^", "2"}]}], "+", 
         RowBox[{"#1", "^", "4"}]}], "&"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{
          RowBox[{"-", "9"}], "/", "2"}], ",", "0", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", "4"}], "]"}], ",", 
     RowBox[{"Sqrt", "[", "5", "]"}]}], "}"}], ",", 
   RowBox[{"SmallestField", "\[Rule]", "True"}]}], "]"}]], "Input", \
"LegacyInput",
 CellID->2070479494],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToNumberField", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"AlgebraicNumber", "[", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"1", "-", 
           RowBox[{"10", " ", 
            RowBox[{"#1", "^", "2"}]}], "+", 
           RowBox[{"#1", "^", "4"}]}], "&"}], ",", "4"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{
          RowBox[{"-", "9"}], "/", "2"}], ",", "0", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"Sqrt", "[", "5", "]"}]}], "}"}], ",", "All"}], "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->723839670],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"9", "-", 
         RowBox[{"14", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", 
        FractionBox["11", "6"]}], ",", "0", ",", 
       FractionBox["1", "6"]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"9", "-", 
         RowBox[{"14", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       FractionBox["17", "6"], ",", "0", ",", 
       RowBox[{"-", 
        FractionBox["1", "6"]}]}], "}"}]}], "]"}]}], "}"}]], "Output",
 CellLabel->"Out[13]=",
 CellID->78473435]
}, Open  ]],

Cell[TextData[{
 "This represents ",
 Cell[BoxData[
  SqrtBox["6"]]],
 "as an element of the field generated by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Root",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Root"], "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "-", 
      RowBox[{"10", 
       SuperscriptBox["#1", "2"]}], "+", 
      SuperscriptBox["#1", "4"]}], "&"}], " ", ",", "4"}], " ", "]"}]], 
  "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->602966178],

Cell[BoxData[
 RowBox[{"ToNumberFieldElement", "[", 
  RowBox[{
   SqrtBox["6"], ",", " ", 
   RowBox[{
    RowBox[{"1", "-", 
     RowBox[{"10", " ", 
      SuperscriptBox["#1", "2"]}], "+", 
     SuperscriptBox["#1", "4"]}], "&"}], ",", " ", "4"}], "]"}]], "Input", \
"LegacyInput",
 CellID->257181987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToNumberField", "[", 
  RowBox[{
   SqrtBox["6"], ",", " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{"10", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[103]:=",
 CellID->87929286],

Cell[BoxData[
 RowBox[{"AlgebraicNumber", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{"10", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["5", "2"]}], ",", "0", ",", 
     FractionBox["1", "2"], ",", "0"}], "}"}]}], "]"}]], "Output",
 CellLabel->"Out[103]=",
 CellID->157105578]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MinimalPolynomial", "UpgradeDetailLabel",
 CellID->36220325],

Cell[TextData[{
 "This gives the minimal polynomial of ",
 Cell[BoxData[
  RowBox[{
   SqrtBox["2"], "+", 
   SqrtBox["3"]}]]],
 "expressed as a pure function:"
}], "UpgradeDetail",
 CellID->207444969],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumberTheory`AlgebraicNumberFields`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"MinimalPolynomial", "[", 
  RowBox[{
   SqrtBox["2"], "+", 
   SqrtBox["3"]}], "]"}]}], "Input", "LegacyInput",
 CellID->524790460],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MinimalPolynomial", "[", 
  RowBox[{
   SqrtBox["2"], "+", 
   SqrtBox["3"]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->273531603],

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "-", 
   RowBox[{"10", " ", 
    SuperscriptBox["#1", "2"]}], "+", 
   SuperscriptBox["#1", "4"]}], "&"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->720411078]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NumberFieldIntegralBasis", "UpgradeDetailLabel",
 CellID->256543851],

Cell[TextData[{
 "This gives an integral basis of the field generated by the first root of ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"533", "+", 
    RowBox[{"429", " ", "#1"}], "+", 
    RowBox[{"18", " ", 
     SuperscriptBox["#1", "2"]}], "+", 
    SuperscriptBox["#1", "3"]}], "&"}]]],
 ":"
}], "UpgradeDetail",
 CellID->236342],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumberTheory`AlgebraicNumberFields`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"IntegralBasis", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"533", "+", 
     RowBox[{"429", " ", "#1"}], "+", 
     RowBox[{"18", " ", 
      SuperscriptBox["#1", "2"]}], "+", 
     SuperscriptBox["#1", "3"]}], "&"}], ",", " ", "1"}], "]"}]}], "Input", \
"LegacyInput",
 CellID->569255590],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldIntegralBasis", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"533", "+", 
     RowBox[{"429", " ", "#1"}], "+", 
     RowBox[{"18", " ", 
      SuperscriptBox["#1", "2"]}], "+", 
     SuperscriptBox["#1", "3"]}], "&"}], ",", " ", "1"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->209959576],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"533", "+", 
         RowBox[{"429", " ", "#1"}], "+", 
         RowBox[{"18", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"533", "+", 
         RowBox[{"429", " ", "#1"}], "+", 
         RowBox[{"18", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["742", "759"], ",", 
       FractionBox["94", "759"], ",", 
       FractionBox["1", "759"]}], "}"}]}], "]"}]}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->294344290]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NumberFieldFundamentalUnits", "UpgradeDetailLabel",
 CellID->681270465],

Cell[TextData[{
 "This gives a fundamental unit of the field ",
 Cell[BoxData[
  RowBox[{"\[DoubleStruckCapitalQ]", "[", 
   RowBox[{
    ButtonBox["Sqrt",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Sqrt"], "[", "2", "]"}], "]"}]], 
  "InlineFormula"],
 " generated by the algebraic number ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sqrt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sqrt"], "[", "2", "]"}]], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->348062787],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumberTheory`AlgebraicNumberFields`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"FundamentalUnits", "[", 
  RowBox[{"Sqrt", "[", "2", "]"}], "]"}]}], "Input", "LegacyInput",
 CellID->133118633],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldFundamentalUnits", "[", 
  RowBox[{"Sqrt", "[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->49416067],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"AlgebraicNumber", "[", 
   RowBox[{
    SqrtBox["2"], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}]}], "]"}], "}"}]], "Output",
 CellLabel->"Out[9]=",
 CellID->784595963]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NumberFieldNormRepresentatives", "UpgradeDetailLabel",
 CellID->730831130],

Cell[TextData[{
 "This gives a set of representatives of classes of elements of norm 2 in the \
field generated by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sqrt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sqrt"], "[", "2", "]"}]], "InlineFormula"],
 "+",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sqrt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sqrt"], "[", "3", "]"}]], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->145806681],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumberTheory`AlgebraicNumberFields`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"NormRepresentatives", "[", 
  RowBox[{"2", ",", 
   RowBox[{
    SqrtBox["2"], "+", 
    SqrtBox["3"]}]}], "]"}]}], "Input", "LegacyInput",
 CellID->727558111],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldNormRepresentatives", "[", 
  RowBox[{
   RowBox[{
    SqrtBox["2"], "+", 
    SqrtBox["3"]}], ",", " ", "2"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->484736991],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"AlgebraicNumber", "[", 
   RowBox[{
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"1", "-", 
        RowBox[{"10", " ", 
         SuperscriptBox["#1", "2"]}], "+", 
        SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["9", "4"]}], ",", 
      FractionBox["9", "4"], ",", 
      FractionBox["1", "4"], ",", 
      RowBox[{"-", 
       FractionBox["1", "4"]}]}], "}"}]}], "]"}], "}"}]], "Output",
 CellLabel->"Out[7]=",
 CellID->300468020]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NumberFieldSignature", "UpgradeDetailLabel",
 CellID->361835225],

Cell[TextData[{
 "Find the signature of the number field ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", 
    RowBox[{
     SqrtBox["2"], "+", 
     SqrtBox["3"]}], "]"}], TraditionalForm]], "InlineMath"],
 ":"
}], "UpgradeDetail",
 CellID->24200690],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumberTheory`AlgebraicNumberFields`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"NumberFieldSignature", "[", 
  RowBox[{
   SqrtBox["2"], "+", 
   SqrtBox["3"]}], "]"}]}], "Input", "LegacyInput",
 CellID->259854163],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldSignature", "[", 
  RowBox[{
   SqrtBox["2"], "+", 
   SqrtBox["3"]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->593009019],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "0"}], "}"}]], "Output",
 CellLabel->"Out[10]=",
 CellID->15660379]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NumberFieldRootsOfUnity", "UpgradeDetailLabel",
 CellID->281092221],

Cell[TextData[{
 "Here are all roots of unity in the field  ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", 
    RowBox[{"1", "+", " ", 
     RowBox[{"\[ImaginaryI]", 
      SqrtBox["3"]}]}], "]"}], TraditionalForm]], "InlineMath"],
 ":"
}], "UpgradeDetail",
 CellID->13701136],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumberTheory`AlgebraicNumberFields`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"RootsOfUnity", "[", 
  RowBox[{"1", "+", 
   RowBox[{"\[ImaginaryI]", " ", 
    SqrtBox["3"]}]}], "]"}]}], "Input", "LegacyInput",
 CellID->122830410],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldRootsOfUnity", "[", 
  RowBox[{"1", "+", 
   RowBox[{"\[ImaginaryI]", " ", 
    SqrtBox["3"]}]}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->973211747],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "1", ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["3"]}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       FractionBox["1", "2"]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["3"]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["3"]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       FractionBox["1", "2"]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["3"]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}]}], "]"}]}], "}"}]], "Output",
 CellLabel->"Out[11]=",
 CellID->156827169]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 55, 46.7364788}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/AlgebraicNumberFields"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 85, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[897, 35, 3775, 121, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[CellGroupData[{
Cell[4697, 160, 65, 1, 70, "UpgradeDetailLabel",
 CellID->305554978],
Cell[4765, 163, 117, 3, 70, "UpgradeDetail",
 CellID->267347351],
Cell[4885, 168, 533, 17, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[5443, 189, 393, 13, 70, "Input",
 CellID->1746043248],
Cell[5839, 204, 341, 11, 70, "Output",
 CellID->296749355]
}, Open  ]],
Cell[CellGroupData[{
Cell[6217, 220, 121, 4, 70, "Input",
 CellID->68078628],
Cell[6341, 226, 113, 2, 70, "Output",
 CellID->89828519]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6503, 234, 62, 1, 70, "UpgradeDetailLabel",
 CellID->73965015],
Cell[6568, 237, 145, 4, 70, "UpgradeDetail",
 CellID->277818128],
Cell[6716, 243, 279, 9, 70, "Input",
 CellID->176443349],
Cell[CellGroupData[{
Cell[7020, 256, 186, 7, 70, "Input",
 CellID->564851838],
Cell[7209, 265, 991, 32, 70, "Output",
 CellID->317730415]
}, Open  ]],
Cell[8215, 300, 154, 4, 70, "UpgradeDetail",
 CellID->41393925],
Cell[8372, 306, 650, 20, 70, "Input",
 CellID->2070479494],
Cell[CellGroupData[{
Cell[9047, 330, 684, 21, 70, "Input",
 CellID->723839670],
Cell[9734, 353, 990, 32, 70, "Output",
 CellID->78473435]
}, Open  ]],
Cell[10739, 388, 477, 19, 70, "UpgradeDetail",
 CellID->602966178],
Cell[11219, 409, 304, 10, 70, "Input",
 CellID->257181987],
Cell[CellGroupData[{
Cell[11548, 423, 359, 13, 70, "Input",
 CellID->87929286],
Cell[11910, 438, 481, 16, 70, "Output",
 CellID->157105578]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12440, 460, 66, 1, 70, "UpgradeDetailLabel",
 CellID->36220325],
Cell[12509, 463, 201, 8, 70, "UpgradeDetail",
 CellID->207444969],
Cell[12713, 473, 257, 8, 70, "Input",
 CellID->524790460],
Cell[CellGroupData[{
Cell[12995, 485, 162, 6, 70, "Input",
 CellID->273531603],
Cell[13160, 493, 199, 7, 70, "Output",
 CellID->720411078]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13408, 506, 74, 1, 70, "UpgradeDetailLabel",
 CellID->256543851],
Cell[13485, 509, 330, 11, 70, "UpgradeDetail",
 CellID->236342],
Cell[13818, 522, 413, 13, 70, "Input",
 CellID->569255590],
Cell[CellGroupData[{
Cell[14256, 539, 327, 10, 70, "Input",
 CellID->209959576],
Cell[14586, 551, 1003, 31, 70, "Output",
 CellID->294344290]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15638, 588, 77, 1, 70, "UpgradeDetailLabel",
 CellID->681270465],
Cell[15718, 591, 490, 17, 70, "UpgradeDetail",
 CellID->348062787],
Cell[16211, 610, 238, 6, 70, "Input",
 CellID->133118633],
Cell[CellGroupData[{
Cell[16474, 620, 153, 4, 70, "Input",
 CellID->49416067],
Cell[16630, 626, 224, 8, 70, "Output",
 CellID->784595963]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16903, 640, 80, 1, 70, "UpgradeDetailLabel",
 CellID->730831130],
Cell[16986, 643, 453, 16, 70, "UpgradeDetail",
 CellID->145806681],
Cell[17442, 661, 285, 9, 70, "Input",
 CellID->727558111],
Cell[CellGroupData[{
Cell[17752, 674, 206, 7, 70, "Input",
 CellID->484736991],
Cell[17961, 683, 588, 20, 70, "Output",
 CellID->300468020]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18598, 709, 70, 1, 70, "UpgradeDetailLabel",
 CellID->361835225],
Cell[18671, 712, 274, 10, 70, "UpgradeDetail",
 CellID->24200690],
Cell[18948, 724, 260, 8, 70, "Input",
 CellID->259854163],
Cell[CellGroupData[{
Cell[19233, 736, 166, 6, 70, "Input",
 CellID->593009019],
Cell[19402, 744, 116, 4, 70, "Output",
 CellID->15660379]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19567, 754, 73, 1, 70, "UpgradeDetailLabel",
 CellID->281092221],
Cell[19643, 757, 301, 10, 70, "UpgradeDetail",
 CellID->13701136],
Cell[19947, 769, 276, 8, 70, "Input",
 CellID->122830410],
Cell[CellGroupData[{
Cell[20248, 781, 193, 6, 70, "Input",
 CellID->973211747],
Cell[20444, 789, 1163, 40, 70, "Output",
 CellID->156827169]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[21646, 834, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

