(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      5536,        203]
NotebookOptionsPosition[      3586,        139]
NotebookOutlinePosition[      4560,        167]
CellTagsIndexPosition[      4517,        164]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["NumberTheory`ContinuedFractions`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Convergents",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Convergents"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["QuadraticIrrationalQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/QuadraticIrrationalQ"]], "InlineFormula"],
 " have been added to the built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel. "
}], "UpgradeSummary",
 CellID->1010000471],

Cell[CellGroupData[{

Cell["Convergents", "UpgradeDetailLabel",
 CellID->2082128514],

Cell["Generate the first 10 convergents to the Golden Ratio:", "UpgradeDetail",
 CellID->556646693],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumberTheory`ContinuedFractions`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Convergents", "[", 
  RowBox[{"GoldenRatio", ",", " ", "10"}], "]"}]}], "Input", "LegacyInput",
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convergents", "[", 
  RowBox[{"GoldenRatio", ",", " ", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1746043248],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", 
   FractionBox["3", "2"], ",", 
   FractionBox["5", "3"], ",", 
   FractionBox["8", "5"], ",", 
   FractionBox["13", "8"], ",", 
   FractionBox["21", "13"], ",", 
   FractionBox["34", "21"], ",", 
   FractionBox["55", "34"], ",", 
   FractionBox["89", "55"]}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->359666569]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["QuadraticIrrationalQ", "UpgradeDetailLabel",
 CellID->19482838],

Cell["Check if an expression is a quadratic irrational:", "UpgradeDetail",
 CellID->431390416],

Cell[BoxData[{
 RowBox[{"<<", "NumberTheory`ContinuedFractions`"}], "\[IndentingNewLine]", 
 RowBox[{"QuadraticIrrationalQ", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"3", "/", "2"}], ",", " ", 
    RowBox[{"Sqrt", "[", "2", "]"}], ",", " ", 
    RowBox[{"Sqrt", "[", "3", "]"}], ",", " ", 
    RowBox[{"Sqrt", "[", "4", "]"}], ",", " ", "Pi"}], "}"}], "]"}]}], "Input",\
 "LegacyInput",
 CellID->3174704],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"QuadraticIrrationalQ", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "/", "2"}], ",", " ", 
     RowBox[{"Sqrt", "[", "2", "]"}], ",", " ", 
     RowBox[{"Sqrt", "[", "3", "]"}], ",", " ", 
     RowBox[{"Sqrt", "[", "4", "]"}], ",", " ", "Pi"}], "}"}], 
   "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->905456],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"False", ",", "True", ",", "True", ",", "False", ",", "False"}], 
  "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->143495224]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 55, 46.9239836}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/ContinuedFractions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 82, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[894, 35, 436, 15, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[CellGroupData[{
Cell[1355, 54, 62, 1, 70, "UpgradeDetailLabel",
 CellID->2082128514],
Cell[1420, 57, 99, 1, 70, "UpgradeDetail",
 CellID->556646693],
Cell[1522, 60, 239, 6, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[1786, 70, 147, 4, 70, "Input",
 CellID->1746043248],
Cell[1936, 76, 381, 12, 70, "Output",
 CellID->359666569]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[2366, 94, 69, 1, 70, "UpgradeDetailLabel",
 CellID->19482838],
Cell[2438, 97, 94, 1, 70, "UpgradeDetail",
 CellID->431390416],
Cell[2535, 100, 409, 10, 70, "Input",
 CellID->3174704],
Cell[CellGroupData[{
Cell[2969, 114, 381, 11, 70, "Input",
 CellID->905456],
Cell[3353, 127, 167, 5, 70, "Output",
 CellID->143495224]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[3559, 137, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

