(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22795,        907]
NotebookOptionsPosition[     16298,        675]
NotebookOutlinePosition[     17275,        703]
CellTagsIndexPosition[     17232,        700]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["NumberTheory`NumberTheoryFunctions`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SquareFreeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SquareFreeQ"]], "InlineFormula"],
 " has been added to the built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel.\n",
 Cell[BoxData[
  ButtonBox["NextPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NextPrime"]], "InlineFormula"],
 " and ",
 Cell[BoxData["PreviousPrime"], "InlineFormula"],
 " are now available as the newly added built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel function ",
 Cell[BoxData[
  ButtonBox["NextPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NextPrime"]], "InlineFormula"],
 ".\n",
 Cell[BoxData[
  RowBox[{"Random", "[", 
   RowBox[{"Prime", ",", "..."}], "]"}]], "InlineFormula"],
 " is now available as the newly added built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel function ",
 Cell[BoxData[
  ButtonBox["RandomPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomPrime"]], "InlineFormula"],
 ".\nThe functionality of ",
 Cell[BoxData["LeastPrimeFactor"], "InlineFormula"],
 " is now available in the enhanced built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel function ",
 Cell[BoxData[
  ButtonBox["FactorInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorInteger"]], "InlineFormula"],
 ".\n",
 Cell[BoxData[
  ButtonBox["PrimePowerQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrimePowerQ"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ChineseRemainder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ChineseRemainder"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["PrimitiveRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrimitiveRoot"]], "InlineFormula"],
 " have been added to the built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel.\n",
 Cell[BoxData["SqrtMod"], "InlineFormula"],
 " is now available as the built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel function ",
 Cell[BoxData[
  ButtonBox["PowerMod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerMod"]], "InlineFormula"],
 ".\n",
 Cell[BoxData["SqrtModList"], "InlineFormula"],
 " is now available as the newly added built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel function ",
 Cell[BoxData[
  ButtonBox["PowerModList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerModList"]], "InlineFormula"],
 ".\n",
 Cell[BoxData["ClassNumber"], "InlineFormula"],
 " is now available as the newly added built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel function ",
 Cell[BoxData[
  ButtonBox["NumberFieldClassNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberFieldClassNumber"]], "InlineFormula"],
 ".\n",
 Cell[BoxData[
  ButtonBox["KroneckerSymbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/KroneckerSymbol"]], "InlineFormula"],
 " is now available as the built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel functions ",
 Cell[BoxData[
  ButtonBox["KroneckerSymbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/KroneckerSymbol"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["JacobiSymbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiSymbol"]], "InlineFormula"],
 ".\n",
 Cell[BoxData["SumOfSquaresR"], "InlineFormula"],
 " is now available as the built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel functions ",
 Cell[BoxData[
  ButtonBox["SquaresR",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SquaresR"]], "InlineFormula"],
 ".\n",
 Cell[BoxData["SumOfSquaresRepresentations"], "InlineFormula"],
 " and ",
 Cell[BoxData["OrderedSumOfSquaresRepresentations"], "InlineFormula"],
 " are now available as the built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel function ",
 Cell[BoxData[
  ButtonBox["PowersRepresentations",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowersRepresentations"]], "InlineFormula"],
 "."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[CellGroupData[{

Cell["SquareFreeQ", "UpgradeDetailLabel",
 CellID->305554978],

Cell["The product of primes contains no squared factors: ", "UpgradeDetail",
 CellID->1457835045],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumberTheory`NumberTheoryFunctions`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"SquareFreeQ", "[", 
  RowBox[{"2", "*", "3", "*", "5", "*", "7"}], "]"}]}], "Input", \
"LegacyInput",
 CellID->128644277],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SquareFreeQ", "[", 
  RowBox[{"2", "*", "3", "*", "5", "*", "7"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->281072451],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[1]=",
 CellID->525798267]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NextPrime and PreviousPrime", "UpgradeDetailLabel",
 CellID->324820794],

Cell["The next prime after a million:", "UpgradeDetail",
 CellID->892538127],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumberTheory`NumberTheoryFunctions`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"NextPrime", "[", "1000000", "]"}]}], "Input", "LegacyInput",
 CellID->391601240],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NextPrime", "[", "1000000", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28416422],

Cell[BoxData["1000003"], "Output",
 CellLabel->"Out[2]=",
 CellID->81684621]
}, Open  ]],

Cell["The last prime before a million:", "UpgradeDetail",
 CellID->137034921],

Cell[BoxData[
 RowBox[{"PreviousPrime", "[", "1000000", "]"}]], "Input", "LegacyInput",
 CellID->141097264],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NextPrime", "[", 
  RowBox[{"1000000", ",", " ", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->101494439],

Cell[BoxData["999983"], "Output",
 CellLabel->"Out[3]=",
 CellID->68491146]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Random[Prime, ...]", "UpgradeDetailLabel",
 CellID->40145315],

Cell["A random prime number between 10 and 100:", "UpgradeDetail",
 CellID->35830],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumberTheory`NumberTheoryFunctions`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Random", "[", 
  RowBox[{"Prime", ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "100"}], "}"}]}], "]"}]}], "Input", "LegacyInput",
 CellID->108510952],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomPrime", "[", 
  RowBox[{"{", 
   RowBox[{"10", ",", " ", "100"}], "}"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->429779807],

Cell[BoxData["97"], "Output",
 CellLabel->"Out[4]=",
 CellID->459266613]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["LeastPrimeFactor", "UpgradeDetailLabel",
 CellID->214525380],

Cell["Find the least prime factor of 713:", "UpgradeDetail",
 CellID->259739886],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumberTheory`NumberTheoryFunctions`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"LeastPrimeFactor", "[", "713", "]"}]}], "Input", "LegacyInput",
 CellID->300813075],

Cell[TextData[{
 "The built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel function ",
 Cell[BoxData[
  ButtonBox["FactorInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorInteger"]], "InlineFormula"],
 " can be used to find the least prime factor: "
}], "UpgradeDetail",
 CellID->123803442],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FactorInteger", "[", "713", "]"}], "[", 
  RowBox[{"[", 
   RowBox[{"1", ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->32988408],

Cell[BoxData["23"], "Output",
 CellLabel->"Out[12]=",
 CellID->57105594]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["PrimePowerQ", "UpgradeDetailLabel",
 CellID->165410566],

Cell["Here is a number that is a power of a single prime: ", "UpgradeDetail",
 CellID->481085314],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumberTheory`NumberTheoryFunctions`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"PrimePowerQ", "[", "12167", "]"}]}], "Input", "LegacyInput",
 CellID->72149551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimePowerQ", "[", "12167", "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->139377120],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[15]=",
 CellID->646270065]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ChineseRemainder", "UpgradeDetailLabel",
 CellID->581857303],

Cell[TextData[{
 "The smallest positive integer ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 "  that satisfies ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["x", "TI"], " ", 
    StyleBox["mod", "TI"], " ", "4"}], " ", "=", " ", "3"}]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["x", "TI"], " ", 
    StyleBox["mod", "TI"], " ", "5"}], " ", "=", " ", "4"}]], 
  "InlineFormula"],
 ": "
}], "UpgradeDetail",
 CellID->59244704],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumberTheory`NumberTheoryFunctions`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ChineseRemainder", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}]}], "]"}]}], "Input", "LegacyInput",
 CellID->90053088],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChineseRemainder", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->101980143],

Cell[BoxData["19"], "Output",
 CellLabel->"Out[16]=",
 CellID->178901819]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SqrtMod and SqrtModList", "UpgradeDetailLabel",
 CellID->695893607],

Cell[TextData[{
 "This finds the smallest nonnegative integer ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " so that ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["x", "TI"], "2"]], "InlineFormula"],
 " is equal to 3 mod 11:"
}], "UpgradeDetail",
 CellID->106259204],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumberTheory`NumberTheoryFunctions`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"SqrtMod", "[", 
  RowBox[{"3", ",", "11"}], "]"}]}], "Input", "LegacyInput",
 CellID->118860234],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerMod", "[", 
  RowBox[{"3", ",", " ", 
   RowBox[{"1", "/", "2"}], ",", " ", "11"}], "]"}]], "Input",
 CellLabel->"In[34]:=",
 CellID->353961455],

Cell[BoxData["5"], "Output",
 CellLabel->"Out[34]=",
 CellID->233278015]
}, Open  ]],

Cell["\<\
This returns all integers less than 11 that satisfy the relation:\
\>", "UpgradeDetail",
 CellID->97564114],

Cell[BoxData[
 RowBox[{"SqrtModList", "[", 
  RowBox[{"3", ",", "11"}], "]"}]], "Input", "LegacyInput",
 CellID->10334051],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerModList", "[", 
  RowBox[{"3", ",", " ", 
   RowBox[{"1", "/", "2"}], ",", " ", "11"}], "]"}]], "Input",
 CellLabel->"In[35]:=",
 CellID->419877291],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", "6"}], "}"}]], "Output",
 CellLabel->"Out[35]=",
 CellID->165907221]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ClassNumber", "UpgradeDetailLabel",
 CellID->197712322],

Cell["\<\
Find the class number for the algebraic number field \[DoubleStruckCapitalQ][\
\[Theta]] generated by \[Theta]:\
\>", "UpgradeDetail",
 CellID->698771136],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumberTheory`NumberTheoryFunctions`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ClassNumber", "[", 
  RowBox[{"-", "10099"}], "]"}]}], "Input", "LegacyInput",
 CellID->5116298],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldClassNumber", "[", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"-", "10099"}], "]"}], "]"}]], "Input",
 CellLabel->"In[37]:=",
 CellID->449207789],

Cell[BoxData["25"], "Output",
 CellLabel->"Out[37]=",
 CellID->165202]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["KroneckerSymbol", "UpgradeDetailLabel",
 CellID->165657071],

Cell[TextData[{
 "Find the Kronecker symbol ",
 Cell[BoxData[
  RowBox[{"(", 
   FractionBox["5", "3"], ")"}]], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->141312315],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumberTheory`NumberTheoryFunctions`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"KroneckerSymbol", "[", 
  RowBox[{"5", ",", "3"}], "]"}]}], "Input", "LegacyInput",
 CellID->98526422],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"KroneckerSymbol", "[", 
  RowBox[{"5", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[39]:=",
 CellID->669813196],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 CellLabel->"Out[39]=",
 CellID->506381678]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiSymbol", "[", 
  RowBox[{"5", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[40]:=",
 CellID->266090956],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 CellLabel->"Out[40]=",
 CellID->184190271]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SumOfSquares", "UpgradeDetailLabel",
 CellID->251791385],

Cell["Number of ways to represent 100 as a sum of 3 squares:", "UpgradeDetail",
 CellID->159092591],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumberTheory`NumberTheoryFunctions`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"SumOfSquaresR", "[", 
  RowBox[{"3", ",", "100"}], "]"}]}], "Input", "LegacyInput",
 CellID->27179866],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SquaresR", "[", 
  RowBox[{"3", ",", "100"}], "]"}]], "Input",
 CellLabel->"In[45]:=",
 CellID->726667955],

Cell[BoxData["30"], "Output",
 CellLabel->"Out[45]=",
 CellID->104821437]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SumOfSquaresRepresentations", "UpgradeDetailLabel",
 CellID->187060254],

Cell["Here are the representations of 100 as a sum of 3 squares: ", \
"UpgradeDetail",
 CellID->198974887],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumberTheory`NumberTheoryFunctions`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"SumOfSquaresRepresentations", "[", 
  RowBox[{"3", ",", "100"}], "]"}]}], "Input", "LegacyInput",
 CellID->438726531],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowersRepresentations", "[", 
  RowBox[{"100", ",", "3", ",", " ", "2"}], "]"}]], "Input",
 CellLabel->"In[50]:=",
 CellID->237985917],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6", ",", "8"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[50]=",
 CellID->2924779]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["OrderedSumOfSquaresRepresentations", "UpgradeDetailLabel",
 CellID->36553416],

Cell["\<\
Here is an ordered list of the representations of 100 as a sum of 3 squares: \
\
\>", "UpgradeDetail",
 CellID->76963685],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumberTheory`NumberTheoryFunctions`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"OrderedSumOfSquaresRepresentations", "[", 
  RowBox[{"3", ",", "100"}], "]"}]}], "Input", "LegacyInput",
 CellID->899464698],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reverse", "/@", 
  RowBox[{"PowersRepresentations", "[", 
   RowBox[{"100", ",", "3", ",", " ", "2"}], "]"}]}]], "Input",
 CellLabel->"In[51]:=",
 CellID->293923564],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"10", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "6", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[51]=",
 CellID->103364682]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 55, 47.3771202}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/NumberTheoryFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 85, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[897, 35, 4039, 135, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[CellGroupData[{
Cell[4961, 174, 61, 1, 70, "UpgradeDetailLabel",
 CellID->305554978],
Cell[5025, 177, 97, 1, 70, "UpgradeDetail",
 CellID->1457835045],
Cell[5125, 180, 247, 7, 70, "Input",
 CellID->128644277],
Cell[CellGroupData[{
Cell[5397, 191, 150, 4, 70, "Input",
 CellID->281072451],
Cell[5550, 197, 74, 2, 70, "Output",
 CellID->525798267]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5673, 205, 77, 1, 70, "UpgradeDetailLabel",
 CellID->324820794],
Cell[5753, 208, 76, 1, 70, "UpgradeDetail",
 CellID->892538127],
Cell[5832, 211, 206, 5, 70, "Input",
 CellID->391601240],
Cell[CellGroupData[{
Cell[6063, 220, 110, 3, 70, "Input",
 CellID->28416422],
Cell[6176, 225, 76, 2, 70, "Output",
 CellID->81684621]
}, Open  ]],
Cell[6267, 230, 77, 1, 70, "UpgradeDetail",
 CellID->137034921],
Cell[6347, 233, 107, 2, 70, "Input",
 CellID->141097264],
Cell[CellGroupData[{
Cell[6479, 239, 158, 5, 70, "Input",
 CellID->101494439],
Cell[6640, 246, 75, 2, 70, "Output",
 CellID->68491146]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6764, 254, 67, 1, 70, "UpgradeDetailLabel",
 CellID->40145315],
Cell[6834, 257, 82, 1, 70, "UpgradeDetail",
 CellID->35830],
Cell[6919, 260, 276, 8, 70, "Input",
 CellID->108510952],
Cell[CellGroupData[{
Cell[7220, 272, 162, 5, 70, "Input",
 CellID->429779807],
Cell[7385, 279, 72, 2, 70, "Output",
 CellID->459266613]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7506, 287, 66, 1, 70, "UpgradeDetailLabel",
 CellID->214525380],
Cell[7575, 290, 80, 1, 70, "UpgradeDetail",
 CellID->259739886],
Cell[7658, 293, 209, 5, 70, "Input",
 CellID->300813075],
Cell[7870, 300, 323, 11, 70, "UpgradeDetail",
 CellID->123803442],
Cell[CellGroupData[{
Cell[8218, 315, 186, 6, 70, "Input",
 CellID->32988408],
Cell[8407, 323, 72, 2, 70, "Output",
 CellID->57105594]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8528, 331, 61, 1, 70, "UpgradeDetailLabel",
 CellID->165410566],
Cell[8592, 334, 97, 1, 70, "UpgradeDetail",
 CellID->481085314],
Cell[8692, 337, 205, 5, 70, "Input",
 CellID->72149551],
Cell[CellGroupData[{
Cell[8922, 346, 112, 3, 70, "Input",
 CellID->139377120],
Cell[9037, 351, 75, 2, 70, "Output",
 CellID->646270065]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9161, 359, 66, 1, 70, "UpgradeDetailLabel",
 CellID->581857303],
Cell[9230, 362, 489, 20, 70, "UpgradeDetail",
 CellID->59244704],
Cell[9722, 384, 332, 10, 70, "Input",
 CellID->90053088],
Cell[CellGroupData[{
Cell[10079, 398, 234, 8, 70, "Input",
 CellID->101980143],
Cell[10316, 408, 73, 2, 70, "Output",
 CellID->178901819]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10438, 416, 73, 1, 70, "UpgradeDetailLabel",
 CellID->695893607],
Cell[10514, 419, 284, 10, 70, "UpgradeDetail",
 CellID->106259204],
Cell[10801, 431, 222, 6, 70, "Input",
 CellID->118860234],
Cell[CellGroupData[{
Cell[11048, 441, 173, 5, 70, "Input",
 CellID->353961455],
Cell[11224, 448, 72, 2, 70, "Output",
 CellID->233278015]
}, Open  ]],
Cell[11311, 453, 117, 3, 70, "UpgradeDetail",
 CellID->97564114],
Cell[11431, 458, 122, 3, 70, "Input",
 CellID->10334051],
Cell[CellGroupData[{
Cell[11578, 465, 177, 5, 70, "Input",
 CellID->419877291],
Cell[11758, 472, 117, 4, 70, "Output",
 CellID->165907221]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11924, 482, 61, 1, 70, "UpgradeDetailLabel",
 CellID->197712322],
Cell[11988, 485, 164, 4, 70, "UpgradeDetail",
 CellID->698771136],
Cell[12155, 491, 222, 6, 70, "Input",
 CellID->5116298],
Cell[CellGroupData[{
Cell[12402, 501, 173, 5, 70, "Input",
 CellID->449207789],
Cell[12578, 508, 70, 2, 70, "Output",
 CellID->165202]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12697, 516, 65, 1, 70, "UpgradeDetailLabel",
 CellID->165657071],
Cell[12765, 519, 175, 7, 70, "UpgradeDetail",
 CellID->141312315],
Cell[12943, 528, 228, 6, 70, "Input",
 CellID->98526422],
Cell[CellGroupData[{
Cell[13196, 538, 135, 4, 70, "Input",
 CellID->669813196],
Cell[13334, 544, 89, 3, 70, "Output",
 CellID->506381678]
}, Open  ]],
Cell[CellGroupData[{
Cell[13460, 552, 132, 4, 70, "Input",
 CellID->266090956],
Cell[13595, 558, 89, 3, 70, "Output",
 CellID->184190271]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13733, 567, 62, 1, 70, "UpgradeDetailLabel",
 CellID->251791385],
Cell[13798, 570, 99, 1, 70, "UpgradeDetail",
 CellID->159092591],
Cell[13900, 573, 228, 6, 70, "Input",
 CellID->27179866],
Cell[CellGroupData[{
Cell[14153, 583, 130, 4, 70, "Input",
 CellID->726667955],
Cell[14286, 589, 73, 2, 70, "Output",
 CellID->104821437]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14408, 597, 77, 1, 70, "UpgradeDetailLabel",
 CellID->187060254],
Cell[14488, 600, 106, 2, 70, "UpgradeDetail",
 CellID->198974887],
Cell[14597, 604, 243, 6, 70, "Input",
 CellID->438726531],
Cell[CellGroupData[{
Cell[14865, 614, 158, 4, 70, "Input",
 CellID->237985917],
Cell[15026, 620, 234, 8, 70, "Output",
 CellID->2924779]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15309, 634, 83, 1, 70, "UpgradeDetailLabel",
 CellID->36553416],
Cell[15395, 637, 131, 4, 70, "UpgradeDetail",
 CellID->76963685],
Cell[15529, 643, 250, 6, 70, "Input",
 CellID->899464698],
Cell[CellGroupData[{
Cell[15804, 653, 189, 5, 70, "Input",
 CellID->293923564],
Cell[15996, 660, 236, 8, 70, "Output",
 CellID->103364682]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[16271, 673, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

