(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      5706,        200]
NotebookOptionsPosition[      4229,        154]
NotebookOutlinePosition[      5201,        182]
CellTagsIndexPosition[      5158,        179]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["NumberTheory`PrimitiveElement`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "The functionality of ",
 Cell[BoxData[
  RowBox[{"PrimitveElement", " "}]], "InlineFormula"],
 "is now available in the newly added built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel function ",
 Cell[BoxData[
  ButtonBox["ToNumberField",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToNumberField"]], "InlineFormula"],
 "."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 Cell[BoxData["PrimitiveElement"], "InlineFormula"],
 " can be implemented using ",
 Cell[BoxData[
  ButtonBox["ToNumberField",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToNumberField"]], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->74044747],

Cell[BoxData[{
 RowBox[{"<<", "NumberTheory`PrimitiveElement`"}], "\[IndentingNewLine]", 
 RowBox[{"PrimitiveElement", "[", 
  RowBox[{"z", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], ",", 
     RowBox[{"Sqrt", "[", "3", "]"}]}], "}"}]}], "]"}]}], "Input", \
"LegacyInput",
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PrimitiveElement", "[", 
    RowBox[{"z_", ",", "algs_List"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ans", "=", 
        RowBox[{"ToNumberField", "[", "algs", "]"}]}], ",", "aa"}], "}"}], 
     ",", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"ListQ", "[", "ans", "]"}], ",", 
        RowBox[{
         RowBox[{"aa", "=", 
          RowBox[{"Select", "[", 
           RowBox[{"ans", ",", 
            RowBox[{
             RowBox[{
              RowBox[{"Head", "[", "#", "]"}], "===", "AlgebraicNumber"}], 
             "&"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"ans", "=", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"aa", "===", 
               RowBox[{"{", "}"}]}], ",", "1", ",", 
              RowBox[{"aa", "[", 
               RowBox[{"[", 
                RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "]"}], ",", 
            RowBox[{"AlgebraicNumberPolynomial", "[", 
             RowBox[{"ans", ",", "z"}], "]"}]}], "}"}]}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ans", "/;", 
       RowBox[{"ListQ", "[", "ans", "]"}]}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"PrimitiveElement", "[", 
  RowBox[{"z", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], ",", 
     RowBox[{"Sqrt", "[", "3", "]"}]}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[15]:=",
 CellID->460794801],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{"10", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"9", " ", "z"}], "2"]}], "+", 
      FractionBox[
       SuperscriptBox["z", "3"], "2"]}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"11", " ", "z"}], "2"], "-", 
      FractionBox[
       SuperscriptBox["z", "3"], "2"]}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[16]=",
 CellID->752189325]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 55, 54.4866772}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/PrimitiveElement"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 80, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[892, 35, 409, 14, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[1304, 51, 273, 9, 70, "UpgradeDetail",
 CellID->74044747],
Cell[1580, 62, 324, 9, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[1929, 75, 1581, 47, 70, "Input",
 CellID->460794801],
Cell[3513, 124, 662, 24, 70, "Output",
 CellID->752189325]
}, Open  ]]
}, Open  ]],
Cell[4202, 152, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

