(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6206,        231]
NotebookOptionsPosition[      4255,        167]
NotebookOutlinePosition[      5220,        195]
CellTagsIndexPosition[      5177,        192]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["NumberTheory`Ramanujan`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RamanujanTau",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RamanujanTau"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RamanujanTauTheta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RamanujanTauTheta"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RamanujanTau",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RamanujanTau"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RamanujanTauZ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RamanujanTauZ"]], "InlineFormula"],
 "  is now available as the newly added built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel function ",
 Cell[BoxData[
  ButtonBox["RamanujanTau",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RamanujanTau"]], "InlineFormula"],
 ".\n",
 Cell[BoxData["RamanujanTauDirichletSeries"], "InlineFormula"],
 " is now available as the newly added built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel function ",
 Cell[BoxData[
  ButtonBox["RamanujanTauL",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RamanujanTauL"]], "InlineFormula"],
 "."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[CellGroupData[{

Cell["RamanujanTau", "UpgradeDetailLabel",
 CellID->320256877],

Cell[TextData[{
 "The first 10 values of ",
 Cell[BoxData[
  ButtonBox["RamanujanTau",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RamanujanTau"]], "InlineFormula"],
 ": "
}], "UpgradeDetail",
 CellID->669821617],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumberTheory`Ramanujan`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"RamanujanTau", "[", "n", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"n", ",", " ", "1", ",", " ", "10"}], "}"}]}], "]"}]}], "Input", \
"LegacyInput",
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"RamanujanTau", "[", "n", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"n", ",", " ", "1", ",", " ", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1746043248],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"-", "24"}], ",", "252", ",", 
   RowBox[{"-", "1472"}], ",", "4830", ",", 
   RowBox[{"-", "6048"}], ",", 
   RowBox[{"-", "16744"}], ",", "84480", ",", 
   RowBox[{"-", "113643"}], ",", 
   RowBox[{"-", "115920"}]}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->1405705]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["RamanujanTauDirichletSeries", "UpgradeDetailLabel",
 CellID->1087906933],

Cell["\<\
The value of  \[Tau]-Dirichlet series near the first zero of the critical \
line: \
\>", "UpgradeDetail",
 CellID->1074807037],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumberTheory`Ramanujan`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"RamanujanTauDirichletSeries", "[", 
  RowBox[{"6", "+", 
   RowBox[{"9.22", "I"}]}], "]"}]}], "Input", "LegacyInput",
 CellID->156175127],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RamanujanTauL", "[", 
  RowBox[{"6", "+", 
   RowBox[{"9.22", "I"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->542181072],

Cell[BoxData[
 RowBox[{"0.0004030903798357173`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.002390127652106469`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellLabel->"Out[4]=",
 CellID->453869004]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 55, 54.6273058}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/Ramanujan"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 73, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[885, 35, 1177, 40, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[CellGroupData[{
Cell[2087, 79, 62, 1, 70, "UpgradeDetailLabel",
 CellID->320256877],
Cell[2152, 82, 217, 8, 70, "UpgradeDetail",
 CellID->669821617],
Cell[2372, 92, 322, 9, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[2719, 105, 240, 7, 70, "Input",
 CellID->1746043248],
Cell[2962, 114, 338, 10, 70, "Output",
 CellID->1405705]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[3349, 130, 78, 1, 70, "UpgradeDetailLabel",
 CellID->1087906933],
Cell[3430, 133, 136, 4, 70, "UpgradeDetail",
 CellID->1074807037],
Cell[3569, 139, 248, 6, 70, "Input",
 CellID->156175127],
Cell[CellGroupData[{
Cell[3842, 149, 154, 5, 70, "Input",
 CellID->542181072],
Cell[3999, 156, 190, 4, 70, "Output",
 CellID->453869004]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4228, 165, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

