(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      4939,        190]
NotebookOptionsPosition[      3197,        134]
NotebookOutlinePosition[      4164,        162]
CellTagsIndexPosition[      4121,        159]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["NumericalMath`BesselZeros`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "New function ",
 Cell[BoxData[
  ButtonBox["BesselJZero",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselJZero"]], "InlineFormula"],
 " has been added to the built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel.\nNew function ",
 Cell[BoxData[
  ButtonBox["BesselYZero",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselYZero"]], "InlineFormula"],
 " has been added to the built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 "Evaluate the ",
 Cell[BoxData[
  FormBox["\[Null]5", TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " zero of the Bessel function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["J", "n"], "(", "x", ")"}], TraditionalForm]]],
 " numerically:"
}], "UpgradeDetail",
 CellID->556646693],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumericalMath`BesselZeros`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"BesselJZeros", "[", 
  RowBox[{"0", ",", "5"}], "]"}]}], "Input", "LegacyInput",
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"BesselJZero", "[", 
   RowBox[{"0", ",", "5"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1746043248],

Cell[BoxData["14.930917708487787`"], "Output",
 CellLabel->"Out[1]=",
 CellID->830281153]
}, Open  ]],

Cell[TextData[{
 "Similarly, evaluate the 1",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "st"], TraditionalForm]]],
 " zero of the Bessel function  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["Y", "n"], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 " numerically:"
}], "UpgradeDetail",
 CellID->1518205097],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumericalMath`BesselZeros`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"BesselYZeros", "[", 
  RowBox[{"0", ",", "1"}], "]"}]}], "Input", "LegacyInput",
 CellID->72371625],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"BesselYZero", "[", 
   RowBox[{"0", ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->874157173],

Cell[BoxData["0.893576966280575`"], "Output",
 CellLabel->"Out[2]=",
 CellID->92746669]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 55, 55.1585694}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/BesselZeros"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 76, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[888, 35, 538, 19, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[1429, 56, 367, 14, 70, "UpgradeDetail",
 CellID->556646693],
Cell[1799, 72, 218, 6, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[2042, 82, 160, 5, 70, "Input",
 CellID->1746043248],
Cell[2205, 89, 89, 2, 70, "Output",
 CellID->830281153]
}, Open  ]],
Cell[2309, 94, 341, 13, 70, "UpgradeDetail",
 CellID->1518205097],
Cell[2653, 109, 216, 6, 70, "Input",
 CellID->72371625],
Cell[CellGroupData[{
Cell[2894, 119, 159, 5, 70, "Input",
 CellID->874157173],
Cell[3056, 126, 87, 2, 70, "Output",
 CellID->92746669]
}, Open  ]]
}, Open  ]],
Cell[3170, 132, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

