(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      5408,        183]
NotebookOptionsPosition[      3916,        137]
NotebookOutlinePosition[      4899,        165]
CellTagsIndexPosition[      4856,        162]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["NumericalMath`NIntegrateInterpolatingFunct`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "All the functionality of ",
 Cell[BoxData[
 "NumericalMath`NIntegrateInterpolatingFunct`"], "InlineFormula"],
 "is now available in the newly created ",
 ButtonBox["Function Approximations Package",
  BaseStyle->"Link",
  ButtonData->
   "paclet:FunctionApproximations/guide/FunctionApproximationsPackage"],
 "."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 "To access functionality from the new ",
 ButtonBox["Function Approximations Package",
  BaseStyle->"Link",
  ButtonData->
   "paclet:FunctionApproximations/guide/FunctionApproximationsPackage"],
 ", load ",
 Cell[BoxData["FunctionApproximations`"], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->556646693],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumericalMath`NIntegrateInterpolatingFunct`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sin", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", 
          RowBox[{"Sin", "[", 
           RowBox[{"x", " ", "y"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "4", ",", ".5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", "0", ",", "4", ",", "0.5"}], "}"}]}], "]"}], ",", 
      "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"NIntegrateInterpolatingFunction", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"sin", "[", 
     RowBox[{
      RowBox[{"y", "^", "2"}], ",", 
      RowBox[{"x", "^", "2"}]}], "]"}], "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "2"}], "}"}]}], "]"}]}], "Input", \
"LegacyInput",
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "FunctionApproximations`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sin", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", 
          RowBox[{"Sin", "[", 
           RowBox[{"x", " ", "y"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "4", ",", ".5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", "0", ",", "4", ",", "0.5"}], "}"}]}], "]"}], ",", 
      "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"NIntegrateInterpolatingFunction", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"sin", "[", 
     RowBox[{
      RowBox[{"y", "^", "2"}], ",", 
      RowBox[{"x", "^", "2"}]}], "]"}], "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "2"}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->1746043248],

Cell[BoxData["1.223322754741601`"], "Output",
 CellLabel->"Out[7]=",
 CellID->2087319717]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 3.1900250}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/NIntegrateInterpolatingFunct"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 93, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[905, 35, 373, 11, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[1281, 48, 330, 10, 70, "UpgradeDetail",
 CellID->556646693],
Cell[1614, 60, 1074, 32, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[2713, 96, 1057, 31, 70, "Input",
 CellID->1746043248],
Cell[3773, 129, 89, 2, 70, "Output",
 CellID->2087319717]
}, Open  ]]
}, Open  ]],
Cell[3889, 135, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

