(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      5764,        207]
NotebookOptionsPosition[      4042,        153]
NotebookOutlinePosition[      5008,        181]
CellTagsIndexPosition[      4965,        178]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["NumericalMath`NewtonCotes`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "All the functionality of ",
 Cell[BoxData[
  RowBox[{"NumericalMath`NewtonCotes`", " "}]], "InlineFormula"],
 "is now available in the newly created ",
 ButtonBox["Numerical Differential Equation Analysis Package",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/guide/\
NumericalDifferentialEquationAnalysisPackage"],
 "."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 "To access functionality from the new ",
 ButtonBox["Numerical Differential Equation Analysis Package",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/guide/\
NumericalDifferentialEquationAnalysisPackage"],
 ", load \n",
 Cell[BoxData["NumericalDifferentialEquationAnalysis`"], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->556646693],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumericalMath`NewtonCotes`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"NewtonCotesWeights", "[", 
  RowBox[{"5", ",", 
   RowBox[{"-", "3"}], ",", "7"}], "]"}]}], "Input", "LegacyInput",
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumericalDifferentialEquationAnalysis`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"NewtonCotesWeights", "[", 
  RowBox[{"5", ",", 
   RowBox[{"-", "3"}], ",", "7"}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->1746043248],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3"}], ",", 
     FractionBox["7", "9"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "2"]}], ",", 
     FractionBox["32", "9"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     FractionBox["4", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["9", "2"], ",", 
     FractionBox["32", "9"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", 
     FractionBox["7", "9"]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->1385587453]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Numerical Differential Equation Analysis", "UpgradePackageSection",
 CellID->1087906933],

Cell[TextData[{
 "Many functions from ",
 Cell[BoxData["NumericalMath`NewtonCotes`"], "InlineFormula"],
 " are now found in the ",
 ButtonBox["Numerical Differential Equation Analysis Package",
  BaseStyle->"Link",
  ButtonData->
   "paclet:NumericalDifferentialEquationAnalysis/guide/\
NumericalDifferentialEquationAnalysisPackage"],
 ":"
}], "UpgradeDetail",
 CellID->1074807037],

Cell[TextData[{
 Cell[BoxData[{
  ButtonBox["NewtonCotesError",
   BaseStyle->"Link",
   ButtonData->
    "paclet:NumericalDifferentialEquationAnalysis/ref/NewtonCotesError"], "\n\
", 
  ButtonBox["NewtonCotesWeights",
   BaseStyle->"Link",
   ButtonData->
    "paclet:NumericalDifferentialEquationAnalysis/ref/NewtonCotesWeights"], "\
\n", 
  ButtonBox["QuadratureType",
   BaseStyle->"Link",
   ButtonData->
    "paclet:NumericalDifferentialEquationAnalysis/ref/QuadratureType"]}], 
  "InlineFormula"],
 "\n",
 Cell[BoxData["Type"], "InlineFormula"]
}], "UpgradePackageListing",
 CellID->701993520]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 3.0493964}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/NewtonCotes"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 76, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[888, 35, 421, 12, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[1312, 49, 396, 11, 70, "UpgradeDetail",
 CellID->556646693],
Cell[1711, 62, 253, 7, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[1989, 73, 273, 8, 70, "Input",
 CellID->1746043248],
Cell[2265, 83, 605, 23, 70, "Output",
 CellID->1385587453]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[2919, 112, 94, 1, 70, "UpgradePackageSection",
 CellID->1087906933],
Cell[3016, 115, 381, 11, 70, "UpgradeDetail",
 CellID->1074807037],
Cell[3400, 128, 600, 20, 70, "UpgradePackageListing",
 CellID->701993520]
}, Open  ]],
Cell[4015, 151, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

