(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6501,        229]
NotebookOptionsPosition[      4777,        175]
NotebookOutlinePosition[      5742,        203]
CellTagsIndexPosition[      5699,        200]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["NumericalMath`SplineFit`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "All the functionality of ",
 Cell[BoxData["NumericalMath`SplineFit`"], "InlineFormula"],
 "is now available in the newly created ",
 ButtonBox["Splines Package",
  BaseStyle->"Link",
  ButtonData->"paclet:Splines/guide/SplinesPackage"],
 "."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 "To access functionality from the new ",
 ButtonBox["Splines Package",
  BaseStyle->"Link",
  ButtonData->"paclet:Splines/guide/SplinesPackage"],
 ", load ",
 Cell[BoxData["Splines`"], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->556646693],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "NumericalMath`SplineFit`"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pts", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"spline", "=", 
  RowBox[{"SplineFit", "[", 
   RowBox[{"pts", ",", "Cubic"}], "]"}]}]}], "Input", "LegacyInput",
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"<<", "Splines`"}], "\n", 
 RowBox[{
  RowBox[{"pts", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"spline", "=", 
  RowBox[{"SplineFit", "[", 
   RowBox[{"pts", ",", "Cubic"}], "]"}]}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->1746043248],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SplineFunction[\"\>", "\[InvisibleSpace]", "Cubic", 
   "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "4.`"}], "}"}], 
   "\[InvisibleSpace]", "\<\", <>]\"\>"}],
  SequenceForm["SplineFunction[", Splines`Cubic, ", ", {0., 4.}, ", <>]"],
  Editable->False]], "Output",
 CellLabel->"Out[5]=",
 CellID->1935132084]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Splines Package", "InlineCode"]], \
"UpgradePackageSection",
 CellID->1087906933],

Cell[TextData[{
 "Many functions from",
 Cell[BoxData[
  RowBox[{" ", "NumericalMath`SplineFit`"}]], "InlineFormula"],
 " are now found in the ",
 ButtonBox["Splines Package",
  BaseStyle->"Link",
  ButtonData->"paclet:Splines/guide/SplinesPackage"],
 ":"
}], "UpgradeDetail",
 CellID->1074807037],

Cell[TextData[Cell[BoxData[{
 ButtonBox["Bezier",
  BaseStyle->"Link",
  ButtonData->"paclet:Splines/ref/Bezier"], "\n", 
 ButtonBox["CompositeBezier",
  BaseStyle->"Link",
  ButtonData->"paclet:Splines/ref/CompositeBezier"], "\n", 
 ButtonBox["Cubic",
  BaseStyle->"Link",
  ButtonData->"paclet:Splines/ref/Cubic"], "\n", 
 ButtonBox["RenderSpline",
  BaseStyle->"Link",
  ButtonData->"paclet:Splines/ref/RenderSpline"], "\n", 
 ButtonBox["Spline",
  BaseStyle->"Link",
  ButtonData->"paclet:Splines/ref/Spline"], "\n", 
 ButtonBox["SplineDivision",
  BaseStyle->"Link",
  ButtonData->"paclet:Splines/ref/SplineDivision"], "\n", 
 ButtonBox["SplineDots",
  BaseStyle->"Link",
  ButtonData->"paclet:Splines/ref/SplineDots"], "\n", 
 ButtonBox["SplineFit",
  BaseStyle->"Link",
  ButtonData->"paclet:Splines/ref/SplineFit"], "\n", 
 ButtonBox["SplineFunction",
  BaseStyle->"Link",
  ButtonData->"paclet:Splines/ref/SplineFunction"], "\n", 
 ButtonBox["SplinePoints",
  BaseStyle->"Link",
  ButtonData->
   "paclet:Splines/ref/SplinePoints"]}], "InlineFormula"]], \
"UpgradePackageListing",
 CellID->701993520]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 12.6277666}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/SplineFit"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 74, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[886, 35, 302, 9, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[1191, 46, 265, 9, 70, "UpgradeDetail",
 CellID->556646693],
Cell[1459, 57, 648, 21, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[2132, 82, 622, 21, 70, "Input",
 CellID->1746043248],
Cell[2757, 105, 412, 10, 70, "Output",
 CellID->1935132084]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[3218, 121, 105, 2, 70, "UpgradePackageSection",
 CellID->1087906933],
Cell[3326, 125, 297, 10, 70, "UpgradeDetail",
 CellID->1074807037],
Cell[3626, 137, 1109, 33, 70, "UpgradePackageListing",
 CellID->701993520]
}, Open  ]],
Cell[4750, 173, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

