(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17839,        657]
NotebookOptionsPosition[     14147,        535]
NotebookOutlinePosition[     15109,        563]
CellTagsIndexPosition[     15066,        560]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["Statistics`Common`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "Functionality in this package has been added to the built\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel or incorporated into newly created packages.\n",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["PDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PDF"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["CharacteristicFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CharacteristicFunction"]], "InlineFormula"],
 " are built into the kernel.\n",
 Cell[BoxData["RandomArray"], "InlineFormula"],
 " is replaced by ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomInteger"]], "InlineFormula"],
 ".\n",
 Cell[BoxData["CovarianceMatrix"], "InlineFormula"],
 " and ",
 Cell[BoxData["CorrelationMatrix"], "InlineFormula"],
 " are replaced by ",
 Cell[BoxData[
  ButtonBox["Covariance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Covariance"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Correlation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Correlation"]], "InlineFormula"],
 " for data.\n",
 Cell[BoxData["RegionProbability"], "InlineFormula"],
 " is replaced by ",
 Cell[BoxData[
  ButtonBox["EllipsoidProbability",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/EllipsoidProbability"]], 
  "InlineFormula"],
 ".\nNew ",
 ButtonBox["Hypothesis Testing",
  BaseStyle->"Link",
  ButtonData->"paclet:HypothesisTesting/guide/HypothesisTestingPackage"],
 ", ",
 ButtonBox["Multivariate Statistics",
  BaseStyle->"Link",
  ButtonData->
   "paclet:MultivariateStatistics/guide/MultivariateStatisticsPackage"],
 " and ",
 ButtonBox["Regression Common Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/guide/RegressionCommonPackage"],
 " packages have been created."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["PDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PDF"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["CharacteristicFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CharacteristicFunction"]], "InlineFormula"],
 " are built into the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel:"
}], "UpgradeDetail",
 CellID->556646693],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`NormalDistribution`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"NormalDistribution", "[", 
    RowBox[{"0", ",", "1"}], "]"}], ",", "x"}], "]"}]}], "Input", \
"LegacyInput",
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"NormalDistribution", "[", 
    RowBox[{"0", ",", "1"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->1746043248],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["x", "2"], "2"]}]], 
  SqrtBox[
   RowBox[{"2", " ", "\[Pi]"}]]]], "Output",
 CellLabel->"Out[15]=",
 CellID->782193119]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->56503734],

Cell[TextData[{
 Cell[BoxData["RandomArray"], "InlineFormula"],
 " is replaced by ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 " for continuous distributions:"
}], "UpgradeDetail",
 CellID->245467195],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`ContinuousDistributions`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"RandomArray", "[", 
  RowBox[{
   RowBox[{"BetaDistribution", "[", 
    RowBox[{"2", ",", "3"}], "]"}], ",", "10"}], "]"}]}], "Input", \
"LegacyInput",
 CellLabel->"In[1]:=",
 CellID->212315539],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{
   RowBox[{"BetaDistribution", "[", 
    RowBox[{"2", ",", "3"}], "]"}], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->166843422],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.4090134714812636`", ",", "0.2706171167393268`", ",", 
   "0.374749443082924`", ",", "0.1686544532428781`", ",", 
   "0.24543265948664741`", ",", "0.22470197585082755`", ",", 
   "0.3522933253688191`", ",", "0.4462214554360375`", ",", 
   "0.5127295365257238`", ",", "0.18103572975446114`"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->23745985]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["RandomArray"], "InlineFormula"],
 " is replaced by ",
 Cell[BoxData[
  ButtonBox["RandomInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomInteger"]], "InlineFormula"],
 " for discrete distributions:"
}], "UpgradeDetail",
 CellID->560816896],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`DiscreteDistributions`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"RandomArray", "[", 
  RowBox[{
   RowBox[{"PoissonDistribution", "[", "5", "]"}], ",", "10"}], 
  "]"}]}], "Input", "LegacyInput",
 CellLabel->"In[3]:=",
 CellID->542839220],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomInteger", "[", 
  RowBox[{
   RowBox[{"PoissonDistribution", "[", "5", "]"}], ",", "10"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->283346933],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3", ",", "6", ",", "6", ",", "9", ",", "7", ",", "7", ",", "6", ",", "3", 
   ",", "2", ",", "7"}], "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->22575496]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->822481974],

Cell["Covariance matrix for data:", "UpgradeDetail",
 CellID->415013396],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`MultiDescriptiveStatistics`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CovarianceMatrix", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"10", ",", "50"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "15"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"20", ",", "25"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "15"}], "}"}]}], "}"}], "]"}]}], "Input", \
"LegacyInput",
 CellLabel->"In[1]:=",
 CellID->218463083],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Covariance", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"10", ",", "50"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "15"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"20", ",", "25"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "15"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->484810466],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"25", ",", 
     RowBox[{"-", 
      FractionBox["25", "6"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["25", "6"]}], ",", 
     FractionBox["3275", "12"]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->16308326]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10322803],

Cell[TextData[{
 Cell[BoxData["RegionProbability"], "InlineFormula"],
 " is replaced by ",
 Cell[BoxData[
  ButtonBox["EllipsoidProbability",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/EllipsoidProbability"]], 
  "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->40873231],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`MultinormalDistribution`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ndist", "=", 
   RowBox[{"MultinormalDistribution", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"1", "/", "3"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "3"}], ",", "1"}], "}"}]}], "}"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"ellipse", "=", 
   RowBox[{"EllipsoidQuantile", "[", 
    RowBox[{"ndist", ",", ".5"}], "]"}]}], ";"}], "\n", 
 RowBox[{"RegionProbability", "[", 
  RowBox[{"ndist", ",", "ellipse"}], "]"}]}], "Input", "LegacyInput",
 CellLabel->"In[1]:=",
 CellID->138711875],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "MultivariateStatistics`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ndist", "=", 
   RowBox[{"MultinormalDistribution", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"1", "/", "3"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "3"}], ",", "1"}], "}"}]}], "}"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"ellipse", "=", 
   RowBox[{"EllipsoidQuantile", "[", 
    RowBox[{"ndist", ",", ".5"}], "]"}]}], ";"}], "\n", 
 RowBox[{"EllipsoidProbability", "[", 
  RowBox[{"ndist", ",", "ellipse"}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->261595021],

Cell[BoxData["0.5`"], "Output",
 CellLabel->"Out[2]=",
 CellID->7413932]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Hypothesis Tests package", "UpgradePackageSection",
 CellID->1087906933],

Cell[TextData[{
 "Symbols from ",
 Cell[BoxData["Statistics`Common`PopulationsCommon`"], "InlineFormula"],
 " are now found in the ",
 StyleBox[ButtonBox["Hypothesis Testing",
  BaseStyle->"Link",
  ButtonData->"paclet:HypothesisTesting/guide/HypothesisTestingPackage"],
  FontWeight->"Bold"],
 " package:"
}], "UpgradeDetail",
 CellID->1074807037],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EqualVariances",
   BaseStyle->"Link",
   ButtonData->"paclet:HypothesisTesting/ref/EqualVariances"]], 
  "InlineFormula"],
 "\n",
 Cell[BoxData[
  ButtonBox["KnownVariance",
   BaseStyle->"Link",
   ButtonData->"paclet:HypothesisTesting/ref/KnownVariance"]], 
  "InlineFormula"]
}], "UpgradePackageListing",
 CellID->701993520],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12859929],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["KnownVariance",
   BaseStyle->"Link",
   ButtonData->"paclet:HypothesisTesting/ref/KnownVariance"]], 
  "InlineFormula"],
 " option replaces ",
 Cell[BoxData["KnownStandardDeviation"], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->380726846],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`HypothesisTests`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"MeanTest", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "2", ",", "5", ",", "10"}], "}"}], ",", "5", 
   ",", 
   RowBox[{"KnownStandardDeviation", "\[Rule]", "2"}]}], "]"}]}], "Input", \
"LegacyInput",
 CellLabel->"In[1]:=",
 CellID->391943743],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "HypothesisTesting`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"MeanTest", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "2", ",", "5", ",", "10"}], "}"}], ",", "5", 
   ",", 
   RowBox[{"KnownVariance", "\[Rule]", 
    RowBox[{"Sqrt", "[", "2", "]"}]}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->63946252],

Cell[BoxData[
 RowBox[{"OneSidedPValue", "\[Rule]", "0.12962175839924334`"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->58025718]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Regression Common Functions package", "UpgradePackageSection",
 CellID->493204189],

Cell[TextData[{
 "Symbols from ",
 Cell[BoxData["Statistics`Common`RegressionCommon`"], "InlineFormula"],
 " are now found in the ",
 StyleBox[ButtonBox["Regression Common Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/guide/RegressionCommonPackage"],
  FontWeight->"Bold"],
 " package. "
}], "UpgradeDetail",
 CellID->27767118],

Cell[TextData[{
 "The following regression report values from other ",
 Cell[BoxData["Statistics`"], "InlineFormula"],
 " standard add\[Hyphen]ons and the ",
 Cell[BoxData[
  ButtonBox["Ellipsoid",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/Ellipsoid"]], "InlineFormula"],
 " primitive are also found in the ",
 StyleBox[ButtonBox["Regression Common Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:RegressionCommon/guide/RegressionCommonPackage"],
  FontWeight->"Bold"],
 " package:"
}], "UpgradeDetail",
 CellID->235713591],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CoefficientOfVariation",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/CoefficientOfVariation"]], 
  "InlineFormula"],
 "\n",
 Cell[BoxData[
  ButtonBox["CorrelationMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/CorrelationMatrix"]], 
  "InlineFormula"],
 "\n",
 Cell[BoxData[
  ButtonBox["CovarianceMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/CovarianceMatrix"]], 
  "InlineFormula"]
}], "UpgradePackageListing",
 CellID->139717169]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 13.1121540}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/Common"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 68, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[880, 35, 2124, 68, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[3007, 105, 524, 20, 70, "UpgradeDetail",
 CellID->556646693],
Cell[3534, 127, 286, 9, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[3845, 140, 195, 6, 70, "Input",
 CellID->1746043248],
Cell[4043, 148, 239, 9, 70, "Output",
 CellID->782193119]
}, Open  ]],
Cell[4297, 160, 124, 3, 70, "ExampleDelimiter",
 CellID->56503734],
Cell[4424, 165, 282, 9, 70, "UpgradeDetail",
 CellID->245467195],
Cell[4709, 176, 320, 10, 70, "Input",
 CellID->212315539],
Cell[CellGroupData[{
Cell[5054, 190, 199, 6, 70, "Input",
 CellID->166843422],
Cell[5256, 198, 396, 9, 70, "Output",
 CellID->23745985]
}, Open  ]],
Cell[5667, 210, 286, 9, 70, "UpgradeDetail",
 CellID->560816896],
Cell[5956, 221, 297, 9, 70, "Input",
 CellID->542839220],
Cell[CellGroupData[{
Cell[6278, 234, 183, 6, 70, "Input",
 CellID->283346933],
Cell[6464, 242, 202, 6, 70, "Output",
 CellID->22575496]
}, Open  ]],
Cell[6681, 251, 125, 3, 70, "ExampleDelimiter",
 CellID->822481974],
Cell[6809, 256, 72, 1, 70, "UpgradeDetail",
 CellID->415013396],
Cell[6884, 259, 514, 17, 70, "Input",
 CellID->218463083],
Cell[CellGroupData[{
Cell[7423, 280, 385, 13, 70, "Input",
 CellID->484810466],
Cell[7811, 295, 336, 13, 70, "Output",
 CellID->16308326]
}, Open  ]],
Cell[8162, 311, 124, 3, 70, "ExampleDelimiter",
 CellID->10322803],
Cell[8289, 316, 304, 10, 70, "UpgradeDetail",
 CellID->40873231],
Cell[8596, 328, 810, 26, 70, "Input",
 CellID->138711875],
Cell[CellGroupData[{
Cell[9431, 358, 783, 25, 70, "Input",
 CellID->261595021],
Cell[10217, 385, 72, 2, 70, "Output",
 CellID->7413932]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10338, 393, 78, 1, 70, "UpgradePackageSection",
 CellID->1087906933],
Cell[10419, 396, 348, 10, 70, "UpgradeDetail",
 CellID->1074807037],
Cell[10770, 408, 372, 13, 70, "UpgradePackageListing",
 CellID->701993520],
Cell[11145, 423, 124, 3, 70, "ExampleDelimiter",
 CellID->12859929],
Cell[11272, 428, 301, 11, 70, "UpgradeDetail",
 CellID->380726846],
Cell[11576, 441, 384, 12, 70, "Input",
 CellID->391943743],
Cell[CellGroupData[{
Cell[11985, 457, 378, 11, 70, "Input",
 CellID->63946252],
Cell[12366, 470, 130, 3, 70, "Output",
 CellID->58025718]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12545, 479, 88, 1, 70, "UpgradePackageSection",
 CellID->493204189],
Cell[12636, 482, 353, 10, 70, "UpgradeDetail",
 CellID->27767118],
Cell[12992, 494, 554, 15, 70, "UpgradeDetail",
 CellID->235713591],
Cell[13549, 511, 556, 19, 70, "UpgradePackageListing",
 CellID->139717169]
}, Open  ]],
Cell[14120, 533, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

