(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      5220,        194]
NotebookOptionsPosition[      3406,        136]
NotebookOutlinePosition[      4381,        164]
CellTagsIndexPosition[      4338,        161]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["Statistics`ConfidenceIntervals`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "All functionality is available in the newly created ",
 ButtonBox["Hypothesis Testing Package",
  BaseStyle->"Link",
  ButtonData->"paclet:HypothesisTesting/guide/HypothesisTestingPackage"],
 "."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 "Load ",
 Cell[BoxData["HypothesisTesting`"], "InlineFormula"],
 " to use the ",
 ButtonBox["Hypothesis Testing Package",
  BaseStyle->"Link",
  ButtonData->"paclet:HypothesisTesting/guide/HypothesisTestingPackage"],
 " functionality:"
}], "UpgradeDetail",
 CellID->7810128],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`ConfidenceIntervals`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"MeanCI", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "4", ",", "2", ",", "5", ",", "10"}], "}"}], 
  "]"}]}], "Input", "LegacyInput",
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "HypothesisTesting`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"MeanCI", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "4", ",", "2", ",", "5", ",", "10"}], "}"}], 
  "]"}]}], "Input",
 CellLabel->"In[39]:=",
 CellID->1746043248],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.045316009334904095`", ",", "8.754683990665097`"}], 
  "}"}]], "Output",
 CellLabel->"Out[40]=",
 CellID->207816012]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12859929],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["KnownVariance",
   BaseStyle->"Link",
   ButtonData->"paclet:HypothesisTesting/ref/KnownVariance"]], 
  "InlineFormula"],
 " option replaces ",
 Cell[BoxData["KnownStandardDeviation"], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->380726846],

Cell[BoxData[
 RowBox[{"MeanCI", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "2", ",", "5", ",", "10"}], "}"}], ",", 
   RowBox[{"KnownStandardDeviation", "\[Rule]", "2"}]}], "]"}]], "Input", \
"LegacyInput",
 CellLabel->"In[1]:=",
 CellID->391943743],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanCI", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "2", ",", "5", ",", "10"}], "}"}], ",", 
   RowBox[{"KnownVariance", "\[Rule]", 
    RowBox[{"Sqrt", "[", "2", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->63946252],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.3576331582860686`", ",", "5.442366841713932`"}], "}"}]], "Output",\

 CellLabel->"Out[2]=",
 CellID->96576003]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 13.2684080}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/ConfidenceIntervals"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 81, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[893, 35, 256, 7, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[1152, 44, 291, 9, 70, "UpgradeDetail",
 CellID->7810128],
Cell[1446, 55, 275, 8, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[1746, 67, 268, 8, 70, "Input",
 CellID->1746043248],
Cell[2017, 77, 157, 5, 70, "Output",
 CellID->207816012]
}, Open  ]],
Cell[2189, 85, 124, 3, 70, "ExampleDelimiter",
 CellID->12859929],
Cell[2316, 90, 301, 11, 70, "UpgradeDetail",
 CellID->380726846],
Cell[2620, 103, 273, 8, 70, "Input",
 CellID->391943743],
Cell[CellGroupData[{
Cell[2918, 115, 279, 8, 70, "Input",
 CellID->63946252],
Cell[3200, 125, 152, 5, 70, "Output",
 CellID->96576003]
}, Open  ]]
}, Open  ]],
Cell[3379, 134, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

